% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransformationBoxCox.R
\docType{class}
\name{transformationBoxCox-class}
\alias{transformationBoxCox-class}
\alias{transformationBoxCoxInvariant-class}
\title{Box-Cox transformation object}
\description{
This class is used for Box-Cox transformations.
}
\section{Slots}{

\describe{
\item{\code{method}}{Main transformation method, i.e. \code{"box_cox"}.}

\item{\code{robust}}{Indicates whether a robust version of the Box-Cox transformation
is used to set transformation parameters. The value depends on the \code{robust}
argument of the \code{find_transformation_parameters} function.}

\item{\code{lambda}}{Numeric lambda parameter for the Box-Cox transformation.}

\item{\code{shift}}{Numeric shift parameter for the Box-Cox transformation. The value
depends on the data used for setting transformation parameters. If all data
are strictly positive, \code{shift} has a value of \code{0.0}. When negative or zero
values are present, data are shifted to be strictly positive. If
\code{invariant=TRUE} in the \code{find_transformation_parameters} function,
\code{lambda}, \code{shift} and \code{scale} parameters are optimised simultaneously.}

\item{\code{scale}}{Numeric scale parameter for the Box-Cox transformation. If
\code{invariant=TRUE} in the \code{find_transformation_parameters} function,
\code{lambda}, \code{shift} and \code{scale} parameters are optimised simultaneously.
Otherwise, the \code{scale} parameter has a value of \code{1.0}.}

\item{\code{complete}}{Indicates whether transformation parameters were set.}
}}

\seealso{
\link{find_transformation_parameters}
}
