% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{agg}
\alias{agg}
\title{Aggregate PPMF Data}
\usage{
agg(ppmf, group = GEOID, age = VOTING_AGE, race = CENRACE, hisp = CENHISP)
}
\arguments{
\item{ppmf}{tibble of ppmf data}

\item{group}{Column in ppmf to group by, typically GEOID}

\item{age}{Column in ppmf containing 1 for not voting age and 2 for voting age}

\item{race}{Column in ppmf containing race codes}

\item{hisp}{Column in ppmf containing 1 for Not Hispanic and 2 for Hispanic}
}
\value{
tibble of ppmf data aggregated by group with race classified with columns:
\itemize{
\item \code{group}: named by entry group
\item \code{pop}: total population
\item \code{pop_hisp}: total population - Hispanic or Latino (of any race)
\item \code{pop_white}: total population - White alone, not Hispanic or Latino
\item \code{pop_black}: total population - Black or African American alone, not Hispanic or Latino
\item \code{pop_aian}: total population - American Indian and Alaska Native alone, not Hispanic or Latino
\item \code{pop_asian}: total population - Asian alone, not Hispanic or Latino
\item \code{pop_nhpi}: total population - Native Hawaiian and Other Pacific Islander alone, not Hispanic or Latino
\item \code{pop_other}: total population - Some Other Race alone, not Hispanic or Latino
\item \code{pop_two}: total population - Population of two or more races, not Hispanic or Latino
\item \code{vap}: voting age population
\item \code{vap_hisp}: voting age population - Hispanic or Latino (of any race)
\item \code{vap_white}: voting age population - White alone, not Hispanic or Latino
\item \code{vap_black}: voting age population - Black or African American alone, not Hispanic or Latino
\item \code{vap_aian}: voting age population - American Indian and Alaska Native alone, not Hispanic or Latino
\item \code{vap_asian}: voting age population - Asian alone, not Hispanic or Latino
\item \code{vap_nhpi}: voting age population - Native Hawaiian and Other Pacific Islander alone, not Hispanic or Latino
\item \code{vap_other}: voting age population - Some Other Race alone, not Hispanic or Latino
\item \code{vap_two}: voting age population - Population of two or more races, not Hispanic or Latino
}
}
\description{
Aggregate PPMF Data
}
\examples{
data(ppmf_ex)
ppmf_ex <- ppmf_ex \%>\% add_geoid()
blocks <- agg(ppmf_ex)

}
\concept{basic}
