% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_overlay.R
\name{pitch_overlay}
\alias{pitch_overlay}
\title{Overlay pitch on plot frame}
\usage{
pitch_overlay(
  pt,
  bottomRange,
  topRange,
  start,
  org_start = 0,
  tfrom0 = TRUE,
  freqRange = NULL,
  plotType = "draw",
  scale = "hz",
  color = "black",
  ind = NULL,
  drawSize = 1,
  speckleSize = 1,
  axisLabel = NULL,
  min_max_only = TRUE,
  highlight = NULL,
  intensity_overlay = FALSE
)
}
\arguments{
\item{pt}{PitchTier object loaded using \link[rPraat:pt.read]{rPraat::pt.read} or other object
formatted in a similar way, i.e. a \code{list} object containing the elements
\code{t} (a vector of time values) and \code{f} (a vector of frequency values) of
identical length.}

\item{bottomRange}{Bottom y-axis range of the plot frame that pitch
is plotted on.}

\item{topRange}{Top y-axis range of the plot frame that pitch is plotted on.}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{org_start}{Start time (in seconds) of desired plotted area in the
original sound file.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{freqRange}{Vector of two integers giving the frequency range to be
used for producing pitch plots. Default is \code{NULL}, in which case the pitch
range is automatically reset to \code{c(-12,30)} for the \code{semitones} scale,
\code{c(0,10)} for the \code{erb} scale, and \code{c(50,500)} for the Hz-based scales,
following Praat defaults.}

\item{plotType}{String giving the type of pitch plot to produce; default
is \code{draw} (a line plot), the only other option is \code{speckle} (a point plot).
Alternatively a vector \code{c('draw','speckle')} can be passed, in which case
both are used.}

\item{scale}{String giving the frequency scale to use when producing
pitch plots. Default is \code{hz}; other options are \code{logarithmic} (also in Hz),
\code{semitones}, \code{erb}, and \code{mel}.}

\item{color}{String giving the name of the color to be used for
plotting pitch. Default is \code{'black'}.}

\item{ind}{Integer indexing current plot frame relative to other plot
components. Default is \code{NULL}.}

\item{drawSize}{Number indicating the line width if
\code{plotType} is \code{'draw'}. Default is \code{1}. Controls the \code{lwd} argument of
\link[graphics:lines]{graphics::lines}.}

\item{speckleSize}{Number indicating the point size of if \verb{_plotType} is
\code{'speckle'}. Default is \code{1}. Controls the \code{cex} arguments of
\link[graphics:points]{graphics::points}.}

\item{axisLabel}{String giving the name of the label to print along the
y-axis when printing a pitch track. Default is \code{NULL}, in which case the
axis label will depend on the scale.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{highlight}{Named list giving parameters for differential
highlighting of pitch based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the optional arguments
\code{color} (string or vector of strings, see \code{color}),
\code{drawSize} or \code{speckleSize} (both numeric), and \code{background}
(a string specifying a background color).}

\item{intensity_overlay}{Logical; is intensity also overlaid on the same
plot frame? Default is \code{FALSE}.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for overlaying pitch contour on another plot frame, viz. the
waveform or spectrogram. Instead of using this function directly, just use
\code{praatpicture('my_sound_file')} with \code{pitch_plotOnSpec} or \code{pitch_plotOnWave}
set to \code{TRUE}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames = 'spectrogram', pitch_plotOnSpec = TRUE)
}
