% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupdiff.R
\name{groupdiff}
\alias{groupdiff}
\title{Test of group differences}
\usage{
groupdiff(
  data,
  y,
  x,
  method = c("anova", "kw"),
  digits = 2,
  horizontal = FALSE,
  posthoc = FALSE
)
}
\arguments{
\item{data}{a data frame.}

\item{y}{a numeric response variable}

\item{x}{a categorical explanatory variable. It will coerced to be
a factor.}

\item{method}{character. Either \code{"anova"}, or \code{"kw"} (see details).}

\item{digits}{Number of significant digits to print.}

\item{horizontal}{logical. If \code{TRUE}, boxplots are plotted horizontally.}

\item{posthoc}{logical. If \code{TRUE}, the default, perform pairwise post-hoc comparisons
(TukeyHSD for ANOVA and Conover Test for Kuskal Wallis). This test
will only be performed if there are 3 or more levels for X.}
}
\value{
a list with 3 components:
\describe{
\item{\code{result}}{omnibus test}
\item{\code{summarystats}}{summary statistics}
\item{\code{plot}}{ggplot2 graph}
}
}
\description{
One-way analysis (ANOVA or Kruskal-Wallis Test)
with post-hoc comparisons and plots
}
\details{
The \code{groupdiff} function performs one of two analyses:
\describe{
\item{\code{anova}}{A one-way analysis of variance, with TukeyHSD
post-hoc comparisons.}
\item{\code{kw}}{A Kruskal Wallis Rank Sum Test, with Conover
Test post-hoc comparisons.}
}
In each case, summary statistics and a grouped boxplots are
provided. In the parametric case, the statistics are n, mean, and
standard deviation. In the nonparametric case the statistics are
n, median, and median absolute deviation. If \code{posthoc = TRUE},
pairwise comparisons of superimposed on the boxplots.
Groups that share a letter are not significantly different (p < .05),
controlling for multiple comparisons.
}
\examples{
# parametric analysis
groupdiff(cars74, hp, gear)

# nonparametric analysis
groupdiff(cardata, popularity, vehicle_style, posthoc=TRUE,
          method="kw", horizontal=TRUE)
}
\seealso{
\link[PMCMRplus]{kwAllPairsConoverTest},
\link[multcompView]{multcompLetters}.
}
