% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quasar-plot.R
\name{plot.quasar}
\alias{plot.quasar}
\title{Plot method for quasar objects}
\usage{
\method{plot}{quasar}(
  x,
  alpha = 0.05,
  legend.position = "topright",
  main = NULL,
  xlab = "Quantile level",
  ylab = "Coefficient",
  col.line = "darkgrey",
  col.sig = "darkred",
  col.nonsig = "darkgrey",
  pch.sig = 19,
  pch.nonsig = 17,
  show.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{quasar}.}

\item{alpha}{Significance level.}

\item{legend.position}{Position of the legend.}

\item{main}{Main plot title.}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{col.line}{Color of the connecting line.}

\item{col.sig}{Color for significant points.}

\item{col.nonsig}{Color for non-significant points.}

\item{pch.sig}{Point character for significant points.}

\item{pch.nonsig}{Point character for non-significant points.}

\item{show.legend}{Logical; whether to display a legend.}

\item{...}{Additional graphical parameters passed to \code{plot()}.}
}
\value{
A base R plot.
}
\description{
Produces a plot of a \code{quasar} object,
typically returned by the \code{\link{closedTesting}} function.
It shows the estimated coefficients by quantile level, highlighting
statistically significant coefficients based on adjusted p-values.
}
\seealso{
\code{\link{closedTesting}}
}
\author{
Anna Vesely
}
