% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{by2}
\alias{by2}
\title{Apply a Function to Data by Group}
\usage{
by2(.data, .vrb.nm, .grp.nm, .sep = ".", .fun, ...)
}
\arguments{
\item{.data}{data.frame of data.}

\item{.vrb.nm}{character vector specifying the colnames of \code{.data} to
select the set of variables to apply \code{.fun} to.}

\item{.grp.nm}{character vector specifying the colnames of \code{.data} to
select the grouping variables.}

\item{.sep}{character vector of length 1 specifying the string to combine the
group values together with. \code{.sep} is only used if there are multiple
grouping variables (i.e., \code{length(.grp.nm)} > 1).}

\item{.fun}{function to apply to the set of variables \code{.data[.vrb.nm]}
for each group.}

\item{...}{additional named arguments to pass to \code{.fun}.}
}
\value{
list of objects containing the return object of \code{.fun} for each
  group. The names are the unique combinations of the grouping variables
  (i.e., \code{unique(interaction(.data[.grp.nm], sep = .sep))}).
}
\description{
\code{by2} applies a function to data by group and is an alternative to the
base R function \code{\link{by}}. The function is apart of the
split-apply-combine type of function discussed in the \code{plyr} R package
and is very similar to \code{\link[plyr]{dlply}}. It splits up one data.frame
\code{.data[.vrb.nm]}into a data.frame for each group in
\code{.data[.grp.nm]}, applies a function \code{.fun} to each data.frame, and
then returns the results as a list with names equal to the group values
\code{unique(interaction(.data[.grp.nm], sep = .sep))}. \code{by2} is simply
\code{split.data.frame} + \code{lapply}. Similar to \code{dlply}, The
arguments all start with \code{.} so that they do not conflict with arguments
from the function \code{.fun}. If you want to apply a function a (atomic)
vector rather than data.frame, then use \code{\link{tapply2}}.
}
\examples{

# one grouping variable
by2(mtcars, .vrb.nm = c("mpg","cyl","disp"), .grp.nm = "vs",
   .fun = cov, use = "complete.obs")

# two grouping variables
x <- by2(mtcars, .vrb.nm = c("mpg","cyl","disp"), .grp.nm = c("vs","am"),
   .fun = cov, use = "complete.obs")
print(x)
str(x)

# compare to by
vrb_nm <- c("mpg","cyl","disp") # Roxygen runs the whole script if I put a c() in a []
grp_nm <- c("vs","am") # Roxygen runs the whole script if I put a c() in a []
y <- by(mtcars[vrb_nm], INDICES = mtcars[grp_nm],
   FUN = cov, use = "complete.obs", simplify = FALSE)
str(y) # has dimnames rather than names
}
\seealso{
\code{\link{by}}
   \code{\link{tapply2}}
   \code{\link[plyr]{dlply}}
}
