% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{mode2}
\alias{mode2}
\title{Statistical Mode of a Numeric Vector}
\usage{
mode2(x, na.rm = FALSE, multiple = FALSE)
}
\arguments{
\item{x}{atomic vector}

\item{na.rm}{logical vector of length 1 specifying if missing values should
be removed from \code{x} before calculating its frequencies.}

\item{multiple}{logical vector of length 1 specifying if multiple modes
should be returned in the case they exist. If multiple modes exist and
\code{multiple} = TRUE, the multiple modes will be returned in alphanumeric
order. If multiple modes exist and \code{multiple} = TRUE, the first mode
in alphanumeric order will be returned. Note, NA is always last in the
alphanumeric order. If only one mode exists, then the \code{multiple}
argument is not used.}
}
\value{
atomic vector of the same storage mode as \code{x} providing the
  statistical mode(s).
}
\description{
\code{mode2} calculates the statistical mode - a measure of central tendancy
- of a numeric vector. This is in contrast to \code{\link{mode}} in base R,
which returns the storage mode of an object. In the case multiple modes
exist, the \code{multiple} argument allows the user to specify if they want
the multiple modes returned or just one.
}
\examples{

# ONE MODE
vec <- c(7,8,9,7,8,9,9)
mode2(vec)
mode2(vec, multiple = TRUE)

# TWO MODES
vec <- c(7,8,9,7,8,9,8,9)
mode2(vec)
mode2(vec, multiple = TRUE)

# WITH NA
vec <- c(7,8,9,7,8,9,NA,9)
mode2(vec)
mode2(vec, na.rm = TRUE)
vec <- c(7,8,9,7,8,9,NA,9,NA,NA)
mode2(vec)
mode2(vec, multiple = TRUE)
}
\seealso{
\code{\link{freq}}
   \code{\link{table}}
}
