/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jpmml.rexp.BinaryOutput;
import org.jpmml.rexp.RDataOutput;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.TextOutput;

public class RExpWriter
implements Closeable {
    private RDataOutput output = null;
    private Map<Object, Integer> referenceTable = new LinkedHashMap<Object, Integer>();

    public RExpWriter(OutputStream os) throws IOException {
        this(os, false);
    }

    public RExpWriter(OutputStream os, boolean ascii) throws IOException {
        this.output = ascii ? new TextOutput(os){

            @Override
            public RExpWriter getWriter() {
                return RExpWriter.this;
            }
        } : new BinaryOutput(os){

            @Override
            public RExpWriter getWriter() {
                return RExpWriter.this;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    public void write(RExp rexp) throws IOException {
        this.output.writeInt(2);
        this.output.writeInt(0);
        this.output.writeInt(0);
        rexp.write(this.output);
    }

    public Map<Object, Integer> getReferenceTable() {
        return this.referenceTable;
    }
}

