% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtf_rich_text.R
\name{rtf_rich_text}
\alias{rtf_rich_text}
\title{Text to Formatted RTF Encode}
\usage{
rtf_rich_text(
  text,
  theme = list(.emph = list(format = "i"), .strong = list(format = "b"))
)
}
\arguments{
\item{text}{Plain text.}

\item{theme}{Named list defining themes for tags. See \code{rtf_text()} for
details on possible formatting.}
}
\description{
Text to Formatted RTF Encode
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if theme list items correspond to \code{font_type()} arguments.
   \item Create regex expressions to match `{}` and `.tag` in text.
   \item Extract tagged text from input text.
   \item Extract tags from tagged text.
   \item Extract text from tagged text.
   \item Validate that lengths of extractions are all the same.
   \item Validate that tags are defined in the `theme` argument.
   \item Execute \code{rtf_text()} with extracted text and relevant formatting.
   \item Reinsert encoded formatted text to original input text.
 }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
rtf_rich_text(
  text = paste(
    "This is {.emph important}.",
    "This is {.strong relevant}.", "This is {.zebra ZEBRA}."
  ),
  theme = list(
    .emph = list(format = "i"),
    .strong = list(format = "b"),
    .zebra = list(color = "white", background_color = "black")
  )
)
}
