/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Network;

import com.conveyal.analysis.datasource.DataSourceException;
import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.osmlib.OSM;
import com.conveyal.r5.analyst.scenario.RasterCost;
import com.conveyal.r5.kryo.KryoNetworkSerializer;
import com.conveyal.r5.streets.StreetLayer;
import com.conveyal.r5.transit.TransferFinder;
import com.conveyal.r5.transit.TransportNetwork;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.ipea.r5r.Network.NetworkChecker;
import org.ipea.r5r.Network.TransitLayerWithShapes;

public class NetworkBuilder {
    public static boolean useNativeElevation = false;
    public static String elevationCostFunction = "NONE";
    private static List<String> gtfsFiles = new ArrayList<String>();
    private static String osmFilename;
    private static OSM osmFile;
    private static Stream<GTFSFeed> gtfsFeeds;
    private static String tiffFile;

    public static TransportNetwork checkAndLoadR5Network(String dataFolder) throws Exception {
        File file = new File(dataFolder, "network.dat");
        if (!file.isFile()) {
            NetworkBuilder.createR5Network(dataFolder);
        } else if (!NetworkChecker.checkR5NetworkVersion(dataFolder)) {
            NetworkBuilder.createR5Network(dataFolder);
        }
        return NetworkBuilder.loadR5Network(dataFolder);
    }

    public static TransportNetwork loadR5Network(String dataFolder) throws Exception {
        return KryoNetworkSerializer.read((File)new File(dataFolder, "network.dat"));
    }

    public static void createR5Network(String dataFolder) {
        File dir = new File(dataFolder);
        NetworkBuilder.cleanUpMapdb(dir);
        NetworkBuilder.loadDirectory(dir);
        TransportNetwork tn = NetworkBuilder.createNetwork();
        Map<String, String> networkConfig = NetworkBuilder.buildNetworkConfig();
        try {
            KryoNetworkSerializer.write((TransportNetwork)tn, (File)new File(dataFolder, "network.dat"));
            NetworkBuilder.writeNetworkSettings(dataFolder, networkConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeNetworkSettings(String dataFolder, Map<String, String> networkConfig) throws IOException {
        String json = "{" + networkConfig.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(", ")) + "}";
        FileWriter fileWriter = new FileWriter(new File(dataFolder, "network_settings.json"));
        PrintWriter printWriter = new PrintWriter(fileWriter);
        printWriter.print(json);
        printWriter.close();
    }

    private static Map<String, String> buildNetworkConfig() {
        LinkedHashMap<String, String> networkConfig = new LinkedHashMap<String, String>();
        networkConfig.put("r5_version", "7.0");
        networkConfig.put("r5_network_version", "nv3");
        networkConfig.put("r5r_version", "1.1.0");
        networkConfig.put("creation_date", LocalDateTime.now().toString());
        networkConfig.put("pbf_file_name", osmFilename);
        for (int i = 0; i < gtfsFiles.size(); ++i) {
            networkConfig.put("gtfs_" + (i + 1), gtfsFiles.get(i));
        }
        networkConfig.put("use_elevation", String.valueOf(useNativeElevation));
        networkConfig.put("elevation_cost_function", elevationCostFunction);
        networkConfig.put("tiff_file_name", tiffFile);
        return networkConfig;
    }

    private static TransportNetwork createNetwork() {
        TransportNetwork network = new TransportNetwork();
        network.scenarioId = "r5r";
        network.streetLayer = new StreetLayer();
        network.streetLayer.loadFromOsm(osmFile);
        osmFile.close();
        network.streetLayer.parentNetwork = network;
        network.streetLayer.indexStreets();
        network.transitLayer = new TransitLayerWithShapes();
        gtfsFeeds.forEach(gtfsFeed -> {
            network.transitLayer.loadFromGtfs(gtfsFeed);
            gtfsFeed.close();
        });
        network.transitLayer.parentNetwork = network;
        network.streetLayer.associateStops(network.transitLayer);
        network.streetLayer.buildEdgeLists();
        network.rebuildTransientIndexes();
        TransferFinder transferFinder = new TransferFinder(network);
        transferFinder.findTransfers();
        transferFinder.findParkRideTransfer();
        try {
            if (useNativeElevation && !tiffFile.equals("")) {
                RasterCost elevationRaster = new RasterCost();
                elevationRaster.dataSourceId = FilenameUtils.removeExtension((String)tiffFile);
                elevationRaster.costFunction = RasterCost.CostFunction.valueOf((String)elevationCostFunction);
                elevationRaster.resolve(network);
                elevationRaster.apply(network);
            }
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        network.scenarioId = "r5r";
        network.transitLayer.buildDistanceTables(null);
        new TransferFinder(network).findTransfers();
        return network;
    }

    public static void loadDirectory(File directory) {
        osmFilename = "";
        tiffFile = "";
        gtfsFiles.clear();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            String name = file.getName();
            if (name.endsWith(".pbf")) {
                osmFilename = file.getAbsolutePath();
                osmFile = new OSM(osmFilename + ".mapdb");
                NetworkBuilder.osmFile.intersectionDetection = true;
                osmFile.readFromFile(osmFilename);
            }
            if (name.endsWith(".zip")) {
                gtfsFiles.add(file.getAbsolutePath());
            }
            if (!(name.endsWith(".tif") | name.endsWith(".tiff"))) continue;
            tiffFile = file.getAbsolutePath();
        }
        gtfsFeeds = gtfsFiles.stream().map(GTFSFeed::readOnlyTempFileFromGtfs);
    }

    private static void cleanUpMapdb(File dir) {
        File[] mapdbFiles = dir.listFiles((d, name) -> name.contains(".mapdb"));
        if (mapdbFiles != null) {
            for (File file : mapdbFiles) {
                file.delete();
            }
        }
    }

    static {
        tiffFile = "";
    }
}

