% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set_speed}
\alias{set_speed}
\title{Set walk and bike speed}
\usage{
set_speed(r5r_core, speed, mode)
}
\arguments{
\item{r5r_core}{An object to connect with the R5 routing engine, created with
\code{\link[=setup_r5]{setup_r5()}}.}

\item{speed}{A number representing the speed in km/h.}

\item{mode}{A string. Either \code{"bike"} or \code{"walk"}.}
}
\value{
Invisibly returns \code{TRUE}.
}
\description{
This function receives the walk and bike 'speed' inputs in Km/h from routing
functions above and converts them to meters per second, which is then used
to set these speed profiles in r5r JAR.
}
\seealso{
Other setting functions: 
\code{\link{set_breakdown}()},
\code{\link{set_cutoffs}()},
\code{\link{set_expanded_travel_times}()},
\code{\link{set_fare_cutoffs}()},
\code{\link{set_fare_structure}()},
\code{\link{set_max_fare}()},
\code{\link{set_max_lts}()},
\code{\link{set_max_rides}()},
\code{\link{set_monte_carlo_draws}()},
\code{\link{set_n_threads}()},
\code{\link{set_output_dir}()},
\code{\link{set_percentiles}()},
\code{\link{set_progress}()},
\code{\link{set_suboptimal_minutes}()},
\code{\link{set_time_window}()},
\code{\link{set_verbose}()}
}
\concept{setting functions}
\keyword{internal}
