% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratioOfQsprays.R
\docType{methods}
\name{as.ratioOfQsprays}
\alias{as.ratioOfQsprays}
\alias{as.ratioOfQsprays,character-method}
\alias{as.ratioOfQsprays,ratioOfQsprays-method}
\alias{as.ratioOfQsprays,qspray-method}
\alias{as.ratioOfQsprays,numeric-method}
\alias{as.ratioOfQsprays,bigz-method}
\alias{as.ratioOfQsprays,bigq-method}
\title{Coercion to a 'ratioOfQsprays' object}
\usage{
\S4method{as.ratioOfQsprays}{character}(x)

\S4method{as.ratioOfQsprays}{ratioOfQsprays}(x)

\S4method{as.ratioOfQsprays}{qspray}(x)

\S4method{as.ratioOfQsprays}{numeric}(x)

\S4method{as.ratioOfQsprays}{bigz}(x)

\S4method{as.ratioOfQsprays}{bigq}(x)
}
\arguments{
\item{x}{a \code{ratioOfQsprays} object, a \code{qspray} object, or an
object yielding a quoted integer or a quoted fraction after an application
of \code{as.character}, e.g. a \code{bigq} number}
}
\value{
This returns \code{x} if \code{x} already is a \code{ratioOfQsprays}
  object, otherwise this returns the \code{ratioOfQsprays} object whose
  numerator is the coercion of \code{x} to a \code{qspray} object and whose
  denominator is the unit \code{qspray} object.
}
\description{
Coercion to a 'ratioOfQsprays' object
}
\examples{
library(qspray)
as.ratioOfQsprays(2)
as.ratioOfQsprays("1/3")
( qspray <- 5*qlone(1) + qlone(2)^2 )
as.ratioOfQsprays(qspray)
# show options are inherited:
showQsprayOption(qspray, "x") <- "A"
as.ratioOfQsprays(qspray)
}
