% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gcomp_binary}
\alias{gcomp_binary}
\title{Utility function for Generalized G-computation for Binary Outcomes}
\usage{
gcomp_binary(
  data,
  outcome = "CRIT1FLN",
  treatment = "TRT",
  covariates = c("BASE", "STRATA", "REGION"),
  reference = "Placebo",
  contrast = "diff",
  method = "Ge",
  type = "HC0",
  ...
)
}
\arguments{
\item{data}{A data.frame containing the analysis dataset.}

\item{outcome}{Name of the binary outcome variable (as string).}

\item{treatment}{Name of the treatment variable (as string).}

\item{covariates}{Character vector of covariate names to adjust for.}

\item{reference}{Reference level for the treatment variable (default: "Placebo").}

\item{contrast}{Type of contrast to compute (default: "diff").}

\item{method}{Marginal estimation method for variance (default: "Ge").}

\item{type}{Variance estimator type (default: "HC0").}

\item{...}{Additional arguments passed to \code{beeca::get_marginal_effect()}.}
}
\value{
A named list with treatment effect estimate, standard error, and degrees of freedom (if applicable).
}
\description{
Wrapper function for targeting a marginal treatment effect
using g-computation using the beeca package. Intended for binary endpoints.
}
\examples{
# Load required packages
library(rbmiUtils)
library(beeca)      # for get_marginal_effect()
library(dplyr)
# Load example data
data("ADMI")
# Ensure correct factor levels
ADMI <- ADMI \%>\%
  mutate(
    TRT = factor(TRT, levels = c("Placebo", "Drug A")),
    STRATA = factor(STRATA),
    REGION = factor(REGION)
  )
# Apply g-computation for binary responder
result <- gcomp_binary(
  data = ADMI,
  outcome = "CRIT1FLN",
  treatment = "TRT",
  covariates = c("BASE", "STRATA", "REGION"),
  reference = "Placebo",
  contrast = "diff",
  method = "Ge",    # from beeca: GEE robust sandwich estimator
  type = "HC0"      # from beeca: heteroskedasticity-consistent SE
)

# Print results
print(result)

}
