% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{add_metadata}
\alias{add_metadata}
\title{Add metadata attributes to a data frame}
\usage{
add_metadata(data, metadata, ..., set_data_types = FALSE)
}
\arguments{
\item{data}{A data frame containing the raw dataset.}

\item{metadata}{A data frame that serves as a metadata dictionary. It must contain
at least the columns: \code{variable_name}, \code{label}, and \code{type}. Optionally,
it may include a \code{valueset} column for categorical variables, which should be
a list column with data frames containing \code{value} and \code{label} columns.}

\item{...}{Additional arguments (currently unused).}

\item{set_data_types}{Logical; if \code{TRUE}, attempts to coerce column data types
to match those implied by the metadata. (Note: currently not fully implemented.)}
}
\value{
A `tibble` with the same data as \code{data}, but with added attributes:
  - Variable labels (via the \code{label} attribute)
  - Value labels (as a \code{haven::labelled} class, if applicable)
}
\description{
Adds variable labels and value labels to a data frame based on a metadata
dictionary. This is particularly useful for preparing datasets for use with
packages like \code{haven} or for exporting to formats like SPSS or Stata.
}
\details{
The function first checks the structure of the \code{metadata} using an internal helper.
Then, for each variable listed in \code{metadata}, it:
- Adds a label using the \code{label} attribute
- Converts values to labelled vectors using \code{haven::labelled()} if a \code{valueset} is provided

If value labels are present, the function tries to align data types between the data
and the valueset (e.g., converting character codes to integers if necessary).
}
\examples{
data <- data.frame(
  sex = c(1, 2, 1),
  age = c(23, 45, 34)
)

metadata <- data.frame(
  variable_name = c("sex", "age"),
  label = c("Gender", "Age in years"),
  type = c("categorical", "numeric"),
  valueset = I(list(
    data.frame(value = c(1, 2), label = c("Male", "Female")),
    NULL
  ))
)

labelled_data <- add_metadata(data, metadata)
str(labelled_data)

}
