% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valley.R
\name{get_stac_asset_urls}
\alias{get_stac_asset_urls}
\title{Retrieve the URLs of all the assets intersecting a bbox from a STAC API}
\usage{
get_stac_asset_urls(bb, endpoint = NULL, collection = NULL)
}
\arguments{
\item{bb}{A bounding box, provided either as a matrix (rows for "x", "y",
columns for "min", "max") or as a vector ("xmin", "ymin", "xmax", "ymax"),
in lat/lon coordinates (WGS84 coordinate referece system) of class \code{bbox}}

\item{endpoint}{URL of the STAC API endpoint. To be provided together with
\code{stac_collection}, or leave blank to use defaults (see
\code{\link{default_stac_dem}})}

\item{collection}{Identifier of the STAC collection to be queried. To be
provided together with \code{stac_endpoint}, or leave blank to use defaults
(see \code{\link{default_stac_dem}})}
}
\value{
A list of URLs for the assets in the collection overlapping with
the specified bounding box
}
\description{
Retrieve the URLs of all the assets intersecting a bbox from a STAC API
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
get_stac_asset_urls(bb)

# Use non-default STAC API
get_stac_asset_urls(bb,
                    endpoint = "some endpoint",
                    collection = "some collection")
\dontshow{\}) # examplesIf}
}
