% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_event_data}
\alias{get_event_data}
\title{Get event data from the newer DHIS2 versions (version >= 2.41)}
\usage{
get_event_data(
  login,
  api_version,
  org_unit,
  program,
  data_elements,
  programs,
  program_stages,
  org_units
)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}

\item{api_version}{A numeric with the API version returned by the
\code{get_api_version()} function}

\item{org_unit}{A character with the organisation unit ID or name}

\item{program}{A character with the program ID or name}

\item{data_elements}{A data frame with the data element IDs and names
obtained from the \code{get_data_elements()} function}

\item{programs}{A data frame with the program IDs and names obtained from the
\code{get_programs()} function}

\item{program_stages}{A data frame with the program stages IDs and names
obtained from the \code{get_program_stages()} function}

\item{org_units}{A data frame with the organisation units IDs and names
obtained from the \code{get_organisation_units()} function}
}
\value{
A data frame with the data elements obtained from each event
}
\description{
Get event data from the newer DHIS2 versions (version >= 2.41)
}
\keyword{internal}
