% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cashrate.R
\name{read_cashrate}
\alias{read_cashrate}
\alias{rba_cashrate}
\title{Convenience function to get the RBA's cash rate.}
\usage{
read_cashrate(type = c("target", "interbank", "both"))

rba_cashrate(...)
}
\arguments{
\item{type}{One of \code{'target'} (the default), \code{'interbank'}, or \code{'both'}.
\describe{
\item{\code{'target'}}{ The RBA's cash rate target.}
\item{\code{'interbank'}}{ The interbank overnight cash rate.}
\item{\code{'both'}}{ Both the cash rate target and interbank overnight cash rate.}
}

\code{'target'} fetches the RBA cash rate target. \code{'interbank'}}

\item{...}{arguments passed to \code{read_cashrate()}}
}
\value{
A \code{tbl_df} with two columns: \code{date} and \code{cash_rate}.
}
\description{
Convenience function to get the RBA's cash rate.
}
\details{
Note that in the very early 1990s, the cash rate target was
expressed as a range (eg. "17\% to 17.5\%"). Where this is the case,
the value returned here (and in \code{read_rba()}) is the mid-point of this range.

If \code{type = 'both'}, note that the returned tbl is tidy/long.

\code{rba_cashrate()} is a wrapper around \code{read_cashrate()}.
}
