% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redatam-query.R
\name{redatam_query}
\alias{redatam_query}
\title{Execute a Redatam command from text}
\usage{
redatam_query(dic, spc, tot.omit = TRUE)
}
\arguments{
\item{dic}{Dictionary identifier}

\item{spc}{Program text in SPC format}

\item{tot.omit}{Omit rows containing total, na y mv values}
}
\value{
{
If the program contains more than one table, the method returns the last table (in the SPC program) as a data frame.
All the tables are registered (as data frames) in a custom environment called \sQuote{redatam::outputs}.
}
}
\description{
Execute a Redatam command: TABLE or AREALIST.
This function removes all the rows that contain total, na or mv values. Additionally, this function removes the "mask" columns.
}
\examples{
\dontrun{
dic<-redatam_open("path/to/rxdb")
df<-redatam_query(dic,"freq person.sexo")
print(df)
}
}
\author{
Jaime Salvador
}
