% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refdb_clean.R
\name{refdb_clean_tax_remove_subsp}
\alias{refdb_clean_tax_remove_subsp}
\title{Remove subspecific information from taxonomic names}
\usage{
refdb_clean_tax_remove_subsp(x, cols = NULL)
}
\arguments{
\item{x}{a reference database.}

\item{cols}{an optional vector of column names.
If \code{NULL} (default), the function is applied to the columns
associated with the \code{taxonomy} and \code{organism} fields.}
}
\value{
A reference database.
}
\description{
Remove subspecific information from taxonomic names
}
\examples{
lib <- read.csv(system.file("extdata", "baetidae_bold.csv", package = "refdb"))
lib <- refdb_set_fields_BOLD(lib)
refdb_clean_tax_remove_subsp(lib)

}
