% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_regmedint_class_user_methods.R
\name{summary.regmedint}
\alias{summary.regmedint}
\title{summary method for regmedint object}
\usage{
\method{summary}{regmedint}(
  object,
  a0 = NULL,
  a1 = NULL,
  m_cde = NULL,
  c_cond = NULL,
  args_mreg_fit = list(),
  args_yreg_fit = list(),
  exponentiate = FALSE,
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{An object of the \code{\link{regmedint}} class.}

\item{a0}{A numeric vector of length 1}

\item{a1}{A numeric vector of length 1}

\item{m_cde}{A numeric vector of length 1 The mediator value at which the controlled direct effect (CDE) conditional on the adjustment covariates is evaluated. If not provided, the default value supplied to the call to \code{\link{regmedint}} will be used. Only the CDE is affected.}

\item{c_cond}{A numeric vector of the same length as \code{cvar}. A set of covariate values at which the conditional natural effects are evaluated.}

\item{args_mreg_fit}{A named list of argument to be passed to the method for the \code{mreg_fit} object.}

\item{args_yreg_fit}{A named list of argument to be passed to the method for the \code{mreg_fit} object.}

\item{exponentiate}{Whether to add exponentiated point and confidence limit estimates. When \code{yreg = "linear"}, it is ignored.}

\item{level}{Confidence level for the confidence intervals.}

\item{...}{For compatibility with the generic. Ignored.}
}
\value{
A \code{summary_regmedint} object, which is a list containing the summary objects of the \code{mreg_fit} and the \code{yreg_fit} as well as the mediation analysis results.
}
\description{
Summarize the \code{mreg_fit}, \code{yreg_fit}, and the mediation analysis effect estimates.
}
\examples{
library(regmedint)
data(vv2015)
regmedint_obj <- regmedint(data = vv2015,
                           ## Variables
                           yvar = "y",
                           avar = "x",
                           mvar = "m",
                           cvar = c("c"),
                           eventvar = "event",
                           ## Values at which effects are evaluated
                           a0 = 0,
                           a1 = 1,
                           m_cde = 1,
                           c_cond = 0.5,
                           ## Model types
                           mreg = "logistic",
                           yreg = "survAFT_weibull",
                           ## Additional specification
                           interaction = TRUE,
                           casecontrol = FALSE)
## Detailed result with summary
summary(regmedint_obj)
## Add exponentiate results for non-linear outcome models
summary(regmedint_obj, exponentiate = TRUE)
## Evaluate at different values
summary(regmedint_obj, m_cde = 0, c_cond = 1)
## Change confidence level
summary(regmedint_obj, m_cde = 0, c_cond = 1, level = 0.99)

}
