% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_utils.R
\name{compute_frechet_mean}
\alias{compute_frechet_mean}
\title{Compute the Frechet Mean}
\usage{
compute_frechet_mean(sample, tol = 0.05, max_iter = 20, lr = 0.2)
}
\arguments{
\item{sample}{An object of class \code{CSample} containing the sample data.}

\item{tol}{A numeric value specifying the tolerance for convergence. Default is 0.05.}

\item{max_iter}{An integer specifying the maximum number of iterations. Default is 20.}

\item{lr}{A numeric value specifying the learning rate. Default is 0.2.}
}
\value{
The computed Frechet mean.
}
\description{
This function computes the Frechet mean of a sample using an iterative algorithm.
}
\details{
The function iteratively updates the reference point of the sample until the change in the reference point is less than the specified tolerance or the maximum number of iterations is reached. If the tangent images are not already computed, they will be computed before starting the iterations.
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  # Load the AIRM metric object
  data(airm)
  # Create a CSample object with example data
  conns <- list(
    diag(2) |> Matrix::nearPD() |> _$mat |> Matrix::pack(),
    diag(c(2, 3)) |> Matrix::nearPD() |> _$mat |> Matrix::pack()
  )
  sample <- CSample$new(conns = conns, metric_obj = airm)
  # Compute the Frechet mean
  compute_frechet_mean(sample, tol = 0.01, max_iter = 50, lr = 0.1)
}
}
