% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleData.R
\name{sampleData}
\alias{sampleData}
\title{Simulate data with binary or time-to-event outcome}
\usage{
sampleData(n,outcome="competing.risks",
formula= ~ f(X1,2)+f(X2,-0.033)+f(X3,0.4)+f(X6,.1)+f(X7,-.1)+f(X8,.5)+f(X9,-1),
          intercept=0)
}
\arguments{
\item{n}{Sample size}

\item{outcome}{Character vector. Response variables are generated
according to keywords: \code{"binary"} = binary response,
\code{"survival"} = survival response, \code{"competing.risks"} =
competing risks response}

\item{formula}{Specify regression coefficients}

\item{intercept}{For binary outcome the intercept of the logistic regression.}
}
\value{
Simulated data as data.table with n rows and the following columns:
Y (binary outcome), time (non-binary outcome), event (non-binary outcome),
X1-X5 (binary predictors), X6-X10 (continous predictors)
}
\description{
Simulate data with binary outcome and 10 covariates.
}
\details{
For the actual lava::regression parameters see the function definition.
}
\examples{
set.seed(10)
sampleData(10,outcome="binary")
sampleData(10,outcome="survival")
sampleData(10,outcome="competing.risks")
}
\seealso{
lvm
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
