% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{rrda.heatmap}
\alias{rrda.heatmap}
\title{Heatmap of the results of cross-validation for Bhat obtained from the \code{rrda.cv} function.}
\usage{
rrda.heatmap(
  cv_result,
  nrank = NULL,
  min_l = NULL,
  max_l = NULL,
  highlight_min = TRUE,
  title = NULL
)
}
\arguments{
\item{cv_result}{A result list from the function \code{rrda.cv}, containing a matrix of MSE values for each rank and lambda, and a vector of lambda values.}

\item{nrank}{A numeric vector specifying the ranks of Bhat to be plotted. Default is \code{NULL}, which plots all ranks.}

\item{min_l}{Minimum lambda value to be plotted. Default is \code{NULL}, which uses the minimum lambda value in \code{cv_result}.}

\item{max_l}{Maximum lambda value to be plotted. Default is \code{NULL}, which uses the maximum lambda value in \code{cv_result}.}

\item{highlight_min}{Logical indicating if the marks should be plotted on the best prediction point, and 1se point. Default is \code{TRUE}.}

\item{title}{Title of the figure}
}
\value{
A heatmap of MSE cross-validation results.
}
\description{
This function creates a heatmap to visualize the Mean Squared Error (MSE) results from the cross-validation of the Bhat matrix obtained from the rrda.cv function. The heatmap displays the MSE for different ranks of Bhat and values of the regularization parameter lambda, allowing users to visually assess the best combination of rank and lambda. The function also allows the user to highlight the points corresponding to the minimum MSE and the 1-standard error rule, helping to identify optimal model parameters.
}
\examples{
set.seed(10)
simdata<-rdasim1(n = 10,p = 30,q = 30,k = 3) # data generation
X <- simdata$X
Y <- simdata$Y

cv_result<- rrda.cv(Y = Y, X = X, maxrank = 5, nfold = 5) # cv
rrda.summary(cv_result = cv_result)
rrda.heatmap(cv_result=cv_result)
}
