% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSVDdpd.R
\name{rSVDdpd}
\alias{rSVDdpd}
\title{Robust Singular Value Decomposition using Density Power Divergence}
\usage{
rSVDdpd(
  X,
  alpha,
  nd = NA,
  tol = 1e-04,
  eps = 1e-04,
  maxiter = 100L,
  initu = NULL,
  initv = NULL
)
}
\arguments{
\item{X}{\code{matrix}, whose singular value decomposition is required}

\item{alpha}{\code{numeric}, robustness parameter between 0 and 1. See details for more.}

\item{nd}{\code{integer}, must be lower than \code{nrow(X)} and \code{ncol(X)} both. If 
NA, defaults to \code{min(nrow(X), ncol(X))}}

\item{tol}{\code{numeric}, a tolerance level. If the residual matrix has lower 
norm than this, then subsequent singular values will be taken as 0.}

\item{eps}{\code{numeric}, a tolerance level for the convergence of singular 
vectors. If in subsequent iterations the singular vectors do not change its 
norm beyond this, then the iteration will stop.}

\item{maxiter}{\code{integer}, upper limit to the maximum number of iterations.}

\item{initu}{\code{matrix}, initializing vectors for left singular values. Must be of dimension \code{nrow(X)} \eqn{\times} \code{min(nrow(X), ncol(X))}. If \code{NULL}, defaults to random initialization.}

\item{initv}{\code{matrix}, initializing vectors for right singular values. Must be of dimension \code{ncol(X)} \eqn{\times} \code{min(nrow(X), ncol(X))}. If \code{NULL}, defaults to random initialization.}
}
\value{
A list containing different components of the decomposition \eqn{X = U D V'}
\itemize{
\item d - The robust singular values, namely the diagonal entries of \eqn{D}.
\item u - The matrix of left singular vectors \eqn{U}. Each column is a singular vector.
\item v - The matrix of right singular vectors \eqn{V}. Each column is a singular vector.
}
}
\description{
\code{rSVDdpd} returns the singular value decomposition of a matrix with robust
singular values in presence of outliers
}
\details{
The usual singular value decomposition is highly prone to error in 
presence of outliers, since it tries to minimize the \eqn{L_2} norm of the errors
between the matrix \eqn{X} and its best lower rank approximation. While there is
considerable effort to impose robustness using \eqn{L_1} norm of the errors instead
of \eqn{L_2} norm, such estimation lacks efficiency. Application of density power
divergence bridges the gap.
\deqn{DPD(f|g) = \int f^{(1+\alpha)} - (1 + \frac{1}{\alpha}) \int f^{\alpha}g + \frac{1}{\alpha} \int g^{(1 + \alpha)} }
The parameter \code{alpha} should be between 0 and 1, if not, then a warning is shown.
Lower \code{alpha} means less robustness
but more efficiency in estimation, while higher \code{alpha} means high robustness but 
less efficiency in estimation. The recommended value of \code{alpha} is 0.3.
The function tries to obtain the best rank one approximation of a matrix by minimizing 
this density power divergence of the true errors with that of a normal distribution centered
at the origin.
}
\examples{
X = matrix(1:20, nrow = 4, ncol = 5)
rSVDdpd(X, alpha = 0.3)
}
\references{
S. Roy, A. Basu and A. Ghosh (2021), A New Robust Scalable Singular Value Decomposition Algorithm for Video Surveillance Background Modelling
\url{https://arxiv.org/abs/2109.10680}
}
\seealso{
\code{\link{svd}}
}
