% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lovb.R
\name{load_lovb_pbp}
\alias{load_lovb_pbp}
\title{Load cleaned lovb play-by-play data from the volleydata repository.}
\usage{
load_lovb_pbp(seasons = NULL)
}
\arguments{
\item{seasons}{An integer or vector of integers of seasons to fetch data for. Defaults to all available seasons.}
}
\value{
A data frame containing the play-by-play data for the specified seasons.\tabular{ll}{
   Column Name \tab Type \cr
   match_id \tab int \cr
   season \tab int \cr
   match_datetime \tab string \cr
   home_team_name \tab string \cr
   away_team_name \tab string \cr
   team_involved \tab string \cr
   jersey_number \tab int \cr
   action \tab string \cr
   outcome \tab string \cr
   set \tab int \cr
   point_number \tab int \cr
   point_winner \tab string \cr
   home_score \tab int \cr
   away_score \tab int \cr
}
}
\description{
Load cleaned lovb play-by-play data from the volleydata repository.
}
\examples{
\donttest{try({load_lovb_pbp(2025)})}
}
