% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{moments.grouped}
\alias{moments.grouped}
\title{Moyenne, variance et variance corrigée (Sheppard)}
\usage{
moments.grouped(gp.data, population = FALSE)
}
\arguments{
\item{gp.data}{Un objet de classe grouped.data créé avec le package \code{actuar}.}

\item{population}{Un booléen qui indique si le calcul est réalisé à partir d'une population (\code{population=TRUE}) ou à partir d'un échantillon pour estimer un paramètre d'une population (\code{population=FALSE}).}
}
\value{
Une liste comportant trois éléments :
\enumerate{
\item La moyenne de la distribution groupée \code{mu}
\item La variance de la distribution non corrigée avec la correction de Sheppard \code{sigma2}
\item La variance de la distribution corrigée avec la correction de Sheppard \code{sigma2Adj}
\item L'asymétrie de Fisher de la distribution \code{sigma2}
\item L'asymétrie de Pearson de la distribution \code{sigma2}
\item L'applatissement de Pearson de la distribution corrigée avec la correction de Sheppard \code{sigma2}
\item L'applatissement de Fisher de la distribution corrigée avec la correction de Sheppard \code{sigma2}
}
}
\description{
Pour une distribution groupée, cette fonction la moyenne, la variance et la variance corrigée à l'aide de la correction de Sheppard.
}
\examples{
lims <- c(40, 45, 50, 55, 60, 65, 70, 75)
counts <- c(1,2,3,4,0,0,1)
grouped.example <- actuar::grouped.data(Group = lims, Frequency = counts)
moments.grouped(grouped.example)

}
