% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-coverage.R
\name{plot_interval_coverage}
\alias{plot_interval_coverage}
\title{Plot interval coverage}
\usage{
plot_interval_coverage(coverage, colour = "model")
}
\arguments{
\item{coverage}{A data frame of coverage values as produced by
\code{\link[=get_coverage]{get_coverage()}}.}

\item{colour}{According to which variable shall the graphs be coloured?
Default is "model".}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Plot interval coverage values (see \code{\link[=get_coverage]{get_coverage()}} for more information).
}
\examples{
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}
example <- as_forecast_quantile(example_quantile)
coverage <- get_coverage(example, by = "model")
plot_interval_coverage(coverage)
}
