% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qq_env_small.R
\name{qqplot_env_pois}
\alias{qqplot_env_pois}
\title{Q-Q plot comparing samples with a theoretical Poisson distribution}
\usage{
qqplot_env_pois(sample_data, lambda, envelope_size = 100, ...)
}
\arguments{
\item{sample_data}{A numeric vector of sample data points or an S3 object for class 'scppp'.}

\item{lambda}{A numeric value specifying the theoretical Poisson parameter.}

\item{envelope_size}{A numeric value specifying the size of envelope on Q-Q plot (default 100).}

\item{...}{not used.}
}
\value{
A ggplot object.
}
\description{
This function returns a Q-Q plot with envelope using a more "continuous" approximation of quantiles.
}
\details{
This is a function for Q-Q envelope plot used to compare whether given sample data points come from the
theoretical Poisson distribution.  By simulating repeated samples of the same size from the candidate
theoretical distribution, and overlaying the envelope on the same figure, it provides a feeling of
understanding the natural variation from the theoretical distribution.

If an S3 object for class 'scppp' is used as input and the stored result under "data" is a matrix,
The GLM-PCA algorithm will be applied to estimate the Poisson parameter for each matrix entry.
Then a specific number of entries will be selected as sample data points to compare with the theoretical Poisson distribution.
}
\references{
\insertRef{glmpca}{scpoisson}
}
