% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visreg.R
\name{visreg_delta}
\alias{visreg_delta}
\alias{visreg2d_delta}
\title{Plot sdmTMB models with the \pkg{visreg} package}
\usage{
visreg_delta(object, ..., model = c(1, 2))

visreg2d_delta(object, ..., model = c(1, 2))
}
\arguments{
\item{object}{Fit from \code{\link[=sdmTMB]{sdmTMB()}}}

\item{...}{Any arguments passed to \code{\link[visreg:visreg]{visreg::visreg()}} or
\code{\link[visreg:visreg2d]{visreg::visreg2d()}}}

\item{model}{1st or 2nd delta model}
}
\value{
A plot from the visreg package. Optionally, the data plotted invisibly if
\code{plot = FALSE}. This is useful if you want to make your own plot after.
}
\description{
sdmTMB models fit with regular (non-delta) families can be passed to
\code{\link[visreg:visreg]{visreg::visreg()}} or \code{\link[visreg:visreg2d]{visreg::visreg2d()}} directly. Examples are shown
below. Delta models can use the helper functions \code{visreg_delta()} or
\code{visreg2d_delta()} described here.
}
\details{
Note the residuals are currently randomized quantile residuals,
\emph{not} deviance residuals as is usual for GLMs with \pkg{visreg}.
}
\examples{
if (require("ggplot2", quietly = TRUE) &&
  require("visreg", quietly = TRUE)) {

\donttest{
  fit <- sdmTMB(
    density ~ s(depth_scaled),
    data = pcod_2011,
    spatial = "off",
    family = tweedie()
  )
  visreg::visreg(fit, xvar = "depth_scaled")

  visreg::visreg(fit, xvar = "depth_scaled", scale = "response")
  v <- visreg::visreg(fit, xvar = "depth_scaled")
  head(v$fit)
  # now use ggplot2 etc. if desired

  # Delta model example:
  fit_dg <- sdmTMB(
    density ~ s(depth_scaled, year, k = 8),
    data = pcod_2011, mesh = pcod_mesh_2011,
    spatial = "off",
    family = delta_gamma()
  )
  visreg_delta(fit_dg, xvar = "depth_scaled", model = 1, gg = TRUE)
  visreg_delta(fit_dg, xvar = "depth_scaled", model = 2, gg = TRUE)
  visreg_delta(fit_dg,
    xvar = "depth_scaled", model = 1,
    scale = "response", gg = TRUE
  )
  visreg_delta(fit_dg,
    xvar = "depth_scaled", model = 2,
    scale = "response"
  )
  visreg_delta(fit_dg,
    xvar = "depth_scaled", model = 2,
    scale = "response", gg = TRUE, rug = FALSE
  )
  visreg2d_delta(fit_dg,
    xvar = "depth_scaled", yvar = "year",
    model = 2, scale = "response"
  )
  visreg2d_delta(fit_dg,
    xvar = "depth_scaled", yvar = "year",
    model = 1, scale = "response", plot.type = "persp"
  )
  visreg2d_delta(fit_dg,
    xvar = "depth_scaled", yvar = "year",
    model = 2, scale = "response", plot.type = "gg"
  )
  }
}
}
