% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_function.R
\name{curve}
\alias{curve}
\title{Analysis: Logistic regression by treatment over time}
\usage{
curve(
  dados,
  trat,
  nrep,
  time,
  n,
  model = LL.3(),
  ylab = "Emergence (\%)",
  xlab = "Time (days)",
  legend.position = c(0.2, 0.8)
)
}
\arguments{
\item{dados}{data.frame containing the responses of the evaluations in separate columns side by side and without the columns with the identification of the factors}

\item{trat}{vector of treatments with n repetitions}

\item{nrep}{Number of repetitions}

\item{time}{vector containing time}

\item{n}{total seeds per repetition}

\item{model}{logistic model according to drc package}

\item{ylab}{y-axis name}

\item{xlab}{x-axis name}

\item{legend.position}{Legend position}
}
\value{
Returns a logistic regression graph by treatment over time.
}
\description{
Performs the construction of a logistic regression graph by treatment over time
}
\examples{
data("substrate")
curve(substrate[,c(3:18)],
      trat = substrate$Trat,
      nrep = 4,
      n=10,
      time = 1:16)
}
