% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_forecast.R
\name{get_data_forecast}
\alias{get_data_forecast}
\title{Set up data for explain_forecast}
\usage{
get_data_forecast(
  y,
  xreg,
  train_idx,
  explain_idx,
  explain_y_lags,
  explain_xreg_lags,
  horizon
)
}
\arguments{
\item{y}{Matrix, data.frame/data.table or a numeric vector.
Contains the endogenous variables used to estimate the (conditional) distributions
needed to properly estimate the conditional expectations in the Shapley formula
including the observations to be explained.}

\item{xreg}{Matrix, data.frame/data.table or a numeric vector.
Contains the exogenous variables used to estimate the (conditional) distributions
needed to properly estimate the conditional expectations in the Shapley formula
including the observations to be explained.
As exogenous variables are used contemporaneously when producing a forecast,
this item should contain nrow(y) + horizon rows.}

\item{train_idx}{Numeric vector.
The row indices in data and reg denoting points in time to use when estimating the conditional expectations in
the Shapley value formula.
If \code{train_idx = NULL} (default) all indices not selected to be explained will be used.}

\item{explain_idx}{Numeric vector.
The row indices in data and reg denoting points in time to explain.}

\item{explain_y_lags}{Numeric vector.
Denotes the number of lags that should be used for each variable in \code{y} when making a forecast.}

\item{explain_xreg_lags}{Numeric vector.
If \code{xreg != NULL}, denotes the number of lags that should be used for each variable in \code{xreg} when making a forecast.}

\item{horizon}{Numeric.
The forecast horizon to explain. Passed to the \code{predict_model} function.}
}
\value{
A list containing
\itemize{
\item The data.frames x_train and x_explain which holds the lagged data examples.
\item A numeric, n_endo denoting how many columns are endogenous in x_train and x_explain.
\item A list, group with groupings of each variable to explain per variable and not per variable and lag.
}
}
\description{
Set up data for explain_forecast
}
\keyword{internal}
