% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality_indices.R
\name{eigen_centrality_signed}
\alias{eigen_centrality_signed}
\title{Signed Eigenvector centrality}
\usage{
eigen_centrality_signed(g, scale = TRUE)
}
\arguments{
\item{g}{igraph object with a sign edge attribute.}

\item{scale}{Logical scalar, whether to scale the result to have a maximum score of one. If no scaling is used then the result vector is the same as returned by \code{eigen()}.}
}
\value{
centrality scores as numeric vector.
}
\description{
returns the eigenvector associated with the dominant eigenvalue from the adjacency matrix.
}
\details{
Note that, with negative values, the adjacency matrix may not have a dominant eigenvalue.
This means it is not clear which eigenvector should be used. In addition it is possible for the adjacency matrix to have repeated eigenvalues and hence multiple linearly independent eigenvectors. In this case certain centralities can be arbitrarily assigned. The function returns an error if this is the case.
}
\examples{
library(igraph)
data("tribes")
eigen_centrality_signed(tribes)
}
\references{
Bonacich, P. and Lloyd, P. (2004). "Calculating Status with Negative Relations." \emph{Social Networks} 26 (4): 331–38.

Everett, M. and Borgatti, S.P. (2014). "Networks Containing Negative Ties." \emph{Social Networks} 38: 111–20.
}
\author{
David Schoch
}
