% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graphs.R
\name{sample_bipartite_signed}
\alias{sample_bipartite_signed}
\title{Bipartite random signed graphs}
\usage{
sample_bipartite_signed(
  n1,
  n2,
  p,
  p_neg,
  directed = FALSE,
  mode = c("out", "in", "all")
)
}
\arguments{
\item{n1}{Integer scalar, the number of bottom vertices.}

\item{n2}{Integer scalar, the number of top vertices.}

\item{p}{The probability for drawing an edge between two arbitrary vertices.}

\item{p_neg}{The probability of a drawn edge to be a negative tie}

\item{directed}{logical, whether the graph will be directed. defaults to FALSE.}

\item{mode}{Character scalar, specifies how to direct the edges in directed graphs. If it is ‘out’, then directed edges point from bottom vertices to top vertices. If it is ‘in’, edges point from top vertices to bottom vertices. ‘out’ and ‘in’ do not generate mutual edges. If this argument is ‘all’, then each edge direction is considered independently and mutual edges might be generated. This argument is ignored for undirected graphs.}
}
\value{
A signed bipartite igraph graph.
}
\description{
Bipartite random signed graphs
}
\examples{
sample_bipartite_signed(10, 10, 0.5, 0.5)
}
