# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert Parameters from the Linear Stochastic Differential Equation Model
#' to State Space Model Parameterization
#'
#' This function converts parameters from
#' the linear stochastic differential equation model
#' to state space model parameterization.
#'
#' @details Let the linear stochastic equation model be given by
#'   \deqn{
#'     \mathrm{d}
#'     \boldsymbol{\eta}_{i, t}
#'     =
#'     \left(
#'       \boldsymbol{\iota}
#'       +
#'       \boldsymbol{\Phi}
#'       \boldsymbol{\eta}_{i, t}
#'     \right)
#'     \mathrm{d} t
#'     +
#'     \boldsymbol{\Sigma}^{\frac{1}{2}}
#'     \mathrm{d}
#'     \mathbf{W}_{i, t}
#'   }
#'   for individual \eqn{i} and time \eqn{t}.
#'   The discrete-time state space model
#'   given below
#'   represents the discrete-time solution
#'   for the linear stochastic differential equation.
#'   \deqn{
#'     \boldsymbol{\eta}_{i, t_{{l_{i}}}}
#'     =
#'     \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
#'     +
#'     \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
#'     \boldsymbol{\eta}_{i, t_{l_{i} - 1}}
#'     +
#'     \boldsymbol{\zeta}_{i, t_{{l_{i}}}},
#'     \quad
#'     \mathrm{with}
#'     \quad
#'     \boldsymbol{\zeta}_{i, t_{{l_{i}}}}
#'     \sim
#'     \mathcal{N}
#'     \left(
#'     \mathbf{0},
#'     \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
#'     \right)
#'   }
#'   with
#'   \deqn{
#'       \boldsymbol{\beta}_{\Delta t_{{l_{i}}}}
#'       =
#'       \exp{
#'         \left(
#'           \Delta t
#'           \boldsymbol{\Phi}
#'         \right)
#'       },
#'   }
#'
#'   \deqn{
#'       \boldsymbol{\alpha}_{\Delta t_{{l_{i}}}}
#'       =
#'       \boldsymbol{\Phi}^{-1}
#'       \left(
#'         \boldsymbol{\beta} - \mathbf{I}_{p}
#'       \right)
#'       \boldsymbol{\iota}, \quad \mathrm{and}
#'   }
#'
#'   \deqn{
#'       \mathrm{vec}
#'       \left(
#'         \boldsymbol{\Psi}_{\Delta t_{{l_{i}}}}
#'       \right)
#'       =
#'       \left[
#'         \left(
#'           \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
#'         \right)
#'         +
#'         \left(
#'           \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
#'         \right)
#'       \right]
#'       \left[
#'         \exp
#'         \left(
#'           \left[
#'             \left(
#'               \boldsymbol{\Phi} \otimes \mathbf{I}_{p}
#'             \right)
#'             +
#'             \left(
#'               \mathbf{I}_{p} \otimes \boldsymbol{\Phi}
#'             \right)
#'           \right]
#'           \Delta t
#'         \right)
#'         -
#'         \mathbf{I}_{p \times p}
#'       \right]
#'       \mathrm{vec}
#'       \left(
#'         \boldsymbol{\Sigma}
#'       \right)
#'   }
#'   where \eqn{t} denotes continuous-time processes
#'   that can be defined by any arbitrary time point,
#'   \eqn{t_{l_{i}}} the \eqn{l^\mathrm{th}}
#'   observed measurement occassion for individual \eqn{i},
#'   \eqn{p} the number of latent variables and
#'   \eqn{\Delta t} the time interval.
#'
#' @references
#'   Harvey, A. C. (1990).
#'   Forecasting, structural time series models and the Kalman filter.
#'   Cambridge University Press.
#'   \doi{10.1017/cbo9781107049994}
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param iota Numeric vector.
#'   An unobserved term that is constant over time
#'   (\eqn{\boldsymbol{\iota}}).
#' @param phi Numeric matrix.
#'   The drift matrix
#'   which represents the rate of change of the solution
#'   in the absence of any random fluctuations
#'   (\eqn{\boldsymbol{\Phi}}).
#' @param sigma_l Numeric matrix.
#'   Cholesky factorization (`t(chol(sigma))`)
#'   of the covariance matrix of volatility
#'   or randomness in the process
#'   (\eqn{\boldsymbol{\Sigma}}).
#' @param delta_t Numeric.
#'   Time interval
#'   (\eqn{\Delta_t}).
#'
#' @return Returns a list of state space parameters:
#'   - `alpha`: Numeric vector.
#'     Vector of constant values for the dynamic model
#'     (\eqn{\boldsymbol{\alpha}}).
#'   - `beta`: Numeric matrix.
#'     Transition matrix relating the values of the latent variables
#'     from the previous time point to the current time point.
#'     (\eqn{\boldsymbol{\beta}}).
#'   - `psi_l`: Numeric matrix.
#'     Cholesky factorization (`t(chol(psi))`)
#'     of the process noise covariance matrix
#'     \eqn{\boldsymbol{\Psi}}.
#'
#' @examples
#' p <- 2
#' iota <- c(0.317, 0.230)
#' phi <- matrix(
#'   data = c(
#'    -0.10,
#'    0.05,
#'    0.05,
#'    -0.10
#'  ),
#'  nrow = p
#' )
#' sigma <- matrix(
#'   data = c(
#'     2.79,
#'     0.06,
#'     0.06,
#'     3.27
#'   ),
#'   nrow = p
#' )
#' sigma_l <- t(chol(sigma))
#' delta_t <- 0.10
#'
#' LinSDE2SSM(
#'   iota = iota,
#'   phi = phi,
#'   sigma_l = sigma_l,
#'   delta_t = delta_t
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace transformation linsde
#' @export
LinSDE2SSM <- function(iota, phi, sigma_l, delta_t) {
    .Call(`_simStateSpace_LinSDE2SSM`, iota, phi, sigma_l, delta_t)
}

.LinSDECovEta <- function(phi, sigma) {
    .Call(`_simStateSpace_LinSDECovEta`, phi, sigma)
}

.LinSDECovY <- function(lambda, theta, cov_eta) {
    .Call(`_simStateSpace_LinSDECovY`, lambda, theta, cov_eta)
}

.LinSDEMeanEta <- function(phi, iota) {
    .Call(`_simStateSpace_LinSDEMeanEta`, phi, iota)
}

.LinSDEMeanY <- function(nu, lambda, mean_eta) {
    .Call(`_simStateSpace_LinSDEMeanY`, nu, lambda, mean_eta)
}

#' Project Matrix to Hurwitz Stability
#'
#' Shifts a square matrix left on the real axis
#' so that its spectral abscissa (maximum real part of the eigenvalues)
#' is strictly less than `-margin`.
#' This is useful for ensuring that continuous-time drift matrices
#' (e.g. in linear SDEs/state-space models) are Hurwitz-stable.
#' If the matrix already satisfies the margin,
#' it is returned unchanged.
#'
#' The projection is performed by subtracting a multiple of the identity:
#' \deqn{x^\star = x - (\alpha + \text{margin}) I,}
#' where \eqn{\alpha = \max \Re\{\lambda_i(x)\}} is the spectral abscissa.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric square matrix.
#' @param margin Positive numeric.
#'   Target buffer inside the Hurwitz region;
#'   the result satisfies
#'   \eqn{\max \Re\{\lambda_i(x^\star)\} \le -\text{margin}}
#'   (default `1e-3`).
#'
#' @return A numeric matrix of the same dimensions as `x`,
#'   shifted if necessary to satisfy the Hurwitz stability constraint.
#'
#' @examples
#' # Unstable (spectral abscissa >= 0):
#' x <- matrix(
#'   data = c(
#'     0.10, -0.40,
#'     0.50, 0.20
#'   ),
#'   nrow = 2
#' )
#' SpectralAbscissa(x = x) # >= 0
#' SpectralAbscissa(x = ProjectToHurwitz(x = x)) # <= -1e-3 (default margin)
#'
#' # Already Hurwitz-stable is returned unchanged up to numerics:
#' x <- matrix(
#'   data = c(
#'     -0.50, -0.20,
#'      1.00, -0.30
#'   ),
#'   nrow = 2
#' )
#' SpectralAbscissa(x = x) # < 0
#' identical(ProjectToHurwitz(x = x), x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace stability linsde
#' @export
ProjectToHurwitz <- function(x, margin = 1e-3) {
    .Call(`_simStateSpace_ProjectToHurwitz`, x, margin)
}

#' Project Matrix to Stability
#'
#' Scales a square matrix
#' so that its spectral radius
#' is strictly less than 1 by a specified stability margin.
#' This is useful for ensuring that transition matrices
#' in state space or vector autoregressive (VAR) models are stationary.
#' If the matrix is already within the margin,
#' it is returned unchanged.
#'
#' The projection is performed
#' by multiplying the matrix by a constant factor
#' \eqn{c = \frac{\text{margin}}{\rho + \text{tol}}},
#' where \eqn{\rho} is the spectral radius and `tol`
#' is a small positive number to prevent division by zero.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric square matrix.
#' @param margin Double in \eqn{(0, 1)}.
#'   Target upper bound for the spectral
#'   radius (default = 0.98).
#' @param tol Small positive double
#'   added to the denominator in the scaling
#'   factor to avoid division by zero
#'   (default `1e-12`).
#'
#' @return A numeric matrix of the same dimensions as `x`,
#'   scaled if necessary to satisfy the stability constraint.
#'
#' @examples
#' # Matrix with eigenvalues greater than 1
#' x <- matrix(
#'   data = c(
#'     1.2, 0.3,
#'     0.4, 0.9
#'   ),
#'   nrow = 2
#' )
#' SpectralRadius(x = x) # > 1
#' SpectralRadius(x = ProjectToStability(x = x))  # < 1
#'
#' # Matrix already stable is returned unchanged
#' x <- matrix(
#'   data = c(
#'     0.5, 0.3,
#'     0.2, 0.4
#'   ),
#'   nrow = 2
#' )
#' identical(ProjectToStability(x = x), x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace stability ssm
#' @export
ProjectToStability <- function(x, margin = 0.98, tol = 1e-12) {
    .Call(`_simStateSpace_ProjectToStability`, x, margin, tol)
}

#' Simulate Intercept Vectors
#' in a Discrete-Time Vector Autoregressive Model
#' from the Multivariate Normal Distribution
#'
#' This function simulates random intercept vectors
#' in a discrete-time vector autoregressive model
#' from the multivariate normal distribution.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param alpha Numeric vector.
#'   Intercept (\eqn{\boldsymbol{\alpha}}).
#' @param vcov_alpha_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_alpha))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\boldsymbol{\alpha}}.
#' @return Returns a list of random intercept vectors.
#'
#' @examples
#' n <- 10
#' alpha <- c(0, 0, 0)
#' vcov_alpha_l <- t(chol(0.001 * diag(3)))
#' SimAlphaN(n = n, alpha = alpha, vcov_alpha_l = vcov_alpha_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimAlphaN <- function(n, alpha, vcov_alpha_l) {
    .Call(`_simStateSpace_SimAlphaN`, n, alpha, vcov_alpha_l)
}

#' Simulate Transition Matrices
#' from the Multivariate Normal Distribution
#' and Project to Stability
#'
#' This function simulates random transition matrices
#' from the multivariate normal distribution
#' then projects each draw to the stability region
#' using [ProjectToStability()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param beta Numeric matrix.
#'   The transition matrix (\eqn{\boldsymbol{\beta}}).
#' @param vcov_beta_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_beta_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.
#' @param margin Double in \eqn{(0, 1)}.
#'   Target upper bound for the spectral radius
#'   (default = 0.98).
#' @param tol Small positive double added to the denominator
#'   in the scaling factor to avoid division by zero
#'   (default = 1e-12).
#' @return Returns a list of random transition matrices.
#'
#' @examples
#' n <- 10
#' beta <- matrix(
#'   data = c(
#'     0.7, 0.5, -0.1,
#'     0.0, 0.6, 0.4,
#'     0, 0, 0.5
#'   ),
#'   nrow = 3
#' )
#' vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
#' SimBetaN2(n = n, beta = beta, vcov_beta_vec_l = vcov_beta_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimBetaN2 <- function(n, beta, vcov_beta_vec_l, margin = 0.98, tol = 1e-12) {
    .Call(`_simStateSpace_SimBetaN2`, n, beta, vcov_beta_vec_l, margin, tol)
}

#' Simulate Transition Matrices with a Covariate
#' from the Multivariate Normal Distribution
#'
#' This function simulates random transition matrices from a multivariate
#' normal distribution, allowing the mean transition matrix to vary as a
#' linear function of a covariate.
#' The function ensures that the generated transition matrices are stationary
#' using [TestStationarity()] with a rejection sampling approach.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param beta0 Numeric matrix.
#'   Baseline transition matrix \eqn{\boldsymbol{\beta}_0}
#'   corresponding to \eqn{\mathbf{x} = \mathbf{0}}.
#' @param vcov_beta_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_beta_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.
#' @param beta1 Numeric matrix.
#'   Matrix of covariate effects mapping \eqn{\mathbf{x}} to
#'   \eqn{\mathrm{vec}(\boldsymbol{\beta})}.
#' @param x List of numeric vectors.
#'   Covariate values.
#' @param margin Numeric scalar specifying the stationarity threshold.
#'   Values less than 1 indicate stricter stationarity criteria.
#' @param beta_lbound Optional numeric matrix of same dim as `beta`.
#'   Use NA for no lower bound.
#' @param beta_ubound Optional numeric matrix of same dim as `beta`.
#'   Use NA for no upper bound.
#' @param bound Logical;
#'   if TRUE, resample until all elements respect bounds (NA bounds ignored).
#' @param max_iter Safety cap on resampling attempts per draw.
#' @return Returns a list of random transition matrices.
#'
#' @examples
#' n <- 5
#' beta0 <- matrix(
#'   data = c(
#'     0.7, 0.5, -0.1,
#'     0.0, 0.6, 0.4,
#'     0, 0, 0.5
#'   ),
#'   nrow = 3
#' )
#' vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
#' # One scalar covariate per replication
#' beta1 <- matrix(data = 0, nrow = 9, ncol = 1)
#' beta1[1, 1] <- 0.10  # x shifts beta[1,1]
#' x <- list(c(0), c(1), c(-1), c(0.5), c(2))
#'
#' SimBetaNCovariate(
#'   n = n,
#'   beta0 = beta0,
#'   vcov_beta_vec_l = vcov_beta_vec_l,
#'   beta1 = beta1,
#'   x = x
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimBetaNCovariate <- function(n, beta0, vcov_beta_vec_l, beta1, x, margin = 1.0, beta_lbound = NULL, beta_ubound = NULL, bound = FALSE, max_iter = 100000L) {
    .Call(`_simStateSpace_SimBetaNCovariate`, n, beta0, vcov_beta_vec_l, beta1, x, margin, beta_lbound, beta_ubound, bound, max_iter)
}

#' Simulate Transition Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random transition matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated transition matrices are stationary
#' using [TestStationarity()] with a rejection sampling approach.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param beta Numeric matrix.
#'   The transition matrix (\eqn{\boldsymbol{\beta}}).
#' @param vcov_beta_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_beta_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.
#' @param margin Numeric scalar specifying the stationarity threshold.
#'   Values less than 1 indicate stricter stationarity criteria.
#' @param beta_lbound Optional numeric matrix of same dim as `beta`.
#'   Use NA for no lower bound.
#' @param beta_ubound Optional numeric matrix of same dim as `beta`.
#'   Use NA for no upper bound.
#' @param bound Logical;
#'   if TRUE, resample until all elements respect bounds (NA bounds ignored).
#' @param max_iter Safety cap on resampling attempts per draw.
#' @return Returns a list of random transition matrices.
#'
#' @examples
#' n <- 10
#' beta <- matrix(
#'   data = c(
#'     0.7, 0.5, -0.1,
#'     0.0, 0.6, 0.4,
#'     0, 0, 0.5
#'   ),
#'   nrow = 3
#' )
#' vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
#' SimBetaN(n = n, beta = beta, vcov_beta_vec_l = vcov_beta_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimBetaN <- function(n, beta, vcov_beta_vec_l, margin = 1.0, beta_lbound = NULL, beta_ubound = NULL, bound = FALSE, max_iter = 100000L) {
    .Call(`_simStateSpace_SimBetaN`, n, beta, vcov_beta_vec_l, margin, beta_lbound, beta_ubound, bound, max_iter)
}

#' Simulate Diagonal Covariance Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random diagonal covariance matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated covariance matrices
#' are positive semi-definite.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param sigma_diag Numeric matrix.
#'   The covariance matrix
#'   (\eqn{\boldsymbol{\Sigma}}).
#' @param vcov_sigma_diag_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_sigma_vech))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)}.
#' @return Returns a list of random diagonal covariance matrices.
#'
#' @examples
#' n <- 10
#' sigma_diag <- c(1, 1, 1)
#' vcov_sigma_diag_l <- t(chol(0.001 * diag(3)))
#' SimCovDiagN(
#'   n = n,
#'   sigma_diag = sigma_diag,
#'   vcov_sigma_diag_l = vcov_sigma_diag_l
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimCovDiagN <- function(n, sigma_diag, vcov_sigma_diag_l) {
    .Call(`_simStateSpace_SimCovDiagN`, n, sigma_diag, vcov_sigma_diag_l)
}

#' Simulate Covariance Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random covariance matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated covariance matrices
#' are positive semi-definite.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param sigma Numeric matrix.
#'   The covariance matrix
#'   (\eqn{\boldsymbol{\Sigma}}).
#' @param vcov_sigma_vech_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_sigma_vech))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)}.
#' @return Returns a list of random covariance matrices.
#'
#' @examples
#' n <- 10
#' sigma <- matrix(
#'   data = c(
#'     1.0, 0.5, 0.3,
#'     0.5, 1.0, 0.4,
#'     0.3, 0.4, 1.0
#'   ),
#'   nrow = 3
#' )
#' vcov_sigma_vech_l <- t(
#'   chol(
#'     0.001 * diag(3 * (3 + 1) / 2)
#'   )
#' )
#' SimCovN(
#'   n = n,
#'   sigma = sigma,
#'   vcov_sigma_vech_l = vcov_sigma_vech_l
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimCovN <- function(n, sigma, vcov_sigma_vech_l) {
    .Call(`_simStateSpace_SimCovN`, n, sigma, vcov_sigma_vech_l)
}

#' Simulate Intercept Vectors
#' in a Continuous-Time Vector Autoregressive Model
#' from the Multivariate Normal Distribution
#'
#' This function simulates random intercept vectors
#' in a continuous-time vector autoregressive model
#' from the multivariate normal distribution.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param iota Numeric vector.
#'   Intercept (\eqn{\boldsymbol{\iota}}).
#' @param vcov_iota_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_iota))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\boldsymbol{\iota}}.
#' @return Returns a list of random intercept vectors.
#'
#' @examples
#' n <- 10
#' iota <- c(0, 0, 0)
#' vcov_iota_l <- t(chol(0.001 * diag(3)))
#' SimIotaN(n = n, iota = iota, vcov_iota_l = vcov_iota_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimIotaN <- function(n, iota, vcov_iota_l) {
    .Call(`_simStateSpace_SimIotaN`, n, iota, vcov_iota_l)
}

#' Simulate Intercept Vectors
#' in a Discrete-Time Vector Autoregressive Model
#' from the Multivariate Normal Distribution
#'
#' This function simulates random intercept vectors
#' in a discrete-time vector autoregressive model
#' from the multivariate normal distribution.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param nu Numeric vector.
#'   Intercept (\eqn{\boldsymbol{\nu}}).
#' @param vcov_nu_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_nu))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\boldsymbol{\nu}}.
#' @return Returns a list of random intercept vectors.
#'
#' @examples
#' n <- 10
#' nu <- c(0, 0, 0)
#' vcov_nu_l <- t(chol(0.001 * diag(3)))
#' SimNuN(n = n, nu = nu, vcov_nu_l = vcov_nu_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace ssm
#' @export
SimNuN <- function(n, nu, vcov_nu_l) {
    .Call(`_simStateSpace_SimNuN`, n, nu, vcov_nu_l)
}

#' Simulate Random Drift Matrices
#' from the Multivariate Normal Distribution
#' and Project to Hurwitz
#'
#' This function simulates random dirft matrices
#' from the multivariate normal distribution
#' then projects each draw to the Hurwitz-stable region
#' using [ProjectToHurwitz()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#' @param vcov_phi_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_phi_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.
#' @param margin Positive numeric.
#'   Target buffer so that the spectral abscissa
#'   is \eqn{\le -\text{margin}} (default `1e-3`).
#' @return Returns a list of random drift matrices.
#'
#' @examples
#' n <- 10
#' phi <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
#' SimPhiN2(n = n, phi = phi, vcov_phi_vec_l = vcov_phi_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace linsde
#' @export
SimPhiN2 <- function(n, phi, vcov_phi_vec_l, margin = 1e-3) {
    .Call(`_simStateSpace_SimPhiN2`, n, phi, vcov_phi_vec_l, margin)
}

#' Simulate Random Drift Matrices with a Covariate
#' from the Multivariate Normal Distribution
#'
#' This function simulates random drift matrices
#' from the multivariate normal distribution,
#' allowing the mean drift matrix to vary
#' as a linear function of a covariate
#' The function ensures that the generated drift matrices are stable
#' using [TestPhi()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param phi0 Numeric matrix.
#'   Baseline drift matrix (\eqn{\boldsymbol{\Phi}_0}).
#' @param vcov_phi_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_phi_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.
#' @param phi1 Numeric matrix.
#'   Matrix of covariate effects mapping \eqn{\mathbf{x}} to
#'   \eqn{\mathrm{vec}(\boldsymbol{\Phi})}.
#' @param x List of numeric vectors.
#'   Covariate values.
#' @param margin Numeric scalar specifying the stability threshold
#'   for the real part of the eigenvalues.
#'   The default `0.0` corresponds to the imaginary axis;
#'   values less than `0.0` enforce a stricter stability margin.
#' @param auto_ubound Numeric scalar specifying the upper bound
#'   for the diagonal elements of \eqn{\boldsymbol{\Phi}}.
#'   Default is `0.0`, requiring all diagonal values to be \eqn{\leq 0}.
#' @param phi_lbound Optional numeric matrix of same dim as `phi`.
#'   Use NA for no lower bound.
#' @param phi_ubound Optional numeric matrix of same dim as `phi`.
#'   Use NA for no upper bound.
#' @param bound Logical;
#'   if TRUE, resample until all elements respect bounds (NA bounds ignored).
#' @param max_iter Safety cap on resampling attempts per draw.
#' @return Returns a list of random drift matrices.
#'
#' @examples
#' n <- 5
#' phi0 <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
#' # One scalar covariate per replication
#' phi1 <- matrix(data = 0, nrow = 9, ncol = 1)
#' phi1[1, 1] <- 0.10  # x shifts phi[1,1]
#' x <- list(c(0), c(1), c(-1), c(0.5), c(2))
#' SimPhiNCovariate(
#'   n = n,
#'   phi0 = phi0,
#'   vcov_phi_vec_l = vcov_phi_vec_l,
#'   phi1 = phi1,
#'   x = x
#' )
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace linsde
#' @export
SimPhiNCovariate <- function(n, phi0, vcov_phi_vec_l, phi1, x, margin = 0.0, auto_ubound = 0.0, phi_lbound = NULL, phi_ubound = NULL, bound = FALSE, max_iter = 100000L) {
    .Call(`_simStateSpace_SimPhiNCovariate`, n, phi0, vcov_phi_vec_l, phi1, x, margin, auto_ubound, phi_lbound, phi_ubound, bound, max_iter)
}

#' Simulate Random Drift Matrices
#' from the Multivariate Normal Distribution
#'
#' This function simulates random drift matrices
#' from the multivariate normal distribution.
#' The function ensures that the generated drift matrices are stable
#' using [TestPhi()].
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param n Positive integer.
#'   Number of replications.
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#' @param vcov_phi_vec_l Numeric matrix.
#'   Cholesky factorization (`t(chol(vcov_phi_vec))`)
#'   of the sampling variance-covariance matrix of
#'   \eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.
#' @param margin Numeric scalar specifying the stability threshold
#'   for the real part of the eigenvalues.
#'   The default `0.0` corresponds to the imaginary axis;
#'   values less than `0.0` enforce a stricter stability margin.
#' @param auto_ubound Numeric scalar specifying the upper bound
#'   for the diagonal elements of \eqn{\boldsymbol{\Phi}}.
#'   Default is `0.0`, requiring all diagonal values to be \eqn{\leq 0}.
#' @param phi_lbound Optional numeric matrix of same dim as `phi`.
#'   Use NA for no lower bound.
#' @param phi_ubound Optional numeric matrix of same dim as `phi`.
#'   Use NA for no upper bound.
#' @param bound Logical;
#'   if TRUE, resample until all elements respect bounds (NA bounds ignored).
#' @param max_iter Safety cap on resampling attempts per draw.
#' @return Returns a list of random drift matrices.
#'
#' @examples
#' n <- 10
#' phi <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
#' SimPhiN(n = n, phi = phi, vcov_phi_vec_l = vcov_phi_vec_l)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace linsde
#' @export
SimPhiN <- function(n, phi, vcov_phi_vec_l, margin = 0.0, auto_ubound = 0.0, phi_lbound = NULL, phi_ubound = NULL, bound = FALSE, max_iter = 100000L) {
    .Call(`_simStateSpace_SimPhiN`, n, phi, vcov_phi_vec_l, margin, auto_ubound, phi_lbound, phi_ubound, bound, max_iter)
}

.SimSSMFixed0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l) {
    .Call(`_simStateSpace_SimSSMFixed0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l)
}

.SimSSMFixed1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMFixed1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma)
}

.SimSSMFixed2 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa) {
    .Call(`_simStateSpace_SimSSMFixed2`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa)
}

.SimSSMIVary0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l) {
    .Call(`_simStateSpace_SimSSMIVary0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l)
}

.SimSSMIVary1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMIVary1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma)
}

.SimSSMIVary2 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa) {
    .Call(`_simStateSpace_SimSSMIVary2`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, nu, lambda, theta_l, x, gamma, kappa)
}

.SimSSMLatFixed0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l) {
    .Call(`_simStateSpace_SimSSMLatFixed0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l)
}

.SimSSMLatFixed1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMLatFixed1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma)
}

.SimSSMLatIVary0 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l) {
    .Call(`_simStateSpace_SimSSMLatIVary0`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l)
}

.SimSSMLatIVary1 <- function(n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma) {
    .Call(`_simStateSpace_SimSSMLatIVary1`, n, time, delta_t, mu0, sigma0_l, alpha, beta, psi_l, x, gamma)
}

.SimSSMLinSDEIVary0 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary0`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, ou)
}

.SimSSMLinSDEIVary1 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary1`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, ou)
}

.SimSSMLinSDEIVary2 <- function(n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, kappa, ou = FALSE) {
    .Call(`_simStateSpace_SimSSMLinSDEIVary2`, n, time, delta_t, mu0, sigma0_l, iota, phi, sigma_l, nu, lambda, theta_l, x, gamma, kappa, ou)
}

.SolveLya <- function(A, Q) {
    .Call(`_simStateSpace_SolveLya`, A, Q)
}

.SolveSyl <- function(A, B, C) {
    .Call(`_simStateSpace_SolveSyl`, A, B, C)
}

#' Spectral Abscissa
#'
#' Returns the maximum real part of the eigenvalues of a square matrix.
#' For continuous-time stability (Hurwitz),
#' a matrix is stable if the spectral abscissa is strictly less than 0.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric square matrix.
#'
#' @return Numeric value \eqn{\alpha(x) = \max \Re(\lambda_i(x))}.
#'
#' @examples
#' # Hurwitz-stable (spectral abscissa < 0):
#' x <- matrix(
#'   data = c(
#'     -0.5, -0.2,
#'      1.0, -0.3
#'   ),
#'   nrow = 2
#' )
#' SpectralAbscissa(x = x) # < 0
#'
#' # Unstable (spectral abscissa > 0):
#' x <- matrix(
#'   data = c(
#'      0.10, 0.50,
#'     -0.40, 0.20
#'   ),
#'   nrow = 2
#' )
#' SpectralAbscissa(x = x) # > 0
#'
#' @keywords simStateSpace stability linsde
#' @export
SpectralAbscissa <- function(x) {
    .Call(`_simStateSpace_SpectralAbscissa`, x)
}

#' Spectral Radius
#'
#' Computes the spectral radius of a square matrix,
#' defined as the maximum modulus (absolute value) of its eigenvalues.
#' The spectral radius is often used to assess the stability of systems
#' such as vector autoregressive (VAR) models:
#' a system is considered stationary
#' if the spectral radius of its transition matrix is strictly less than 1.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric square matrix.
#'
#' @return Numeric value representing the spectral radius of `x`.
#'
#' @examples
#' # Matrix with eigenvalues less than 1
#' x <- matrix(
#'   data = c(
#'     0.5, 0.3,
#'     0.2, 0.4
#'   ),
#'   nrow = 2
#' )
#' SpectralRadius(x)
#'
#' # Matrix with eigenvalues greater than 1
#' y <- matrix(
#'   data = c(
#'     1.2, 0.3,
#'     0.4, 0.9
#'   ),
#'   nrow = 2
#' )
#' SpectralRadius(y)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace stability ssm
#' @export
SpectralRadius <- function(x) {
    .Call(`_simStateSpace_SpectralRadius`, x)
}

.SSMCovEta <- function(beta, psi) {
    .Call(`_simStateSpace_SSMCovEta`, beta, psi)
}

.SSMCovY <- function(lambda, theta, cov_eta) {
    .Call(`_simStateSpace_SSMCovY`, lambda, theta, cov_eta)
}

.SSMMeanEta <- function(beta, alpha) {
    .Call(`_simStateSpace_SSMMeanEta`, beta, alpha)
}

.SSMMeanY <- function(nu, lambda, mean_eta) {
    .Call(`_simStateSpace_SSMMeanY`, nu, lambda, mean_eta)
}

#' Test Hurwitz Stability of a Drift Matrix
#'
#' Returns `TRUE` iff the drift matrix \eqn{\boldsymbol{\Phi}}
#' is Hurwitz-stable,
#' i.e., all eigenvalues have real parts strictly less than `-eps`.
#' Setting `eps = 0` enforces the usual strict condition
#' \eqn{\max \Re\{\lambda_i(\boldsymbol{\Phi})\} < 0}.
#' A small positive `eps` (e.g., `1e-12`) can be used
#' to guard against floating-point round-off.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#' @param eps Nonnegative numeric tolerance (default `0.0`).
#'   The test checks \eqn{\Re(\lambda_i) < -\text{eps}} for all eigenvalues.
#'
#' @examples
#' # Unstable example (spectral abscissa >= 0):
#' phi <- matrix(
#'   data = c(
#'     0.10, -0.40,
#'     0.50, 0.20
#'   ),
#'   nrow = 2
#' )
#' TestPhiHurwitz(phi = phi) # FALSE
#'
#' # Stable example (all real parts < 0):
#' phi <- matrix(
#'   data = c(
#'     -0.50, -0.20,
#'      1.00, -0.30
#'   ),
#'   nrow = 2
#' )
#' TestPhiHurwitz(phi = phi) # TRUE
#' TestPhiHurwitz(phi = phi, eps = 1e-12) # also TRUE with tolerance
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test linsde
#' @export
TestPhiHurwitz <- function(phi, eps = 0.0) {
    .Call(`_simStateSpace_TestPhiHurwitz`, phi, eps)
}

#' Test the Drift Matrix
#'
#' Both have to be true for the function to return `TRUE`.
#'   - Test that the real part of all eigenvalues of \eqn{\boldsymbol{\Phi}}
#'     are less than zero.
#'   - Test that the diagonal values of \eqn{\boldsymbol{\Phi}}
#'     are between 0 to negative inifinity.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param phi Numeric matrix.
#'   The drift matrix (\eqn{\boldsymbol{\Phi}}).
#' @param margin Numeric scalar specifying the stability threshold
#'   for the real part of the eigenvalues.
#'   The default `0.0` corresponds to the imaginary axis;
#'   values less than `0.0` enforce a stricter stability margin.
#' @param auto_ubound Numeric scalar specifying the upper bound
#'   for the diagonal elements of \eqn{\boldsymbol{\Phi}}.
#'   Default is `0.0`, requiring all diagonal values to be \eqn{\leq 0}.
#'
#' @examples
#' phi <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' TestPhi(phi = phi)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test linsde
#' @export
TestPhi <- function(phi, margin = 0.0, auto_ubound = 0.0) {
    .Call(`_simStateSpace_TestPhi`, phi, margin, auto_ubound)
}

#' Test Stability
#'
#' The function computes the eigenvalues of the input matrix `x`.
#' It checks if the real part of all eigenvalues is negative.
#' If all eigenvalues have negative real parts,
#' the system is considered stable.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric matrix.
#' @param margin Numeric scalar specifying the stability threshold
#'   for the real part of the eigenvalues.
#'   The default `0.0` corresponds to the imaginary axis;
#'   values less than `0.0` enforce a stricter stability margin.
#'
#' @examples
#' x <- matrix(
#'   data = c(
#'     -0.357, 0.771, -0.450,
#'     0.0, -0.511, 0.729,
#'     0, 0, -0.693
#'   ),
#'   nrow = 3
#' )
#' TestStability(x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test linsde
#' @export
TestStability <- function(x, margin = 0.0) {
    .Call(`_simStateSpace_TestStability`, x, margin)
}

#' Test Stationarity
#'
#' The function computes the eigenvalues of the input matrix `x`.
#' It checks if all eigenvalues have moduli less than 1.
#' If all eigenvalues have moduli less than 1,
#' the system is considered stationary.
#'
#' @author Ivan Jacob Agaloos Pesigan
#'
#' @param x Numeric matrix.
#' @param margin Numeric scalar specifying the stationarity threshold.
#'   Values less than 1 indicate stricter stationarity criteria.
#'
#' @examples
#' x <- matrix(
#'   data = c(0.5, 0.3, 0.2, 0.4),
#'   nrow = 2
#' )
#' TestStationarity(x)
#'
#' x <- matrix(
#'   data = c(0.9, -0.5, 0.8, 0.7),
#'   nrow = 2
#' )
#' TestStationarity(x)
#'
#' @family Simulation of State Space Models Data Functions
#' @keywords simStateSpace test ssm
#' @export
TestStationarity <- function(x, margin = 1.0) {
    .Call(`_simStateSpace_TestStationarity`, x, margin)
}

