% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimPhiNCovariate}
\alias{SimPhiNCovariate}
\title{Simulate Random Drift Matrices with a Covariate
from the Multivariate Normal Distribution}
\usage{
SimPhiNCovariate(
  n,
  phi0,
  vcov_phi_vec_l,
  phi1,
  x,
  margin = 0,
  auto_ubound = 0,
  phi_lbound = NULL,
  phi_ubound = NULL,
  bound = FALSE,
  max_iter = 100000L
)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{phi0}{Numeric matrix.
Baseline drift matrix (\eqn{\boldsymbol{\Phi}_0}).}

\item{vcov_phi_vec_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_phi_vec))})
of the sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)}.}

\item{phi1}{Numeric matrix.
Matrix of covariate effects mapping \eqn{\mathbf{x}} to
\eqn{\mathrm{vec}(\boldsymbol{\Phi})}.}

\item{x}{List of numeric vectors.
Covariate values.}

\item{margin}{Numeric scalar specifying the stability threshold
for the real part of the eigenvalues.
The default \code{0.0} corresponds to the imaginary axis;
values less than \code{0.0} enforce a stricter stability margin.}

\item{auto_ubound}{Numeric scalar specifying the upper bound
for the diagonal elements of \eqn{\boldsymbol{\Phi}}.
Default is \code{0.0}, requiring all diagonal values to be \eqn{\leq 0}.}

\item{phi_lbound}{Optional numeric matrix of same dim as \code{phi}.
Use NA for no lower bound.}

\item{phi_ubound}{Optional numeric matrix of same dim as \code{phi}.
Use NA for no upper bound.}

\item{bound}{Logical;
if TRUE, resample until all elements respect bounds (NA bounds ignored).}

\item{max_iter}{Safety cap on resampling attempts per draw.}
}
\value{
Returns a list of random drift matrices.
}
\description{
This function simulates random drift matrices
from the multivariate normal distribution,
allowing the mean drift matrix to vary
as a linear function of a covariate
The function ensures that the generated drift matrices are stable
using \code{\link[=TestPhi]{TestPhi()}}.
}
\examples{
n <- 5
phi0 <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
vcov_phi_vec_l <- t(chol(0.001 * diag(9)))
# One scalar covariate per replication
phi1 <- matrix(data = 0, nrow = 9, ncol = 1)
phi1[1, 1] <- 0.10  # x shifts phi[1,1]
x <- list(c(0), c(1), c(-1), c(0.5), c(2))
SimPhiNCovariate(
  n = n,
  phi0 = phi0,
  vcov_phi_vec_l = vcov_phi_vec_l,
  phi1 = phi1,
  x = x
)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
