
<!-- README.md is generated from README.Rmd. Please edit that file -->

# simulateDCE

<!-- badges: start -->
<!-- badges: end -->

The goal of simulateDCE is to make it easy to simulate choice experiment
datasets using designs from NGENE, `idefix` or `spdesign`. You have to
store the design file(s) in a subfolder and need to specify certain
parameters and the utility functions for the data generating process.
The package is useful for:

1.  Test different designs in terms of statistical power, efficiency and
    unbiasedness

2.  To test the effects of deviations from RUM, e.g. heuristics, on
    model performance for different designs.

3.  In teaching, using simulated data is useful, if you want to know the
    data generating process. It helps to demonstrate Maximum likelihood
    and choice models, knowing exactly what you should expect.

4.  You can use simulation in pre-registration to justify your sample
    size and design choice.

5.  Before data collection, you can use simulated data to estimate the
    models you plan to use in the actual analysis. You can thus make
    sure, you can estimate all effects for given sample sizes.

## Installation

You can install simulateDCE from github. You need to install the
`devtools` package first. The current version is alpha and there is no
version on cran:

``` r

install.packages("devtools")
devtools::install_git('https://github.com/sagebiej/simulateDCE', ref = "main")
```

For the latest development version use this:

``` r

install.packages("devtools")
devtools::install_git('https://github.com/sagebiej/simulateDCE', ref = "devel")
```

## Example

This is a basic example for a simulation:

``` r


rm(list=ls())
library(simulateDCE)
library(rlang)
library(formula.tools)
#> 
#> Attaching package: 'formula.tools'
#> The following object is masked from 'package:rlang':
#> 
#>     env


designpath<- system.file("extdata","SE_DRIVE" ,package = "simulateDCE")

resps =120  # number of respondents
nosim= 400 # number of simulations to run (about 500 is minimum)






# bcoeff <- list(
#   bpreis = -0.036,
#   blade  = -0.034,
#   bwarte = -0.049)


decisiongroups=c(0,0.7,1)

# wrong parameters

# place b coefficients into an r list:
bcoeff  = list(
  bpreis = -0.01,
  blade = -0.07,
  bwarte = 0.02)

manipulations = list(alt1.x2=     expr(alt1.x2/10),
                     alt1.x3=     expr(alt1.x3/10),
                     alt2.x2=     expr(alt2.x2/10),
                     alt2.x3=     expr(alt2.x3/10)
)


#place your utility functions here
ul<-list( u1 =

           list(
             v1 =V.1~  bpreis * alt1.x1 + blade*alt1.x2 + bwarte*alt1.x3   ,
             v2 =V.2~  bpreis * alt2.x1 + blade*alt2.x2 + bwarte*alt2.x3
           )

         ,
         u2 = list(  v1 =V.1~  bpreis * alt1.x1    ,
                     v2 =V.2~  bpreis * alt2.x1)

)


destype="ngene"

sedrive <- sim_all(nosim = nosim, resps=resps, destype = destype,
                   designpath = designpath, u=ul, bcoeff = bcoeff, decisiongroups = decisiongroups)
#> 'simple' is deprecated and will be removed in the future. Use 'exact' instead.
#> bcoeff_lookup already exists; skipping modification.
#> Utility function used in simulation, ie the true utility: 
#> 
#> $u1
#> $u1$v1
#> V.1 ~ bpreis * alt1.x1 + blade * alt1.x2 + bwarte * alt1.x3
#> <environment: 0x5cc5fbecc2e0>
#> 
#> $u1$v2
#> V.2 ~ bpreis * alt2.x1 + blade * alt2.x2 + bwarte * alt2.x3
#> <environment: 0x5cc5fbf0ffd8>
#> 
#> 
#> $u2
#> $u2$v1
#> V.1 ~ bpreis * alt1.x1
#> <environment: 0x5cc5fbf32890>
#> 
#> $u2$v2
#> V.2 ~ bpreis * alt2.x1
#> <environment: 0x5cc5fbf54428>
#> 'destype' is deprecated. Please use 'designtype' instead.
#> New names:
#> • `Choice situation` -> `Choice.situation`
#> • `` -> `...10`
#>  
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5346621  0.7318508  -1.0846621 -11.868149      1
#> 2     1  -0.95  -2.35  0.5773936 -0.7811993  -0.3726064  -3.131199      1
#> 3     1  -6.20  -2.30  1.3382771  0.1158697  -4.8617229  -2.184130      2
#> 4     1 -13.90  -2.55  1.0026198  0.9662150 -12.8973802  -1.583785      2
#> 5     1 -14.40  -5.80  0.4685361 -0.4860094 -13.9314639  -6.286009      2
#> 6     1  -3.60  -1.70  2.5243715  0.6438044  -1.0756285  -1.056196      2
#> 
#>  
#>  Transformed utility function (type: simple ):
#> [1] "U_1 = @bpreis * $alt1_x1 + @blade * $alt1_x2 + @bwarte * $alt1_x3 ;U_2 = @bpreis * $alt2_x1 + @blade * $alt2_x2 + @bwarte * $alt2_x3 ;"
#> This is Run number  1 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.0480412 1.0658687   1.4980412 -11.5341313      1
#> 2     1  -0.95  -2.35  1.6458423 3.0029775   0.6958423   0.6529775      1
#> 3     1  -6.20  -2.30  0.8064037 1.7156233  -5.3935963  -0.5843767      2
#> 4     1 -13.90  -2.55 -0.9656518 0.7281514 -14.8656518  -1.8218486      2
#> 5     1 -14.40  -5.80 -0.8679570 3.8650136 -15.2679570  -1.9349864      2
#> 6     1  -3.60  -1.70  0.7468481 1.9040151  -2.8531519   0.2040151      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6900 -38650   7050 
#> initial  value 998.131940 
#> iter   2 value 814.051264
#> iter   3 value 803.513852
#> iter   4 value 803.277976
#> iter   5 value 766.362532
#> iter   6 value 757.804164
#> iter   7 value 756.391651
#> iter   8 value 756.360304
#> iter   9 value 756.360241
#> iter  10 value 756.360224
#> iter  10 value 756.360214
#> iter  10 value 756.360206
#> final  value 756.360206 
#> converged
#> This is Run number  2 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.95903510  1.7469021  -1.5090351 -10.8530979      1
#> 2     1  -0.95  -2.35  0.48567293  1.3550837  -0.4643271  -0.9949163      1
#> 3     1  -6.20  -2.30 -0.07062326 -0.3819651  -6.2706233  -2.6819651      2
#> 4     1 -13.90  -2.55 -0.27359542  1.7458482 -14.1735954  -0.8041518      2
#> 5     1 -14.40  -5.80  0.62747982  1.1230906 -13.7725202  -4.6769094      2
#> 6     1  -3.60  -1.70  5.51924738  0.5975311   1.9192474  -1.1024689      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7320 -40200   5325 
#> initial  value 998.131940 
#> iter   2 value 798.413557
#> iter   3 value 790.367792
#> iter   4 value 788.829313
#> iter   5 value 756.684783
#> iter   6 value 747.942494
#> iter   7 value 746.186623
#> iter   8 value 746.134114
#> iter   9 value 746.133922
#> iter  10 value 746.133904
#> iter  10 value 746.133904
#> iter  10 value 746.133894
#> final  value 746.133894 
#> converged
#> This is Run number  3 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.3494364 -1.2638437  -0.8994364 -13.8638437      1
#> 2     1  -0.95  -2.35 -1.0591545 -0.3654889  -2.0091545  -2.7154889      1
#> 3     1  -6.20  -2.30 -0.6391097 -1.0715919  -6.8391097  -3.3715919      2
#> 4     1 -13.90  -2.55  1.9630398 -0.7375982 -11.9369602  -3.2875982      2
#> 5     1 -14.40  -5.80 -0.7461610  0.5740361 -15.1461610  -5.2259639      2
#> 6     1  -3.60  -1.70  1.1724058  0.9519715  -2.4275942  -0.7480285      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -38275   7025 
#> initial  value 998.131940 
#> iter   2 value 820.132002
#> iter   3 value 808.671749
#> iter   4 value 807.589000
#> iter   5 value 769.808211
#> iter   6 value 761.347358
#> iter   7 value 759.964884
#> iter   8 value 759.935731
#> iter   9 value 759.935680
#> iter  10 value 759.935667
#> iter  10 value 759.935656
#> iter  10 value 759.935656
#> final  value 759.935656 
#> converged
#> This is Run number  4 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1651308  0.04473541  -0.38486924 -12.555265      1
#> 2     1  -0.95  -2.35  1.0457067 -0.56572294   0.09570666  -2.915723      1
#> 3     1  -6.20  -2.30  0.2653277  0.21907004  -5.93467227  -2.080930      2
#> 4     1 -13.90  -2.55 -0.4685129  0.47136596 -14.36851288  -2.078634      2
#> 5     1 -14.40  -5.80  1.5752600  2.73346135 -12.82473995  -3.066539      2
#> 6     1  -3.60  -1.70 -0.3584104  0.55026311  -3.95841043  -1.149737      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -39625   8000 
#> initial  value 998.131940 
#> iter   2 value 794.188083
#> iter   3 value 778.031063
#> iter   4 value 777.087469
#> iter   5 value 743.540679
#> iter   6 value 734.976004
#> iter   7 value 733.845920
#> iter   8 value 733.827251
#> iter   9 value 733.827233
#> iter   9 value 733.827230
#> iter   9 value 733.827220
#> final  value 733.827220 
#> converged
#> This is Run number  5 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5668505  1.9385048  -1.116850 -10.6614952      1
#> 2     1  -0.95  -2.35 -1.0846610  0.5273078  -2.034661  -1.8226922      2
#> 3     1  -6.20  -2.30 -1.1667192 -0.3741714  -7.366719  -2.6741714      2
#> 4     1 -13.90  -2.55 -0.1146248  1.0349357 -14.014625  -1.5150643      2
#> 5     1 -14.40  -5.80 -0.4668516  2.2256308 -14.866852  -3.5743692      2
#> 6     1  -3.60  -1.70  0.2743071  2.4364835  -3.325693   0.7364835      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -36600   5775 
#> initial  value 998.131940 
#> iter   2 value 849.190980
#> iter   3 value 842.712950
#> iter   4 value 841.936546
#> iter   5 value 799.442275
#> iter   6 value 791.541423
#> iter   7 value 789.904678
#> iter   8 value 789.870085
#> iter   9 value 789.869999
#> iter   9 value 789.869999
#> iter   9 value 789.869999
#> final  value 789.869999 
#> converged
#> This is Run number  6 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1867229 -1.3282405  -0.3632771 -13.92824045      1
#> 2     1  -0.95  -2.35 -0.7120267  0.4058905  -1.6620267  -1.94410949      1
#> 3     1  -6.20  -2.30  0.9499792  1.3408087  -5.2500208  -0.95919130      2
#> 4     1 -13.90  -2.55 -0.6068414 -0.2863894 -14.5068414  -2.83638939      2
#> 5     1 -14.40  -5.80  0.2791787  0.1775473 -14.1208213  -5.62245268      2
#> 6     1  -3.60  -1.70 -0.4503255  1.6392219  -4.0503255  -0.06077805      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -40050   6300 
#> initial  value 998.131940 
#> iter   2 value 797.254783
#> iter   3 value 784.067854
#> iter   4 value 781.033483
#> iter   5 value 748.988742
#> iter   6 value 740.229226
#> iter   7 value 738.865229
#> iter   8 value 738.831723
#> iter   9 value 738.831657
#> iter   9 value 738.831649
#> iter   9 value 738.831643
#> final  value 738.831643 
#> converged
#> This is Run number  7 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.21350661 -0.0899883  -0.3364934 -12.689988      1
#> 2     1  -0.95  -2.35  2.12381588 -0.2254029   1.1738159  -2.575403      1
#> 3     1  -6.20  -2.30  4.10025765  0.4750744  -2.0997424  -1.824926      2
#> 4     1 -13.90  -2.55 -0.41310328 -0.6352374 -14.3131033  -3.185237      2
#> 5     1 -14.40  -5.80  0.05799517 -1.3854798 -14.3420048  -7.185480      2
#> 6     1  -3.60  -1.70  2.15245815  0.5629682  -1.4475418  -1.137032      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5760 -37400   6900 
#> initial  value 998.131940 
#> iter   2 value 833.324198
#> iter   3 value 821.238217
#> iter   4 value 819.048965
#> iter   5 value 779.096282
#> iter   6 value 770.853182
#> iter   7 value 769.477617
#> iter   8 value 769.450544
#> iter   9 value 769.450502
#> iter   9 value 769.450491
#> iter   9 value 769.450486
#> final  value 769.450486 
#> converged
#> This is Run number  8 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5798834 -0.3211425   0.02988338 -12.9211425      1
#> 2     1  -0.95  -2.35 -0.6568726  2.9615102  -1.60687260   0.6115102      2
#> 3     1  -6.20  -2.30  1.0462290 -0.8025417  -5.15377097  -3.1025417      2
#> 4     1 -13.90  -2.55  1.9432565 -0.5925105 -11.95674349  -3.1425105      2
#> 5     1 -14.40  -5.80 -0.2125311 -0.5395650 -14.61253107  -6.3395650      2
#> 6     1  -3.60  -1.70  0.5850380  0.8600823  -3.01496199  -0.8399177      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -39500   7725 
#> initial  value 998.131940 
#> iter   2 value 797.555745
#> iter   3 value 783.435479
#> iter   4 value 783.002682
#> iter   5 value 748.858861
#> iter   6 value 740.221327
#> iter   7 value 739.023456
#> iter   8 value 739.001304
#> iter   9 value 739.001293
#> iter   9 value 739.001288
#> iter  10 value 739.001265
#> iter  11 value 739.001253
#> iter  11 value 739.001253
#> iter  11 value 739.001250
#> final  value 739.001250 
#> converged
#> This is Run number  9 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1          e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.69241378 -0.027102867  -1.242414 -12.6271029      1
#> 2     1  -0.95  -2.35 -0.33240342  0.957319274  -1.282403  -1.3926807      1
#> 3     1  -6.20  -2.30 -0.02159452  0.523861864  -6.221595  -1.7761381      2
#> 4     1 -13.90  -2.55 -0.43976792  2.255627590 -14.339768  -0.2943724      2
#> 5     1 -14.40  -5.80  1.59548064  0.005022084 -12.804519  -5.7949779      2
#> 6     1  -3.60  -1.70  0.36964385 -0.070284512  -3.230356  -1.7702845      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -38925   7375 
#> initial  value 998.131940 
#> iter   2 value 808.805881
#> iter   3 value 794.383536
#> iter   4 value 792.492764
#> iter   5 value 756.940395
#> iter   6 value 748.397803
#> iter   7 value 747.136101
#> iter   8 value 747.111451
#> iter   9 value 747.111422
#> iter   9 value 747.111412
#> iter   9 value 747.111406
#> final  value 747.111406 
#> converged
#> This is Run number  10 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.55377101 -0.06400035  -1.1037710 -12.664000      1
#> 2     1  -0.95  -2.35  0.65046709  1.31960333  -0.2995329  -1.030397      1
#> 3     1  -6.20  -2.30 -0.08514854 -0.35122632  -6.2851485  -2.651226      2
#> 4     1 -13.90  -2.55 -0.24910236  0.41807233 -14.1491024  -2.131928      2
#> 5     1 -14.40  -5.80  1.44398692  0.61195541 -12.9560131  -5.188045      2
#> 6     1  -3.60  -1.70  1.29566396  0.41997169  -2.3043360  -1.280028      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7240 -39850   6400 
#> initial  value 998.131940 
#> iter   2 value 799.047238
#> iter   3 value 789.288368
#> iter   4 value 788.745320
#> iter   5 value 755.304582
#> iter   6 value 746.556906
#> iter   7 value 745.070645
#> iter   8 value 745.032618
#> iter   9 value 745.032529
#> iter  10 value 745.032514
#> iter  10 value 745.032507
#> iter  10 value 745.032499
#> final  value 745.032499 
#> converged
#> This is Run number  11 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8302687  0.6367215   0.2802687 -11.963278      1
#> 2     1  -0.95  -2.35  0.1713546 -0.6215377  -0.7786454  -2.971538      1
#> 3     1  -6.20  -2.30  0.2922556  0.0418291  -5.9077444  -2.258171      2
#> 4     1 -13.90  -2.55  1.1815540  0.6897143 -12.7184460  -1.860286      2
#> 5     1 -14.40  -5.80 -0.2580984  1.6449478 -14.6580984  -4.155052      2
#> 6     1  -3.60  -1.70  2.0032401  0.0826559  -1.5967599  -1.617344      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5560 -39250   7150 
#> initial  value 998.131940 
#> iter   2 value 805.365550
#> iter   3 value 787.032465
#> iter   4 value 782.361624
#> iter   5 value 748.443105
#> iter   6 value 739.857615
#> iter   7 value 738.659548
#> iter   8 value 738.636756
#> iter   9 value 738.636736
#> iter   9 value 738.636731
#> iter   9 value 738.636727
#> final  value 738.636727 
#> converged
#> This is Run number  12 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9803801 -0.26153559  -1.5303801 -12.8615356      1
#> 2     1  -0.95  -2.35  1.7419333  0.07796661   0.7919333  -2.2720334      1
#> 3     1  -6.20  -2.30  1.4003382 -0.88584325  -4.7996618  -3.1858432      2
#> 4     1 -13.90  -2.55 -1.4346036 -0.76433179 -15.3346036  -3.3143318      2
#> 5     1 -14.40  -5.80 -0.6871762 -1.84393126 -15.0871762  -7.6439313      2
#> 6     1  -3.60  -1.70  3.1893690  1.48324819  -0.4106310  -0.2167518      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -38575   6775 
#> initial  value 998.131940 
#> iter   2 value 816.882836
#> iter   3 value 806.574919
#> iter   4 value 805.890778
#> iter   5 value 768.813677
#> iter   6 value 760.282612
#> iter   7 value 758.832693
#> iter   8 value 758.799819
#> iter   9 value 758.799752
#> iter  10 value 758.799736
#> iter  10 value 758.799726
#> iter  10 value 758.799725
#> final  value 758.799725 
#> converged
#> This is Run number  13 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1991772  1.1511615  -0.74917718 -11.448838      1
#> 2     1  -0.95  -2.35  0.9329473  0.3775952  -0.01705267  -1.972405      1
#> 3     1  -6.20  -2.30  1.8494722 -0.5189996  -4.35052776  -2.819000      2
#> 4     1 -13.90  -2.55  0.1553253  0.6869012 -13.74467470  -1.863099      2
#> 5     1 -14.40  -5.80  2.9140428  2.1088163 -11.48595724  -3.691184      2
#> 6     1  -3.60  -1.70  0.9493834 -0.4533498  -2.65061659  -2.153350      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5720 -38225   7225 
#> initial  value 998.131940 
#> iter   2 value 819.997689
#> iter   3 value 805.307244
#> iter   4 value 802.513743
#> iter   5 value 765.124055
#> iter   6 value 756.700421
#> iter   7 value 755.405431
#> iter   8 value 755.380579
#> iter   9 value 755.380550
#> iter   9 value 755.380540
#> iter   9 value 755.380535
#> final  value 755.380535 
#> converged
#> This is Run number  14 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0226271  1.8022229  -1.5726271 -10.7977771      1
#> 2     1  -0.95  -2.35  0.2449677 -0.7119570  -0.7050323  -3.0619570      1
#> 3     1  -6.20  -2.30 -0.3483096 -0.8870686  -6.5483096  -3.1870686      2
#> 4     1 -13.90  -2.55 -0.3558228  1.8516659 -14.2558228  -0.6983341      2
#> 5     1 -14.40  -5.80  1.9414634  3.9030741 -12.4585366  -1.8969259      2
#> 6     1  -3.60  -1.70  0.8671413  2.5681117  -2.7328587   0.8681117      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6060 -38125   7250 
#> initial  value 998.131940 
#> iter   2 value 821.172714
#> iter   3 value 808.367696
#> iter   4 value 806.782637
#> iter   5 value 768.753533
#> iter   6 value 760.339769
#> iter   7 value 759.013804
#> iter   8 value 758.987644
#> iter   9 value 758.987607
#> iter  10 value 758.987595
#> iter  10 value 758.987585
#> iter  10 value 758.987580
#> final  value 758.987580 
#> converged
#> This is Run number  15 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6697426 -0.2212345  -1.2197426 -12.821234      1
#> 2     1  -0.95  -2.35  0.1329135 -0.1484477  -0.8170865  -2.498448      1
#> 3     1  -6.20  -2.30  1.8040782 -1.1926918  -4.3959218  -3.492692      2
#> 4     1 -13.90  -2.55 -0.2969303  0.4498545 -14.1969303  -2.100146      2
#> 5     1 -14.40  -5.80 -0.8939682  0.1640928 -15.2939682  -5.635907      2
#> 6     1  -3.60  -1.70 -0.9939891  0.3689768  -4.5939891  -1.331023      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -37875   6650 
#> initial  value 998.131940 
#> iter   2 value 827.899993
#> iter   3 value 817.382899
#> iter   4 value 815.958442
#> iter   5 value 777.095544
#> iter   6 value 768.734927
#> iter   7 value 767.282448
#> iter   8 value 767.251137
#> iter   9 value 767.251077
#> iter   9 value 767.251076
#> iter   9 value 767.251076
#> final  value 767.251076 
#> converged
#> This is Run number  16 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4430095 -0.5300688  -0.9930095 -13.1300688      1
#> 2     1  -0.95  -2.35  3.5029252 -1.1477896   2.5529252  -3.4977896      1
#> 3     1  -6.20  -2.30  1.2878364  1.4547887  -4.9121636  -0.8452113      2
#> 4     1 -13.90  -2.55  2.0919139 -1.2793114 -11.8080861  -3.8293114      2
#> 5     1 -14.40  -5.80 -0.3452620 -0.5455779 -14.7452620  -6.3455779      2
#> 6     1  -3.60  -1.70 -1.0382948 -0.3328220  -4.6382948  -2.0328220      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -38700   8425 
#> initial  value 998.131940 
#> iter   2 value 805.632321
#> iter   3 value 787.126143
#> iter   4 value 784.943829
#> iter   5 value 749.005847
#> iter   6 value 740.652192
#> iter   7 value 739.522359
#> iter   8 value 739.506073
#> iter   9 value 739.506060
#> iter   9 value 739.506055
#> iter   9 value 739.506052
#> final  value 739.506052 
#> converged
#> This is Run number  17 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.10726253  0.1562533   0.5572625 -12.4437467      1
#> 2     1  -0.95  -2.35 -1.03723690  2.4601367  -1.9872369   0.1101367      2
#> 3     1  -6.20  -2.30  0.33340273  0.2966318  -5.8665973  -2.0033682      2
#> 4     1 -13.90  -2.55  0.47342490  1.1619897 -13.4265751  -1.3880103      2
#> 5     1 -14.40  -5.80 -0.04790816 -0.9262372 -14.4479082  -6.7262372      2
#> 6     1  -3.60  -1.70 -0.25237807  0.6792071  -3.8523781  -1.0207929      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6060 -39525   8600 
#> initial  value 998.131940 
#> iter   2 value 791.960827
#> iter   3 value 772.617019
#> iter   4 value 771.139777
#> iter   5 value 737.594100
#> iter   6 value 729.207147
#> iter   7 value 728.147911
#> iter   8 value 728.133621
#> iter   9 value 728.133602
#> iter   9 value 728.133596
#> iter   9 value 728.133596
#> final  value 728.133596 
#> converged
#> This is Run number  18 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7412233  0.62578691   0.1912233 -11.974213      1
#> 2     1  -0.95  -2.35  0.3224486  0.83719236  -0.6275514  -1.512808      1
#> 3     1  -6.20  -2.30 -1.0891595 -0.07786002  -7.2891595  -2.377860      2
#> 4     1 -13.90  -2.55 -0.6999784  0.43833581 -14.5999784  -2.111664      2
#> 5     1 -14.40  -5.80 -0.9937733  0.84542868 -15.3937733  -4.954571      2
#> 6     1  -3.60  -1.70  0.4503231 -0.52201593  -3.1496769  -2.222016      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7360 -40025   5825 
#> initial  value 998.131940 
#> iter   2 value 798.921328
#> iter   3 value 790.485091
#> iter   4 value 789.657678
#> iter   5 value 756.737560
#> iter   6 value 747.986793
#> iter   7 value 746.352573
#> iter   8 value 746.307171
#> iter   9 value 746.307041
#> iter  10 value 746.307026
#> iter  10 value 746.307026
#> iter  10 value 746.307019
#> final  value 746.307019 
#> converged
#> This is Run number  19 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5742353  0.2599047  -1.12423532 -12.340095      1
#> 2     1  -0.95  -2.35  0.8716942  1.0253969  -0.07830585  -1.324603      1
#> 3     1  -6.20  -2.30  0.4024112 -0.1901571  -5.79758884  -2.490157      2
#> 4     1 -13.90  -2.55  1.1478203 -0.7324204 -12.75217966  -3.282420      2
#> 5     1 -14.40  -5.80  0.5179299  1.2628388 -13.88207015  -4.537161      2
#> 6     1  -3.60  -1.70  0.2990833 -0.4118175  -3.30091671  -2.111818      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -40250   8050 
#> initial  value 998.131940 
#> iter   2 value 784.410953
#> iter   3 value 763.207399
#> iter   4 value 759.363723
#> iter   5 value 728.629462
#> iter   6 value 720.229731
#> iter   7 value 719.188904
#> iter   8 value 719.172593
#> iter   8 value 719.172586
#> final  value 719.172586 
#> converged
#> This is Run number  20 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.54093200 0.9146525   0.99093200 -11.6853475      1
#> 2     1  -0.95  -2.35  0.99359644 0.8103119   0.04359644  -1.5396881      1
#> 3     1  -6.20  -2.30 -0.05574717 3.6530462  -6.25574717   1.3530462      2
#> 4     1 -13.90  -2.55  1.14689252 0.3959909 -12.75310748  -2.1540091      2
#> 5     1 -14.40  -5.80 -0.29085079 0.6199654 -14.69085079  -5.1800346      2
#> 6     1  -3.60  -1.70 -0.57138927 1.2125393  -4.17138927  -0.4874607      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5940 -38500   6550 
#> initial  value 998.131940 
#> iter   2 value 819.663167
#> iter   3 value 806.484485
#> iter   4 value 803.481753
#> iter   5 value 766.853816
#> iter   6 value 758.331166
#> iter   7 value 756.931409
#> iter   8 value 756.900884
#> iter   9 value 756.900831
#> iter   9 value 756.900822
#> iter   9 value 756.900817
#> final  value 756.900817 
#> converged
#> This is Run number  21 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2           U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  3.1726579 -1.3164440   2.622657902 -13.9164440      1
#> 2     1  -0.95  -2.35  0.9532956  3.6710337   0.003295594   1.3210337      2
#> 3     1  -6.20  -2.30  0.6409443  0.4491905  -5.559055733  -1.8508095      2
#> 4     1 -13.90  -2.55 -0.3810352  2.1951681 -14.281035155  -0.3548319      2
#> 5     1 -14.40  -5.80  1.5795551 -0.3248330 -12.820444855  -6.1248330      2
#> 6     1  -3.60  -1.70 -0.4157202 -0.5185339  -4.015720176  -2.2185339      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -39550   7375 
#> initial  value 998.131940 
#> iter   2 value 799.220577
#> iter   3 value 784.729741
#> iter   4 value 783.181163
#> iter   5 value 749.406678
#> iter   6 value 740.779257
#> iter   7 value 739.551151
#> iter   8 value 739.526731
#> iter   9 value 739.526702
#> iter   9 value 739.526693
#> iter   9 value 739.526686
#> final  value 739.526686 
#> converged
#> This is Run number  22 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.8175021 -0.35435672  -1.367502 -12.954357      1
#> 2     1  -0.95  -2.35 -0.1995796 -0.61567055  -1.149580  -2.965671      1
#> 3     1  -6.20  -2.30  0.7204438  0.23624759  -5.479556  -2.063752      2
#> 4     1 -13.90  -2.55  1.8926614 -0.02072729 -12.007339  -2.570727      2
#> 5     1 -14.40  -5.80 -0.2718300  0.18629880 -14.671830  -5.613701      2
#> 6     1  -3.60  -1.70 -0.6245241  0.21125305  -4.224524  -1.488747      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5600 -37200   7575 
#> initial  value 998.131940 
#> iter   2 value 832.190865
#> iter   3 value 818.820408
#> iter   4 value 816.918318
#> iter   5 value 776.346371
#> iter   6 value 768.166574
#> iter   7 value 766.883717
#> iter   8 value 766.861318
#> iter   9 value 766.861291
#> iter   9 value 766.861281
#> iter   9 value 766.861276
#> final  value 766.861276 
#> converged
#> This is Run number  23 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.23997973  1.6529340  -0.3100203 -10.947066      1
#> 2     1  -0.95  -2.35 -0.35775476 -1.0901106  -1.3077548  -3.440111      1
#> 3     1  -6.20  -2.30  0.05300973 -1.1033464  -6.1469903  -3.403346      2
#> 4     1 -13.90  -2.55  1.55715428  1.0464371 -12.3428457  -1.503563      2
#> 5     1 -14.40  -5.80  1.06540419  0.6167304 -13.3345958  -5.183270      2
#> 6     1  -3.60  -1.70 -0.29567605  0.3535731  -3.8956761  -1.346427      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5880 -39025   6950 
#> initial  value 998.131940 
#> iter   2 value 809.832251
#> iter   3 value 794.516541
#> iter   4 value 791.150581
#> iter   5 value 756.230383
#> iter   6 value 747.646775
#> iter   7 value 746.359738
#> iter   8 value 746.333251
#> iter   9 value 746.333218
#> iter   9 value 746.333210
#> iter   9 value 746.333205
#> final  value 746.333205 
#> converged
#> This is Run number  24 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5811512 -0.6668047  -1.131151 -13.2668047      1
#> 2     1  -0.95  -2.35  2.3536173 -1.0546874   1.403617  -3.4046874      1
#> 3     1  -6.20  -2.30 -1.0869926 -0.5082091  -7.286993  -2.8082091      2
#> 4     1 -13.90  -2.55  0.5573746  2.3065882 -13.342625  -0.2434118      2
#> 5     1 -14.40  -5.80 -0.5445224  0.0458446 -14.944522  -5.7541554      2
#> 6     1  -3.60  -1.70 -0.3383747 -0.7048156  -3.938375  -2.4048156      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38900   6875 
#> initial  value 998.131940 
#> iter   2 value 811.861737
#> iter   3 value 799.578196
#> iter   4 value 797.953502
#> iter   5 value 762.142990
#> iter   6 value 753.563423
#> iter   7 value 752.195332
#> iter   8 value 752.165387
#> iter   9 value 752.165337
#> iter  10 value 752.165325
#> iter  10 value 752.165317
#> iter  10 value 752.165317
#> final  value 752.165317 
#> converged
#> This is Run number  25 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.79506340  2.9684872   0.2450634 -9.6315128      1
#> 2     1  -0.95  -2.35  0.02059948  4.0962295  -0.9294005  1.7462295      2
#> 3     1  -6.20  -2.30 -0.89827309 -0.2988247  -7.0982731 -2.5988247      2
#> 4     1 -13.90  -2.55  1.85670394 -0.5479160 -12.0432961 -3.0979160      2
#> 5     1 -14.40  -5.80  0.33733135  0.2319431 -14.0626686 -5.5680569      2
#> 6     1  -3.60  -1.70  1.80807202  2.1504539  -1.7919280  0.4504539      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -38200   6400 
#> initial  value 998.131940 
#> iter   2 value 824.772414
#> iter   3 value 811.610414
#> iter   4 value 808.317614
#> iter   5 value 770.861084
#> iter   6 value 762.384077
#> iter   7 value 760.960246
#> iter   8 value 760.929323
#> iter   9 value 760.929266
#> iter   9 value 760.929257
#> iter   9 value 760.929252
#> final  value 760.929252 
#> converged
#> This is Run number  26 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.61494977  0.7730959   0.06494977 -11.826904      1
#> 2     1  -0.95  -2.35  1.88643832  0.6808709   0.93643832  -1.669129      1
#> 3     1  -6.20  -2.30 -0.86961688 -0.1904128  -7.06961688  -2.490413      2
#> 4     1 -13.90  -2.55 -0.05374765  0.7616439 -13.95374765  -1.788356      2
#> 5     1 -14.40  -5.80  3.47362298  1.5059658 -10.92637702  -4.294034      2
#> 6     1  -3.60  -1.70  0.28917639 -1.3190910  -3.31082361  -3.019091      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6200 -38275   5925 
#> initial  value 998.131940 
#> iter   2 value 825.848063
#> iter   3 value 815.246076
#> iter   4 value 812.696404
#> iter   5 value 775.260391
#> iter   6 value 766.794316
#> iter   7 value 765.220969
#> iter   8 value 765.183547
#> iter   9 value 765.183455
#> iter  10 value 765.183442
#> iter  10 value 765.183442
#> iter  10 value 765.183438
#> final  value 765.183438 
#> converged
#> This is Run number  27 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.17428232 -0.5063131  -0.3757177 -13.1063131      1
#> 2     1  -0.95  -2.35  0.59503521  0.4532163  -0.3549648  -1.8967837      1
#> 3     1  -6.20  -2.30 -0.80878323  2.8184548  -7.0087832   0.5184548      2
#> 4     1 -13.90  -2.55  1.16638698 -1.1685989 -12.7336130  -3.7185989      2
#> 5     1 -14.40  -5.80  3.87828296 -0.5075608 -10.5217170  -6.3075608      2
#> 6     1  -3.60  -1.70  0.05482436  1.8947469  -3.5451756   0.1947469      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -37525   6375 
#> initial  value 998.131940 
#> iter   2 value 833.922833
#> iter   3 value 825.513174
#> iter   4 value 824.798810
#> iter   5 value 784.717063
#> iter   6 value 776.469774
#> iter   7 value 774.919701
#> iter   8 value 774.885346
#> iter   9 value 774.885266
#> iter   9 value 774.885264
#> iter   9 value 774.885264
#> final  value 774.885264 
#> converged
#> This is Run number  28 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.009285943 0.99401803  -0.5592859 -11.6059820      1
#> 2     1  -0.95  -2.35  0.292396581 0.18369436  -0.6576034  -2.1663056      1
#> 3     1  -6.20  -2.30 -1.115241992 0.01880581  -7.3152420  -2.2811942      2
#> 4     1 -13.90  -2.55  2.386206195 2.16271800 -11.5137938  -0.3872820      2
#> 5     1 -14.40  -5.80  0.733583378 0.96497297 -13.6664166  -4.8350270      2
#> 6     1  -3.60  -1.70  0.401342416 0.96390485  -3.1986576  -0.7360952      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -38750   8175 
#> initial  value 998.131940 
#> iter   2 value 806.438136
#> iter   3 value 790.250129
#> iter   4 value 789.046565
#> iter   5 value 752.928739
#> iter   6 value 744.477324
#> iter   7 value 743.317181
#> iter   8 value 743.298959
#> iter   9 value 743.298945
#> iter   9 value 743.298942
#> iter  10 value 743.298931
#> iter  10 value 743.298923
#> iter  10 value 743.298922
#> final  value 743.298922 
#> converged
#> This is Run number  29 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7471286 -0.3855214   1.1971286 -12.9855214      1
#> 2     1  -0.95  -2.35  0.1612026  1.2885028  -0.7887974  -1.0614972      1
#> 3     1  -6.20  -2.30  3.1399183  0.7451406  -3.0600817  -1.5548594      2
#> 4     1 -13.90  -2.55  1.1562691  1.1418581 -12.7437309  -1.4081419      2
#> 5     1 -14.40  -5.80 -0.2553048 -0.4954830 -14.6553048  -6.2954830      2
#> 6     1  -3.60  -1.70  1.7257312  0.8319119  -1.8742688  -0.8680881      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -36675   6825 
#> initial  value 998.131940 
#> iter   2 value 843.431492
#> iter   3 value 832.639176
#> iter   4 value 830.764674
#> iter   5 value 788.737420
#> iter   6 value 780.709120
#> iter   7 value 779.326526
#> iter   8 value 779.300299
#> iter   9 value 779.300257
#> iter   9 value 779.300256
#> iter   9 value 779.300256
#> final  value 779.300256 
#> converged
#> This is Run number  30 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4583561 -0.4276330  -1.008356 -13.027633      1
#> 2     1  -0.95  -2.35 -0.9055229 -0.1672029  -1.855523  -2.517203      1
#> 3     1  -6.20  -2.30  1.7038551  0.7256820  -4.496145  -1.574318      2
#> 4     1 -13.90  -2.55 -0.7621098 -0.4771581 -14.662110  -3.027158      2
#> 5     1 -14.40  -5.80 -0.3998774 -1.0933774 -14.799877  -6.893377      2
#> 6     1  -3.60  -1.70  1.6273573  0.1763657  -1.972643  -1.523634      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -38075   6375 
#> initial  value 998.131940 
#> iter   2 value 826.535088
#> iter   3 value 815.752278
#> iter   4 value 813.745311
#> iter   5 value 775.608465
#> iter   6 value 767.196971
#> iter   7 value 765.709509
#> iter   8 value 765.676337
#> iter   9 value 765.676270
#> iter   9 value 765.676260
#> iter   9 value 765.676254
#> final  value 765.676254 
#> converged
#> This is Run number  31 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0695231  0.2012381  -1.619523 -12.3987619      1
#> 2     1  -0.95  -2.35 -0.3692137  1.7454102  -1.319214  -0.6045898      2
#> 3     1  -6.20  -2.30  0.9046795  1.4778487  -5.295320  -0.8221513      2
#> 4     1 -13.90  -2.55 -0.2933849  0.7417986 -14.193385  -1.8082014      2
#> 5     1 -14.40  -5.80 -0.6282223  1.8206628 -15.028222  -3.9793372      2
#> 6     1  -3.60  -1.70  0.7008495 -0.9524986  -2.899151  -2.6524986      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -37975   6875 
#> initial  value 998.131940 
#> iter   2 value 825.239839
#> iter   3 value 814.469941
#> iter   4 value 813.367835
#> iter   5 value 774.710702
#> iter   6 value 766.320084
#> iter   7 value 764.901373
#> iter   8 value 764.871231
#> iter   9 value 764.871175
#> iter  10 value 764.871161
#> iter  10 value 764.871151
#> iter  10 value 764.871146
#> final  value 764.871146 
#> converged
#> This is Run number  32 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2923237 -0.34185310  -0.2576763 -12.94185310      1
#> 2     1  -0.95  -2.35  0.1778100  2.28439972  -0.7721900  -0.06560028      2
#> 3     1  -6.20  -2.30  4.6585126  0.50816742  -1.5414874  -1.79183258      1
#> 4     1 -13.90  -2.55  2.6096463  0.06879165 -11.2903537  -2.48120835      2
#> 5     1 -14.40  -5.80 -0.2451368 -0.42604177 -14.6451368  -6.22604177      2
#> 6     1  -3.60  -1.70  1.2610084 -0.99274356  -2.3389916  -2.69274356      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6520 -38150   5800 
#> initial  value 998.131940 
#> iter   2 value 827.981080
#> iter   3 value 819.282063
#> iter   4 value 817.639860
#> iter   5 value 779.580434
#> iter   6 value 771.185328
#> iter   7 value 769.529829
#> iter   8 value 769.489814
#> iter   9 value 769.489708
#> iter  10 value 769.489695
#> iter  10 value 769.489693
#> iter  10 value 769.489692
#> final  value 769.489692 
#> converged
#> This is Run number  33 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7820398 -0.3618176  -1.332040 -12.9618176      1
#> 2     1  -0.95  -2.35 -0.2823878  0.4905537  -1.232388  -1.8594463      1
#> 3     1  -6.20  -2.30  0.6124959  0.2771269  -5.587504  -2.0228731      2
#> 4     1 -13.90  -2.55  1.1618612  0.4721477 -12.738139  -2.0778523      2
#> 5     1 -14.40  -5.80  2.9320682 -0.3157078 -11.467932  -6.1157078      2
#> 6     1  -3.60  -1.70 -0.5046445  2.4571157  -4.104644   0.7571157      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -37900   6850 
#> initial  value 998.131940 
#> iter   2 value 826.616061
#> iter   3 value 814.587727
#> iter   4 value 812.582007
#> iter   5 value 773.985393
#> iter   6 value 765.615980
#> iter   7 value 764.226528
#> iter   8 value 764.197877
#> iter   9 value 764.197830
#> iter   9 value 764.197819
#> iter   9 value 764.197813
#> final  value 764.197813 
#> converged
#> This is Run number  34 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  1.35318374  1.71399735   0.8031837 -10.88600265      1
#> 2     1  -0.95  -2.35 -0.05992435 -0.10723221  -1.0099244  -2.45723221      1
#> 3     1  -6.20  -2.30  0.09335095 -1.19775312  -6.1066491  -3.49775312      2
#> 4     1 -13.90  -2.55 -0.59008289  0.74789339 -14.4900829  -1.80210661      2
#> 5     1 -14.40  -5.80  1.81945873  0.01755771 -12.5805413  -5.78244229      2
#> 6     1  -3.60  -1.70 -0.12606651  1.78929845  -3.7260665   0.08929845      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5920 -38325   7575 
#> initial  value 998.131940 
#> iter   2 value 816.457874
#> iter   3 value 801.948179
#> iter   4 value 800.077130
#> iter   5 value 762.770038
#> iter   6 value 754.342467
#> iter   7 value 753.083401
#> iter   8 value 753.060307
#> iter   9 value 753.060281
#> iter   9 value 753.060272
#> iter   9 value 753.060266
#> final  value 753.060266 
#> converged
#> This is Run number  35 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.14043048  1.39313651  -0.4095695 -11.2068635      1
#> 2     1  -0.95  -2.35 -0.73092421  2.68732915  -1.6809242   0.3373292      2
#> 3     1  -6.20  -2.30 -0.15294274  1.21610800  -6.3529427  -1.0838920      2
#> 4     1 -13.90  -2.55 -0.04897067  1.62698452 -13.9489707  -0.9230155      2
#> 5     1 -14.40  -5.80  1.84091168  0.11293400 -12.5590883  -5.6870660      2
#> 6     1  -3.60  -1.70 -0.72173644 -0.04155647  -4.3217364  -1.7415565      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5960 -38675   7275 
#> initial  value 998.131940 
#> iter   2 value 813.146036
#> iter   3 value 798.593452
#> iter   4 value 796.234509
#> iter   5 value 760.058109
#> iter   6 value 751.554155
#> iter   7 value 750.274208
#> iter   8 value 750.249141
#> iter   9 value 750.249111
#> iter   9 value 750.249101
#> iter   9 value 750.249096
#> final  value 750.249096 
#> converged
#> This is Run number  36 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.54236870  1.37120574  -1.092369 -11.228794      1
#> 2     1  -0.95  -2.35 -0.13553929 -1.50755110  -1.085539  -3.857551      1
#> 3     1  -6.20  -2.30 -0.46534926 -0.08382678  -6.665349  -2.383827      2
#> 4     1 -13.90  -2.55 -0.07478104  0.78998504 -13.974781  -1.760015      2
#> 5     1 -14.40  -5.80  0.62893248  0.12093493 -13.771068  -5.679065      2
#> 6     1  -3.60  -1.70 -0.47623471 -0.68165571  -4.076235  -2.381656      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -37200   6375 
#> initial  value 998.131940 
#> iter   2 value 838.701786
#> iter   3 value 828.804108
#> iter   4 value 827.012125
#> iter   5 value 786.387129
#> iter   6 value 778.216387
#> iter   7 value 776.731959
#> iter   8 value 776.700938
#> iter   9 value 776.700877
#> iter   9 value 776.700876
#> iter   9 value 776.700876
#> final  value 776.700876 
#> converged
#> This is Run number  37 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7042745  1.71020923   1.1542745 -10.8897908      1
#> 2     1  -0.95  -2.35  0.8188401  1.73055549  -0.1311599  -0.6194445      1
#> 3     1  -6.20  -2.30  0.8142049  0.61972236  -5.3857951  -1.6802776      2
#> 4     1 -13.90  -2.55  1.5539823  2.02942975 -12.3460177  -0.5205703      2
#> 5     1 -14.40  -5.80  0.2413219 -0.01021182 -14.1586781  -5.8102118      2
#> 6     1  -3.60  -1.70 -1.1351223  1.98439698  -4.7351223   0.2843970      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38300   5875 
#> initial  value 998.131940 
#> iter   2 value 825.550793
#> iter   3 value 816.241328
#> iter   4 value 814.381273
#> iter   5 value 776.815424
#> iter   6 value 768.371424
#> iter   7 value 766.748122
#> iter   8 value 766.708831
#> iter   9 value 766.708730
#> iter  10 value 766.708718
#> iter  10 value 766.708715
#> iter  10 value 766.708711
#> final  value 766.708711 
#> converged
#> This is Run number  38 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7138098 -0.6272689   0.1638098 -13.227269      1
#> 2     1  -0.95  -2.35  1.1214789 -0.3768925   0.1714789  -2.726892      1
#> 3     1  -6.20  -2.30 -0.7095841  0.6286292  -6.9095841  -1.671371      2
#> 4     1 -13.90  -2.55  0.6902177 -1.0113477 -13.2097823  -3.561348      2
#> 5     1 -14.40  -5.80  1.0391582 -0.3155666 -13.3608418  -6.115567      2
#> 6     1  -3.60  -1.70  4.6394236  0.6673716   1.0394236  -1.032628      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38325   6650 
#> initial  value 998.131940 
#> iter   2 value 821.529415
#> iter   3 value 810.144082
#> iter   4 value 808.364363
#> iter   5 value 770.894356
#> iter   6 value 762.425153
#> iter   7 value 760.993309
#> iter   8 value 760.961861
#> iter   9 value 760.961803
#> iter   9 value 760.961803
#> iter   9 value 760.961803
#> final  value 760.961803 
#> converged
#> This is Run number  39 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.78675832  0.06521298  -1.33675832 -12.5347870      1
#> 2     1  -0.95  -2.35  0.96785957  2.19000495   0.01785957  -0.1599950      1
#> 3     1  -6.20  -2.30 -1.04345527  0.19961485  -7.24345527  -2.1003852      2
#> 4     1 -13.90  -2.55 -0.04306056 -0.68188404 -13.94306056  -3.2318840      2
#> 5     1 -14.40  -5.80  3.13787860 -0.01945734 -11.26212140  -5.8194573      2
#> 6     1  -3.60  -1.70  0.29463320  1.46263966  -3.30536680  -0.2373603      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -37625   7150 
#> initial  value 998.131940 
#> iter   2 value 828.350273
#> iter   3 value 818.368201
#> iter   4 value 818.098898
#> iter   5 value 778.265521
#> iter   6 value 769.940285
#> iter   7 value 768.529884
#> iter   8 value 768.500721
#> iter   9 value 768.500664
#> iter  10 value 768.500647
#> iter  10 value 768.500637
#> iter  10 value 768.500631
#> final  value 768.500631 
#> converged
#> This is Run number  40 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  5.64420497 -0.3499432   5.094205 -12.9499432      1
#> 2     1  -0.95  -2.35 -0.87913942 -0.1768537  -1.829139  -2.5268537      1
#> 3     1  -6.20  -2.30  0.18467297  1.7994440  -6.015327  -0.5005560      2
#> 4     1 -13.90  -2.55  0.55369332  1.8287463 -13.346307  -0.7212537      2
#> 5     1 -14.40  -5.80  0.40074217  0.1881833 -13.999258  -5.6118167      2
#> 6     1  -3.60  -1.70 -0.05689137 -0.7171636  -3.656891  -2.4171636      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5780 -37300   7100 
#> initial  value 998.131940 
#> iter   2 value 833.572147
#> iter   3 value 821.535543
#> iter   4 value 819.669924
#> iter   5 value 779.354791
#> iter   6 value 771.141273
#> iter   7 value 769.789226
#> iter   8 value 769.763318
#> iter   9 value 769.763279
#> iter   9 value 769.763268
#> iter   9 value 769.763262
#> final  value 769.763262 
#> converged
#> This is Run number  41 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.71344109 -0.61904602   0.1634411 -13.2190460      1
#> 2     1  -0.95  -2.35 -0.77153748  2.68346729  -1.7215375   0.3334673      2
#> 3     1  -6.20  -2.30  0.77589563  1.10408139  -5.4241044  -1.1959186      2
#> 4     1 -13.90  -2.55  2.34094934  1.97225981 -11.5590507  -0.5777402      2
#> 5     1 -14.40  -5.80 -1.14422438  1.35972356 -15.5442244  -4.4402764      2
#> 6     1  -3.60  -1.70  0.06537586  0.04048977  -3.5346241  -1.6595102      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -38450   6950 
#> initial  value 998.131940 
#> iter   2 value 817.889984
#> iter   3 value 806.904123
#> iter   4 value 806.075294
#> iter   5 value 768.711924
#> iter   6 value 760.208173
#> iter   7 value 758.803017
#> iter   8 value 758.772441
#> iter   9 value 758.772384
#> iter  10 value 758.772369
#> iter  10 value 758.772359
#> iter  10 value 758.772359
#> final  value 758.772359 
#> converged
#> This is Run number  42 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.66879038  0.4249742   0.1187904 -12.1750258      1
#> 2     1  -0.95  -2.35  1.27022437 -0.3186559   0.3202244  -2.6686559      1
#> 3     1  -6.20  -2.30  3.49196275  0.4859582  -2.7080373  -1.8140418      2
#> 4     1 -13.90  -2.55  0.06579049  0.8237347 -13.8342095  -1.7262653      2
#> 5     1 -14.40  -5.80 -0.35180520 -0.9315576 -14.7518052  -6.7315576      2
#> 6     1  -3.60  -1.70 -0.10000316  1.5322635  -3.7000032  -0.1677365      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -39650   7725 
#> initial  value 998.131940 
#> iter   2 value 795.642293
#> iter   3 value 779.625121
#> iter   4 value 778.030535
#> iter   5 value 744.673312
#> iter   6 value 736.094145
#> iter   7 value 734.934048
#> iter   8 value 734.913266
#> iter   8 value 734.913257
#> final  value 734.913257 
#> converged
#> This is Run number  43 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.79728459  0.6615376   1.2472846 -11.9384624      1
#> 2     1  -0.95  -2.35  0.69384936  0.7528065  -0.2561506  -1.5971935      1
#> 3     1  -6.20  -2.30  0.09488667 -0.2946189  -6.1051133  -2.5946189      2
#> 4     1 -13.90  -2.55 -0.17879059  0.2140843 -14.0787906  -2.3359157      2
#> 5     1 -14.40  -5.80  0.20991343  2.4000887 -14.1900866  -3.3999113      2
#> 6     1  -3.60  -1.70  0.80539326  0.9928431  -2.7946067  -0.7071569      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -39925   6900 
#> initial  value 998.131940 
#> iter   2 value 796.234974
#> iter   3 value 780.987785
#> iter   4 value 777.914120
#> iter   5 value 745.620412
#> iter   6 value 736.936690
#> iter   7 value 735.696435
#> iter   8 value 735.669800
#> iter   9 value 735.669767
#> iter   9 value 735.669760
#> iter   9 value 735.669756
#> final  value 735.669756 
#> converged
#> This is Run number  44 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.15137793 -0.2996835   1.601378 -12.8996835      1
#> 2     1  -0.95  -2.35  2.20135275  2.6315006   1.251353   0.2815006      1
#> 3     1  -6.20  -2.30 -0.44624093  1.2011576  -6.646241  -1.0988424      2
#> 4     1 -13.90  -2.55 -0.92385415  0.3782121 -14.823854  -2.1717879      2
#> 5     1 -14.40  -5.80  0.75980472 -0.1540351 -13.640195  -5.9540351      2
#> 6     1  -3.60  -1.70 -0.01342134  0.6343489  -3.613421  -1.0656511      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -39325   7200 
#> initial  value 998.131940 
#> iter   2 value 803.937680
#> iter   3 value 786.970750
#> iter   4 value 783.227340
#> iter   5 value 749.361634
#> iter   6 value 740.778429
#> iter   7 value 739.562344
#> iter   8 value 739.538702
#> iter   9 value 739.538679
#> iter   9 value 739.538673
#> iter   9 value 739.538669
#> final  value 739.538669 
#> converged
#> This is Run number  45 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.2268981  0.52156093   1.6768981 -12.078439      1
#> 2     1  -0.95  -2.35  1.1853668  0.57665505   0.2353668  -1.773345      1
#> 3     1  -6.20  -2.30  1.8662031 -1.16877987  -4.3337969  -3.468780      2
#> 4     1 -13.90  -2.55  1.8871877  0.26783324 -12.0128123  -2.282167      2
#> 5     1 -14.40  -5.80  2.1544772 -0.06336121 -12.2455228  -5.863361      2
#> 6     1  -3.60  -1.70 -0.8812035 -0.01736191  -4.4812035  -1.717362      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6740 -38750   6250 
#> initial  value 998.131940 
#> iter   2 value 816.998406
#> iter   3 value 807.551852
#> iter   4 value 806.444364
#> iter   5 value 769.928505
#> iter   6 value 761.376496
#> iter   7 value 759.822928
#> iter   8 value 759.785233
#> iter   9 value 759.785144
#> iter  10 value 759.785131
#> iter  10 value 759.785124
#> iter  10 value 759.785122
#> final  value 759.785122 
#> converged
#> This is Run number  46 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.0752339  3.5760596   1.5252339 -9.0239404      1
#> 2     1  -0.95  -2.35  0.8326241 -0.7056624  -0.1173759 -3.0556624      1
#> 3     1  -6.20  -2.30 -1.2166153  1.7291134  -7.4166153 -0.5708866      2
#> 4     1 -13.90  -2.55  0.6362095  1.3768847 -13.2637905 -1.1731153      2
#> 5     1 -14.40  -5.80 -0.9054315  0.3000937 -15.3054315 -5.4999063      2
#> 6     1  -3.60  -1.70  0.2473169  1.1548039  -3.3526831 -0.5451961      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -38300   7300 
#> initial  value 998.131940 
#> iter   2 value 818.263020
#> iter   3 value 805.890818
#> iter   4 value 804.812583
#> iter   5 value 767.149205
#> iter   6 value 758.688534
#> iter   7 value 757.361049
#> iter   8 value 757.334486
#> iter   9 value 757.334446
#> iter  10 value 757.334433
#> iter  10 value 757.334423
#> iter  10 value 757.334416
#> final  value 757.334416 
#> converged
#> This is Run number  47 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.002738357 -0.10609074  -0.5527384 -12.70609074      1
#> 2     1  -0.95  -2.35 -1.106705668  2.26787135  -2.0567057  -0.08212865      2
#> 3     1  -6.20  -2.30  0.866482793  0.07076876  -5.3335172  -2.22923124      2
#> 4     1 -13.90  -2.55 -0.515772589  5.44155689 -14.4157726   2.89155689      2
#> 5     1 -14.40  -5.80  2.332070612 -0.22660395 -12.0679294  -6.02660395      2
#> 6     1  -3.60  -1.70 -0.294911813  3.35509553  -3.8949118   1.65509553      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7060 -40100   6825 
#> initial  value 998.131940 
#> iter   2 value 793.158459
#> iter   3 value 781.454262
#> iter   4 value 780.714280
#> iter   5 value 748.201439
#> iter   6 value 739.441585
#> iter   7 value 738.110261
#> iter   8 value 738.078954
#> iter   9 value 738.078898
#> iter  10 value 738.078885
#> iter  10 value 738.078877
#> iter  10 value 738.078870
#> final  value 738.078870 
#> converged
#> This is Run number  48 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.9371712 -0.49542166   2.387171 -13.0954217      1
#> 2     1  -0.95  -2.35 -0.1214152  0.74815949  -1.071415  -1.6018405      1
#> 3     1  -6.20  -2.30 -0.1583219 -0.15883663  -6.358322  -2.4588366      2
#> 4     1 -13.90  -2.55  2.1187215  0.02039968 -11.781279  -2.5296003      2
#> 5     1 -14.40  -5.80 -1.4620323  2.24545905 -15.862032  -3.5545409      2
#> 6     1  -3.60  -1.70  0.5090615  1.32945124  -3.090938  -0.3705488      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5960 -37900   6725 
#> initial  value 998.131940 
#> iter   2 value 827.293699
#> iter   3 value 815.341660
#> iter   4 value 813.156383
#> iter   5 value 774.601331
#> iter   6 value 766.229112
#> iter   7 value 764.822091
#> iter   8 value 764.792688
#> iter   9 value 764.792638
#> iter   9 value 764.792628
#> iter   9 value 764.792622
#> final  value 764.792622 
#> converged
#> This is Run number  49 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8564031  0.7850111   0.3064031 -11.814989      1
#> 2     1  -0.95  -2.35  0.6465253 -0.2390917  -0.3034747  -2.589092      1
#> 3     1  -6.20  -2.30  0.0358460  3.6958055  -6.1641540   1.395806      2
#> 4     1 -13.90  -2.55 -0.8363841  1.3921845 -14.7363841  -1.157815      2
#> 5     1 -14.40  -5.80  1.3140880  0.0114584 -13.0859120  -5.788542      2
#> 6     1  -3.60  -1.70  0.8793345 -0.8890097  -2.7206655  -2.589010      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5920 -38175   7275 
#> initial  value 998.131940 
#> iter   2 value 820.374861
#> iter   3 value 806.770309
#> iter   4 value 804.742841
#> iter   5 value 766.995619
#> iter   6 value 758.579463
#> iter   7 value 757.271294
#> iter   8 value 757.245909
#> iter   9 value 757.245876
#> iter   9 value 757.245865
#> iter   9 value 757.245859
#> final  value 757.245859 
#> converged
#> This is Run number  50 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0705900  5.1100053  -1.620590 -7.4899947      1
#> 2     1  -0.95  -2.35 -1.1243438  2.1529982  -2.074344 -0.1970018      2
#> 3     1  -6.20  -2.30 -0.4195396  0.3477998  -6.619540 -1.9522002      2
#> 4     1 -13.90  -2.55  0.3434726  1.9679806 -13.556527 -0.5820194      2
#> 5     1 -14.40  -5.80 -0.1494952 -0.4306518 -14.549495 -6.2306518      2
#> 6     1  -3.60  -1.70  0.6583265  1.2582679  -2.941673 -0.4417321      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -38975   6775 
#> initial  value 998.131940 
#> iter   2 value 811.262900
#> iter   3 value 799.195027
#> iter   4 value 797.529397
#> iter   5 value 761.935076
#> iter   6 value 753.338990
#> iter   7 value 751.954330
#> iter   8 value 751.923408
#> iter   9 value 751.923355
#> iter  10 value 751.923343
#> iter  10 value 751.923335
#> iter  10 value 751.923335
#> final  value 751.923335 
#> converged
#> This is Run number  51 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1734721  4.0768734  -0.7234721 -8.523127      1
#> 2     1  -0.95  -2.35 -0.5763385  1.2462055  -1.5263385 -1.103794      2
#> 3     1  -6.20  -2.30  0.2401681 -0.1925522  -5.9598319 -2.492552      2
#> 4     1 -13.90  -2.55 -1.0784556 -0.4946384 -14.9784556 -3.044638      2
#> 5     1 -14.40  -5.80  0.9013395  0.6825405 -13.4986605 -5.117459      2
#> 6     1  -3.60  -1.70  2.3287621 -0.6088609  -1.2712379 -2.308861      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5940 -38350   6625 
#> initial  value 998.131940 
#> iter   2 value 821.439197
#> iter   3 value 808.514081
#> iter   4 value 805.738817
#> iter   5 value 768.627081
#> iter   6 value 760.142531
#> iter   7 value 758.744908
#> iter   8 value 758.714885
#> iter   9 value 758.714834
#> iter   9 value 758.714825
#> iter   9 value 758.714820
#> final  value 758.714820 
#> converged
#> This is Run number  52 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.21332141  0.6115616  -0.7633214 -11.988438      1
#> 2     1  -0.95  -2.35 -0.06550073 -0.2540718  -1.0155007  -2.604072      1
#> 3     1  -6.20  -2.30 -0.47778568  0.6458479  -6.6777857  -1.654152      2
#> 4     1 -13.90  -2.55  0.26206233 -0.5363866 -13.6379377  -3.086387      2
#> 5     1 -14.40  -5.80 -1.28305421 -0.9505438 -15.6830542  -6.750544      2
#> 6     1  -3.60  -1.70 -0.03367503  3.4157704  -3.6336750   1.715770      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5600 -37700   6850 
#> initial  value 998.131940 
#> iter   2 value 829.488034
#> iter   3 value 815.880643
#> iter   4 value 812.851747
#> iter   5 value 773.954597
#> iter   6 value 765.620054
#> iter   7 value 764.262927
#> iter   8 value 764.236153
#> iter   9 value 764.236115
#> iter   9 value 764.236106
#> iter   9 value 764.236102
#> final  value 764.236102 
#> converged
#> This is Run number  53 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 1.5840847 -0.53130286   1.03408467 -13.1313029      1
#> 2     1  -0.95  -2.35 0.9671002  0.57240380   0.01710017  -1.7775962      1
#> 3     1  -6.20  -2.30 1.1787649 -0.04038893  -5.02123513  -2.3403889      2
#> 4     1 -13.90  -2.55 0.5168136  0.74795404 -13.38318641  -1.8020460      2
#> 5     1 -14.40  -5.80 0.0269467  2.70764331 -14.37305330  -3.0923567      2
#> 6     1  -3.60  -1.70 2.1059306  0.91435411  -1.49406938  -0.7856459      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -38500   7325 
#> initial  value 998.131940 
#> iter   2 value 815.434675
#> iter   3 value 800.680455
#> iter   4 value 798.200804
#> iter   5 value 761.549803
#> iter   6 value 753.081569
#> iter   7 value 751.804646
#> iter   8 value 751.780141
#> iter   9 value 751.780113
#> iter   9 value 751.780103
#> iter   9 value 751.780098
#> final  value 751.780098 
#> converged
#> This is Run number  54 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.1226000  0.48452969  -1.6726000 -12.115470      1
#> 2     1  -0.95  -2.35  0.5041335 -0.51810840  -0.4458665  -2.868108      1
#> 3     1  -6.20  -2.30  0.2347791  1.99681704  -5.9652209  -0.303183      2
#> 4     1 -13.90  -2.55  0.4909746 -0.08782500 -13.4090254  -2.637825      2
#> 5     1 -14.40  -5.80 -1.0817428  0.09356892 -15.4817428  -5.706431      2
#> 6     1  -3.60  -1.70 -0.1716076  0.47813314  -3.7716076  -1.221867      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6640 -38100   7375 
#> initial  value 998.131940 
#> iter   2 value 820.359070
#> iter   3 value 809.234542
#> iter   4 value 808.981016
#> iter   5 value 770.540398
#> iter   6 value 762.092484
#> iter   7 value 760.737481
#> iter   8 value 760.710046
#> iter   9 value 760.709998
#> iter  10 value 760.709983
#> iter  10 value 760.709974
#> iter  10 value 760.709966
#> final  value 760.709966 
#> converged
#> This is Run number  55 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.9081562  2.42970564   2.3581562 -10.170294      1
#> 2     1  -0.95  -2.35  0.3418053 -0.02434984  -0.6081947  -2.374350      1
#> 3     1  -6.20  -2.30 -0.5075199 -0.67135129  -6.7075199  -2.971351      2
#> 4     1 -13.90  -2.55  0.3120520 -0.21792546 -13.5879480  -2.767925      2
#> 5     1 -14.40  -5.80  0.2889016  0.88446951 -14.1110984  -4.915530      2
#> 6     1  -3.60  -1.70  0.3922307  0.33060741  -3.2077693  -1.369393      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5660 -36700   7575 
#> initial  value 998.131940 
#> iter   2 value 838.829533
#> iter   3 value 826.877525
#> iter   4 value 825.526432
#> iter   5 value 783.392655
#> iter   6 value 775.339955
#> iter   7 value 774.050023
#> iter   8 value 774.027792
#> iter   9 value 774.027762
#> iter   9 value 774.027751
#> iter   9 value 774.027745
#> final  value 774.027745 
#> converged
#> This is Run number  56 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.002726308 -0.4310971  -0.5472737 -13.03109715      1
#> 2     1  -0.95  -2.35  0.029817228  0.1321433  -0.9201828  -2.21785665      1
#> 3     1  -6.20  -2.30  0.852524470  2.2600634  -5.3474755  -0.03993665      2
#> 4     1 -13.90  -2.55 -0.387014032  0.1709590 -14.2870140  -2.37904103      2
#> 5     1 -14.40  -5.80 -1.619565647  1.4339483 -16.0195656  -4.36605167      2
#> 6     1  -3.60  -1.70 -0.864710967  3.0335322  -4.4647110   1.33353222      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7200 -40600   6275 
#> initial  value 998.131940 
#> iter   2 value 787.877907
#> iter   3 value 777.147900
#> iter   4 value 775.935444
#> iter   5 value 744.967575
#> iter   6 value 736.153199
#> iter   7 value 734.751407
#> iter   8 value 734.714794
#> iter   9 value 734.714716
#> iter   9 value 734.714705
#> iter   9 value 734.714697
#> final  value 734.714697 
#> converged
#> This is Run number  57 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9945020  0.520600487   0.444502 -12.079400      1
#> 2     1  -0.95  -2.35 -0.1858918  0.007004588  -1.135892  -2.342995      1
#> 3     1  -6.20  -2.30 -0.2102867 -0.641286324  -6.410287  -2.941286      2
#> 4     1 -13.90  -2.55  3.7337388 -0.089307883 -10.166261  -2.639308      2
#> 5     1 -14.40  -5.80  0.2335292 -0.627732068 -14.166471  -6.427732      2
#> 6     1  -3.60  -1.70 -0.3792656  1.148182025  -3.979266  -0.551818      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -40025   7000 
#> initial  value 998.131940 
#> iter   2 value 793.717902
#> iter   3 value 780.617740
#> iter   4 value 779.324508
#> iter   5 value 746.808653
#> iter   6 value 738.088269
#> iter   7 value 736.817074
#> iter   8 value 736.788971
#> iter   9 value 736.788931
#> iter   9 value 736.788920
#> iter   9 value 736.788913
#> final  value 736.788913 
#> converged
#> This is Run number  58 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1           e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4571985  1.3058410927  -0.09280151 -11.294159      1
#> 2     1  -0.95  -2.35 -0.1937811 -1.0521658995  -1.14378108  -3.402166      1
#> 3     1  -6.20  -2.30 -0.9002293 -0.3171285445  -7.10022930  -2.617129      2
#> 4     1 -13.90  -2.55  2.0540424 -0.0008984213 -11.84595755  -2.550898      2
#> 5     1 -14.40  -5.80  1.2539520  0.2071496298 -13.14604797  -5.592850      2
#> 6     1  -3.60  -1.70  0.1663033 -0.2220928603  -3.43369670  -1.922093      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6520 -38425   6300 
#> initial  value 998.131940 
#> iter   2 value 821.677556
#> iter   3 value 811.847539
#> iter   4 value 810.449793
#> iter   5 value 773.105717
#> iter   6 value 764.621464
#> iter   7 value 763.090220
#> iter   8 value 763.054354
#> iter   9 value 763.054274
#> iter  10 value 763.054262
#> iter  10 value 763.054255
#> iter  10 value 763.054252
#> final  value 763.054252 
#> converged
#> This is Run number  59 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.43597779  1.56527902  -0.9859778 -11.034721      1
#> 2     1  -0.95  -2.35  3.85699231  0.06030084   2.9069923  -2.289699      1
#> 3     1  -6.20  -2.30  0.28358072  0.33147899  -5.9164193  -1.968521      2
#> 4     1 -13.90  -2.55 -0.23075292  0.17126672 -14.1307529  -2.378733      2
#> 5     1 -14.40  -5.80  0.09154495  1.70106369 -14.3084551  -4.098936      2
#> 6     1  -3.60  -1.70  1.08872305 -0.50416569  -2.5112770  -2.204166      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38125   6675 
#> initial  value 998.131940 
#> iter   2 value 824.153085
#> iter   3 value 813.691828
#> iter   4 value 812.473636
#> iter   5 value 774.255517
#> iter   6 value 765.832548
#> iter   7 value 764.377969
#> iter   8 value 764.345990
#> iter   9 value 764.345928
#> iter   9 value 764.345928
#> iter   9 value 764.345928
#> final  value 764.345928 
#> converged
#> This is Run number  60 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2508201 -0.3734890  -0.2991799 -12.973489      1
#> 2     1  -0.95  -2.35 -1.3414033 -0.5180348  -2.2914033  -2.868035      1
#> 3     1  -6.20  -2.30  4.8701170  0.1663493  -1.3298830  -2.133651      1
#> 4     1 -13.90  -2.55  2.8363642  2.9052270 -11.0636358   0.355227      2
#> 5     1 -14.40  -5.80 -0.1019067  1.4269929 -14.5019067  -4.373007      2
#> 6     1  -3.60  -1.70 -0.2679252  0.5507058  -3.8679252  -1.149294      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -38625   6500 
#> initial  value 998.131940 
#> iter   2 value 818.145445
#> iter   3 value 803.059787
#> iter   4 value 798.995026
#> iter   5 value 762.916691
#> iter   6 value 754.331446
#> iter   7 value 752.976540
#> iter   8 value 752.947464
#> iter   9 value 752.947416
#> iter   9 value 752.947407
#> iter   9 value 752.947403
#> final  value 752.947403 
#> converged
#> This is Run number  61 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.14092514  1.0831714  -0.6909251 -11.516829      1
#> 2     1  -0.95  -2.35 -0.08381742 -1.7439245  -1.0338174  -4.093924      1
#> 3     1  -6.20  -2.30 -0.42034058  0.8241373  -6.6203406  -1.475863      2
#> 4     1 -13.90  -2.55  3.81712748 -0.3536398 -10.0828725  -2.903640      2
#> 5     1 -14.40  -5.80  0.08110513  1.2564924 -14.3188949  -4.543508      2
#> 6     1  -3.60  -1.70  2.12373749 -0.3276367  -1.4762625  -2.027637      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -38550   7450 
#> initial  value 998.131940 
#> iter   2 value 813.862286
#> iter   3 value 800.098676
#> iter   4 value 798.591095
#> iter   5 value 761.819604
#> iter   6 value 753.332299
#> iter   7 value 752.054468
#> iter   8 value 752.029896
#> iter   9 value 752.029865
#> iter   9 value 752.029854
#> iter   9 value 752.029847
#> final  value 752.029847 
#> converged
#> This is Run number  62 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.3758963 -0.43300879  -0.1741037 -13.0330088      1
#> 2     1  -0.95  -2.35  0.6072881 -0.06120956  -0.3427119  -2.4112096      1
#> 3     1  -6.20  -2.30  1.9644980  0.88644384  -4.2355020  -1.4135562      2
#> 4     1 -13.90  -2.55 -0.8964901  1.33120664 -14.7964901  -1.2187934      2
#> 5     1 -14.40  -5.80 -0.9474455  1.23384735 -15.3474455  -4.5661526      2
#> 6     1  -3.60  -1.70 -0.3889098  2.14841735  -3.9889098   0.4484173      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7160 -40725   6900 
#> initial  value 998.131940 
#> iter   2 value 782.639395
#> iter   3 value 770.073151
#> iter   4 value 769.243252
#> iter   5 value 738.689303
#> iter   6 value 729.908723
#> iter   7 value 728.669815
#> iter   8 value 728.641377
#> iter   9 value 728.641335
#> iter   9 value 728.641324
#> iter   9 value 728.641316
#> final  value 728.641316 
#> converged
#> This is Run number  63 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.09708567  0.22972358  -0.4529143 -12.3702764      1
#> 2     1  -0.95  -2.35 -0.28340339  0.90102124  -1.2334034  -1.4489788      1
#> 3     1  -6.20  -2.30 -0.72245935  1.42273912  -6.9224594  -0.8772609      2
#> 4     1 -13.90  -2.55 -0.26040919 -0.55923959 -14.1604092  -3.1092396      2
#> 5     1 -14.40  -5.80  5.96485406 -0.04564194  -8.4351459  -5.8456419      2
#> 6     1  -3.60  -1.70  0.77720827  1.06356686  -2.8227917  -0.6364331      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5540 -37050   6825 
#> initial  value 998.131940 
#> iter   2 value 838.484488
#> iter   3 value 826.128444
#> iter   4 value 823.520020
#> iter   5 value 782.698589
#> iter   6 value 774.543489
#> iter   7 value 773.173324
#> iter   8 value 773.147130
#> iter   9 value 773.147091
#> iter   9 value 773.147082
#> iter   9 value 773.147078
#> final  value 773.147078 
#> converged
#> This is Run number  64 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9645116  0.66883180  -1.5145116 -11.9311682      1
#> 2     1  -0.95  -2.35  1.3703464  0.50142487   0.4203464  -1.8485751      1
#> 3     1  -6.20  -2.30  2.4423214 -0.55877465  -3.7576786  -2.8587746      2
#> 4     1 -13.90  -2.55  0.9106932 -0.06069489 -12.9893068  -2.6106949      2
#> 5     1 -14.40  -5.80  0.7759955  5.06427833 -13.6240045  -0.7357217      2
#> 6     1  -3.60  -1.70  1.5890401  1.53529954  -2.0109599  -0.1647005      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6400 -38375   6575 
#> initial  value 998.131940 
#> iter   2 value 821.095508
#> iter   3 value 810.427510
#> iter   4 value 808.992492
#> iter   5 value 771.547059
#> iter   6 value 763.067506
#> iter   7 value 761.604698
#> iter   8 value 761.571795
#> iter   9 value 761.571730
#> iter   9 value 761.571729
#> iter   9 value 761.571729
#> final  value 761.571729 
#> converged
#> This is Run number  65 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60  1.2704263 3.37310339   0.7204263 -9.226897      1
#> 2     1  -0.95  -2.35 -0.3886616 0.08641257  -1.3386616 -2.263587      1
#> 3     1  -6.20  -2.30  0.9599140 0.79382039  -5.2400860 -1.506180      2
#> 4     1 -13.90  -2.55  0.1436504 1.29666697 -13.7563496 -1.253333      2
#> 5     1 -14.40  -5.80  1.0584448 0.70018071 -13.3415552 -5.099819      2
#> 6     1  -3.60  -1.70 -0.9948526 3.43193013  -4.5948526  1.731930      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7500 -39325   5525 
#> initial  value 998.131940 
#> iter   2 value 810.778554
#> iter   3 value 804.127351
#> iter   4 value 803.725034
#> iter   5 value 768.530008
#> iter   6 value 759.937831
#> iter   7 value 758.112106
#> iter   8 value 758.061529
#> iter   9 value 758.061358
#> iter  10 value 758.061342
#> iter  10 value 758.061342
#> iter  10 value 758.061336
#> final  value 758.061336 
#> converged
#> This is Run number  66 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.94274035 1.0587750  -1.492740 -11.5412250      1
#> 2     1  -0.95  -2.35 -0.50325596 0.5223148  -1.453256  -1.8276852      1
#> 3     1  -6.20  -2.30  0.85593397 1.1380797  -5.344066  -1.1619203      2
#> 4     1 -13.90  -2.55  0.90895125 0.5227077 -12.991049  -2.0272923      2
#> 5     1 -14.40  -5.80  0.05103792 1.1640035 -14.348962  -4.6359965      2
#> 6     1  -3.60  -1.70 -0.97035454 1.5549439  -4.570355  -0.1450561      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -40375   7175 
#> initial  value 998.131940 
#> iter   2 value 787.535400
#> iter   3 value 771.277229
#> iter   4 value 768.428218
#> iter   5 value 737.516024
#> iter   6 value 728.858032
#> iter   7 value 727.703811
#> iter   8 value 727.680519
#> iter   9 value 727.680498
#> iter   9 value 727.680492
#> iter   9 value 727.680488
#> final  value 727.680488 
#> converged
#> This is Run number  67 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.2173684 -0.3451926   1.667368 -12.945193      1
#> 2     1  -0.95  -2.35 -0.4137732 -0.3473576  -1.363773  -2.697358      1
#> 3     1  -6.20  -2.30 -1.0058077  0.3302565  -7.205808  -1.969743      2
#> 4     1 -13.90  -2.55 -0.2291413 -0.4238604 -14.129141  -2.973860      2
#> 5     1 -14.40  -5.80 -0.1175618  1.4433230 -14.517562  -4.356677      2
#> 6     1  -3.60  -1.70  2.3114642  0.6781493  -1.288536  -1.021851      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6300 -40450   6625 
#> initial  value 998.131940 
#> iter   2 value 789.365128
#> iter   3 value 773.698035
#> iter   4 value 769.900117
#> iter   5 value 739.331998
#> iter   6 value 730.592069
#> iter   7 value 729.375716
#> iter   8 value 729.348246
#> iter   9 value 729.348207
#> iter   9 value 729.348202
#> iter   9 value 729.348197
#> final  value 729.348197 
#> converged
#> This is Run number  68 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.9237850  0.3464801   1.373785 -12.253520      1
#> 2     1  -0.95  -2.35  2.1097690  0.8237414   1.159769  -1.526259      1
#> 3     1  -6.20  -2.30  0.6987535  0.4687134  -5.501246  -1.831287      2
#> 4     1 -13.90  -2.55  2.0057769  0.9240380 -11.894223  -1.625962      2
#> 5     1 -14.40  -5.80 -0.9823895 -0.8427107 -15.382389  -6.642711      2
#> 6     1  -3.60  -1.70  1.4806043 -0.5814357  -2.119396  -2.281436      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -37975   7475 
#> initial  value 998.131940 
#> iter   2 value 822.009027
#> iter   3 value 808.751339
#> iter   4 value 807.252887
#> iter   5 value 768.791592
#> iter   6 value 760.417338
#> iter   7 value 759.122939
#> iter   8 value 759.098674
#> iter   9 value 759.098642
#> iter  10 value 759.098630
#> iter  10 value 759.098621
#> iter  10 value 759.098615
#> final  value 759.098615 
#> converged
#> This is Run number  69 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 0.2831594 -0.1999130  -0.2668406 -12.7999130      1
#> 2     1  -0.95  -2.35 0.4834013 -0.2763667  -0.4665987  -2.6263667      1
#> 3     1  -6.20  -2.30 1.1292655  1.5569049  -5.0707345  -0.7430951      2
#> 4     1 -13.90  -2.55 1.0461758  0.6917944 -12.8538242  -1.8582056      2
#> 5     1 -14.40  -5.80 1.4374732 -1.6730457 -12.9625268  -7.4730457      2
#> 6     1  -3.60  -1.70 1.0482825  4.2943994  -2.5517175   2.5943994      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7280 -40550   6250 
#> initial  value 998.131940 
#> iter   2 value 788.693308
#> iter   3 value 778.388955
#> iter   4 value 777.399561
#> iter   5 value 746.195610
#> iter   6 value 737.380478
#> iter   7 value 735.951866
#> iter   8 value 735.914177
#> iter   9 value 735.914093
#> iter  10 value 735.914081
#> iter  10 value 735.914076
#> iter  10 value 735.914069
#> final  value 735.914069 
#> converged
#> This is Run number  70 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.98806493 1.14983111   2.4380649 -11.4501689      1
#> 2     1  -0.95  -2.35  1.31764356 0.70060328   0.3676436  -1.6493967      1
#> 3     1  -6.20  -2.30  0.27133930 2.84941387  -5.9286607   0.5494139      2
#> 4     1 -13.90  -2.55 -0.38386691 0.09670359 -14.2838669  -2.4532964      2
#> 5     1 -14.40  -5.80 -0.19966443 0.67225741 -14.5996644  -5.1277426      2
#> 6     1  -3.60  -1.70  0.05103394 0.68438236  -3.5489661  -1.0156176      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7360 -40125   5975 
#> initial  value 998.131940 
#> iter   2 value 796.656315
#> iter   3 value 787.797068
#> iter   4 value 787.032502
#> iter   5 value 754.410469
#> iter   6 value 745.639165
#> iter   7 value 744.060553
#> iter   8 value 744.017332
#> iter   9 value 744.017216
#> iter  10 value 744.017202
#> iter  10 value 744.017197
#> iter  10 value 744.017190
#> final  value 744.017190 
#> converged
#> This is Run number  71 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.9558678 -0.28590425   1.40586777 -12.8859043      1
#> 2     1  -0.95  -2.35  0.9939595 -0.47121844   0.04395947  -2.8212184      1
#> 3     1  -6.20  -2.30  1.3622489  2.04312783  -4.83775108  -0.2568722      2
#> 4     1 -13.90  -2.55  0.8113508  6.91967651 -13.08864923   4.3696765      2
#> 5     1 -14.40  -5.80  1.3510047  0.06870411 -13.04899526  -5.7312959      2
#> 6     1  -3.60  -1.70 -2.0749149 -0.35809217  -5.67491489  -2.0580922      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5840 -38800   7350 
#> initial  value 998.131940 
#> iter   2 value 810.909720
#> iter   3 value 795.271293
#> iter   4 value 792.441926
#> iter   5 value 756.788568
#> iter   6 value 748.279850
#> iter   7 value 747.029721
#> iter   8 value 747.005883
#> iter   9 value 747.005858
#> iter   9 value 747.005849
#> iter   9 value 747.005844
#> final  value 747.005844 
#> converged
#> This is Run number  72 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.68005206  0.51367898  -1.230052 -12.086321      1
#> 2     1  -0.95  -2.35  3.89628108 -0.02885329   2.946281  -2.378853      1
#> 3     1  -6.20  -2.30  0.62907324 -1.11398545  -5.570927  -3.413985      2
#> 4     1 -13.90  -2.55 -1.17330829 -0.17502990 -15.073308  -2.725030      2
#> 5     1 -14.40  -5.80  1.83859271 -0.29812469 -12.561407  -6.098125      2
#> 6     1  -3.60  -1.70 -0.08773535 -0.55055796  -3.687735  -2.250558      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5640 -38375   7200 
#> initial  value 998.131940 
#> iter   2 value 817.996336
#> iter   3 value 802.495944
#> iter   4 value 799.232143
#> iter   5 value 762.401709
#> iter   6 value 753.947707
#> iter   7 value 752.666703
#> iter   8 value 752.642195
#> iter   9 value 752.642168
#> iter   9 value 752.642159
#> iter   9 value 752.642155
#> final  value 752.642155 
#> converged
#> This is Run number  73 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.0637934  0.8624431   0.5137934 -11.7375569      1
#> 2     1  -0.95  -2.35  0.6601374 -0.7218626  -0.2898626  -3.0718626      1
#> 3     1  -6.20  -2.30 -0.8427415  0.5771343  -7.0427415  -1.7228657      2
#> 4     1 -13.90  -2.55  1.6078021  0.4439846 -12.2921979  -2.1060154      2
#> 5     1 -14.40  -5.80  0.1739378 -0.2364939 -14.2260622  -6.0364939      2
#> 6     1  -3.60  -1.70  1.1675201  1.0402617  -2.4324799  -0.6597383      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6780 -38900   6825 
#> initial  value 998.131940 
#> iter   2 value 811.772035
#> iter   3 value 801.083775
#> iter   4 value 800.422025
#> iter   5 value 764.297307
#> iter   6 value 755.700620
#> iter   7 value 754.275055
#> iter   8 value 754.242478
#> iter   9 value 754.242413
#> iter  10 value 754.242398
#> iter  10 value 754.242388
#> iter  10 value 754.242381
#> final  value 754.242381 
#> converged
#> This is Run number  74 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.2924840  0.8739020   1.7424840 -11.726098      1
#> 2     1  -0.95  -2.35  0.1284661 -0.1764717  -0.8215339  -2.526472      1
#> 3     1  -6.20  -2.30  1.0086759  0.4222885  -5.1913241  -1.877712      2
#> 4     1 -13.90  -2.55  2.2127638  0.3745331 -11.6872362  -2.175467      2
#> 5     1 -14.40  -5.80 -0.2433684  4.5157374 -14.6433684  -1.284263      2
#> 6     1  -3.60  -1.70  1.1963571 -0.6265572  -2.4036429  -2.326557      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6820 -40325   5425 
#> initial  value 998.131940 
#> iter   2 value 796.625937
#> iter   3 value 785.810638
#> iter   4 value 782.689526
#> iter   5 value 751.417583
#> iter   6 value 742.606890
#> iter   7 value 741.008584
#> iter   8 value 740.961345
#> iter   9 value 740.961168
#> iter  10 value 740.961150
#> iter  10 value 740.961150
#> iter  11 value 740.961138
#> iter  11 value 740.961135
#> iter  11 value 740.961133
#> final  value 740.961133 
#> converged
#> This is Run number  75 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7526788  0.7104879  -1.3026788 -11.889512      1
#> 2     1  -0.95  -2.35  1.0967658  1.1902048   0.1467658  -1.159795      1
#> 3     1  -6.20  -2.30  1.2696449 -0.8296046  -4.9303551  -3.129605      2
#> 4     1 -13.90  -2.55  0.4102497  2.8696700 -13.4897503   0.319670      2
#> 5     1 -14.40  -5.80  0.9725670  0.9143179 -13.4274330  -4.885682      2
#> 6     1  -3.60  -1.70  1.5803217 -0.8893010  -2.0196783  -2.589301      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6600 -39500   7300 
#> initial  value 998.131940 
#> iter   2 value 800.275257
#> iter   3 value 786.800005
#> iter   4 value 785.724964
#> iter   5 value 751.632452
#> iter   6 value 742.982749
#> iter   7 value 741.721943
#> iter   8 value 741.695990
#> iter   9 value 741.695955
#> iter  10 value 741.695944
#> iter  10 value 741.695935
#> iter  10 value 741.695928
#> final  value 741.695928 
#> converged
#> This is Run number  76 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.002203018  1.84932479  -0.5522030 -10.750675      1
#> 2     1  -0.95  -2.35  0.055219473  0.35429777  -0.8947805  -1.995702      1
#> 3     1  -6.20  -2.30 -0.688342460 -0.02749961  -6.8883425  -2.327500      2
#> 4     1 -13.90  -2.55  1.096123941  0.52721483 -12.8038761  -2.022785      2
#> 5     1 -14.40  -5.80  0.887343077  1.54773004 -13.5126569  -4.252270      2
#> 6     1  -3.60  -1.70  0.093306994  0.19990133  -3.5066930  -1.500099      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7380 -39075   6425 
#> initial  value 998.131940 
#> iter   2 value 810.468861
#> iter   3 value 801.910484
#> iter   4 value 801.830183
#> iter   5 value 765.949678
#> iter   6 value 757.354382
#> iter   7 value 755.771362
#> iter   8 value 755.731368
#> iter   9 value 755.731260
#> iter  10 value 755.731242
#> iter  10 value 755.731234
#> iter  10 value 755.731226
#> final  value 755.731226 
#> converged
#> This is Run number  77 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1461190 -0.1267509  -0.696119 -12.7267509      1
#> 2     1  -0.95  -2.35 -0.1065639  1.4266081  -1.056564  -0.9233919      2
#> 3     1  -6.20  -2.30  0.8214025 -0.2072795  -5.378598  -2.5072795      2
#> 4     1 -13.90  -2.55 -1.3949348 -1.2271316 -15.294935  -3.7771316      2
#> 5     1 -14.40  -5.80  1.0483308  0.9607808 -13.351669  -4.8392192      2
#> 6     1  -3.60  -1.70  1.4301829  0.2960541  -2.169817  -1.4039459      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -38075   7150 
#> initial  value 998.131940 
#> iter   2 value 822.471399
#> iter   3 value 809.775560
#> iter   4 value 808.022519
#> iter   5 value 769.885747
#> iter   6 value 761.481827
#> iter   7 value 760.141959
#> iter   8 value 760.115221
#> iter   9 value 760.115181
#> iter  10 value 760.115169
#> iter  10 value 760.115160
#> iter  10 value 760.115160
#> final  value 760.115160 
#> converged
#> This is Run number  78 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.8893032  1.9656623  -1.43930316 -10.634338      1
#> 2     1  -0.95  -2.35  3.3472836  0.4352147   2.39728364  -1.914785      1
#> 3     1  -6.20  -2.30 -0.4710426 -0.6388205  -6.67104263  -2.938821      2
#> 4     1 -13.90  -2.55  0.6830566 -0.3580751 -13.21694344  -2.908075      2
#> 5     1 -14.40  -5.80 -0.1114782  1.2884228 -14.51147819  -4.511577      2
#> 6     1  -3.60  -1.70  3.5861732  0.1459608  -0.01382677  -1.554039      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6520 -40625   6975 
#> initial  value 998.131940 
#> iter   2 value 784.520677
#> iter   3 value 769.116361
#> iter   4 value 766.435370
#> iter   5 value 736.184360
#> iter   6 value 727.483128
#> iter   7 value 726.315096
#> iter   8 value 726.290190
#> iter   9 value 726.290163
#> iter   9 value 726.290163
#> iter   9 value 726.290163
#> final  value 726.290163 
#> converged
#> This is Run number  79 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1567705 -0.1169315  -0.7067705 -12.7169315      1
#> 2     1  -0.95  -2.35  1.3874137  0.1202300   0.4374137  -2.2297700      1
#> 3     1  -6.20  -2.30  1.0389011  4.0860144  -5.1610989   1.7860144      2
#> 4     1 -13.90  -2.55  0.9800581 -1.1122798 -12.9199419  -3.6622798      2
#> 5     1 -14.40  -5.80  2.8822508  1.6856565 -11.5177492  -4.1143435      2
#> 6     1  -3.60  -1.70 -0.4873458  2.0758497  -4.0873458   0.3758497      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -39675   6425 
#> initial  value 998.131940 
#> iter   2 value 802.589947
#> iter   3 value 788.890342
#> iter   4 value 785.685694
#> iter   5 value 752.574239
#> iter   6 value 743.859365
#> iter   7 value 742.502476
#> iter   8 value 742.470541
#> iter   9 value 742.470483
#> iter   9 value 742.470475
#> iter   9 value 742.470469
#> final  value 742.470469 
#> converged
#> This is Run number  80 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.6986578  0.84202093   1.148658 -11.757979      1
#> 2     1  -0.95  -2.35  0.6242290 -0.78962108  -0.325771  -3.139621      1
#> 3     1  -6.20  -2.30  0.4635686  1.13209145  -5.736431  -1.167909      2
#> 4     1 -13.90  -2.55 -0.5302197  0.16731670 -14.430220  -2.382683      2
#> 5     1 -14.40  -5.80  1.3253005  1.37522472 -13.074700  -4.424775      2
#> 6     1  -3.60  -1.70  0.4165892  0.03988974  -3.183411  -1.660110      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -41325   6975 
#> initial  value 998.131940 
#> iter   2 value 773.106087
#> iter   3 value 755.069418
#> iter   4 value 750.865562
#> iter   5 value 723.186784
#> iter   6 value 714.574958
#> iter   7 value 713.534303
#> iter   8 value 713.513225
#> iter   9 value 713.513212
#> iter   9 value 713.513209
#> iter   9 value 713.513206
#> final  value 713.513206 
#> converged
#> This is Run number  81 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.8857455  0.69194360   2.335746 -11.908056      1
#> 2     1  -0.95  -2.35 -0.4785646  0.15365553  -1.428565  -2.196344      1
#> 3     1  -6.20  -2.30  0.6992334  0.85319884  -5.500767  -1.446801      2
#> 4     1 -13.90  -2.55  0.5870290  0.08244343 -13.312971  -2.467557      2
#> 5     1 -14.40  -5.80 -1.5699970  1.28708053 -15.969997  -4.512919      2
#> 6     1  -3.60  -1.70 -0.4917272 -0.33048189  -4.091727  -2.030482      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -39275   7600 
#> initial  value 998.131940 
#> iter   2 value 802.288107
#> iter   3 value 785.872757
#> iter   4 value 783.411391
#> iter   5 value 749.140416
#> iter   6 value 740.601795
#> iter   7 value 739.410538
#> iter   8 value 739.388807
#> iter   9 value 739.388788
#> iter   9 value 739.388781
#> iter   9 value 739.388780
#> final  value 739.388780 
#> converged
#> This is Run number  82 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6815306 -0.4990454   0.1315306 -13.09904539      1
#> 2     1  -0.95  -2.35 -0.2967441  2.4164207  -1.2467441   0.06642072      2
#> 3     1  -6.20  -2.30  0.1689444  0.7661130  -6.0310556  -1.53388699      2
#> 4     1 -13.90  -2.55  0.4964737  1.8496352 -13.4035263  -0.70036480      2
#> 5     1 -14.40  -5.80  0.8407347  1.0421646 -13.5592653  -4.75783541      2
#> 6     1  -3.60  -1.70 -1.2571612  1.8605432  -4.8571612   0.16054320      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6900 -39150   6800 
#> initial  value 998.131940 
#> iter   2 value 808.056514
#> iter   3 value 797.396430
#> iter   4 value 796.824326
#> iter   5 value 761.404299
#> iter   6 value 752.761342
#> iter   7 value 751.337283
#> iter   8 value 751.304138
#> iter   9 value 751.304071
#> iter  10 value 751.304056
#> iter  10 value 751.304046
#> iter  10 value 751.304039
#> final  value 751.304039 
#> converged
#> This is Run number  83 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5597245 -1.0562157  -1.109724 -13.6562157      1
#> 2     1  -0.95  -2.35  2.2426874  1.4630482   1.292687  -0.8869518      1
#> 3     1  -6.20  -2.30 -0.1302133  1.6207747  -6.330213  -0.6792253      2
#> 4     1 -13.90  -2.55  2.7377421  0.7494584 -11.162258  -1.8005416      2
#> 5     1 -14.40  -5.80 -0.6496455 -0.6952994 -15.049646  -6.4952994      2
#> 6     1  -3.60  -1.70 -0.4470218  0.6057720  -4.047022  -1.0942280      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -38400   7275 
#> initial  value 998.131940 
#> iter   2 value 816.973242
#> iter   3 value 804.458518
#> iter   4 value 803.292750
#> iter   5 value 765.943703
#> iter   6 value 757.464569
#> iter   7 value 756.138870
#> iter   8 value 756.112181
#> iter   9 value 756.112140
#> iter  10 value 756.112128
#> iter  10 value 756.112118
#> iter  10 value 756.112112
#> final  value 756.112112 
#> converged
#> This is Run number  84 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.00565409  1.4715000  -0.5556541 -11.1285000      1
#> 2     1  -0.95  -2.35 -0.86209904 -0.8104365  -1.8120990  -3.1604365      1
#> 3     1  -6.20  -2.30 -1.23565575  0.4038228  -7.4356557  -1.8961772      2
#> 4     1 -13.90  -2.55 -0.13403324  4.4855720 -14.0340332   1.9355720      2
#> 5     1 -14.40  -5.80  0.02812253  2.0297037 -14.3718775  -3.7702963      2
#> 6     1  -3.60  -1.70 -0.09737891  2.2596579  -3.6973789   0.5596579      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -39675   6475 
#> initial  value 998.131940 
#> iter   2 value 802.092574
#> iter   3 value 790.123337
#> iter   4 value 788.155126
#> iter   5 value 754.686635
#> iter   6 value 745.975887
#> iter   7 value 744.577068
#> iter   8 value 744.543447
#> iter   9 value 744.543383
#> iter   9 value 744.543373
#> iter   9 value 744.543366
#> final  value 744.543366 
#> converged
#> This is Run number  85 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.23782935  1.22338909  -0.7878293 -11.3766109      1
#> 2     1  -0.95  -2.35 -0.89027730  0.14954986  -1.8402773  -2.2004501      1
#> 3     1  -6.20  -2.30  0.01225359  2.07308943  -6.1877464  -0.2269106      2
#> 4     1 -13.90  -2.55 -0.56036504 -0.07918101 -14.4603650  -2.6291810      2
#> 5     1 -14.40  -5.80 -0.50471200 -1.03424789 -14.9047120  -6.8342479      2
#> 6     1  -3.60  -1.70  1.39182076  4.74249936  -2.2081792   3.0424994      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -39125   5950 
#> initial  value 998.131940 
#> iter   2 value 813.102193
#> iter   3 value 802.363339
#> iter   4 value 799.959552
#> iter   5 value 764.939601
#> iter   6 value 756.303575
#> iter   7 value 754.747740
#> iter   8 value 754.708418
#> iter   9 value 754.708319
#> iter  10 value 754.708306
#> iter  10 value 754.708306
#> iter  10 value 754.708301
#> final  value 754.708301 
#> converged
#> This is Run number  86 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1           e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.71164782 -0.0003000682  -1.2616478 -12.600300      1
#> 2     1  -0.95  -2.35  0.02092574  1.2677891730  -0.9290743  -1.082211      1
#> 3     1  -6.20  -2.30  0.07405645 -0.9306325511  -6.1259435  -3.230633      2
#> 4     1 -13.90  -2.55 -0.46904329  0.5459137931 -14.3690433  -2.004086      2
#> 5     1 -14.40  -5.80  0.26722338 -0.1514355147 -14.1327766  -5.951436      2
#> 6     1  -3.60  -1.70 -0.10558449  0.0898571504  -3.7055845  -1.610143      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5500 -37025   8075 
#> initial  value 998.131940 
#> iter   2 value 831.429429
#> iter   3 value 817.182107
#> iter   4 value 815.542847
#> iter   5 value 774.386792
#> iter   6 value 766.259396
#> iter   7 value 765.033427
#> iter   8 value 765.014414
#> iter   8 value 765.014405
#> final  value 765.014405 
#> converged
#> This is Run number  87 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7188451  0.2618778  -1.268845 -12.3381222      1
#> 2     1  -0.95  -2.35  2.2075609  1.6493675   1.257561  -0.7006325      1
#> 3     1  -6.20  -2.30 -0.8432090  2.0008099  -7.043209  -0.2991901      2
#> 4     1 -13.90  -2.55 -0.6457151  0.1147588 -14.545715  -2.4352412      2
#> 5     1 -14.40  -5.80  0.9222172  3.6196986 -13.477783  -2.1803014      2
#> 6     1  -3.60  -1.70 -1.2049979 -0.9766591  -4.804998  -2.6766591      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -39850   7650 
#> initial  value 998.131940 
#> iter   2 value 793.110813
#> iter   3 value 775.933356
#> iter   4 value 773.456835
#> iter   5 value 740.961570
#> iter   6 value 732.397012
#> iter   7 value 731.258090
#> iter   8 value 731.237662
#> iter   8 value 731.237660
#> final  value 731.237660 
#> converged
#> This is Run number  88 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.744638159  1.03020721   1.194638 -11.569793      1
#> 2     1  -0.95  -2.35 -0.793194933 -1.07851091  -1.743195  -3.428511      1
#> 3     1  -6.20  -2.30 -0.007010485  0.61980791  -6.207010  -1.680192      2
#> 4     1 -13.90  -2.55  1.177290376  0.86976812 -12.722710  -1.680232      2
#> 5     1 -14.40  -5.80 -1.132210133  0.72612006 -15.532210  -5.073880      2
#> 6     1  -3.60  -1.70 -0.072517801 -0.06271019  -3.672518  -1.762710      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -38175   6300 
#> initial  value 998.131940 
#> iter   2 value 825.198873
#> iter   3 value 816.019724
#> iter   4 value 814.950279
#> iter   5 value 776.785208
#> iter   6 value 768.364234
#> iter   7 value 766.812165
#> iter   8 value 766.776137
#> iter   9 value 766.776054
#> iter   9 value 766.776054
#> iter   9 value 766.776054
#> final  value 766.776054 
#> converged
#> This is Run number  89 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.4232817  2.07696403   0.8732817 -10.523036      1
#> 2     1  -0.95  -2.35  2.7080865  0.94286474   1.7580865  -1.407135      1
#> 3     1  -6.20  -2.30  3.0254708  0.89297547  -3.1745292  -1.407025      2
#> 4     1 -13.90  -2.55 -1.0799164  0.61342594 -14.9799164  -1.936574      2
#> 5     1 -14.40  -5.80  0.8685468  0.70204311 -13.5314532  -5.097957      2
#> 6     1  -3.60  -1.70 -0.2552806 -0.03218343  -3.8552806  -1.732183      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -39800   6050 
#> initial  value 998.131940 
#> iter   2 value 802.352330
#> iter   3 value 790.135954
#> iter   4 value 787.157110
#> iter   5 value 754.310293
#> iter   6 value 745.562416
#> iter   7 value 744.107272
#> iter   8 value 744.070061
#> iter   9 value 744.069972
#> iter   9 value 744.069962
#> iter   9 value 744.069955
#> final  value 744.069955 
#> converged
#> This is Run number  90 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.44094030 -0.32883801  -0.9909403 -12.928838      1
#> 2     1  -0.95  -2.35  0.87180930  0.39872858  -0.0781907  -1.951271      1
#> 3     1  -6.20  -2.30  0.53070026 -0.31913791  -5.6692997  -2.619138      2
#> 4     1 -13.90  -2.55  1.50135707 -0.31045543 -12.3986429  -2.860455      2
#> 5     1 -14.40  -5.80 -0.06862105 -0.07179713 -14.4686210  -5.871797      2
#> 6     1  -3.60  -1.70  0.23052304  5.12983842  -3.3694770   3.429838      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -37325   7500 
#> initial  value 998.131940 
#> iter   2 value 830.755377
#> iter   3 value 819.355764
#> iter   4 value 818.675097
#> iter   5 value 778.120094
#> iter   6 value 769.875666
#> iter   7 value 768.553430
#> iter   8 value 768.528831
#> iter   9 value 768.528793
#> iter  10 value 768.528780
#> iter  10 value 768.528771
#> iter  10 value 768.528764
#> final  value 768.528764 
#> converged
#> This is Run number  91 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8172137  2.77756144   0.2672137 -9.8224386      1
#> 2     1  -0.95  -2.35  4.8469756  0.09810341   3.8969756 -2.2518966      1
#> 3     1  -6.20  -2.30  0.4007139  0.84027400  -5.7992861 -1.4597260      2
#> 4     1 -13.90  -2.55 -0.1725408  1.84094520 -14.0725408 -0.7090548      2
#> 5     1 -14.40  -5.80  0.8811397  2.08972692 -13.5188603 -3.7102731      2
#> 6     1  -3.60  -1.70  0.1976318 -1.13201925  -3.4023682 -2.8320192      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6400 -37850   6275 
#> initial  value 998.131940 
#> iter   2 value 830.048550
#> iter   3 value 820.774742
#> iter   4 value 819.462971
#> iter   5 value 780.467786
#> iter   6 value 772.128770
#> iter   7 value 770.585173
#> iter   8 value 770.550348
#> iter   9 value 770.550270
#> iter   9 value 770.550270
#> iter   9 value 770.550270
#> final  value 770.550270 
#> converged
#> This is Run number  92 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.3782552  0.5277570  -0.9282552 -12.0722430      1
#> 2     1  -0.95  -2.35  0.3848940  1.7450431  -0.5651060  -0.6049569      1
#> 3     1  -6.20  -2.30  1.2760597  0.1427823  -4.9239403  -2.1572177      2
#> 4     1 -13.90  -2.55  0.2774260 -0.8705159 -13.6225740  -3.4205159      2
#> 5     1 -14.40  -5.80 -0.6837159  0.7658291 -15.0837159  -5.0341709      2
#> 6     1  -3.60  -1.70 -0.5557368  1.8227113  -4.1557368   0.1227113      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -40900   8025 
#> initial  value 998.131940 
#> iter   2 value 773.525140
#> iter   3 value 755.780727
#> iter   4 value 754.784495
#> iter   5 value 725.218662
#> iter   6 value 716.705448
#> iter   7 value 715.693984
#> iter   8 value 715.678378
#> iter   9 value 715.678363
#> iter   9 value 715.678358
#> iter   9 value 715.678358
#> final  value 715.678358 
#> converged
#> This is Run number  93 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.42406469 -0.45506422  -0.1259353 -13.0550642      1
#> 2     1  -0.95  -2.35  0.26999715  1.10979980  -0.6800028  -1.2402002      1
#> 3     1  -6.20  -2.30 -0.53698555 -1.93636105  -6.7369856  -4.2363611      2
#> 4     1 -13.90  -2.55  0.42871830  0.02752338 -13.4712817  -2.5224766      2
#> 5     1 -14.40  -5.80  0.02837421  0.17888129 -14.3716258  -5.6211187      2
#> 6     1  -3.60  -1.70  3.16162656  0.87174521  -0.4383734  -0.8282548      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7340 -40575   5175 
#> initial  value 998.131940 
#> iter   2 value 793.018991
#> iter   3 value 784.664339
#> iter   4 value 782.695933
#> iter   5 value 751.848644
#> iter   6 value 743.072806
#> iter   7 value 741.320183
#> iter   8 value 741.265254
#> iter   9 value 741.265030
#> iter  10 value 741.265009
#> iter  10 value 741.265009
#> iter  11 value 741.264996
#> iter  11 value 741.264993
#> iter  11 value 741.264990
#> final  value 741.264990 
#> converged
#> This is Run number  94 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7860526  0.2175871   0.2360526 -12.382413      1
#> 2     1  -0.95  -2.35  1.4269285 -0.3319648   0.4769285  -2.681965      1
#> 3     1  -6.20  -2.30  1.6028516 -0.7671012  -4.5971484  -3.067101      2
#> 4     1 -13.90  -2.55 -0.5500101 -0.6169612 -14.4500101  -3.166961      2
#> 5     1 -14.40  -5.80  0.6854648 -0.7490042 -13.7145352  -6.549004      2
#> 6     1  -3.60  -1.70 -1.0744341  0.6171008  -4.6744341  -1.082899      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7040 -37875   6500 
#> initial  value 998.131940 
#> iter   2 value 827.873844
#> iter   3 value 819.910406
#> iter   4 value 819.823583
#> iter   5 value 780.536525
#> iter   6 value 772.212288
#> iter   7 value 770.626266
#> iter   8 value 770.589427
#> iter   9 value 770.589330
#> iter  10 value 770.589313
#> iter  10 value 770.589304
#> iter  10 value 770.589297
#> final  value 770.589297 
#> converged
#> This is Run number  95 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.52030281 -1.0448761  -1.0703028 -13.644876      1
#> 2     1  -0.95  -2.35  0.50106016  0.1937960  -0.4489398  -2.156204      1
#> 3     1  -6.20  -2.30  1.13885214  5.1724104  -5.0611479   2.872410      2
#> 4     1 -13.90  -2.55  0.07858258  0.4218970 -13.8214174  -2.128103      2
#> 5     1 -14.40  -5.80  2.27074668 -0.1716853 -12.1292533  -5.971685      2
#> 6     1  -3.60  -1.70 -1.19075772 -0.2243023  -4.7907577  -1.924302      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5840 -37925   6300 
#> initial  value 998.131940 
#> iter   2 value 829.153988
#> iter   3 value 816.959339
#> iter   4 value 813.984339
#> iter   5 value 775.667894
#> iter   6 value 767.263657
#> iter   7 value 765.802217
#> iter   8 value 765.770403
#> iter   9 value 765.770341
#> iter   9 value 765.770331
#> iter   9 value 765.770326
#> final  value 765.770326 
#> converged
#> This is Run number  96 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4619269  0.1830388  -0.08807309 -12.416961      1
#> 2     1  -0.95  -2.35 -1.1055677  1.2947104  -2.05556768  -1.055290      2
#> 3     1  -6.20  -2.30 -0.9920002  0.7381641  -7.19200015  -1.561836      2
#> 4     1 -13.90  -2.55  1.2400074 -1.8832944 -12.65999258  -4.433294      2
#> 5     1 -14.40  -5.80 -0.8096838  1.3550804 -15.20968378  -4.444920      2
#> 6     1  -3.60  -1.70  1.3494219  4.5936374  -2.25057807   2.893637      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5540 -36625   7350 
#> initial  value 998.131940 
#> iter   2 value 841.160825
#> iter   3 value 829.191831
#> iter   4 value 827.394110
#> iter   5 value 785.186479
#> iter   6 value 777.164053
#> iter   7 value 775.854991
#> iter   8 value 775.831950
#> iter   9 value 775.831919
#> iter   9 value 775.831908
#> iter   9 value 775.831903
#> final  value 775.831903 
#> converged
#> This is Run number  97 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.001834528  0.1211372  -0.5481655 -12.47886279      1
#> 2     1  -0.95  -2.35 -0.364888939  1.0070213  -1.3148889  -1.34297872      1
#> 3     1  -6.20  -2.30 -1.023418534  2.2813831  -7.2234185  -0.01861692      2
#> 4     1 -13.90  -2.55  0.084338947 -0.5288091 -13.8156611  -3.07880910      2
#> 5     1 -14.40  -5.80  1.765133967 -1.6300936 -12.6348660  -7.43009358      2
#> 6     1  -3.60  -1.70  0.401290546  1.9348229  -3.1987095   0.23482287      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -37975   6400 
#> initial  value 998.131940 
#> iter   2 value 827.830640
#> iter   3 value 817.119439
#> iter   4 value 815.163047
#> iter   5 value 776.729990
#> iter   6 value 768.343618
#> iter   7 value 766.859410
#> iter   8 value 766.826619
#> iter   9 value 766.826554
#> iter   9 value 766.826543
#> iter   9 value 766.826537
#> final  value 766.826537 
#> converged
#> This is Run number  98 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2214239  0.23385145  -0.7714239 -12.3661486      1
#> 2     1  -0.95  -2.35  0.1485121  2.05537818  -0.8014879  -0.2946218      2
#> 3     1  -6.20  -2.30 -0.5975881 -0.08669776  -6.7975881  -2.3866978      2
#> 4     1 -13.90  -2.55 -0.5028826  0.77572753 -14.4028826  -1.7742725      2
#> 5     1 -14.40  -5.80 -1.0752891 -0.56008177 -15.4752891  -6.3600818      2
#> 6     1  -3.60  -1.70  1.7581633 -0.53301247  -1.8418367  -2.2330125      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -39125   7225 
#> initial  value 998.131940 
#> iter   2 value 806.211272
#> iter   3 value 794.130963
#> iter   4 value 793.577324
#> iter   5 value 758.186887
#> iter   6 value 749.557951
#> iter   7 value 748.233117
#> iter   8 value 748.204899
#> iter   9 value 748.204853
#> iter  10 value 748.204839
#> iter  10 value 748.204830
#> iter  10 value 748.204822
#> final  value 748.204822 
#> converged
#> This is Run number  99 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.06519970 0.2946808   0.5151997 -12.3053192      1
#> 2     1  -0.95  -2.35  0.36221651 0.2169767  -0.5877835  -2.1330233      1
#> 3     1  -6.20  -2.30 -0.15168121 2.4710551  -6.3516812   0.1710551      2
#> 4     1 -13.90  -2.55  2.97693647 1.4339706 -10.9230635  -1.1160294      2
#> 5     1 -14.40  -5.80  0.00316157 0.9153798 -14.3968384  -4.8846202      2
#> 6     1  -3.60  -1.70  1.30588506 1.3028120  -2.2941149  -0.3971880      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5540 -37725   7425 
#> initial  value 998.131940 
#> iter   2 value 825.897094
#> iter   3 value 811.151912
#> iter   4 value 808.437890
#> iter   5 value 769.592293
#> iter   6 value 761.286919
#> iter   7 value 760.005446
#> iter   8 value 759.982305
#> iter   9 value 759.982279
#> iter   9 value 759.982270
#> iter   9 value 759.982265
#> final  value 759.982265 
#> converged
#> This is Run number  100 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2           U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5424929  0.8393994  -0.007507102 -11.760601      1
#> 2     1  -0.95  -2.35  1.3364321 -0.5358660   0.386432058  -2.885866      1
#> 3     1  -6.20  -2.30  3.2140910 -0.3558320  -2.985909045  -2.655832      2
#> 4     1 -13.90  -2.55 -1.1102428  1.6823350 -15.010242773  -0.867665      2
#> 5     1 -14.40  -5.80 -0.8430685  1.5801660 -15.243068486  -4.219834      2
#> 6     1  -3.60  -1.70 -0.3074278  0.3142555  -3.907427819  -1.385744      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -37450   6825 
#> initial  value 998.131940 
#> iter   2 value 833.021894
#> iter   3 value 821.415000
#> iter   4 value 819.414169
#> iter   5 value 779.545122
#> iter   6 value 771.290314
#> iter   7 value 769.895365
#> iter   8 value 769.867357
#> iter   9 value 769.867311
#> iter   9 value 769.867300
#> iter   9 value 769.867295
#> final  value 769.867295 
#> converged
#> This is Run number  101 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4177567  1.1234849  -0.9677567 -11.476515      1
#> 2     1  -0.95  -2.35 -0.8108214  0.2932045  -1.7608214  -2.056796      1
#> 3     1  -6.20  -2.30 -0.7437990  1.1748935  -6.9437990  -1.125107      2
#> 4     1 -13.90  -2.55 -0.2841491 -0.5240037 -14.1841491  -3.074004      2
#> 5     1 -14.40  -5.80  2.0962448  1.6465735 -12.3037552  -4.153427      2
#> 6     1  -3.60  -1.70  0.5646285  0.9756100  -3.0353715  -0.724390      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -40125   7000 
#> initial  value 998.131940 
#> iter   2 value 792.574507
#> iter   3 value 776.314691
#> iter   4 value 772.897455
#> iter   5 value 741.332557
#> iter   6 value 732.660217
#> iter   7 value 731.467736
#> iter   8 value 731.442932
#> iter   9 value 731.442906
#> iter   9 value 731.442900
#> iter   9 value 731.442896
#> final  value 731.442896 
#> converged
#> This is Run number  102 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1628389 -1.1173058  -0.3871611 -13.717306      1
#> 2     1  -0.95  -2.35  0.4535009  1.3115566  -0.4964991  -1.038443      1
#> 3     1  -6.20  -2.30  1.8628134 -0.1766261  -4.3371866  -2.476626      2
#> 4     1 -13.90  -2.55 -0.3649576  0.4817129 -14.2649576  -2.068287      2
#> 5     1 -14.40  -5.80  2.8226493 -0.7196365 -11.5773507  -6.519637      2
#> 6     1  -3.60  -1.70  0.9927357  0.1253296  -2.6072643  -1.574670      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5440 -37450   8125 
#> initial  value 998.131940 
#> iter   2 value 825.356584
#> iter   3 value 809.639500
#> iter   4 value 807.503829
#> iter   5 value 767.735343
#> iter   6 value 759.529343
#> iter   7 value 758.317293
#> iter   8 value 758.298615
#> iter   9 value 758.298600
#> iter   9 value 758.298598
#> iter  10 value 758.298587
#> iter  10 value 758.298579
#> iter  10 value 758.298579
#> final  value 758.298579 
#> converged
#> This is Run number  103 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.07796849  1.3753498  -0.4720315 -11.224650      1
#> 2     1  -0.95  -2.35 -0.06360688  0.9425686  -1.0136069  -1.407431      1
#> 3     1  -6.20  -2.30  0.08685488 -0.6554985  -6.1131451  -2.955499      2
#> 4     1 -13.90  -2.55 -0.66296248  1.3728537 -14.5629625  -1.177146      2
#> 5     1 -14.40  -5.80  1.67964597  2.4150648 -12.7203540  -3.384935      2
#> 6     1  -3.60  -1.70  0.09866260  0.5150201  -3.5013374  -1.184980      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7180 -40400   6400 
#> initial  value 998.131940 
#> iter   2 value 790.484082
#> iter   3 value 779.725808
#> iter   4 value 778.723689
#> iter   5 value 747.099805
#> iter   6 value 738.300139
#> iter   7 value 736.900041
#> iter   8 value 736.864265
#> iter   9 value 736.864191
#> iter  10 value 736.864179
#> iter  10 value 736.864173
#> iter  10 value 736.864166
#> final  value 736.864166 
#> converged
#> This is Run number  104 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.5828111 -0.53231778   1.032811 -13.132318      1
#> 2     1  -0.95  -2.35 -0.2370028  0.52920908  -1.187003  -1.820791      1
#> 3     1  -6.20  -2.30  0.5973776  3.61496297  -5.602622   1.314963      2
#> 4     1 -13.90  -2.55 -0.1884095 -0.31090653 -14.088409  -2.860907      2
#> 5     1 -14.40  -5.80  1.1612007 -0.06128768 -13.238799  -5.861288      2
#> 6     1  -3.60  -1.70  0.6454892 -0.80832087  -2.954511  -2.508321      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5620 -38275   7525 
#> initial  value 998.131940 
#> iter   2 value 817.536131
#> iter   3 value 801.675184
#> iter   4 value 798.781680
#> iter   5 value 761.613672
#> iter   6 value 753.209023
#> iter   7 value 751.960521
#> iter   8 value 751.938043
#> iter   9 value 751.938021
#> iter   9 value 751.938013
#> iter   9 value 751.938008
#> final  value 751.938008 
#> converged
#> This is Run number  105 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.40524442 -0.5430965   0.8552444 -13.143097      1
#> 2     1  -0.95  -2.35  0.06301837 -0.4978175  -0.8869816  -2.847817      1
#> 3     1  -6.20  -2.30 -0.27339252 -0.8589458  -6.4733925  -3.158946      2
#> 4     1 -13.90  -2.55  0.40597044 -0.3665527 -13.4940296  -2.916553      2
#> 5     1 -14.40  -5.80  0.99030336 -1.0762871 -13.4096966  -6.876287      2
#> 6     1  -3.60  -1.70  0.14650550 -0.7617994  -3.4534945  -2.461799      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6960 -40425   5050 
#> initial  value 998.131940 
#> iter   2 value 796.402308
#> iter   3 value 786.462839
#> iter   4 value 783.330902
#> iter   5 value 752.354794
#> iter   6 value 743.546725
#> iter   7 value 741.822076
#> iter   8 value 741.766938
#> iter   9 value 741.766669
#> iter  10 value 741.766643
#> iter  10 value 741.766642
#> iter  11 value 741.766625
#> iter  11 value 741.766619
#> iter  11 value 741.766616
#> final  value 741.766616 
#> converged
#> This is Run number  106 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.3706653 -0.6501890  -0.1793347 -13.25018899      1
#> 2     1  -0.95  -2.35 -0.1868625  2.7003048  -1.1368625   0.35030479      2
#> 3     1  -6.20  -2.30  2.2690864  4.4052166  -3.9309136   2.10521657      2
#> 4     1 -13.90  -2.55  4.6366917  2.5933194  -9.2633083   0.04331944      2
#> 5     1 -14.40  -5.80 -0.2063270  0.5632061 -14.6063270  -5.23679388      2
#> 6     1  -3.60  -1.70  0.1576100 -0.2597351  -3.4423900  -1.95973514      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5960 -38625   7950 
#> initial  value 998.131940 
#> iter   2 value 809.775970
#> iter   3 value 793.933928
#> iter   4 value 792.285217
#> iter   5 value 755.875833
#> iter   6 value 747.431923
#> iter   7 value 746.237832
#> iter   8 value 746.217828
#> iter   9 value 746.217812
#> iter   9 value 746.217809
#> iter  10 value 746.217797
#> iter  10 value 746.217788
#> iter  10 value 746.217786
#> final  value 746.217786 
#> converged
#> This is Run number  107 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.4762951 -0.6836320   0.9262951 -13.2836320      1
#> 2     1  -0.95  -2.35 -0.4807399  1.0827014  -1.4307399  -1.2672986      2
#> 3     1  -6.20  -2.30  0.6813360  1.5812004  -5.5186640  -0.7187996      2
#> 4     1 -13.90  -2.55  1.7734735  2.1870237 -12.1265265  -0.3629763      2
#> 5     1 -14.40  -5.80 -0.9053541  0.3587707 -15.3053541  -5.4412293      2
#> 6     1  -3.60  -1.70  1.4485602  4.7696816  -2.1514398   3.0696816      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -38575   7450 
#> initial  value 998.131940 
#> iter   2 value 813.171740
#> iter   3 value 800.922688
#> iter   4 value 800.432948
#> iter   5 value 763.447755
#> iter   6 value 754.915769
#> iter   7 value 753.606315
#> iter   8 value 753.580189
#> iter   9 value 753.580148
#> iter  10 value 753.580135
#> iter  10 value 753.580126
#> iter  10 value 753.580118
#> final  value 753.580118 
#> converged
#> This is Run number  108 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 1.2464269  2.4212451   0.6964269 -10.178755      1
#> 2     1  -0.95  -2.35 4.4072346 -1.4690220   3.4572346  -3.819022      1
#> 3     1  -6.20  -2.30 1.2752983  0.6047428  -4.9247017  -1.695257      2
#> 4     1 -13.90  -2.55 1.0704427 -0.1757256 -12.8295573  -2.725726      2
#> 5     1 -14.40  -5.80 1.0463270 -0.1008591 -13.3536730  -5.900859      2
#> 6     1  -3.60  -1.70 0.2063991  7.3843605  -3.3936009   5.684360      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -39800   6925 
#> initial  value 998.131940 
#> iter   2 value 797.959726
#> iter   3 value 783.718605
#> iter   4 value 781.325700
#> iter   5 value 748.458307
#> iter   6 value 739.776260
#> iter   7 value 738.507520
#> iter   8 value 738.479953
#> iter   9 value 738.479915
#> iter   9 value 738.479907
#> iter   9 value 738.479901
#> final  value 738.479901 
#> converged
#> This is Run number  109 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.39172647 -0.05203641  -0.1582735 -12.6520364      1
#> 2     1  -0.95  -2.35  0.35006235  0.18508616  -0.5999376  -2.1649138      1
#> 3     1  -6.20  -2.30 -0.10029407  2.41787591  -6.3002941   0.1178759      2
#> 4     1 -13.90  -2.55  1.26744572  3.91574939 -12.6325543   1.3657494      2
#> 5     1 -14.40  -5.80 -1.26637011 -0.98797537 -15.6663701  -6.7879754      2
#> 6     1  -3.60  -1.70  0.03827256  1.82511702  -3.5617274   0.1251170      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6040 -39400   6775 
#> initial  value 998.131940 
#> iter   2 value 805.087619
#> iter   3 value 790.091283
#> iter   4 value 786.704589
#> iter   5 value 752.878187
#> iter   6 value 744.227483
#> iter   7 value 742.932781
#> iter   8 value 742.904817
#> iter   9 value 742.904778
#> iter   9 value 742.904770
#> iter   9 value 742.904766
#> final  value 742.904766 
#> converged
#> This is Run number  110 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0910901  0.90853720  -1.6410901 -11.6914628      1
#> 2     1  -0.95  -2.35  1.3017514 -1.00060731   0.3517514  -3.3506073      1
#> 3     1  -6.20  -2.30  1.2648228 -0.05677941  -4.9351772  -2.3567794      2
#> 4     1 -13.90  -2.55  0.3140348  1.90530349 -13.5859652  -0.6446965      2
#> 5     1 -14.40  -5.80  0.2810206  0.57483531 -14.1189794  -5.2251647      2
#> 6     1  -3.60  -1.70  0.7601856  0.34027990  -2.8398144  -1.3597201      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5940 -38125   6575 
#> initial  value 998.131940 
#> iter   2 value 824.912812
#> iter   3 value 812.553499
#> iter   4 value 809.950878
#> iter   5 value 772.140296
#> iter   6 value 763.706414
#> iter   7 value 762.287589
#> iter   8 value 762.257174
#> iter   9 value 762.257121
#> iter   9 value 762.257111
#> iter   9 value 762.257106
#> final  value 762.257106 
#> converged
#> This is Run number  111 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.8058212 0.5478766  -2.35582117 -12.052123      1
#> 2     1  -0.95  -2.35  0.8956382 3.9970831  -0.05436175   1.647083      2
#> 3     1  -6.20  -2.30 -1.0416625 1.2273396  -7.24166246  -1.072660      2
#> 4     1 -13.90  -2.55  1.2373552 0.3883678 -12.66264480  -2.161632      2
#> 5     1 -14.40  -5.80  2.2001644 1.0020730 -12.19983560  -4.797927      2
#> 6     1  -3.60  -1.70  0.3534812 0.4687166  -3.24651883  -1.231283      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -39400   6700 
#> initial  value 998.131940 
#> iter   2 value 805.065551
#> iter   3 value 793.444220
#> iter   4 value 792.117019
#> iter   5 value 757.657785
#> iter   6 value 748.986708
#> iter   7 value 747.595235
#> iter   8 value 747.562878
#> iter   9 value 747.562819
#> iter  10 value 747.562807
#> iter  10 value 747.562799
#> iter  10 value 747.562793
#> final  value 747.562793 
#> converged
#> This is Run number  112 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.3826689 -1.24161744   0.8326689 -13.8416174      1
#> 2     1  -0.95  -2.35  0.3772576  3.33768768  -0.5727424   0.9876877      2
#> 3     1  -6.20  -2.30  0.2983948 -0.67344002  -5.9016052  -2.9734400      2
#> 4     1 -13.90  -2.55 -0.0890675  3.88421060 -13.9890675   1.3342106      2
#> 5     1 -14.40  -5.80  3.0158876 -0.62171061 -11.3841124  -6.4217106      2
#> 6     1  -3.60  -1.70  0.9935424 -0.08074774  -2.6064576  -1.7807477      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -39875   7375 
#> initial  value 998.131940 
#> iter   2 value 794.308919
#> iter   3 value 778.338280
#> iter   4 value 775.959628
#> iter   5 value 743.431949
#> iter   6 value 734.810346
#> iter   7 value 733.630021
#> iter   8 value 733.607087
#> iter   9 value 733.607066
#> iter   9 value 733.607059
#> iter   9 value 733.607058
#> final  value 733.607058 
#> converged
#> This is Run number  113 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 0.3519052 -0.22087558  -0.1980948 -12.8208756      1
#> 2     1  -0.95  -2.35 1.2378199 -0.07860796   0.2878199  -2.4286080      1
#> 3     1  -6.20  -2.30 0.4250086  2.64291920  -5.7749914   0.3429192      2
#> 4     1 -13.90  -2.55 0.6505979 -0.56735223 -13.2494021  -3.1173522      2
#> 5     1 -14.40  -5.80 0.8804580 -0.51777450 -13.5195420  -6.3177745      2
#> 6     1  -3.60  -1.70 0.2589436 -0.02692288  -3.3410564  -1.7269229      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -39150   6775 
#> initial  value 998.131940 
#> iter   2 value 808.487918
#> iter   3 value 796.925104
#> iter   4 value 795.689517
#> iter   5 value 760.472944
#> iter   6 value 751.841719
#> iter   7 value 750.448134
#> iter   8 value 750.416367
#> iter   9 value 750.416309
#> iter  10 value 750.416297
#> iter  10 value 750.416288
#> iter  10 value 750.416282
#> final  value 750.416282 
#> converged
#> This is Run number  114 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.603536490  4.4812340  -1.1535365 -8.11876598      1
#> 2     1  -0.95  -2.35  1.290789430  2.2773126   0.3407894 -0.07268735      1
#> 3     1  -6.20  -2.30  0.003402257  5.9140531  -6.1965977  3.61405310      2
#> 4     1 -13.90  -2.55  2.397009249  0.9084427 -11.5029908 -1.64155726      2
#> 5     1 -14.40  -5.80  0.742565603 -0.4794452 -13.6574344 -6.27944515      2
#> 6     1  -3.60  -1.70  1.486062314 -0.2661207  -2.1139377 -1.96612070      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -37400   6925 
#> initial  value 998.131940 
#> iter   2 value 832.765736
#> iter   3 value 823.424745
#> iter   4 value 823.020686
#> iter   5 value 782.559148
#> iter   6 value 774.309776
#> iter   7 value 772.861929
#> iter   8 value 772.831602
#> iter   9 value 772.831539
#> iter  10 value 772.831523
#> iter  10 value 772.831513
#> iter  10 value 772.831508
#> final  value 772.831508 
#> converged
#> This is Run number  115 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5331682 1.3911256  -0.0168318 -11.208874      1
#> 2     1  -0.95  -2.35 -1.3483805 1.1460807  -2.2983805  -1.203919      2
#> 3     1  -6.20  -2.30 -0.6134916 0.0323085  -6.8134916  -2.267692      2
#> 4     1 -13.90  -2.55  1.9731837 1.1929599 -11.9268163  -1.357040      2
#> 5     1 -14.40  -5.80 -0.1644487 3.4581791 -14.5644487  -2.341821      2
#> 6     1  -3.60  -1.70  1.6290556 0.4892958  -1.9709444  -1.210704      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -37250   6025 
#> initial  value 998.131940 
#> iter   2 value 839.546954
#> iter   3 value 831.298995
#> iter   4 value 830.002911
#> iter   5 value 789.364037
#> iter   6 value 781.212880
#> iter   7 value 779.624756
#> iter   8 value 779.589912
#> iter   9 value 779.589831
#> iter   9 value 779.589820
#> iter   9 value 779.589816
#> final  value 779.589816 
#> converged
#> This is Run number  116 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.06747118 -1.0469348  -0.4825288 -13.646935      1
#> 2     1  -0.95  -2.35  2.01765020  0.5799595   1.0676502  -1.770041      1
#> 3     1  -6.20  -2.30 -0.75327868  1.0381586  -6.9532787  -1.261841      2
#> 4     1 -13.90  -2.55  0.66372100  1.4667980 -13.2362790  -1.083202      2
#> 5     1 -14.40  -5.80  1.91002904  3.0442269 -12.4899710  -2.755773      2
#> 6     1  -3.60  -1.70  1.64466850 -0.5971875  -1.9553315  -2.297188      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -38775   6900 
#> initial  value 998.131940 
#> iter   2 value 813.306633
#> iter   3 value 802.338936
#> iter   4 value 801.590755
#> iter   5 value 765.141387
#> iter   6 value 756.570232
#> iter   7 value 755.161933
#> iter   8 value 755.130457
#> iter   9 value 755.130397
#> iter  10 value 755.130382
#> iter  10 value 755.130372
#> iter  10 value 755.130365
#> final  value 755.130365 
#> converged
#> This is Run number  117 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.4045822  0.4387684   0.8545822 -12.161232      1
#> 2     1  -0.95  -2.35  1.3983074  3.4322257   0.4483074   1.082226      2
#> 3     1  -6.20  -2.30 -1.3395984  0.9512213  -7.5395984  -1.348779      2
#> 4     1 -13.90  -2.55 -0.4738667 -0.5406114 -14.3738667  -3.090611      2
#> 5     1 -14.40  -5.80 -0.6829639  2.0351891 -15.0829639  -3.764811      2
#> 6     1  -3.60  -1.70  1.6339875  3.2106441  -1.9660125   1.510644      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7100 -39175   6575 
#> initial  value 998.131940 
#> iter   2 value 808.623354
#> iter   3 value 799.000421
#> iter   4 value 798.628478
#> iter   5 value 763.169641
#> iter   6 value 754.523404
#> iter   7 value 753.024454
#> iter   8 value 752.987845
#> iter   9 value 752.987760
#> iter  10 value 752.987743
#> iter  10 value 752.987734
#> iter  10 value 752.987727
#> final  value 752.987727 
#> converged
#> This is Run number  118 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6235698 -0.1444569  -1.1735698 -12.744457      1
#> 2     1  -0.95  -2.35  0.5702282 -0.8272312  -0.3797718  -3.177231      1
#> 3     1  -6.20  -2.30 -0.7591878  4.6361855  -6.9591878   2.336186      2
#> 4     1 -13.90  -2.55 -0.1806253  0.7253241 -14.0806253  -1.824676      2
#> 5     1 -14.40  -5.80 -0.2472027  2.1010108 -14.6472027  -3.698989      2
#> 6     1  -3.60  -1.70 -0.7508465 -0.4454714  -4.3508465  -2.145471      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -38475   7200 
#> initial  value 998.131940 
#> iter   2 value 816.471785
#> iter   3 value 802.714777
#> iter   4 value 800.600099
#> iter   5 value 763.746666
#> iter   6 value 755.268351
#> iter   7 value 753.960391
#> iter   8 value 753.934366
#> iter   9 value 753.934331
#> iter   9 value 753.934320
#> iter   9 value 753.934315
#> final  value 753.934315 
#> converged
#> This is Run number  119 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.73532364  0.5536026   0.1853236 -12.0463974      1
#> 2     1  -0.95  -2.35  1.06250084 -0.8391651   0.1125008  -3.1891651      1
#> 3     1  -6.20  -2.30  0.13021923 -0.7465294  -6.0697808  -3.0465294      2
#> 4     1 -13.90  -2.55  1.61984241  0.1540740 -12.2801576  -2.3959260      2
#> 5     1 -14.40  -5.80 -0.01241165  4.5142412 -14.4124117  -1.2857588      2
#> 6     1  -3.60  -1.70 -0.76568476  0.9609069  -4.3656848  -0.7390931      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6900 -40675   6575 
#> initial  value 998.131940 
#> iter   2 value 785.510710
#> iter   3 value 772.756777
#> iter   4 value 770.895300
#> iter   5 value 740.440300
#> iter   6 value 731.657421
#> iter   7 value 730.378372
#> iter   8 value 730.347558
#> iter   9 value 730.347508
#> iter   9 value 730.347507
#> iter   9 value 730.347507
#> final  value 730.347507 
#> converged
#> This is Run number  120 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.01594104  4.1415568  -0.5659410 -8.458443      1
#> 2     1  -0.95  -2.35  1.34969009  0.1006979   0.3996901 -2.249302      1
#> 3     1  -6.20  -2.30 -0.82920188 -1.0474885  -7.0292019 -3.347488      2
#> 4     1 -13.90  -2.55 -0.54090910  0.2416173 -14.4409091 -2.308383      2
#> 5     1 -14.40  -5.80  0.03498942 -0.2569341 -14.3650106 -6.056934      2
#> 6     1  -3.60  -1.70  1.45119880  1.4463160  -2.1488012 -0.253684      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5880 -37025   6550 
#> initial  value 998.131940 
#> iter   2 value 840.204456
#> iter   3 value 829.913440
#> iter   4 value 828.081264
#> iter   5 value 786.992376
#> iter   6 value 778.866204
#> iter   7 value 777.423344
#> iter   8 value 777.394222
#> iter   9 value 777.394169
#> iter   9 value 777.394167
#> iter   9 value 777.394167
#> final  value 777.394167 
#> converged
#> This is Run number  121 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.007398645 -0.6456223  -0.5573986 -13.2456223      1
#> 2     1  -0.95  -2.35  2.755982139 -1.4123493   1.8059821  -3.7623493      1
#> 3     1  -6.20  -2.30 -0.962504418  1.8263480  -7.1625044  -0.4736520      2
#> 4     1 -13.90  -2.55 -0.738591477 -0.4129857 -14.6385915  -2.9629857      2
#> 5     1 -14.40  -5.80  0.921618417  3.8217972 -13.4783816  -1.9782028      2
#> 6     1  -3.60  -1.70  0.368379844  1.0427421  -3.2316202  -0.6572579      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -39000   6425 
#> initial  value 998.131940 
#> iter   2 value 812.553482
#> iter   3 value 801.917743
#> iter   4 value 800.469960
#> iter   5 value 764.820947
#> iter   6 value 756.213543
#> iter   7 value 754.735317
#> iter   8 value 754.700099
#> iter   9 value 754.700025
#> iter  10 value 754.700013
#> iter  10 value 754.700006
#> iter  10 value 754.700006
#> final  value 754.700006 
#> converged
#> This is Run number  122 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1044082 -1.0239845   0.5544082 -13.6239845      1
#> 2     1  -0.95  -2.35  1.8460893 -0.3844123   0.8960893  -2.7344123      1
#> 3     1  -6.20  -2.30  4.6929555  0.2772338  -1.5070445  -2.0227662      1
#> 4     1 -13.90  -2.55 -0.6429437  1.7768983 -14.5429437  -0.7731017      2
#> 5     1 -14.40  -5.80  0.1151027 -1.2141846 -14.2848973  -7.0141846      2
#> 6     1  -3.60  -1.70  2.2423465  0.3866359  -1.3576535  -1.3133641      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -39975   6725 
#> initial  value 998.131940 
#> iter   2 value 796.078869
#> iter   3 value 783.337508
#> iter   4 value 781.563694
#> iter   5 value 748.983905
#> iter   6 value 740.254234
#> iter   7 value 738.934391
#> iter   8 value 738.903793
#> iter   9 value 738.903743
#> iter   9 value 738.903743
#> iter   9 value 738.903743
#> final  value 738.903743 
#> converged
#> This is Run number  123 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4958699  0.4953689  -1.0458699 -12.1046311      1
#> 2     1  -0.95  -2.35  0.8843669  2.6466201  -0.0656331   0.2966201      2
#> 3     1  -6.20  -2.30 -0.7861591  0.7865901  -6.9861591  -1.5134099      2
#> 4     1 -13.90  -2.55 -0.8921643  1.7033495 -14.7921643  -0.8466505      2
#> 5     1 -14.40  -5.80  1.3302444 -1.3219559 -13.0697556  -7.1219559      2
#> 6     1  -3.60  -1.70  0.1916989 -0.4053545  -3.4083011  -2.1053545      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38575   5850 
#> initial  value 998.131940 
#> iter   2 value 821.834037
#> iter   3 value 811.011828
#> iter   4 value 808.291189
#> iter   5 value 771.753259
#> iter   6 value 763.214772
#> iter   7 value 761.632365
#> iter   8 value 761.593493
#> iter   9 value 761.593391
#> iter  10 value 761.593378
#> iter  10 value 761.593377
#> iter  10 value 761.593372
#> final  value 761.593372 
#> converged
#> This is Run number  124 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2104237  0.09877969  -0.7604237 -12.5012203      1
#> 2     1  -0.95  -2.35  2.0589260  1.08507825   1.1089260  -1.2649218      1
#> 3     1  -6.20  -2.30  3.1514716 -0.68329469  -3.0485284  -2.9832947      2
#> 4     1 -13.90  -2.55  1.1270583 -0.62843630 -12.7729417  -3.1784363      2
#> 5     1 -14.40  -5.80  1.4032159 -0.33711845 -12.9967841  -6.1371184      2
#> 6     1  -3.60  -1.70 -0.7215012  1.10637593  -4.3215012  -0.5936241      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5880 -39100   7250 
#> initial  value 998.131940 
#> iter   2 value 807.024467
#> iter   3 value 791.045094
#> iter   4 value 787.929812
#> iter   5 value 753.234479
#> iter   6 value 744.677040
#> iter   7 value 743.436278
#> iter   8 value 743.412094
#> iter   9 value 743.412068
#> iter   9 value 743.412061
#> iter   9 value 743.412056
#> final  value 743.412056 
#> converged
#> This is Run number  125 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.28295939  1.4161426  -0.2670406 -11.1838574      1
#> 2     1  -0.95  -2.35  2.29162878  1.4828809   1.3416288  -0.8671191      1
#> 3     1  -6.20  -2.30  0.13773400  1.0801234  -6.0622660  -1.2198766      2
#> 4     1 -13.90  -2.55 -1.10820683  0.2308282 -15.0082068  -2.3191718      2
#> 5     1 -14.40  -5.80 -0.02794952 -0.2549103 -14.4279495  -6.0549103      2
#> 6     1  -3.60  -1.70  2.24755125 -1.0006981  -1.3524487  -2.7006981      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5960 -38700   6875 
#> initial  value 998.131940 
#> iter   2 value 815.023033
#> iter   3 value 801.068300
#> iter   4 value 798.261613
#> iter   5 value 762.216639
#> iter   6 value 753.678486
#> iter   7 value 752.342646
#> iter   8 value 752.314655
#> iter   9 value 752.314615
#> iter   9 value 752.314606
#> iter   9 value 752.314601
#> final  value 752.314601 
#> converged
#> This is Run number  126 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  3.1859691 -0.8381323   2.6359691 -13.4381323      1
#> 2     1  -0.95  -2.35  1.1883152 -0.8078310   0.2383152  -3.1578310      1
#> 3     1  -6.20  -2.30  0.7620435  3.6183367  -5.4379565   1.3183367      2
#> 4     1 -13.90  -2.55  1.0069732  1.9725617 -12.8930268  -0.5774383      2
#> 5     1 -14.40  -5.80 -0.2800473  1.2369484 -14.6800473  -4.5630516      2
#> 6     1  -3.60  -1.70  4.4138473  3.1231985   0.8138473   1.4231985      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6100 -38775   6575 
#> initial  value 998.131940 
#> iter   2 value 815.460942
#> iter   3 value 802.537169
#> iter   4 value 799.819079
#> iter   5 value 763.925311
#> iter   6 value 755.356496
#> iter   7 value 753.959953
#> iter   8 value 753.928901
#> iter   9 value 753.928847
#> iter   9 value 753.928837
#> iter   9 value 753.928832
#> final  value 753.928832 
#> converged
#> This is Run number  127 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4704153  1.705396125  -0.07958474 -10.8946039      1
#> 2     1  -0.95  -2.35  0.2806316  0.007796026  -0.66936843  -2.3422040      1
#> 3     1  -6.20  -2.30  0.6016990  1.967345465  -5.59830097  -0.3326545      2
#> 4     1 -13.90  -2.55  0.6087371  0.352152908 -13.29126289  -2.1978471      2
#> 5     1 -14.40  -5.80  1.9502347  0.965958981 -12.44976534  -4.8340410      2
#> 6     1  -3.60  -1.70 -0.9923503 -0.619029628  -4.59235026  -2.3190296      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -39575   7700 
#> initial  value 998.131940 
#> iter   2 value 796.921234
#> iter   3 value 781.307460
#> iter   4 value 779.870670
#> iter   5 value 746.228503
#> iter   6 value 737.641984
#> iter   7 value 736.469027
#> iter   8 value 736.447753
#> iter   8 value 736.447749
#> final  value 736.447749 
#> converged
#> This is Run number  128 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 1.6155602  0.30384009   1.0655602 -12.2961599      1
#> 2     1  -0.95  -2.35 0.7574315 -0.61876202  -0.1925685  -2.9687620      1
#> 3     1  -6.20  -2.30 1.9302551  2.70334303  -4.2697449   0.4033430      2
#> 4     1 -13.90  -2.55 0.5040528  0.10378346 -13.3959472  -2.4462165      2
#> 5     1 -14.40  -5.80 0.6823083  0.04999199 -13.7176917  -5.7500080      2
#> 6     1  -3.60  -1.70 0.2407718  1.10703430  -3.3592282  -0.5929657      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -37950   5925 
#> initial  value 998.131940 
#> iter   2 value 830.175463
#> iter   3 value 821.900026
#> iter   4 value 820.671042
#> iter   5 value 781.912269
#> iter   6 value 773.571604
#> iter   7 value 771.931159
#> iter   8 value 771.892446
#> iter   9 value 771.892347
#> iter  10 value 771.892335
#> iter  10 value 771.892331
#> iter  10 value 771.892327
#> final  value 771.892327 
#> converged
#> This is Run number  129 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.013257058  0.6146410  -0.5367429 -11.9853590      1
#> 2     1  -0.95  -2.35 -0.007590402 -0.2269947  -0.9575904  -2.5769947      1
#> 3     1  -6.20  -2.30 -0.129764150 -0.4604442  -6.3297641  -2.7604442      2
#> 4     1 -13.90  -2.55 -0.826629694  0.6566235 -14.7266297  -1.8933765      2
#> 5     1 -14.40  -5.80  0.925438344 -0.3550511 -13.4745617  -6.1550511      2
#> 6     1  -3.60  -1.70  0.523862051  1.2371312  -3.0761379  -0.4628688      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6600 -38925   6375 
#> initial  value 998.131940 
#> iter   2 value 813.935764
#> iter   3 value 803.434884
#> iter   4 value 801.941989
#> iter   5 value 766.082142
#> iter   6 value 757.489358
#> iter   7 value 755.997046
#> iter   8 value 755.961420
#> iter   9 value 755.961344
#> iter  10 value 755.961332
#> iter  10 value 755.961325
#> iter  10 value 755.961325
#> final  value 755.961325 
#> converged
#> This is Run number  130 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.28706691  0.08503725  -0.8370669 -12.5149627      1
#> 2     1  -0.95  -2.35  0.72972559  1.68337268  -0.2202744  -0.6666273      1
#> 3     1  -6.20  -2.30  1.29963033 -0.42474723  -4.9003697  -2.7247472      2
#> 4     1 -13.90  -2.55  1.16782494  4.82519673 -12.7321751   2.2751967      2
#> 5     1 -14.40  -5.80 -0.03524421 -0.37960836 -14.4352442  -6.1796084      2
#> 6     1  -3.60  -1.70 -0.63969585 -0.34121831  -4.2396959  -2.0412183      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -38225   6475 
#> initial  value 998.131940 
#> iter   2 value 823.840237
#> iter   3 value 813.092715
#> iter   4 value 811.346496
#> iter   5 value 773.561946
#> iter   6 value 765.116619
#> iter   7 value 763.642130
#> iter   8 value 763.609118
#> iter   9 value 763.609052
#> iter   9 value 763.609052
#> iter   9 value 763.609052
#> final  value 763.609052 
#> converged
#> This is Run number  131 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.3165315  1.524189532  -0.8665315 -11.075810      1
#> 2     1  -0.95  -2.35  1.3164826  0.652308434   0.3664826  -1.697692      1
#> 3     1  -6.20  -2.30 -1.4117486 -0.016456106  -7.6117486  -2.316456      2
#> 4     1 -13.90  -2.55 -0.2352694 -0.080260767 -14.1352694  -2.630261      2
#> 5     1 -14.40  -5.80  0.6037892  0.500541109 -13.7962108  -5.299459      2
#> 6     1  -3.60  -1.70  0.4378517 -0.009254014  -3.1621483  -1.709254      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5580 -39075   8575 
#> initial  value 998.131940 
#> iter   2 value 799.060048
#> iter   3 value 778.598971
#> iter   4 value 775.824969
#> iter   5 value 741.258481
#> iter   6 value 732.942168
#> iter   7 value 731.848667
#> iter   8 value 731.833511
#> iter   9 value 731.833497
#> iter   9 value 731.833494
#> iter   9 value 731.833494
#> final  value 731.833494 
#> converged
#> This is Run number  132 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5196768  0.5890659  -1.0696768 -12.01093412      1
#> 2     1  -0.95  -2.35  0.8236607 -0.2641049  -0.1263393  -2.61410492      1
#> 3     1  -6.20  -2.30  4.4109768 -0.1255354  -1.7890232  -2.42553541      1
#> 4     1 -13.90  -2.55 -0.7794212  0.3924532 -14.6794212  -2.15754678      2
#> 5     1 -14.40  -5.80  1.3540949  0.4193582 -13.0459051  -5.38064184      2
#> 6     1  -3.60  -1.70  1.4265360  1.6007162  -2.1734640  -0.09928384      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5720 -36525   7175 
#> initial  value 998.131940 
#> iter   2 value 843.439420
#> iter   3 value 832.706472
#> iter   4 value 831.328997
#> iter   5 value 788.744654
#> iter   6 value 780.755104
#> iter   7 value 779.414690
#> iter   8 value 779.390285
#> iter   9 value 779.390248
#> iter  10 value 779.390236
#> iter  10 value 779.390225
#> iter  10 value 779.390220
#> final  value 779.390220 
#> converged
#> This is Run number  133 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6985852 -0.3486969  -1.2485852 -12.9486969      1
#> 2     1  -0.95  -2.35  0.3226493 -0.5028395  -0.6273507  -2.8528395      1
#> 3     1  -6.20  -2.30  3.4734443  0.4955129  -2.7265557  -1.8044871      2
#> 4     1 -13.90  -2.55  0.2666107  0.7923951 -13.6333893  -1.7576049      2
#> 5     1 -14.40  -5.80  1.4734701  4.4063127 -12.9265299  -1.3936873      2
#> 6     1  -3.60  -1.70 -0.1324955  1.1545845  -3.7324955  -0.5454155      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5340 -36175   7200 
#> initial  value 998.131940 
#> iter   2 value 847.822259
#> iter   3 value 836.129674
#> iter   4 value 834.008898
#> iter   5 value 790.676626
#> iter   6 value 782.794608
#> iter   7 value 781.486977
#> iter   8 value 781.464486
#> iter   9 value 781.464457
#> iter   9 value 781.464447
#> iter   9 value 781.464442
#> final  value 781.464442 
#> converged
#> This is Run number  134 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.87286352 -0.6392067   0.3228635 -13.239207      1
#> 2     1  -0.95  -2.35  1.75347823 -0.2807660   0.8034782  -2.630766      1
#> 3     1  -6.20  -2.30  0.52224873  1.0334426  -5.6777513  -1.266557      2
#> 4     1 -13.90  -2.55 -0.78541897 -1.0078416 -14.6854190  -3.557842      2
#> 5     1 -14.40  -5.80 -0.54515703  1.2838356 -14.9451570  -4.516164      2
#> 6     1  -3.60  -1.70  0.02167894 -1.7751504  -3.5783211  -3.475150      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5840 -36525   7650 
#> initial  value 998.131940 
#> iter   2 value 840.601584
#> iter   3 value 829.543291
#> iter   4 value 828.768332
#> iter   5 value 785.997373
#> iter   6 value 777.977331
#> iter   7 value 776.688733
#> iter   8 value 776.666672
#> iter   9 value 776.666641
#> iter   9 value 776.666629
#> iter   9 value 776.666624
#> final  value 776.666624 
#> converged
#> This is Run number  135 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8856850 -0.41886283   0.335685 -13.0188628      1
#> 2     1  -0.95  -2.35 -0.7252232  0.51405599  -1.675223  -1.8359440      1
#> 3     1  -6.20  -2.30  0.3163594  0.41299380  -5.883641  -1.8870062      2
#> 4     1 -13.90  -2.55  1.9515774 -0.08487522 -11.948423  -2.6348752      2
#> 5     1 -14.40  -5.80  1.2379621 -0.57006197 -13.162038  -6.3700620      2
#> 6     1  -3.60  -1.70  0.3179838  2.16273940  -3.282016   0.4627394      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -37075   6825 
#> initial  value 998.131940 
#> iter   2 value 838.047265
#> iter   3 value 827.742923
#> iter   4 value 826.366996
#> iter   5 value 785.280305
#> iter   6 value 777.135385
#> iter   7 value 775.723808
#> iter   8 value 775.695699
#> iter   9 value 775.695649
#> iter   9 value 775.695649
#> iter   9 value 775.695649
#> final  value 775.695649 
#> converged
#> This is Run number  136 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.23167818  2.42646006   1.681678 -10.1735399      1
#> 2     1  -0.95  -2.35  2.01476686  0.47271232   1.064767  -1.8772877      1
#> 3     1  -6.20  -2.30 -0.20470875  0.05081534  -6.404709  -2.2491847      2
#> 4     1 -13.90  -2.55  2.29210249 -0.08752552 -11.607898  -2.6375255      2
#> 5     1 -14.40  -5.80  0.64678624 -0.08449036 -13.753214  -5.8844904      2
#> 6     1  -3.60  -1.70 -0.09931459  1.05061407  -3.699315  -0.6493859      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -38825   8150 
#> initial  value 998.131940 
#> iter   2 value 805.572942
#> iter   3 value 788.489731
#> iter   4 value 786.670826
#> iter   5 value 750.959618
#> iter   6 value 742.528961
#> iter   7 value 741.373855
#> iter   8 value 741.355702
#> iter   9 value 741.355687
#> iter   9 value 741.355684
#> iter   9 value 741.355675
#> final  value 741.355675 
#> converged
#> This is Run number  137 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8511228 -0.02889434   0.30112281 -12.628894      1
#> 2     1  -0.95  -2.35  0.9178843 -0.43448110  -0.03211565  -2.784481      1
#> 3     1  -6.20  -2.30 -0.7812737  0.33578475  -6.98127367  -1.964215      2
#> 4     1 -13.90  -2.55  1.1838083  0.12798655 -12.71619170  -2.422013      2
#> 5     1 -14.40  -5.80  1.4619885  1.73312689 -12.93801148  -4.066873      2
#> 6     1  -3.60  -1.70 -0.5712750  2.11494896  -4.17127502   0.414949      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38925   7200 
#> initial  value 998.131940 
#> iter   2 value 809.612017
#> iter   3 value 796.934252
#> iter   4 value 795.808298
#> iter   5 value 759.981885
#> iter   6 value 751.403569
#> iter   7 value 750.085991
#> iter   8 value 750.058522
#> iter   9 value 750.058480
#> iter  10 value 750.058468
#> iter  10 value 750.058458
#> iter  10 value 750.058452
#> final  value 750.058452 
#> converged
#> This is Run number  138 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8205621  0.3040667   0.2705621 -12.2959333      1
#> 2     1  -0.95  -2.35  0.6763085  2.0613613  -0.2736915  -0.2886387      1
#> 3     1  -6.20  -2.30  1.1298120 -0.1978730  -5.0701880  -2.4978730      2
#> 4     1 -13.90  -2.55 -0.9525673  0.1635724 -14.8525673  -2.3864276      2
#> 5     1 -14.40  -5.80 -0.1402400  0.8233854 -14.5402400  -4.9766146      2
#> 6     1  -3.60  -1.70 -0.6453974  0.0574075  -4.2453974  -1.6425925      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7020 -39900   7525 
#> initial  value 998.131940 
#> iter   2 value 792.314353
#> iter   3 value 778.832828
#> iter   4 value 778.545369
#> iter   5 value 745.526780
#> iter   6 value 736.825756
#> iter   7 value 735.615245
#> iter   8 value 735.591317
#> iter   9 value 735.591286
#> iter   9 value 735.591278
#> iter   9 value 735.591276
#> final  value 735.591276 
#> converged
#> This is Run number  139 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.58365874 -0.09696646   0.03365874 -12.6969665      1
#> 2     1  -0.95  -2.35 -0.97517770  0.86955234  -1.92517770  -1.4804477      2
#> 3     1  -6.20  -2.30 -1.63648937  1.65310178  -7.83648937  -0.6468982      2
#> 4     1 -13.90  -2.55 -0.02224711 -0.20563262 -13.92224711  -2.7556326      2
#> 5     1 -14.40  -5.80  4.36404999  1.41800687 -10.03595001  -4.3819931      2
#> 6     1  -3.60  -1.70  2.28158734 -1.17624436  -1.31841266  -2.8762444      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5880 -38400   8225 
#> initial  value 998.131940 
#> iter   2 value 811.283694
#> iter   3 value 794.969622
#> iter   4 value 793.501579
#> iter   5 value 756.400747
#> iter   6 value 748.013795
#> iter   7 value 746.843840
#> iter   8 value 746.825819
#> iter   9 value 746.825806
#> iter   9 value 746.825803
#> iter   9 value 746.825792
#> final  value 746.825792 
#> converged
#> This is Run number  140 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1195485 -0.99575207  -0.4304515 -13.595752      1
#> 2     1  -0.95  -2.35 -1.0843589 -0.52583176  -2.0343589  -2.875832      1
#> 3     1  -6.20  -2.30  1.9381947 -0.71982923  -4.2618053  -3.019829      2
#> 4     1 -13.90  -2.55  0.1439180  0.52312576 -13.7560820  -2.026874      2
#> 5     1 -14.40  -5.80 -0.2379121 -0.05483515 -14.6379121  -5.854835      2
#> 6     1  -3.60  -1.70 -0.5339392 -0.27023570  -4.1339392  -1.970236      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -35975   6100 
#> initial  value 998.131940 
#> iter   2 value 855.726129
#> iter   3 value 849.449133
#> iter   4 value 848.985625
#> iter   5 value 804.812668
#> iter   6 value 797.105243
#> iter   7 value 795.568336
#> iter   8 value 795.538065
#> iter   9 value 795.537995
#> iter   9 value 795.537989
#> iter   9 value 795.537989
#> final  value 795.537989 
#> converged
#> This is Run number  141 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5204681 -0.8373088  -0.02953187 -13.437309      1
#> 2     1  -0.95  -2.35  0.8694662  0.3745249  -0.08053376  -1.975475      1
#> 3     1  -6.20  -2.30  2.4218607 -0.4524521  -3.77813930  -2.752452      2
#> 4     1 -13.90  -2.55  0.1557874  1.0736752 -13.74421264  -1.476325      2
#> 5     1 -14.40  -5.80 -1.2387726  0.7329548 -15.63877263  -5.067045      2
#> 6     1  -3.60  -1.70  2.2043552 -0.4960609  -1.39564481  -2.196061      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -38050   6325 
#> initial  value 998.131940 
#> iter   2 value 827.024049
#> iter   3 value 817.163741
#> iter   4 value 815.642434
#> iter   5 value 777.278519
#> iter   6 value 768.882294
#> iter   7 value 767.360503
#> iter   8 value 767.326015
#> iter   9 value 767.325941
#> iter  10 value 767.325929
#> iter  10 value 767.325922
#> iter  10 value 767.325917
#> final  value 767.325917 
#> converged
#> This is Run number  142 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9356484  1.3688998   0.3856484 -11.2311002      1
#> 2     1  -0.95  -2.35  2.0059175  2.6400638   1.0559175   0.2900638      1
#> 3     1  -6.20  -2.30  0.2949954 -0.4800333  -5.9050046  -2.7800333      2
#> 4     1 -13.90  -2.55 -1.2173447  2.3460072 -15.1173447  -0.2039928      2
#> 5     1 -14.40  -5.80 -0.4629034  1.3966766 -14.8629034  -4.4033234      2
#> 6     1  -3.60  -1.70  0.1672113  0.6482633  -3.4327887  -1.0517367      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -38125   6775 
#> initial  value 998.131940 
#> iter   2 value 823.649927
#> iter   3 value 812.860074
#> iter   4 value 811.623783
#> iter   5 value 773.423588
#> iter   6 value 764.999157
#> iter   7 value 763.567407
#> iter   8 value 763.536394
#> iter   9 value 763.536335
#> iter  10 value 763.536322
#> iter  10 value 763.536312
#> iter  10 value 763.536308
#> final  value 763.536308 
#> converged
#> This is Run number  143 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.01623733  4.4900386  -0.5662373 -8.1099614      1
#> 2     1  -0.95  -2.35  0.14646683 -0.1479136  -0.8035332 -2.4979136      1
#> 3     1  -6.20  -2.30  0.55993888  0.2951670  -5.6400611 -2.0048330      2
#> 4     1 -13.90  -2.55  1.57540644  1.7172438 -12.3245936 -0.8327562      2
#> 5     1 -14.40  -5.80  0.61582758  4.2606734 -13.7841724 -1.5393266      2
#> 6     1  -3.60  -1.70  0.06077692  2.0014828  -3.5392231  0.3014828      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -38850   8000 
#> initial  value 998.131940 
#> iter   2 value 806.102722
#> iter   3 value 790.137963
#> iter   4 value 788.714221
#> iter   5 value 752.930872
#> iter   6 value 744.455297
#> iter   7 value 743.278152
#> iter   8 value 743.258637
#> iter   9 value 743.258617
#> iter   9 value 743.258613
#> iter   9 value 743.258606
#> final  value 743.258606 
#> converged
#> This is Run number  144 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.02540204  0.08516046  -0.5754020 -12.5148395      1
#> 2     1  -0.95  -2.35  0.12932325 -0.08493782  -0.8206767  -2.4349378      1
#> 3     1  -6.20  -2.30  0.94974298 -0.92341321  -5.2502570  -3.2234132      2
#> 4     1 -13.90  -2.55  5.45093184  0.97000046  -8.4490682  -1.5799995      2
#> 5     1 -14.40  -5.80  0.68751333 -0.09983055 -13.7124867  -5.8998306      2
#> 6     1  -3.60  -1.70  1.06535369  0.74274411  -2.5346463  -0.9572559      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39550   7625 
#> initial  value 998.131940 
#> iter   2 value 797.674010
#> iter   3 value 782.801550
#> iter   4 value 781.654072
#> iter   5 value 747.826941
#> iter   6 value 739.216033
#> iter   7 value 738.022354
#> iter   8 value 738.000025
#> iter   9 value 738.000002
#> iter   9 value 737.999994
#> iter   9 value 737.999991
#> final  value 737.999991 
#> converged
#> This is Run number  145 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1425866  1.0008970  -0.4074134 -11.5991030      1
#> 2     1  -0.95  -2.35 -1.1802779  1.6102184  -2.1302779  -0.7397816      2
#> 3     1  -6.20  -2.30  0.7753154 -0.2292162  -5.4246846  -2.5292162      2
#> 4     1 -13.90  -2.55 -1.2358724  0.9545549 -15.1358724  -1.5954451      2
#> 5     1 -14.40  -5.80 -0.9534038  2.0717363 -15.3534038  -3.7282637      2
#> 6     1  -3.60  -1.70  1.8562992 -0.3633814  -1.7437008  -2.0633814      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -39275   6850 
#> initial  value 998.131940 
#> iter   2 value 806.619959
#> iter   3 value 790.947770
#> iter   4 value 787.259675
#> iter   5 value 753.144637
#> iter   6 value 744.515946
#> iter   7 value 743.238137
#> iter   8 value 743.211328
#> iter   9 value 743.211293
#> iter   9 value 743.211286
#> iter   9 value 743.211281
#> final  value 743.211281 
#> converged
#> This is Run number  146 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2867370 -0.9313730  -0.83673697 -13.531373      1
#> 2     1  -0.95  -2.35  0.8640782  0.5480416  -0.08592184  -1.801958      1
#> 3     1  -6.20  -2.30 -1.4136972  0.6295673  -7.61369720  -1.670433      2
#> 4     1 -13.90  -2.55  1.1147061  0.4361971 -12.78529389  -2.113803      2
#> 5     1 -14.40  -5.80  2.4387189  0.3467111 -11.96128112  -5.453289      2
#> 6     1  -3.60  -1.70  0.6153004 -0.8356694  -2.98469961  -2.535669      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38000   6950 
#> initial  value 998.131940 
#> iter   2 value 824.432157
#> iter   3 value 813.690608
#> iter   4 value 812.771878
#> iter   5 value 774.140127
#> iter   6 value 765.740075
#> iter   7 value 764.328791
#> iter   8 value 764.298907
#> iter   9 value 764.298852
#> iter  10 value 764.298837
#> iter  10 value 764.298827
#> iter  10 value 764.298824
#> final  value 764.298824 
#> converged
#> This is Run number  147 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.24351930  2.14403611  -1.793519 -10.4559639      1
#> 2     1  -0.95  -2.35  2.90579605 -0.09093662   1.955796  -2.4409366      1
#> 3     1  -6.20  -2.30  0.69668368  0.41219840  -5.503316  -1.8878016      2
#> 4     1 -13.90  -2.55  0.05818041  0.10300689 -13.841820  -2.4469931      2
#> 5     1 -14.40  -5.80 -1.29087069 -0.81303065 -15.690871  -6.6130307      2
#> 6     1  -3.60  -1.70  1.35727580  1.41340633  -2.242724  -0.2865937      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -39350   7225 
#> initial  value 998.131940 
#> iter   2 value 803.207714
#> iter   3 value 789.025029
#> iter   4 value 787.183568
#> iter   5 value 752.857580
#> iter   6 value 744.242693
#> iter   7 value 742.980120
#> iter   8 value 742.954307
#> iter   9 value 742.954274
#> iter   9 value 742.954264
#> iter   9 value 742.954258
#> final  value 742.954258 
#> converged
#> This is Run number  148 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.19733318  0.51077804   0.6473332 -12.0892220      1
#> 2     1  -0.95  -2.35 -0.52125916  2.13107625  -1.4712592  -0.2189238      2
#> 3     1  -6.20  -2.30 -0.18981702 -0.03074734  -6.3898170  -2.3307473      2
#> 4     1 -13.90  -2.55  1.64015825  3.01803842 -12.2598417   0.4680384      2
#> 5     1 -14.40  -5.80  0.03052362 -0.57099509 -14.3694764  -6.3709951      2
#> 6     1  -3.60  -1.70  1.33886210 -0.39531734  -2.2611379  -2.0953173      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5620 -37600   8125 
#> initial  value 998.131940 
#> iter   2 value 823.285079
#> iter   3 value 808.031135
#> iter   4 value 806.333951
#> iter   5 value 766.884280
#> iter   6 value 758.633079
#> iter   7 value 757.422678
#> iter   8 value 757.403788
#> iter   9 value 757.403772
#> iter   9 value 757.403772
#> iter   9 value 757.403766
#> final  value 757.403766 
#> converged
#> This is Run number  149 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.43609393 0.7013268  -0.1139061 -11.8986732      1
#> 2     1  -0.95  -2.35 -1.11922853 3.1194979  -2.0692285   0.7694979      2
#> 3     1  -6.20  -2.30  0.06393889 1.0611855  -6.1360611  -1.2388145      2
#> 4     1 -13.90  -2.55  0.79532654 3.7323890 -13.1046735   1.1823890      2
#> 5     1 -14.40  -5.80 -1.15528773 0.2589116 -15.5552877  -5.5410884      2
#> 6     1  -3.60  -1.70  2.16473543 1.4874184  -1.4352646  -0.2125816      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5320 -35950   6950 
#> initial  value 998.131940 
#> iter   2 value 852.058458
#> iter   3 value 841.022494
#> iter   4 value 838.842118
#> iter   5 value 794.959638
#> iter   6 value 787.156416
#> iter   7 value 785.830916
#> iter   8 value 785.807907
#> iter   9 value 785.807875
#> iter   9 value 785.807866
#> iter   9 value 785.807862
#> final  value 785.807862 
#> converged
#> This is Run number  150 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1925067  2.04015897  -0.7425067 -10.5598410      1
#> 2     1  -0.95  -2.35  0.1776420  0.05961709  -0.7723580  -2.2903829      1
#> 3     1  -6.20  -2.30  1.7347755 -0.47444233  -4.4652245  -2.7744423      2
#> 4     1 -13.90  -2.55 -0.3297786  1.79303070 -14.2297786  -0.7569693      2
#> 5     1 -14.40  -5.80  0.7295488  0.46424627 -13.6704512  -5.3357537      2
#> 6     1  -3.60  -1.70 -0.3886173  0.29899326  -3.9886173  -1.4010067      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6440 -38450   6275 
#> initial  value 998.131940 
#> iter   2 value 821.505696
#> iter   3 value 811.331868
#> iter   4 value 809.670627
#> iter   5 value 772.483885
#> iter   6 value 763.991729
#> iter   7 value 762.467864
#> iter   8 value 762.432221
#> iter   9 value 762.432143
#> iter  10 value 762.432131
#> iter  10 value 762.432125
#> iter  10 value 762.432123
#> final  value 762.432123 
#> converged
#> This is Run number  151 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5600606  1.33529786  -1.1100606 -11.264702      1
#> 2     1  -0.95  -2.35  2.4614802  0.16456444   1.5114802  -2.185436      1
#> 3     1  -6.20  -2.30 -0.6452466 -1.11798262  -6.8452466  -3.417983      2
#> 4     1 -13.90  -2.55 -0.2636248 -0.79869186 -14.1636248  -3.348692      2
#> 5     1 -14.40  -5.80 -0.2024300  2.80931145 -14.6024300  -2.990689      2
#> 6     1  -3.60  -1.70  2.7816691 -0.07894998  -0.8183309  -1.778950      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38025   6725 
#> initial  value 998.131940 
#> iter   2 value 825.384958
#> iter   3 value 814.547207
#> iter   4 value 813.129980
#> iter   5 value 774.696324
#> iter   6 value 766.297102
#> iter   7 value 764.861318
#> iter   8 value 764.830368
#> iter   9 value 764.830311
#> iter   9 value 764.830311
#> iter   9 value 764.830311
#> final  value 764.830311 
#> converged
#> This is Run number  152 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6250066  0.2262293  -1.175007 -12.3737707      1
#> 2     1  -0.95  -2.35  3.3231726 -0.6459198   2.373173  -2.9959198      1
#> 3     1  -6.20  -2.30 -0.5017023  1.5260813  -6.701702  -0.7739187      2
#> 4     1 -13.90  -2.55  0.5679645  0.1826057 -13.332035  -2.3673943      2
#> 5     1 -14.40  -5.80  0.9951574 -0.4104710 -13.404843  -6.2104710      2
#> 6     1  -3.60  -1.70  1.8083609 -1.3865536  -1.791639  -3.0865536      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4860 -35025   6700 
#> initial  value 998.131940 
#> iter   2 value 864.561788
#> iter   3 value 853.366007
#> iter   4 value 850.618570
#> iter   5 value 804.486120
#> iter   6 value 796.982491
#> iter   7 value 795.705861
#> iter   8 value 795.685667
#> iter   9 value 795.685642
#> iter   9 value 795.685636
#> iter   9 value 795.685633
#> final  value 795.685633 
#> converged
#> This is Run number  153 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2870767 -0.02050144  -0.8370767 -12.620501      1
#> 2     1  -0.95  -2.35  0.1221351  1.23251082  -0.8278649  -1.117489      1
#> 3     1  -6.20  -2.30  1.0288343  0.70349491  -5.1711657  -1.596505      2
#> 4     1 -13.90  -2.55 -0.7415543  0.29205276 -14.6415543  -2.257947      2
#> 5     1 -14.40  -5.80 -0.5924580 -0.16841918 -14.9924580  -5.968419      2
#> 6     1  -3.60  -1.70 -1.3418374 -0.60850812  -4.9418374  -2.308508      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5380 -36925   7325 
#> initial  value 998.131940 
#> iter   2 value 837.353294
#> iter   3 value 823.886922
#> iter   4 value 821.325484
#> iter   5 value 780.150321
#> iter   6 value 772.039706
#> iter   7 value 770.738327
#> iter   8 value 770.715401
#> iter   9 value 770.715374
#> iter   9 value 770.715364
#> iter   9 value 770.715359
#> final  value 770.715359 
#> converged
#> This is Run number  154 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.53920613  0.4633758   0.9892061 -12.1366242      1
#> 2     1  -0.95  -2.35  1.71380230 -0.4433767   0.7638023  -2.7933767      1
#> 3     1  -6.20  -2.30  0.03696869  1.8820436  -6.1630313  -0.4179564      2
#> 4     1 -13.90  -2.55  0.19547196  6.2942176 -13.7045280   3.7442176      2
#> 5     1 -14.40  -5.80 -0.88588605 -0.7344021 -15.2858860  -6.5344021      2
#> 6     1  -3.60  -1.70  0.65747306 -0.3554803  -2.9425269  -2.0554803      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6880 -37700   5775 
#> initial  value 998.131940 
#> iter   2 value 834.023460
#> iter   3 value 827.284290
#> iter   4 value 826.728475
#> iter   5 value 787.034662
#> iter   6 value 778.799035
#> iter   7 value 777.075526
#> iter   8 value 777.034725
#> iter   9 value 777.034609
#> iter  10 value 777.034597
#> iter  10 value 777.034592
#> iter  10 value 777.034587
#> final  value 777.034587 
#> converged
#> This is Run number  155 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9846353  2.0813401  -1.5346353 -10.518660      1
#> 2     1  -0.95  -2.35  0.3228183 -1.2500166  -0.6271817  -3.600017      1
#> 3     1  -6.20  -2.30  1.3564790 -0.5968467  -4.8435210  -2.896847      2
#> 4     1 -13.90  -2.55  0.3135420 -0.1155842 -13.5864580  -2.665584      2
#> 5     1 -14.40  -5.80  1.5523309  0.1802541 -12.8476691  -5.619746      2
#> 6     1  -3.60  -1.70  1.4359782 -1.2105459  -2.1640218  -2.910546      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -39075   7000 
#> initial  value 998.131940 
#> iter   2 value 808.235077
#> iter   3 value 796.796033
#> iter   4 value 796.120122
#> iter   5 value 760.557113
#> iter   6 value 751.932193
#> iter   7 value 750.559096
#> iter   8 value 750.528560
#> iter   9 value 750.528505
#> iter  10 value 750.528490
#> iter  10 value 750.528480
#> iter  10 value 750.528473
#> final  value 750.528473 
#> converged
#> This is Run number  156 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.3284442 -0.8323573   0.7784442 -13.432357      1
#> 2     1  -0.95  -2.35 -0.2553660 -0.1226016  -1.2053660  -2.472602      1
#> 3     1  -6.20  -2.30  0.9513305  2.0407260  -5.2486695  -0.259274      2
#> 4     1 -13.90  -2.55  1.8509883  1.2119672 -12.0490117  -1.338033      2
#> 5     1 -14.40  -5.80  0.2170416  0.6717132 -14.1829584  -5.128287      2
#> 6     1  -3.60  -1.70 -0.5796611  0.1742366  -4.1796611  -1.525763      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6520 -38875   7475 
#> initial  value 998.131940 
#> iter   2 value 808.688095
#> iter   3 value 795.657059
#> iter   4 value 794.915069
#> iter   5 value 758.892339
#> iter   6 value 750.324033
#> iter   7 value 749.044868
#> iter   8 value 749.019613
#> iter   9 value 749.019578
#> iter  10 value 749.019566
#> iter  10 value 749.019557
#> iter  10 value 749.019549
#> final  value 749.019549 
#> converged
#> This is Run number  157 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1196599  0.3701395  -0.4303401 -12.22986050      1
#> 2     1  -0.95  -2.35  1.8375022  2.0634689   0.8875022  -0.28653107      1
#> 3     1  -6.20  -2.30 -0.2368146  0.5991558  -6.4368146  -1.70084418      2
#> 4     1 -13.90  -2.55 -0.7280566  1.1624193 -14.6280566  -1.38758066      2
#> 5     1 -14.40  -5.80  1.6802103 -0.1810604 -12.7197897  -5.98106041      2
#> 6     1  -3.60  -1.70 -0.1156988  1.7546507  -3.7156988   0.05465075      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7160 -40075   5850 
#> initial  value 998.131940 
#> iter   2 value 798.311202
#> iter   3 value 789.045381
#> iter   4 value 787.698957
#> iter   5 value 755.128609
#> iter   6 value 746.366016
#> iter   7 value 744.780987
#> iter   8 value 744.737392
#> iter   9 value 744.737272
#> iter  10 value 744.737259
#> iter  10 value 744.737259
#> iter  10 value 744.737252
#> final  value 744.737252 
#> converged
#> This is Run number  158 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.01687771 -0.1186750  -0.5668777 -12.718675      1
#> 2     1  -0.95  -2.35 -0.31483839  1.2810316  -1.2648384  -1.068968      2
#> 3     1  -6.20  -2.30  1.48161290  0.6009233  -4.7183871  -1.699077      2
#> 4     1 -13.90  -2.55 -0.34127499  0.5603407 -14.2412750  -1.989659      2
#> 5     1 -14.40  -5.80 -0.85863450 -1.4289316 -15.2586345  -7.228932      2
#> 6     1  -3.60  -1.70 -0.69124424  0.3564565  -4.2912442  -1.343544      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5580 -37725   6075 
#> initial  value 998.131940 
#> iter   2 value 833.062560
#> iter   3 value 819.839446
#> iter   4 value 816.162791
#> iter   5 value 777.306314
#> iter   6 value 768.889047
#> iter   7 value 767.425852
#> iter   8 value 767.394077
#> iter   9 value 767.394008
#> iter   9 value 767.393996
#> iter   9 value 767.393991
#> final  value 767.393991 
#> converged
#> This is Run number  159 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.6252827  1.56392814   1.0752827 -11.036072      1
#> 2     1  -0.95  -2.35  1.6101609 -0.70950821   0.6601609  -3.059508      1
#> 3     1  -6.20  -2.30  0.3404632  1.94502896  -5.8595368  -0.354971      2
#> 4     1 -13.90  -2.55  1.7445505 -0.45246603 -12.1554495  -3.002466      2
#> 5     1 -14.40  -5.80  2.3145823  3.10005494 -12.0854177  -2.699945      2
#> 6     1  -3.60  -1.70 -0.3846931 -0.07749941  -3.9846931  -1.777499      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -38825   7325 
#> initial  value 998.131940 
#> iter   2 value 810.565721
#> iter   3 value 796.559650
#> iter   4 value 794.769234
#> iter   5 value 758.876864
#> iter   6 value 750.342003
#> iter   7 value 749.063438
#> iter   8 value 749.038146
#> iter   9 value 749.038114
#> iter   9 value 749.038104
#> iter   9 value 749.038098
#> final  value 749.038098 
#> converged
#> This is Run number  160 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1534838  0.1509388  -0.7034838 -12.449061      1
#> 2     1  -0.95  -2.35 -0.7931639 -1.1335804  -1.7431639  -3.483580      1
#> 3     1  -6.20  -2.30  0.1991533 -0.9363168  -6.0008467  -3.236317      2
#> 4     1 -13.90  -2.55  0.1736630  0.5310906 -13.7263370  -2.018909      2
#> 5     1 -14.40  -5.80  0.9010981  0.2076687 -13.4989019  -5.592331      2
#> 6     1  -3.60  -1.70  0.4056225 -0.4256635  -3.1943775  -2.125664      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -40200   6725 
#> initial  value 998.131940 
#> iter   2 value 792.504082
#> iter   3 value 779.511942
#> iter   4 value 777.665254
#> iter   5 value 745.791488
#> iter   6 value 737.045892
#> iter   7 value 735.750623
#> iter   8 value 735.720557
#> iter   9 value 735.720510
#> iter   9 value 735.720509
#> iter   9 value 735.720509
#> final  value 735.720509 
#> converged
#> This is Run number  161 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  3.8941682 -0.09420352   3.3441682 -12.6942035      1
#> 2     1  -0.95  -2.35  0.4358084 -0.64355644  -0.5141916  -2.9935564      1
#> 3     1  -6.20  -2.30  0.8005120  1.02216237  -5.3994880  -1.2778376      2
#> 4     1 -13.90  -2.55  1.1187836  1.30594143 -12.7812164  -1.2440586      2
#> 5     1 -14.40  -5.80  1.9581834 -0.51155744 -12.4418166  -6.3115574      2
#> 6     1  -3.60  -1.70 -0.1522272  0.90016952  -3.7522272  -0.7998305      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -39575   6800 
#> initial  value 998.131940 
#> iter   2 value 802.223079
#> iter   3 value 787.609132
#> iter   4 value 784.579141
#> iter   5 value 751.191393
#> iter   6 value 742.524072
#> iter   7 value 741.233800
#> iter   8 value 741.205637
#> iter   9 value 741.205597
#> iter   9 value 741.205590
#> iter   9 value 741.205585
#> final  value 741.205585 
#> converged
#> This is Run number  162 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 0.4024772  2.2065009  -0.1475228 -10.393499      1
#> 2     1  -0.95  -2.35 1.9501775 -0.6720595   1.0001775  -3.022059      1
#> 3     1  -6.20  -2.30 2.4944470  1.1268340  -3.7055530  -1.173166      2
#> 4     1 -13.90  -2.55 1.0818204 -0.3008397 -12.8181796  -2.850840      2
#> 5     1 -14.40  -5.80 0.3670193  0.7052709 -14.0329807  -5.094729      2
#> 6     1  -3.60  -1.70 0.7669320  0.5907449  -2.8330680  -1.109255      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38400   6425 
#> initial  value 998.131940 
#> iter   2 value 821.459643
#> iter   3 value 811.235144
#> iter   4 value 809.808167
#> iter   5 value 772.414800
#> iter   6 value 763.932312
#> iter   7 value 762.433650
#> iter   8 value 762.399186
#> iter   9 value 762.399114
#> iter   9 value 762.399113
#> iter   9 value 762.399113
#> final  value 762.399113 
#> converged
#> This is Run number  163 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.8459106  0.2562057  -1.3959106 -12.34379426      1
#> 2     1  -0.95  -2.35  1.8055598 -0.2288344   0.8555598  -2.57883441      1
#> 3     1  -6.20  -2.30  1.8646730  2.2020751  -4.3353270  -0.09792495      2
#> 4     1 -13.90  -2.55  0.8799374 -0.5573151 -13.0200626  -3.10731515      2
#> 5     1 -14.40  -5.80  4.7217307  0.2221229  -9.6782693  -5.57787711      2
#> 6     1  -3.60  -1.70  0.4361255 -0.8619898  -3.1638745  -2.56198977      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39225   7050 
#> initial  value 998.131940 
#> iter   2 value 805.972527
#> iter   3 value 793.127502
#> iter   4 value 791.702106
#> iter   5 value 756.829082
#> iter   6 value 748.203899
#> iter   7 value 746.884422
#> iter   8 value 746.856053
#> iter   9 value 746.856009
#> iter  10 value 746.855998
#> iter  10 value 746.855989
#> iter  10 value 746.855983
#> final  value 746.855983 
#> converged
#> This is Run number  164 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.35174017 -0.2326349   0.8017402 -12.8326349      1
#> 2     1  -0.95  -2.35  0.04486872  0.4759409  -0.9051313  -1.8740591      1
#> 3     1  -6.20  -2.30  0.76992536  0.3174228  -5.4300746  -1.9825772      2
#> 4     1 -13.90  -2.55 -0.60627405  1.6330446 -14.5062740  -0.9169554      2
#> 5     1 -14.40  -5.80 -1.34156099 -0.7300498 -15.7415610  -6.5300498      2
#> 6     1  -3.60  -1.70  4.19109845 -0.5847035   0.5910984  -2.2847035      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7340 -40925   6625 
#> initial  value 998.131940 
#> iter   2 value 780.605962
#> iter   3 value 769.056220
#> iter   4 value 768.294039
#> iter   5 value 738.250872
#> iter   6 value 729.435459
#> iter   7 value 728.148023
#> iter   8 value 728.116321
#> iter   9 value 728.116266
#> iter  10 value 728.116255
#> iter  10 value 728.116248
#> iter  10 value 728.116241
#> final  value 728.116241 
#> converged
#> This is Run number  165 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.4828286 -0.77702401   0.9328286 -13.377024      1
#> 2     1  -0.95  -2.35 -0.1076765  0.28578178  -1.0576765  -2.064218      1
#> 3     1  -6.20  -2.30  1.5515890 -1.37701768  -4.6484110  -3.677018      2
#> 4     1 -13.90  -2.55  0.7053390  0.04244316 -13.1946610  -2.507557      2
#> 5     1 -14.40  -5.80 -0.3282014  4.34726022 -14.7282014  -1.452740      2
#> 6     1  -3.60  -1.70  1.5438018 -0.65594209  -2.0561982  -2.355942      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6600 -39450   7250 
#> initial  value 998.131940 
#> iter   2 value 801.327289
#> iter   3 value 788.069927
#> iter   4 value 786.986615
#> iter   5 value 752.732022
#> iter   6 value 744.083323
#> iter   7 value 742.808823
#> iter   8 value 742.782266
#> iter   9 value 742.782229
#> iter  10 value 742.782218
#> iter  10 value 742.782208
#> iter  10 value 742.782202
#> final  value 742.782202 
#> converged
#> This is Run number  166 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.2470518 -1.5662488   2.6970518 -14.166249      1
#> 2     1  -0.95  -2.35  1.5102476  0.5018118   0.5602476  -1.848188      1
#> 3     1  -6.20  -2.30  0.7285373 -0.9111377  -5.4714627  -3.211138      2
#> 4     1 -13.90  -2.55  1.0032664  0.5799024 -12.8967336  -1.970098      2
#> 5     1 -14.40  -5.80 -1.0072278  2.3951188 -15.4072278  -3.404881      2
#> 6     1  -3.60  -1.70 -0.5007747 -0.1459498  -4.1007747  -1.845950      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -37850   6450 
#> initial  value 998.131940 
#> iter   2 value 829.396853
#> iter   3 value 818.195621
#> iter   4 value 815.979070
#> iter   5 value 777.273101
#> iter   6 value 768.912330
#> iter   7 value 767.450212
#> iter   8 value 767.418620
#> iter   9 value 767.418560
#> iter   9 value 767.418550
#> iter   9 value 767.418544
#> final  value 767.418544 
#> converged
#> This is Run number  167 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  6.210010956  0.9690609   5.6600110 -11.6309391      1
#> 2     1  -0.95  -2.35  0.128578778  1.5716314  -0.8214212  -0.7783686      2
#> 3     1  -6.20  -2.30  4.427367559 -0.7495352  -1.7726324  -3.0495352      1
#> 4     1 -13.90  -2.55 -0.432867145  0.8710364 -14.3328671  -1.6789636      2
#> 5     1 -14.40  -5.80  0.002340605  0.9181577 -14.3976594  -4.8818423      2
#> 6     1  -3.60  -1.70 -0.442111183 -0.2147327  -4.0421112  -1.9147327      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38350   7200 
#> initial  value 998.131940 
#> iter   2 value 818.137327
#> iter   3 value 805.799048
#> iter   4 value 804.553795
#> iter   5 value 767.069334
#> iter   6 value 758.599634
#> iter   7 value 757.260562
#> iter   8 value 757.233309
#> iter   9 value 757.233267
#> iter  10 value 757.233254
#> iter  10 value 757.233244
#> iter  10 value 757.233238
#> final  value 757.233238 
#> converged
#> This is Run number  168 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.16828034 -0.19179388  -0.7182803 -12.791794      1
#> 2     1  -0.95  -2.35 -0.01768426 -0.95595519  -0.9676843  -3.305955      1
#> 3     1  -6.20  -2.30  1.07361811  0.12428209  -5.1263819  -2.175718      2
#> 4     1 -13.90  -2.55 -1.48609969  0.04991446 -15.3860997  -2.500086      2
#> 5     1 -14.40  -5.80  0.56137385  3.00713266 -13.8386262  -2.792867      2
#> 6     1  -3.60  -1.70  0.51907780 -0.28979636  -3.0809222  -1.989796      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -36425   6625 
#> initial  value 998.131940 
#> iter   2 value 847.707465
#> iter   3 value 838.185997
#> iter   4 value 836.660612
#> iter   5 value 793.887708
#> iter   6 value 785.953742
#> iter   7 value 784.537768
#> iter   8 value 784.510629
#> iter   9 value 784.510581
#> iter   9 value 784.510578
#> iter   9 value 784.510578
#> final  value 784.510578 
#> converged
#> This is Run number  169 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  4.4480199 -0.75530324   3.8980199 -13.3553032      1
#> 2     1  -0.95  -2.35  0.8271159  1.36319291  -0.1228841  -0.9868071      1
#> 3     1  -6.20  -2.30  2.9929490  5.74847339  -3.2070510   3.4484734      2
#> 4     1 -13.90  -2.55 -1.2897084  2.81034097 -15.1897084   0.2603410      2
#> 5     1 -14.40  -5.80  0.6008244  0.72731480 -13.7991756  -5.0726852      2
#> 6     1  -3.60  -1.70  0.5481241 -0.06931992  -3.0518759  -1.7693199      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7360 -39400   6650 
#> initial  value 998.131940 
#> iter   2 value 804.455522
#> iter   3 value 794.918487
#> iter   4 value 794.819545
#> iter   5 value 759.968614
#> iter   6 value 751.295296
#> iter   7 value 749.801974
#> iter   8 value 749.764962
#> iter   9 value 749.764873
#> iter  10 value 749.764854
#> iter  10 value 749.764846
#> iter  10 value 749.764837
#> final  value 749.764837 
#> converged
#> This is Run number  170 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.18507888  0.16385218  -0.3649211 -12.436148      1
#> 2     1  -0.95  -2.35  0.39011929  0.91902517  -0.5598807  -1.430975      1
#> 3     1  -6.20  -2.30  0.21859640 -0.55904567  -5.9814036  -2.859046      2
#> 4     1 -13.90  -2.55 -1.12228819 -0.38246311 -15.0222882  -2.932463      2
#> 5     1 -14.40  -5.80  0.07611045  1.03420648 -14.3238895  -4.765794      2
#> 6     1  -3.60  -1.70  0.29273584  0.03752286  -3.3072642  -1.662477      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -38725   6925 
#> initial  value 998.131940 
#> iter   2 value 814.132713
#> iter   3 value 802.258990
#> iter   4 value 800.931184
#> iter   5 value 764.520624
#> iter   6 value 755.970302
#> iter   7 value 754.592956
#> iter   8 value 754.563019
#> iter   9 value 754.562967
#> iter  10 value 754.562955
#> iter  10 value 754.562945
#> iter  10 value 754.562945
#> final  value 754.562945 
#> converged
#> This is Run number  171 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.38130658  1.0115170  -0.1686934 -11.588483      1
#> 2     1  -0.95  -2.35  0.01982722  1.2410011  -0.9301728  -1.108999      1
#> 3     1  -6.20  -2.30  0.77813010 -0.7520586  -5.4218699  -3.052059      2
#> 4     1 -13.90  -2.55  0.49137246 -0.7456776 -13.4086275  -3.295678      2
#> 5     1 -14.40  -5.80  1.00506794 -0.6362403 -13.3949321  -6.436240      2
#> 6     1  -3.60  -1.70 -0.91253799  0.1935483  -4.5125380  -1.506452      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6860 -40575   6875 
#> initial  value 998.131940 
#> iter   2 value 785.566447
#> iter   3 value 772.155593
#> iter   4 value 770.588870
#> iter   5 value 739.805612
#> iter   6 value 731.052874
#> iter   7 value 729.821595
#> iter   8 value 729.793782
#> iter   9 value 729.793744
#> iter   9 value 729.793735
#> iter   9 value 729.793729
#> final  value 729.793729 
#> converged
#> This is Run number  172 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4409470 -0.7932469  -0.99094698 -13.393247      1
#> 2     1  -0.95  -2.35  0.9145395 -0.3289082  -0.03546045  -2.678908      1
#> 3     1  -6.20  -2.30  1.1574568 -0.7803319  -5.04254318  -3.080332      2
#> 4     1 -13.90  -2.55 -0.6775352 -0.5768270 -14.57753519  -3.126827      2
#> 5     1 -14.40  -5.80  0.7977654 -0.2551995 -13.60223459  -6.055199      2
#> 6     1  -3.60  -1.70 -1.0778157  0.3826733  -4.67781574  -1.317327      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -39625   6850 
#> initial  value 998.131940 
#> iter   2 value 801.282254
#> iter   3 value 784.716401
#> iter   4 value 780.606245
#> iter   5 value 747.641999
#> iter   6 value 738.977177
#> iter   7 value 737.740404
#> iter   8 value 737.714532
#> iter   9 value 737.714500
#> iter   9 value 737.714494
#> iter   9 value 737.714490
#> final  value 737.714490 
#> converged
#> This is Run number  173 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.421346074 0.4893955   0.8713461 -12.1106045      1
#> 2     1  -0.95  -2.35  2.216092730 3.1490119   1.2660927   0.7990119      1
#> 3     1  -6.20  -2.30  1.900551535 1.4918179  -4.2994485  -0.8081821      2
#> 4     1 -13.90  -2.55  1.063080893 1.1520007 -12.8369191  -1.3979993      2
#> 5     1 -14.40  -5.80 -0.003249443 1.4609062 -14.4032494  -4.3390938      2
#> 6     1  -3.60  -1.70  1.932355926 0.7714596  -1.6676441  -0.9285404      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -37375   6250 
#> initial  value 998.131940 
#> iter   2 value 836.943545
#> iter   3 value 826.925249
#> iter   4 value 824.938504
#> iter   5 value 784.846526
#> iter   6 value 776.624489
#> iter   7 value 775.116530
#> iter   8 value 775.084256
#> iter   9 value 775.084190
#> iter   9 value 775.084180
#> iter   9 value 775.084175
#> final  value 775.084175 
#> converged
#> This is Run number  174 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.31013417 -0.2115279  -0.8601342 -12.8115279      1
#> 2     1  -0.95  -2.35 -0.53787463 -0.3893213  -1.4878746  -2.7393213      1
#> 3     1  -6.20  -2.30  0.04893292 -0.3078683  -6.1510671  -2.6078683      2
#> 4     1 -13.90  -2.55 -0.28150001  1.6459548 -14.1815000  -0.9040452      2
#> 5     1 -14.40  -5.80  1.56821981  1.8214466 -12.8317802  -3.9785534      2
#> 6     1  -3.60  -1.70 -0.35828502  2.0678416  -3.9582850   0.3678416      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -39400   7425 
#> initial  value 998.131940 
#> iter   2 value 801.411006
#> iter   3 value 785.492116
#> iter   4 value 782.999205
#> iter   5 value 749.073145
#> iter   6 value 740.496753
#> iter   7 value 739.288779
#> iter   8 value 739.265701
#> iter   9 value 739.265679
#> iter   9 value 739.265672
#> iter   9 value 739.265666
#> final  value 739.265666 
#> converged
#> This is Run number  175 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8872974  0.12341300   0.3372974 -12.4765870      1
#> 2     1  -0.95  -2.35  1.6189959  1.68494407   0.6689959  -0.6650559      1
#> 3     1  -6.20  -2.30  1.8328573 -0.34986021  -4.3671427  -2.6498602      2
#> 4     1 -13.90  -2.55  0.3975676 -0.46245576 -13.5024324  -3.0124558      2
#> 5     1 -14.40  -5.80  0.3211577 -0.06038181 -14.0788423  -5.8603818      2
#> 6     1  -3.60  -1.70 -1.0312273 -1.01319438  -4.6312273  -2.7131944      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5720 -37425   8125 
#> initial  value 998.131940 
#> iter   2 value 825.669270
#> iter   3 value 811.266908
#> iter   4 value 809.984140
#> iter   5 value 769.899215
#> iter   6 value 761.667549
#> iter   7 value 760.451298
#> iter   8 value 760.432272
#> iter   9 value 760.432257
#> iter   9 value 760.432255
#> iter  10 value 760.432241
#> iter  10 value 760.432231
#> iter  10 value 760.432231
#> final  value 760.432231 
#> converged
#> This is Run number  176 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.3745435 -0.29377364   2.8245435 -12.893774      1
#> 2     1  -0.95  -2.35 -0.5793627  0.32469731  -1.5293627  -2.025303      1
#> 3     1  -6.20  -2.30 -0.8267588 -1.55561020  -7.0267588  -3.855610      2
#> 4     1 -13.90  -2.55  1.1583074 -0.05119815 -12.7416926  -2.601198      2
#> 5     1 -14.40  -5.80  0.9096218  0.31094409 -13.4903782  -5.489056      2
#> 6     1  -3.60  -1.70  3.2312005 -0.13720072  -0.3687995  -1.837201      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6960 -40275   7050 
#> initial  value 998.131940 
#> iter   2 value 789.275549
#> iter   3 value 776.363160
#> iter   4 value 775.464621
#> iter   5 value 743.600302
#> iter   6 value 734.854965
#> iter   7 value 733.603681
#> iter   8 value 733.576007
#> iter   9 value 733.575967
#> iter  10 value 733.575956
#> iter  10 value 733.575947
#> iter  10 value 733.575940
#> final  value 733.575940 
#> converged
#> This is Run number  177 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.174721419  0.2918176   1.6247214 -12.3081824      1
#> 2     1  -0.95  -2.35  1.541069712  0.4410086   0.5910697  -1.9089914      1
#> 3     1  -6.20  -2.30 -1.090772027  1.9146486  -7.2907720  -0.3853514      2
#> 4     1 -13.90  -2.55  0.377090608 -0.9893143 -13.5229094  -3.5393143      2
#> 5     1 -14.40  -5.80 -0.919079935 -0.7391974 -15.3190799  -6.5391974      2
#> 6     1  -3.60  -1.70  0.001740311  1.1685960  -3.5982597  -0.5314040      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38825   6750 
#> initial  value 998.131940 
#> iter   2 value 813.643151
#> iter   3 value 801.736130
#> iter   4 value 800.051369
#> iter   5 value 764.017687
#> iter   6 value 755.447785
#> iter   7 value 754.051034
#> iter   8 value 754.019933
#> iter   9 value 754.019878
#> iter  10 value 754.019866
#> iter  10 value 754.019858
#> iter  10 value 754.019857
#> final  value 754.019857 
#> converged
#> This is Run number  178 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.157130763  2.14610729  -0.7071308 -10.4538927      1
#> 2     1  -0.95  -2.35 -1.577677435  0.07339648  -2.5276774  -2.2766035      2
#> 3     1  -6.20  -2.30 -0.003356045 -0.17701049  -6.2033560  -2.4770105      2
#> 4     1 -13.90  -2.55  1.337153663 -0.22073210 -12.5628463  -2.7707321      2
#> 5     1 -14.40  -5.80  1.206183765 -0.88403495 -13.1938162  -6.6840350      2
#> 6     1  -3.60  -1.70  1.164644577  2.39105834  -2.4353554   0.6910583      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -39225   7500 
#> initial  value 998.131940 
#> iter   2 value 803.573969
#> iter   3 value 788.306160
#> iter   4 value 786.339931
#> iter   5 value 751.742337
#> iter   6 value 743.178570
#> iter   7 value 741.958460
#> iter   8 value 741.935311
#> iter   9 value 741.935288
#> iter   9 value 741.935279
#> iter   9 value 741.935273
#> final  value 741.935273 
#> converged
#> This is Run number  179 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.36614924  0.3678008  -1.916149 -12.232199      1
#> 2     1  -0.95  -2.35 -0.09774777  0.4061983  -1.047748  -1.943802      1
#> 3     1  -6.20  -2.30 -1.38289196  0.1333675  -7.582892  -2.166633      2
#> 4     1 -13.90  -2.55 -0.60933313 -0.3739232 -14.509333  -2.923923      2
#> 5     1 -14.40  -5.80  1.08012001  2.0695022 -13.319880  -3.730498      2
#> 6     1  -3.60  -1.70  1.76909512 -0.6888554  -1.830905  -2.388855      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5380 -38450   8225 
#> initial  value 998.131940 
#> iter   2 value 810.608798
#> iter   3 value 791.580833
#> iter   4 value 788.319662
#> iter   5 value 751.898298
#> iter   6 value 743.572566
#> iter   7 value 742.413209
#> iter   8 value 742.395716
#> iter   8 value 742.395707
#> final  value 742.395707 
#> converged
#> This is Run number  180 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.42984402 1.15624238  -1.979844 -11.4437576      1
#> 2     1  -0.95  -2.35  0.47558499 1.25333024  -0.474415  -1.0966698      1
#> 3     1  -6.20  -2.30  0.92039109 0.23790478  -5.279609  -2.0620952      2
#> 4     1 -13.90  -2.55  0.11262462 3.27760830 -13.787375   0.7276083      2
#> 5     1 -14.40  -5.80 -0.08676749 0.61826096 -14.486767  -5.1817390      2
#> 6     1  -3.60  -1.70  0.63872769 0.04009302  -2.961272  -1.6599070      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -37675   7550 
#> initial  value 998.131940 
#> iter   2 value 825.792327
#> iter   3 value 812.538935
#> iter   4 value 810.995136
#> iter   5 value 771.683888
#> iter   6 value 763.380591
#> iter   7 value 762.092411
#> iter   8 value 762.069000
#> iter   9 value 762.068970
#> iter   9 value 762.068959
#> iter   9 value 762.068953
#> final  value 762.068953 
#> converged
#> This is Run number  181 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2           U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5501851 -1.44881516  1.851489e-04 -14.048815      1
#> 2     1  -0.95  -2.35 -0.9403997  2.01401200 -1.890400e+00  -0.335988      2
#> 3     1  -6.20  -2.30  3.2561479  0.02313325 -2.943852e+00  -2.276867      2
#> 4     1 -13.90  -2.55 -0.6795747  0.93851184 -1.457957e+01  -1.611488      2
#> 5     1 -14.40  -5.80  3.2273245  2.75636301 -1.117268e+01  -3.043637      2
#> 6     1  -3.60  -1.70  1.3287723  0.62510498 -2.271228e+00  -1.074895      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -37525   7050 
#> initial  value 998.131940 
#> iter   2 value 830.623869
#> iter   3 value 819.786132
#> iter   4 value 818.726984
#> iter   5 value 778.803378
#> iter   6 value 770.524132
#> iter   7 value 769.135738
#> iter   8 value 769.107769
#> iter   9 value 769.107721
#> iter  10 value 769.107707
#> iter  10 value 769.107696
#> iter  10 value 769.107692
#> final  value 769.107692 
#> converged
#> This is Run number  182 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.3877798  1.5985972   0.8377798 -11.0014028      1
#> 2     1  -0.95  -2.35 -0.7188988 -0.9631932  -1.6688988  -3.3131932      1
#> 3     1  -6.20  -2.30  0.9125603 -0.1913886  -5.2874397  -2.4913886      2
#> 4     1 -13.90  -2.55  2.4980210 -1.3445891 -11.4019790  -3.8945891      2
#> 5     1 -14.40  -5.80 -1.2407653  0.8945358 -15.6407653  -4.9054642      2
#> 6     1  -3.60  -1.70  2.6447546  1.3720081  -0.9552454  -0.3279919      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -39350   7025 
#> initial  value 998.131940 
#> iter   2 value 804.029515
#> iter   3 value 791.861529
#> iter   4 value 790.907386
#> iter   5 value 756.253960
#> iter   6 value 747.596710
#> iter   7 value 746.261089
#> iter   8 value 746.231653
#> iter   9 value 746.231605
#> iter  10 value 746.231591
#> iter  10 value 746.231582
#> iter  10 value 746.231575
#> final  value 746.231575 
#> converged
#> This is Run number  183 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.80651529 -0.8156940   0.2565153 -13.415694      1
#> 2     1  -0.95  -2.35 -0.06376154  0.9184796  -1.0137615  -1.431520      1
#> 3     1  -6.20  -2.30 -0.16201991  0.3479954  -6.3620199  -1.952005      2
#> 4     1 -13.90  -2.55 -0.34846009  0.1217536 -14.2484601  -2.428246      2
#> 5     1 -14.40  -5.80 -0.63207541 -0.3123931 -15.0320754  -6.112393      2
#> 6     1  -3.60  -1.70  1.88403816  2.0195630  -1.7159618   0.319563      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -37550   6825 
#> initial  value 998.131940 
#> iter   2 value 831.441654
#> iter   3 value 821.382124
#> iter   4 value 820.418177
#> iter   5 value 780.517258
#> iter   6 value 772.236743
#> iter   7 value 770.800043
#> iter   8 value 770.769984
#> iter   9 value 770.769926
#> iter  10 value 770.769912
#> iter  10 value 770.769902
#> iter  10 value 770.769895
#> final  value 770.769895 
#> converged
#> This is Run number  184 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5336898  0.01430224  -1.0836898 -12.585698      1
#> 2     1  -0.95  -2.35  0.5064921 -0.80267268  -0.4435079  -3.152673      1
#> 3     1  -6.20  -2.30  0.7161820  0.93388315  -5.4838180  -1.366117      2
#> 4     1 -13.90  -2.55  1.8915819 -0.08514197 -12.0084181  -2.635142      2
#> 5     1 -14.40  -5.80  6.7373003  0.54983778  -7.6626997  -5.250162      2
#> 6     1  -3.60  -1.70 -0.7919913 -0.13593672  -4.3919913  -1.835937      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -39750   6125 
#> initial  value 998.131940 
#> iter   2 value 802.582106
#> iter   3 value 791.516142
#> iter   4 value 789.415144
#> iter   5 value 756.164762
#> iter   6 value 747.435155
#> iter   7 value 745.952436
#> iter   8 value 745.914516
#> iter   9 value 745.914429
#> iter   9 value 745.914418
#> iter   9 value 745.914411
#> final  value 745.914411 
#> converged
#> This is Run number  185 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  1.15265139  2.2761791   0.6026514 -10.32382089      1
#> 2     1  -0.95  -2.35 -0.30652863 -0.3118787  -1.2565286  -2.66187870      1
#> 3     1  -6.20  -2.30 -0.41694314  1.1836174  -6.6169431  -1.11638259      2
#> 4     1 -13.90  -2.55  0.41632608  2.6217143 -13.4836739   0.07171428      2
#> 5     1 -14.40  -5.80 -0.03841894  1.2841927 -14.4384189  -4.51580730      2
#> 6     1  -3.60  -1.70 -0.50718130 -0.5421385  -4.1071813  -2.24213851      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -37575   6500 
#> initial  value 998.131940 
#> iter   2 value 832.782799
#> iter   3 value 823.351503
#> iter   4 value 822.216163
#> iter   5 value 782.414388
#> iter   6 value 774.140895
#> iter   7 value 772.643795
#> iter   8 value 772.611360
#> iter   9 value 772.611293
#> iter   9 value 772.611291
#> iter   9 value 772.611291
#> final  value 772.611291 
#> converged
#> This is Run number  186 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.31849409 -1.1475188  -0.2315059 -13.7475188      1
#> 2     1  -0.95  -2.35 -0.22081305  1.6985502  -1.1708130  -0.6514498      2
#> 3     1  -6.20  -2.30  0.05877666  0.1210087  -6.1412233  -2.1789913      2
#> 4     1 -13.90  -2.55  0.40693132 -0.3927151 -13.4930687  -2.9427151      2
#> 5     1 -14.40  -5.80  0.83378602  0.9974509 -13.5662140  -4.8025491      2
#> 6     1  -3.60  -1.70  2.03295389  0.9473908  -1.5670461  -0.7526092      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -37500   6275 
#> initial  value 998.131940 
#> iter   2 value 834.726166
#> iter   3 value 826.636796
#> iter   4 value 825.947470
#> iter   5 value 785.782981
#> iter   6 value 777.551282
#> iter   7 value 775.976183
#> iter   8 value 775.941005
#> iter   9 value 775.940921
#> iter   9 value 775.940919
#> iter   9 value 775.940919
#> final  value 775.940919 
#> converged
#> This is Run number  187 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1768436 -0.4033544   0.6268436 -13.0033544      1
#> 2     1  -0.95  -2.35  1.7434304  3.3584012   0.7934304   1.0084012      2
#> 3     1  -6.20  -2.30  0.4410919 -0.9225754  -5.7589081  -3.2225754      2
#> 4     1 -13.90  -2.55  0.9139621 -0.4707154 -12.9860379  -3.0207154      2
#> 5     1 -14.40  -5.80  1.8159705 -0.3670249 -12.5840295  -6.1670249      2
#> 6     1  -3.60  -1.70 -0.1686814  2.1369949  -3.7686814   0.4369949      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -37975   6525 
#> initial  value 998.131940 
#> iter   2 value 827.122648
#> iter   3 value 816.774891
#> iter   4 value 815.272899
#> iter   5 value 776.706030
#> iter   6 value 768.322593
#> iter   7 value 766.846473
#> iter   8 value 766.813985
#> iter   9 value 766.813920
#> iter   9 value 766.813920
#> iter   9 value 766.813920
#> final  value 766.813920 
#> converged
#> This is Run number  188 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.0338425  0.8205150   1.483843 -11.7794850      1
#> 2     1  -0.95  -2.35 -0.8180443 -0.8602384  -1.768044  -3.2102384      1
#> 3     1  -6.20  -2.30  0.6849739 -0.3229602  -5.515026  -2.6229602      2
#> 4     1 -13.90  -2.55  0.3239195  1.8556292 -13.576080  -0.6943708      2
#> 5     1 -14.40  -5.80 -0.7300829 -0.2151003 -15.130083  -6.0151003      2
#> 6     1  -3.60  -1.70  1.4884202 -0.5213997  -2.111580  -2.2213997      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5840 -36775   6075 
#> initial  value 998.131940 
#> iter   2 value 845.878251
#> iter   3 value 836.328672
#> iter   4 value 834.205564
#> iter   5 value 792.548050
#> iter   6 value 784.507969
#> iter   7 value 782.994471
#> iter   8 value 782.963394
#> iter   9 value 782.963331
#> iter   9 value 782.963321
#> iter   9 value 782.963317
#> final  value 782.963317 
#> converged
#> This is Run number  189 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4316206  2.0186043  -0.9816206 -10.581396      1
#> 2     1  -0.95  -2.35 -0.9205920  0.9624501  -1.8705920  -1.387550      2
#> 3     1  -6.20  -2.30 -1.0869945  0.3877159  -7.2869945  -1.912284      2
#> 4     1 -13.90  -2.55  2.7058583  1.2630219 -11.1941417  -1.286978      2
#> 5     1 -14.40  -5.80 -0.1632859 -0.3171861 -14.5632859  -6.117186      2
#> 6     1  -3.60  -1.70  0.7129282  0.3385117  -2.8870718  -1.361488      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -38400   6275 
#> initial  value 998.131940 
#> iter   2 value 822.177848
#> iter   3 value 812.347784
#> iter   4 value 810.892362
#> iter   5 value 773.494169
#> iter   6 value 765.015975
#> iter   7 value 763.480907
#> iter   8 value 763.444953
#> iter   9 value 763.444873
#> iter  10 value 763.444861
#> iter  10 value 763.444854
#> iter  10 value 763.444851
#> final  value 763.444851 
#> converged
#> This is Run number  190 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8669391  1.2829662   0.3169391 -11.3170338      1
#> 2     1  -0.95  -2.35 -0.4963417  1.0327632  -1.4463417  -1.3172368      2
#> 3     1  -6.20  -2.30 -0.1639651  2.4129229  -6.3639651   0.1129229      2
#> 4     1 -13.90  -2.55  2.1850226 -0.4910186 -11.7149774  -3.0410186      2
#> 5     1 -14.40  -5.80  0.4407121  0.6021247 -13.9592879  -5.1978753      2
#> 6     1  -3.60  -1.70  1.5326628  2.8870041  -2.0673372   1.1870041      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7420 -40625   4875 
#> initial  value 998.131940 
#> iter   2 value 793.259227
#> iter   3 value 785.481207
#> iter   4 value 783.382954
#> iter   5 value 752.757599
#> iter   6 value 744.010708
#> iter   7 value 742.141658
#> iter   8 value 742.079824
#> iter   9 value 742.079515
#> iter  10 value 742.079487
#> iter  10 value 742.079486
#> iter  11 value 742.079468
#> iter  11 value 742.079462
#> iter  11 value 742.079459
#> final  value 742.079459 
#> converged
#> This is Run number  191 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.04740747 -0.21692241  -0.5974075 -12.81692241      1
#> 2     1  -0.95  -2.35  1.50952731 -0.55648315   0.5595273  -2.90648315      1
#> 3     1  -6.20  -2.30  0.59228059 -0.18472714  -5.6077194  -2.48472714      2
#> 4     1 -13.90  -2.55  0.69356433  0.02821362 -13.2064357  -2.52178638      2
#> 5     1 -14.40  -5.80 -0.15262047  1.87286297 -14.5526205  -3.92713703      2
#> 6     1  -3.60  -1.70  0.38306370  1.61245394  -3.2169363  -0.08754606      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -38250   6925 
#> initial  value 998.131940 
#> iter   2 value 821.246532
#> iter   3 value 808.446353
#> iter   4 value 806.263232
#> iter   5 value 768.732781
#> iter   6 value 760.285536
#> iter   7 value 758.922635
#> iter   8 value 758.894445
#> iter   9 value 758.894402
#> iter   9 value 758.894392
#> iter   9 value 758.894386
#> final  value 758.894386 
#> converged
#> This is Run number  192 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.77438849  0.3426618   2.224388 -12.257338      1
#> 2     1  -0.95  -2.35  3.31776593  0.4104071   2.367766  -1.939593      1
#> 3     1  -6.20  -2.30 -0.01538850 -1.3005204  -6.215388  -3.600520      2
#> 4     1 -13.90  -2.55  0.05183684 -1.0913297 -13.848163  -3.641330      2
#> 5     1 -14.40  -5.80 -0.54034107  0.2902806 -14.940341  -5.509719      2
#> 6     1  -3.60  -1.70  1.39107077 -0.6858458  -2.208929  -2.385846      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6440 -38950   5975 
#> initial  value 998.131940 
#> iter   2 value 815.636264
#> iter   3 value 804.901308
#> iter   4 value 802.500386
#> iter   5 value 766.969640
#> iter   6 value 758.365476
#> iter   7 value 756.809996
#> iter   8 value 756.771283
#> iter   9 value 756.771187
#> iter  10 value 756.771175
#> iter  10 value 756.771175
#> iter  10 value 756.771170
#> final  value 756.771170 
#> converged
#> This is Run number  193 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60  2.23681938  4.23561905   1.6868194 -8.364381      1
#> 2     1  -0.95  -2.35  0.62215365 -0.08347456  -0.3278463 -2.433475      1
#> 3     1  -6.20  -2.30  3.33367967 -0.82596626  -2.8663203 -3.125966      1
#> 4     1 -13.90  -2.55 -0.60050490  1.25185987 -14.5005049 -1.298140      2
#> 5     1 -14.40  -5.80 -1.04581477 -0.79087053 -15.4458148 -6.590871      2
#> 6     1  -3.60  -1.70  0.04483899 -0.13272195  -3.5551610 -1.832722      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -38450   6875 
#> initial  value 998.131940 
#> iter   2 value 818.718002
#> iter   3 value 803.697893
#> iter   4 value 800.168359
#> iter   5 value 763.562357
#> iter   6 value 755.061158
#> iter   7 value 753.740804
#> iter   8 value 753.714085
#> iter   9 value 753.714049
#> iter   9 value 753.714041
#> iter   9 value 753.714036
#> final  value 753.714036 
#> converged
#> This is Run number  194 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2685430 -0.4870776  -0.8185430 -13.087078      1
#> 2     1  -0.95  -2.35  0.8251384  0.2982941  -0.1248616  -2.051706      1
#> 3     1  -6.20  -2.30 -0.4028685  0.1790501  -6.6028685  -2.120950      2
#> 4     1 -13.90  -2.55  0.2935466 -1.3087466 -13.6064534  -3.858747      2
#> 5     1 -14.40  -5.80  0.5960075  2.7431325 -13.8039925  -3.056868      2
#> 6     1  -3.60  -1.70  0.5781135  1.4689670  -3.0218865  -0.231033      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6960 -41000   6825 
#> initial  value 998.131940 
#> iter   2 value 778.809209
#> iter   3 value 765.158628
#> iter   4 value 763.484505
#> iter   5 value 734.027050
#> iter   6 value 725.271131
#> iter   7 value 724.083866
#> iter   8 value 724.056948
#> iter   9 value 724.056913
#> iter   9 value 724.056912
#> iter   9 value 724.056912
#> final  value 724.056912 
#> converged
#> This is Run number  195 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.8492848 -0.53395365   2.2992848 -13.1339536      1
#> 2     1  -0.95  -2.35  0.3839092  1.63353669  -0.5660908  -0.7164633      1
#> 3     1  -6.20  -2.30 -0.5999922 -0.02843212  -6.7999922  -2.3284321      2
#> 4     1 -13.90  -2.55 -0.1481716 -1.16700661 -14.0481716  -3.7170066      2
#> 5     1 -14.40  -5.80 -0.1826396  0.62942178 -14.5826396  -5.1705782      2
#> 6     1  -3.60  -1.70 -0.3461750  0.92165860  -3.9461750  -0.7783414      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6920 -38300   7675 
#> initial  value 998.131940 
#> iter   2 value 815.378508
#> iter   3 value 803.595570
#> iter   4 value 803.587425
#> iter   5 value 765.383725
#> iter   6 value 757.202761
#> iter   7 value 755.994848
#> iter   8 value 755.973212
#> iter   9 value 755.973177
#> iter   9 value 755.973170
#> iter   9 value 755.973160
#> final  value 755.973160 
#> converged
#> This is Run number  196 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2584187  1.27538370  -0.2915813 -11.3246163      1
#> 2     1  -0.95  -2.35 -1.1944636  1.60267970  -2.1444636  -0.7473203      2
#> 3     1  -6.20  -2.30  0.3963088  0.04613938  -5.8036912  -2.2538606      2
#> 4     1 -13.90  -2.55  1.2945879 -1.05373477 -12.6054121  -3.6037348      2
#> 5     1 -14.40  -5.80  0.7435609  1.86424057 -13.6564391  -3.9357594      2
#> 6     1  -3.60  -1.70 -0.7769179  0.82060087  -4.3769179  -0.8793991      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6860 -40000   6125 
#> initial  value 998.131940 
#> iter   2 value 798.553892
#> iter   3 value 787.687845
#> iter   4 value 785.804415
#> iter   5 value 753.230464
#> iter   6 value 744.470930
#> iter   7 value 742.997792
#> iter   8 value 742.959543
#> iter   9 value 742.959455
#> iter   9 value 742.959444
#> iter   9 value 742.959437
#> final  value 742.959437 
#> converged
#> This is Run number  197 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1795092  0.1768442   0.6295092 -12.4231558      1
#> 2     1  -0.95  -2.35  0.4985522  2.6045716  -0.4514478   0.2545716      2
#> 3     1  -6.20  -2.30 -1.2315964  0.9454194  -7.4315964  -1.3545806      2
#> 4     1 -13.90  -2.55 -0.3435481  1.3788827 -14.2435481  -1.1711173      2
#> 5     1 -14.40  -5.80  3.7034150 -0.3254818 -10.6965850  -6.1254818      2
#> 6     1  -3.60  -1.70  2.0566962  3.7886589  -1.5433038   2.0886589      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6820 -40725   7125 
#> initial  value 998.131940 
#> iter   2 value 781.788472
#> iter   3 value 767.303168
#> iter   4 value 765.751687
#> iter   5 value 735.496737
#> iter   6 value 726.782344
#> iter   7 value 725.620422
#> iter   8 value 725.595971
#> iter   9 value 725.595944
#> iter   9 value 725.595937
#> iter   9 value 725.595936
#> final  value 725.595936 
#> converged
#> This is Run number  198 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.676615 -0.4508708   2.1266146 -13.050871      1
#> 2     1  -0.95  -2.35  1.159416 -0.5837382   0.2094159  -2.933738      1
#> 3     1  -6.20  -2.30  1.261371 -0.7553756  -4.9386295  -3.055376      2
#> 4     1 -13.90  -2.55  2.460986 -0.4025537 -11.4390143  -2.952554      2
#> 5     1 -14.40  -5.80  0.898933  2.3905539 -13.5010670  -3.409446      2
#> 6     1  -3.60  -1.70 -1.191725  0.2209825  -4.7917249  -1.479018      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6640 -40000   7100 
#> initial  value 998.131940 
#> iter   2 value 793.663299
#> iter   3 value 779.872106
#> iter   4 value 778.346302
#> iter   5 value 745.856404
#> iter   6 value 737.157314
#> iter   7 value 735.913605
#> iter   8 value 735.886988
#> iter   9 value 735.886953
#> iter   9 value 735.886943
#> iter   9 value 735.886936
#> final  value 735.886936 
#> converged
#> This is Run number  199 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5658026  0.1511926  -1.11580255 -12.4488074      1
#> 2     1  -0.95  -2.35  0.8758248  1.6622111  -0.07417522  -0.6877889      1
#> 3     1  -6.20  -2.30 -0.1747381  1.3247372  -6.37473815  -0.9752628      2
#> 4     1 -13.90  -2.55 -0.6417134  1.1229533 -14.54171342  -1.4270467      2
#> 5     1 -14.40  -5.80  1.6665734 -0.2648074 -12.73342657  -6.0648074      2
#> 6     1  -3.60  -1.70 -0.2353709  0.8166244  -3.83537086  -0.8833756      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -39625   6575 
#> initial  value 998.131940 
#> iter   2 value 802.556116
#> iter   3 value 789.091674
#> iter   4 value 786.330848
#> iter   5 value 752.974064
#> iter   6 value 744.278695
#> iter   7 value 742.933661
#> iter   8 value 742.902636
#> iter   9 value 742.902584
#> iter   9 value 742.902575
#> iter   9 value 742.902570
#> final  value 742.902570 
#> converged
#> This is Run number  200 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.74858405 -0.5936579   0.1985841 -13.19365786      1
#> 2     1  -0.95  -2.35 -0.50898491  0.2072589  -1.4589849  -2.14274111      1
#> 3     1  -6.20  -2.30  2.07503380  3.9442964  -4.1249662   1.64429640      2
#> 4     1 -13.90  -2.55 -0.08858795  2.1107706 -13.9885880  -0.43922944      2
#> 5     1 -14.40  -5.80  0.76113817 -0.5174640 -13.6388618  -6.31746397      2
#> 6     1  -3.60  -1.70 -0.70785248  1.7888556  -4.3078525   0.08885562      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5920 -38250   7125 
#> initial  value 998.131940 
#> iter   2 value 820.162332
#> iter   3 value 806.641201
#> iter   4 value 804.398536
#> iter   5 value 766.912473
#> iter   6 value 758.474755
#> iter   7 value 757.149550
#> iter   8 value 757.123155
#> iter   9 value 757.123118
#> iter   9 value 757.123108
#> iter   9 value 757.123102
#> final  value 757.123102 
#> converged
#> This is Run number  201 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2           U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7083281 -0.23988548 -1.258328e+00 -12.839885      1
#> 2     1  -0.95  -2.35  0.9506646 -0.50004482  6.645586e-04  -2.850045      1
#> 3     1  -6.20  -2.30 -0.1447649 -0.03361594 -6.344765e+00  -2.333616      2
#> 4     1 -13.90  -2.55  5.9692551 -1.35843711 -7.930745e+00  -3.908437      2
#> 5     1 -14.40  -5.80 -0.6342011  2.02312797 -1.503420e+01  -3.776872      2
#> 6     1  -3.60  -1.70 -0.3238174 -0.69004692 -3.923817e+00  -2.390047      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6820 -39875   5950 
#> initial  value 998.131940 
#> iter   2 value 801.375294
#> iter   3 value 790.814640
#> iter   4 value 788.724097
#> iter   5 value 755.826632
#> iter   6 value 747.081158
#> iter   7 value 745.554604
#> iter   8 value 745.514137
#> iter   9 value 745.514034
#> iter  10 value 745.514022
#> iter  10 value 745.514022
#> iter  10 value 745.514016
#> final  value 745.514016 
#> converged
#> This is Run number  202 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5697809 -0.7909869   0.01978094 -13.3909869      1
#> 2     1  -0.95  -2.35  2.4273928  1.6648303   1.47739277  -0.6851697      1
#> 3     1  -6.20  -2.30  1.4611589  0.3452577  -4.73884110  -1.9547423      2
#> 4     1 -13.90  -2.55 -0.8986482  0.3966028 -14.79864816  -2.1533972      2
#> 5     1 -14.40  -5.80 -1.2740867  0.3010369 -15.67408671  -5.4989631      2
#> 6     1  -3.60  -1.70  1.5582558 -1.1247511  -2.04174419  -2.8247511      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -37450   6125 
#> initial  value 998.131940 
#> iter   2 value 836.231956
#> iter   3 value 828.120323
#> iter   4 value 827.144406
#> iter   5 value 786.934084
#> iter   6 value 778.723677
#> iter   7 value 777.133218
#> iter   8 value 777.097716
#> iter   9 value 777.097631
#> iter   9 value 777.097630
#> iter   9 value 777.097630
#> final  value 777.097630 
#> converged
#> This is Run number  203 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.97575981  1.77107368  -1.525760 -10.828926      1
#> 2     1  -0.95  -2.35 -0.47955729 -0.02563109  -1.429557  -2.375631      1
#> 3     1  -6.20  -2.30 -0.11500065  0.24392994  -6.315001  -2.056070      2
#> 4     1 -13.90  -2.55 -0.32306038  1.25897720 -14.223060  -1.291023      2
#> 5     1 -14.40  -5.80  0.07754566 -0.51699646 -14.322454  -6.316996      2
#> 6     1  -3.60  -1.70 -1.26012197 -0.26795801  -4.860122  -1.967958      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5540 -37525   7425 
#> initial  value 998.131940 
#> iter   2 value 828.662301
#> iter   3 value 814.421967
#> iter   4 value 811.902972
#> iter   5 value 772.426458
#> iter   6 value 764.166167
#> iter   7 value 762.877585
#> iter   8 value 762.854421
#> iter   9 value 762.854394
#> iter   9 value 762.854384
#> iter   9 value 762.854379
#> final  value 762.854379 
#> converged
#> This is Run number  204 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.82756837  0.9945737   2.2775684 -11.605426      1
#> 2     1  -0.95  -2.35  0.02854267 -0.2602364  -0.9214573  -2.610236      1
#> 3     1  -6.20  -2.30  0.98715561  1.1569931  -5.2128444  -1.143007      2
#> 4     1 -13.90  -2.55  0.03342283  1.0614358 -13.8665772  -1.488564      2
#> 5     1 -14.40  -5.80 -0.01490610 -0.1229999 -14.4149061  -5.923000      2
#> 6     1  -3.60  -1.70  3.19890631  0.3938729  -0.4010937  -1.306127      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5640 -36900   7025 
#> initial  value 998.131940 
#> iter   2 value 839.381554
#> iter   3 value 827.670726
#> iter   4 value 825.665146
#> iter   5 value 784.278678
#> iter   6 value 776.177329
#> iter   7 value 774.822840
#> iter   8 value 774.797450
#> iter   9 value 774.797412
#> iter   9 value 774.797401
#> iter   9 value 774.797396
#> final  value 774.797396 
#> converged
#> This is Run number  205 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6653152  0.2775223  -1.215315 -12.322478      1
#> 2     1  -0.95  -2.35 -0.3506892  0.9136511  -1.300689  -1.436349      1
#> 3     1  -6.20  -2.30 -0.3339382  4.8395650  -6.533938   2.539565      2
#> 4     1 -13.90  -2.55  0.6295637  1.0879722 -13.270436  -1.462028      2
#> 5     1 -14.40  -5.80 -0.4716169 -0.4118703 -14.871617  -6.211870      2
#> 6     1  -3.60  -1.70  0.1401795 -1.1066294  -3.459821  -2.806629      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -38450   6425 
#> initial  value 998.131940 
#> iter   2 value 820.500551
#> iter   3 value 811.148662
#> iter   4 value 810.325943
#> iter   5 value 772.873807
#> iter   6 value 764.382310
#> iter   7 value 762.850214
#> iter   8 value 762.814215
#> iter   9 value 762.814132
#> iter  10 value 762.814118
#> iter  10 value 762.814109
#> iter  10 value 762.814105
#> final  value 762.814105 
#> converged
#> This is Run number  206 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.00562084  1.3004540   0.4556208 -11.299546      1
#> 2     1  -0.95  -2.35  1.35113052  0.5180916   0.4011305  -1.831908      1
#> 3     1  -6.20  -2.30  0.69321991  0.2222753  -5.5067801  -2.077725      2
#> 4     1 -13.90  -2.55 -0.53267292 -0.1220737 -14.4326729  -2.672074      2
#> 5     1 -14.40  -5.80  2.19095060  0.5133671 -12.2090494  -5.286633      2
#> 6     1  -3.60  -1.70 -0.01871406  0.5301702  -3.6187141  -1.169830      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6640 -38975   8000 
#> initial  value 998.131940 
#> iter   2 value 803.832796
#> iter   3 value 789.484828
#> iter   4 value 789.203618
#> iter   5 value 753.507337
#> iter   6 value 744.940445
#> iter   7 value 743.754970
#> iter   8 value 743.734896
#> iter   9 value 743.734873
#> iter   9 value 743.734867
#> iter   9 value 743.734863
#> final  value 743.734863 
#> converged
#> This is Run number  207 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  1.79827061 -1.0301249   1.248271 -13.63012489      1
#> 2     1  -0.95  -2.35 -0.70996696  1.7787087  -1.659967  -0.57129125      2
#> 3     1  -6.20  -2.30 -0.69222404  0.1297352  -6.892224  -2.17026482      2
#> 4     1 -13.90  -2.55  1.28727624  2.4872409 -12.612724  -0.06275913      2
#> 5     1 -14.40  -5.80 -0.85938065 -0.8659836 -15.259381  -6.66598355      2
#> 6     1  -3.60  -1.70  0.09647942 -0.4644043  -3.503521  -2.16440430      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5460 -39225   7775 
#> initial  value 998.131940 
#> iter   2 value 802.031969
#> iter   3 value 782.092187
#> iter   4 value 777.723227
#> iter   5 value 743.861703
#> iter   6 value 735.404082
#> iter   7 value 734.264279
#> iter   8 value 734.245285
#> iter   8 value 734.245277
#> final  value 734.245277 
#> converged
#> This is Run number  208 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.474340733  1.7911282  -0.07565927 -10.8088718      1
#> 2     1  -0.95  -2.35 -0.556423489  2.9628059  -1.50642349   0.6128059      2
#> 3     1  -6.20  -2.30 -1.296550267  0.3542291  -7.49655027  -1.9457709      2
#> 4     1 -13.90  -2.55 -0.832512501  0.1800411 -14.73251250  -2.3699589      2
#> 5     1 -14.40  -5.80  0.008062101 -0.1892226 -14.39193790  -5.9892226      2
#> 6     1  -3.60  -1.70  0.300677695 -0.3856469  -3.29932230  -2.0856469      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7160 -38275   5350 
#> initial  value 998.131940 
#> iter   2 value 827.439670
#> iter   3 value 821.366945
#> iter   4 value 820.756337
#> iter   5 value 782.650249
#> iter   6 value 774.309125
#> iter   7 value 772.441022
#> iter   8 value 772.393038
#> iter   9 value 772.392877
#> iter  10 value 772.392863
#> iter  10 value 772.392863
#> iter  10 value 772.392859
#> final  value 772.392859 
#> converged
#> This is Run number  209 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8225040 -0.1780247   0.272504 -12.7780247      1
#> 2     1  -0.95  -2.35  2.0999462  1.6790221   1.149946  -0.6709779      1
#> 3     1  -6.20  -2.30  1.2541799  3.1807898  -4.945820   0.8807898      2
#> 4     1 -13.90  -2.55 -1.1655911  0.1878590 -15.065591  -2.3621410      2
#> 5     1 -14.40  -5.80 -0.5826035  1.2253266 -14.982604  -4.5746734      2
#> 6     1  -3.60  -1.70  1.6363569  0.9918696  -1.963643  -0.7081304      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -38725   7000 
#> initial  value 998.131940 
#> iter   2 value 813.924157
#> iter   3 value 800.358844
#> iter   4 value 798.069634
#> iter   5 value 761.970917
#> iter   6 value 753.435851
#> iter   7 value 752.107717
#> iter   8 value 752.080088
#> iter   9 value 752.080048
#> iter   9 value 752.080038
#> iter   9 value 752.080032
#> final  value 752.080032 
#> converged
#> This is Run number  210 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0804471  1.6148739  -1.6304471 -10.9851261      1
#> 2     1  -0.95  -2.35  1.7314486  0.4688926   0.7814486  -1.8811074      1
#> 3     1  -6.20  -2.30  1.5239115  0.2387191  -4.6760885  -2.0612809      2
#> 4     1 -13.90  -2.55 -0.5629955  1.8695882 -14.4629955  -0.6804118      2
#> 5     1 -14.40  -5.80 -0.1106001 -0.1239423 -14.5106001  -5.9239423      2
#> 6     1  -3.60  -1.70  0.8496519 -0.3173498  -2.7503481  -2.0173498      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38525   5900 
#> initial  value 998.131940 
#> iter   2 value 822.255128
#> iter   3 value 812.118377
#> iter   4 value 809.853369
#> iter   5 value 773.052328
#> iter   6 value 764.541898
#> iter   7 value 762.948070
#> iter   8 value 762.909123
#> iter   9 value 762.909023
#> iter  10 value 762.909011
#> iter  10 value 762.909011
#> iter  10 value 762.909006
#> final  value 762.909006 
#> converged
#> This is Run number  211 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7381860  2.3702811  -1.288186 -10.229719      1
#> 2     1  -0.95  -2.35 -1.0710475 -0.3180330  -2.021048  -2.668033      1
#> 3     1  -6.20  -2.30 -0.1021724  0.1380649  -6.302172  -2.161935      2
#> 4     1 -13.90  -2.55  3.2012258  1.2632025 -10.698774  -1.286798      2
#> 5     1 -14.40  -5.80  0.3240949 -0.5851632 -14.075905  -6.385163      2
#> 6     1  -3.60  -1.70 -0.6865354 -1.2800631  -4.286535  -2.980063      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5640 -38125   7800 
#> initial  value 998.131940 
#> iter   2 value 817.997227
#> iter   3 value 802.145859
#> iter   4 value 799.752160
#> iter   5 value 762.038148
#> iter   6 value 753.679818
#> iter   7 value 752.452537
#> iter   8 value 752.431655
#> iter   9 value 752.431635
#> iter   9 value 752.431629
#> iter   9 value 752.431629
#> final  value 752.431629 
#> converged
#> This is Run number  212 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5518995  0.7412249  -1.101900 -11.858775      1
#> 2     1  -0.95  -2.35 -1.2393277 -0.3694231  -2.189328  -2.719423      1
#> 3     1  -6.20  -2.30  2.7140459  0.6899771  -3.485954  -1.610023      2
#> 4     1 -13.90  -2.55  0.5622765  0.9551819 -13.337723  -1.594818      2
#> 5     1 -14.40  -5.80 -0.3327129 -0.1355594 -14.732713  -5.935559      2
#> 6     1  -3.60  -1.70  0.3038434 -1.2381983  -3.296157  -2.938198      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39400   5850 
#> initial  value 998.131940 
#> iter   2 value 809.433833
#> iter   3 value 798.150084
#> iter   4 value 795.306960
#> iter   5 value 761.213008
#> iter   6 value 752.519260
#> iter   7 value 750.971687
#> iter   8 value 750.931472
#> iter   9 value 750.931362
#> iter  10 value 750.931350
#> iter  10 value 750.931349
#> iter  10 value 750.931343
#> final  value 750.931343 
#> converged
#> This is Run number  213 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8397235 0.8683139   0.2897235 -11.7316861      1
#> 2     1  -0.95  -2.35 -0.5890346 0.9158195  -1.5390346  -1.4341805      2
#> 3     1  -6.20  -2.30  2.0217331 0.8086952  -4.1782669  -1.4913048      2
#> 4     1 -13.90  -2.55 -1.1671817 0.2152469 -15.0671817  -2.3347531      2
#> 5     1 -14.40  -5.80  0.6411148 0.3520927 -13.7588852  -5.4479073      2
#> 6     1  -3.60  -1.70  0.1473700 1.2898364  -3.4526300  -0.4101636      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5560 -35925   6275 
#> initial  value 998.131940 
#> iter   2 value 855.875285
#> iter   3 value 846.557284
#> iter   4 value 844.541095
#> iter   5 value 800.651093
#> iter   6 value 792.889076
#> iter   7 value 791.466039
#> iter   8 value 791.439678
#> iter   9 value 791.439632
#> iter   9 value 791.439631
#> iter   9 value 791.439631
#> final  value 791.439631 
#> converged
#> This is Run number  214 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5880903  1.72894066   0.03809032 -10.871059      1
#> 2     1  -0.95  -2.35 -1.3183744  0.02608701  -2.26837443  -2.323913      1
#> 3     1  -6.20  -2.30 -0.5867485 -0.76564477  -6.78674846  -3.065645      2
#> 4     1 -13.90  -2.55  2.5043098  0.68273099 -11.39569015  -1.867269      2
#> 5     1 -14.40  -5.80  3.0882450 -1.53274335 -11.31175496  -7.332743      2
#> 6     1  -3.60  -1.70 -1.2458252 -0.81017421  -4.84582520  -2.510174      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -38750   7775 
#> initial  value 998.131940 
#> iter   2 value 808.808801
#> iter   3 value 794.775476
#> iter   4 value 794.006426
#> iter   5 value 757.686181
#> iter   6 value 749.161460
#> iter   7 value 747.932226
#> iter   8 value 747.910021
#> iter   9 value 747.909995
#> iter   9 value 747.909988
#> iter   9 value 747.909986
#> final  value 747.909986 
#> converged
#> This is Run number  215 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.09169008 -0.1369218  -0.4583099 -12.7369218      1
#> 2     1  -0.95  -2.35 -0.09315536 -0.6526726  -1.0431554  -3.0026726      1
#> 3     1  -6.20  -2.30 -0.45936153  3.2561633  -6.6593615   0.9561633      2
#> 4     1 -13.90  -2.55 -0.26124703 -0.3651859 -14.1612470  -2.9151859      2
#> 5     1 -14.40  -5.80  1.02114270  1.0287486 -13.3788573  -4.7712514      2
#> 6     1  -3.60  -1.70 -0.30273714  0.8162572  -3.9027371  -0.8837428      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -39350   7125 
#> initial  value 998.131940 
#> iter   2 value 803.935733
#> iter   3 value 788.262130
#> iter   4 value 785.181803
#> iter   5 value 751.201637
#> iter   6 value 742.598680
#> iter   7 value 741.353379
#> iter   8 value 741.328242
#> iter   9 value 741.328214
#> iter   9 value 741.328206
#> iter   9 value 741.328201
#> final  value 741.328201 
#> converged
#> This is Run number  216 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2066983  2.6146710  -0.7566983 -9.9853290      1
#> 2     1  -0.95  -2.35  0.3564629  1.9682892  -0.5935371 -0.3817108      2
#> 3     1  -6.20  -2.30  1.0512524  1.6769366  -5.1487476 -0.6230634      2
#> 4     1 -13.90  -2.55  2.0165478  0.8636186 -11.8834522 -1.6863814      2
#> 5     1 -14.40  -5.80  1.2738111  0.2055095 -13.1261889 -5.5944905      2
#> 6     1  -3.60  -1.70 -0.4822271 -0.4540221  -4.0822271 -2.1540221      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5720 -37900   7275 
#> initial  value 998.131940 
#> iter   2 value 824.311550
#> iter   3 value 810.335267
#> iter   4 value 807.912021
#> iter   5 value 769.479035
#> iter   6 value 761.124843
#> iter   7 value 759.819415
#> iter   8 value 759.794711
#> iter   9 value 759.794680
#> iter   9 value 759.794670
#> iter   9 value 759.794665
#> final  value 759.794665 
#> converged
#> This is Run number  217 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 0.9269806 -0.4281532   0.3769806 -13.028153      1
#> 2     1  -0.95  -2.35 1.9402842 -0.3252042   0.9902842  -2.675204      1
#> 3     1  -6.20  -2.30 3.3392293  0.3297800  -2.8607707  -1.970220      2
#> 4     1 -13.90  -2.55 1.6926674 -0.6094662 -12.2073326  -3.159466      2
#> 5     1 -14.40  -5.80 3.9327639 -0.1386314 -10.4672361  -5.938631      2
#> 6     1  -3.60  -1.70 1.6349908 -1.3948699  -1.9650092  -3.094870      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -39075   7025 
#> initial  value 998.131940 
#> iter   2 value 808.666363
#> iter   3 value 793.236179
#> iter   4 value 789.971672
#> iter   5 value 755.191358
#> iter   6 value 746.609712
#> iter   7 value 745.335143
#> iter   8 value 745.309189
#> iter   9 value 745.309157
#> iter   9 value 745.309150
#> iter   9 value 745.309145
#> final  value 745.309145 
#> converged
#> This is Run number  218 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.16000160 -0.03526239  -1.710002 -12.63526239      1
#> 2     1  -0.95  -2.35 -0.89423071 -0.64229143  -1.844231  -2.99229143      1
#> 3     1  -6.20  -2.30 -1.17382981  0.14981155  -7.373830  -2.15018845      2
#> 4     1 -13.90  -2.55  0.22575472 -0.32449013 -13.674245  -2.87449013      2
#> 5     1 -14.40  -5.80 -0.03684955  0.32234712 -14.436850  -5.47765288      2
#> 6     1  -3.60  -1.70  0.28921266  1.60723484  -3.310787  -0.09276516      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5920 -38300   7725 
#> initial  value 998.131940 
#> iter   2 value 815.900592
#> iter   3 value 801.140831
#> iter   4 value 799.430577
#> iter   5 value 762.025225
#> iter   6 value 753.610059
#> iter   7 value 752.369440
#> iter   8 value 752.347448
#> iter   9 value 752.347424
#> iter   9 value 752.347416
#> iter   9 value 752.347410
#> final  value 752.347410 
#> converged
#> This is Run number  219 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.91658657  3.91101543  -1.4665866 -8.688985      1
#> 2     1  -0.95  -2.35  0.08912086  0.07344246  -0.8608791 -2.276558      1
#> 3     1  -6.20  -2.30  1.74606889  0.59702546  -4.4539311 -1.702975      2
#> 4     1 -13.90  -2.55  2.04921261  0.42832508 -11.8507874 -2.121675      2
#> 5     1 -14.40  -5.80  1.52153305 -0.40264686 -12.8784670 -6.202647      2
#> 6     1  -3.60  -1.70  0.54033159 -0.86860529  -3.0596684 -2.568605      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -38650   6850 
#> initial  value 998.131940 
#> iter   2 value 815.638568
#> iter   3 value 804.051855
#> iter   4 value 802.712554
#> iter   5 value 766.072786
#> iter   6 value 757.535318
#> iter   7 value 756.138987
#> iter   8 value 756.108346
#> iter   9 value 756.108292
#> iter  10 value 756.108279
#> iter  10 value 756.108270
#> iter  10 value 756.108268
#> final  value 756.108268 
#> converged
#> This is Run number  220 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0654828 0.6547639  -1.6154828 -11.94523608      1
#> 2     1  -0.95  -2.35  0.3993259 0.3562450  -0.5506741  -1.99375501      1
#> 3     1  -6.20  -2.30  2.7682318 1.1207055  -3.4317682  -1.17929447      2
#> 4     1 -13.90  -2.55  1.0575306 1.3948554 -12.8424694  -1.15514458      2
#> 5     1 -14.40  -5.80  2.4069026 0.2330548 -11.9930974  -5.56694521      2
#> 6     1  -3.60  -1.70 -1.1249150 1.7991393  -4.7249150   0.09913926      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5820 -37775   7350 
#> initial  value 998.131940 
#> iter   2 value 825.601490
#> iter   3 value 812.297340
#> iter   4 value 810.377079
#> iter   5 value 771.446108
#> iter   6 value 763.119233
#> iter   7 value 761.810783
#> iter   8 value 761.786157
#> iter   9 value 761.786125
#> iter   9 value 761.786114
#> iter   9 value 761.786108
#> final  value 761.786108 
#> converged
#> This is Run number  221 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9000783 -0.004409697   0.3500783 -12.604410      1
#> 2     1  -0.95  -2.35 -0.4800878  0.563000045  -1.4300878  -1.787000      1
#> 3     1  -6.20  -2.30  0.4041835  0.605752274  -5.7958165  -1.694248      2
#> 4     1 -13.90  -2.55 -0.7918820  0.761345481 -14.6918820  -1.788655      2
#> 5     1 -14.40  -5.80  0.8632203  0.200058745 -13.5367797  -5.599941      2
#> 6     1  -3.60  -1.70  0.8651042  0.042409954  -2.7348958  -1.657590      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -39000   7225 
#> initial  value 998.131940 
#> iter   2 value 808.253020
#> iter   3 value 795.813338
#> iter   4 value 794.951389
#> iter   5 value 759.274754
#> iter   6 value 750.677054
#> iter   7 value 749.358660
#> iter   8 value 749.331012
#> iter   9 value 749.330969
#> iter  10 value 749.330956
#> iter  10 value 749.330946
#> iter  10 value 749.330939
#> final  value 749.330939 
#> converged
#> This is Run number  222 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5974888  0.7207872  -1.147489 -11.8792128      1
#> 2     1  -0.95  -2.35  2.4177932  1.2107015   1.467793  -1.1392985      1
#> 3     1  -6.20  -2.30 -0.9147225  0.8125029  -7.114723  -1.4874971      2
#> 4     1 -13.90  -2.55  0.9994110  2.1232375 -12.900589  -0.4267625      2
#> 5     1 -14.40  -5.80 -1.0913688  4.5534294 -15.491369  -1.2465706      2
#> 6     1  -3.60  -1.70 -0.0112052 -0.3993452  -3.611205  -2.0993452      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -38075   7100 
#> initial  value 998.131940 
#> iter   2 value 822.261078
#> iter   3 value 811.942835
#> iter   4 value 811.632289
#> iter   5 value 773.078012
#> iter   6 value 764.644017
#> iter   7 value 763.231041
#> iter   8 value 763.200911
#> iter   9 value 763.200851
#> iter  10 value 763.200835
#> iter  10 value 763.200825
#> iter  10 value 763.200818
#> final  value 763.200818 
#> converged
#> This is Run number  223 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1           U_2 CHOICE
#> 1     1  -0.55 -12.60  1.8476100  1.3207487   1.297610 -11.279251334      1
#> 2     1  -0.95  -2.35 -0.8531956  2.3562997  -1.803196   0.006299748      2
#> 3     1  -6.20  -2.30  1.3090482 -1.4392946  -4.890952  -3.739294611      2
#> 4     1 -13.90  -2.55  0.7109863  1.2417223 -13.189014  -1.308277719      2
#> 5     1 -14.40  -5.80  2.1710187  0.4505619 -12.228981  -5.349438056      2
#> 6     1  -3.60  -1.70 -1.3060764 -0.1635694  -4.906076  -1.863569387      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -37325   6150 
#> initial  value 998.131940 
#> iter   2 value 837.964233
#> iter   3 value 829.286267
#> iter   4 value 827.941315
#> iter   5 value 787.517484
#> iter   6 value 779.333333
#> iter   7 value 777.774281
#> iter   8 value 777.740246
#> iter   9 value 777.740170
#> iter   9 value 777.740170
#> iter   9 value 777.740170
#> final  value 777.740170 
#> converged
#> This is Run number  224 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.1452453  0.13098693  -1.6952453 -12.4690131      1
#> 2     1  -0.95  -2.35  0.3876162  0.77493437  -0.5623838  -1.5750656      1
#> 3     1  -6.20  -2.30  1.6711713  0.74241078  -4.5288287  -1.5575892      2
#> 4     1 -13.90  -2.55 -0.7816148  1.76706709 -14.6816148  -0.7829329      2
#> 5     1 -14.40  -5.80  0.4505547 -0.46879084 -13.9494453  -6.2687908      2
#> 6     1  -3.60  -1.70  0.3612035  0.07746109  -3.2387965  -1.6225389      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5960 -36850   6500 
#> initial  value 998.131940 
#> iter   2 value 842.752952
#> iter   3 value 833.218933
#> iter   4 value 831.692715
#> iter   5 value 790.047163
#> iter   6 value 781.982992
#> iter   7 value 780.525025
#> iter   8 value 780.495636
#> iter   9 value 780.495581
#> iter   9 value 780.495578
#> iter   9 value 780.495578
#> final  value 780.495578 
#> converged
#> This is Run number  225 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5534737  0.51978165  -1.103474 -12.080218      1
#> 2     1  -0.95  -2.35  2.2873416  0.72168668   1.337342  -1.628313      1
#> 3     1  -6.20  -2.30  2.7367478  0.46097836  -3.463252  -1.839022      2
#> 4     1 -13.90  -2.55  2.6558252 -0.38613520 -11.244175  -2.936135      2
#> 5     1 -14.40  -5.80  3.9567387 -0.21961638 -10.443261  -6.019616      2
#> 6     1  -3.60  -1.70  2.2565819 -0.01522072  -1.343418  -1.715221      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38975   8025 
#> initial  value 998.131940 
#> iter   2 value 804.001710
#> iter   3 value 788.334758
#> iter   4 value 787.279503
#> iter   5 value 751.775799
#> iter   6 value 743.269799
#> iter   7 value 742.099602
#> iter   8 value 742.080249
#> iter   9 value 742.080228
#> iter   9 value 742.080220
#> iter   9 value 742.080216
#> final  value 742.080216 
#> converged
#> This is Run number  226 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7441052  0.2947034   1.194105 -12.30529658      1
#> 2     1  -0.95  -2.35 -0.7036946 -1.5217352  -1.653695  -3.87173525      1
#> 3     1  -6.20  -2.30  0.6120319  1.3815294  -5.587968  -0.91847058      2
#> 4     1 -13.90  -2.55  0.9700783  2.5828218 -12.929922   0.03282182      2
#> 5     1 -14.40  -5.80  0.2687309  2.1144806 -14.131269  -3.68551941      2
#> 6     1  -3.60  -1.70 -1.2389821  0.4902838  -4.838982  -1.20971616      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7160 -38425   5725 
#> initial  value 998.131940 
#> iter   2 value 823.668463
#> iter   3 value 816.850808
#> iter   4 value 816.408532
#> iter   5 value 778.669920
#> iter   6 value 770.251297
#> iter   7 value 768.484599
#> iter   8 value 768.439764
#> iter   9 value 768.439627
#> iter  10 value 768.439613
#> iter  10 value 768.439609
#> iter  10 value 768.439606
#> final  value 768.439606 
#> converged
#> This is Run number  227 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.4441583  2.6284613   2.894158 -9.9715387      1
#> 2     1  -0.95  -2.35 -1.0597370  0.4807928  -2.009737 -1.8692072      2
#> 3     1  -6.20  -2.30  0.2773811  2.1961445  -5.922619 -0.1038555      2
#> 4     1 -13.90  -2.55 -0.8482658  1.0370210 -14.748266 -1.5129790      2
#> 5     1 -14.40  -5.80  0.1758028 -0.3642346 -14.224197 -6.1642346      2
#> 6     1  -3.60  -1.70  1.4461426  0.4603274  -2.153857 -1.2396726      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6220 -36625   5775 
#> initial  value 998.131940 
#> iter   2 value 849.049071
#> iter   3 value 841.696413
#> iter   4 value 840.394412
#> iter   5 value 798.144243
#> iter   6 value 790.213110
#> iter   7 value 788.605465
#> iter   8 value 788.571698
#> iter   9 value 788.571618
#> iter   9 value 788.571608
#> iter   9 value 788.571604
#> final  value 788.571604 
#> converged
#> This is Run number  228 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.0447475 -0.40380582  -0.5052525 -13.0038058      1
#> 2     1  -0.95  -2.35  3.5619603  1.67717616   2.6119603  -0.6728238      1
#> 3     1  -6.20  -2.30  0.7238402  3.03673666  -5.4761598   0.7367367      2
#> 4     1 -13.90  -2.55  0.7806459 -0.08152807 -13.1193541  -2.6315281      2
#> 5     1 -14.40  -5.80  0.9494378  1.00268280 -13.4505622  -4.7973172      2
#> 6     1  -3.60  -1.70 -0.5529688  0.98569664  -4.1529688  -0.7143034      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5500 -36900   7075 
#> initial  value 998.131940 
#> iter   2 value 839.113520
#> iter   3 value 826.637404
#> iter   4 value 824.257472
#> iter   5 value 782.968090
#> iter   6 value 774.862478
#> iter   7 value 773.525022
#> iter   8 value 773.500427
#> iter   9 value 773.500393
#> iter   9 value 773.500383
#> iter   9 value 773.500378
#> final  value 773.500378 
#> converged
#> This is Run number  229 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.9852670  2.5355131   1.4352670 -10.0644869      1
#> 2     1  -0.95  -2.35  1.1320253  1.9968171   0.1820253  -0.3531829      1
#> 3     1  -6.20  -2.30 -0.6673611 -1.0597203  -6.8673611  -3.3597203      2
#> 4     1 -13.90  -2.55  1.0495013  1.3418826 -12.8504987  -1.2081174      2
#> 5     1 -14.40  -5.80 -0.8831389  0.1121219 -15.2831389  -5.6878781      2
#> 6     1  -3.60  -1.70  1.0609421  2.1497227  -2.5390579   0.4497227      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6120 -37525   7850 
#> initial  value 998.131940 
#> iter   2 value 825.892580
#> iter   3 value 813.272609
#> iter   4 value 812.660445
#> iter   5 value 772.686939
#> iter   6 value 764.388726
#> iter   7 value 763.125869
#> iter   8 value 763.104057
#> iter   9 value 763.104028
#> iter   9 value 763.104020
#> iter   9 value 763.104012
#> final  value 763.104012 
#> converged
#> This is Run number  230 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.03255199  2.7785120  -0.517448 -9.8214880      1
#> 2     1  -0.95  -2.35  2.77938134  1.2514665   1.829381 -1.0985335      1
#> 3     1  -6.20  -2.30 -0.21063749 -0.5963459  -6.410637 -2.8963459      2
#> 4     1 -13.90  -2.55  1.91723859  3.5261275 -11.982761  0.9761275      2
#> 5     1 -14.40  -5.80  0.72171373  0.8986288 -13.678286 -4.9013712      2
#> 6     1  -3.60  -1.70  0.61462267  0.4009530  -2.985377 -1.2990470      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -38025   8150 
#> initial  value 998.131940 
#> iter   2 value 817.132946
#> iter   3 value 801.813499
#> iter   4 value 800.504616
#> iter   5 value 762.214966
#> iter   6 value 753.869159
#> iter   7 value 752.672882
#> iter   8 value 752.654045
#> iter   9 value 752.654027
#> iter   9 value 752.654020
#> iter   9 value 752.654016
#> final  value 752.654016 
#> converged
#> This is Run number  231 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1          e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.73531656 -1.530465749  -1.285317 -14.1304657      1
#> 2     1  -0.95  -2.35 -0.48852775  2.150363214  -1.438528  -0.1996368      2
#> 3     1  -6.20  -2.30  0.10929049 -0.962438246  -6.090710  -3.2624382      2
#> 4     1 -13.90  -2.55  0.11701363 -1.239015260 -13.782986  -3.7890153      2
#> 5     1 -14.40  -5.80 -0.35429037  0.002149594 -14.754290  -5.7978504      2
#> 6     1  -3.60  -1.70 -0.05224961  2.132736925  -3.652250   0.4327369      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39450   7575 
#> initial  value 998.131940 
#> iter   2 value 799.503982
#> iter   3 value 784.965112
#> iter   4 value 783.844908
#> iter   5 value 749.690918
#> iter   6 value 741.080205
#> iter   7 value 739.869311
#> iter   8 value 739.846278
#> iter   9 value 739.846252
#> iter   9 value 739.846244
#> iter   9 value 739.846243
#> final  value 739.846243 
#> converged
#> This is Run number  232 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.8773840 -0.03556040  -1.4273840 -12.6355604      1
#> 2     1  -0.95  -2.35  1.5218759  3.73471566   0.5718759   1.3847157      2
#> 3     1  -6.20  -2.30 -0.7278281 -0.01909818  -6.9278281  -2.3190982      2
#> 4     1 -13.90  -2.55  1.0088512  0.66409343 -12.8911488  -1.8859066      2
#> 5     1 -14.40  -5.80  3.3750571  0.66021795 -11.0249429  -5.1397820      2
#> 6     1  -3.60  -1.70  0.3978376  1.34839978  -3.2021624  -0.3516002      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38800   6175 
#> initial  value 998.131940 
#> iter   2 value 817.016408
#> iter   3 value 805.408360
#> iter   4 value 802.782092
#> iter   5 value 766.891990
#> iter   6 value 758.309422
#> iter   7 value 756.814807
#> iter   8 value 756.779226
#> iter   9 value 756.779148
#> iter   9 value 756.779137
#> iter   9 value 756.779131
#> final  value 756.779131 
#> converged
#> This is Run number  233 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.48119914  0.7116074  -1.031199 -11.8883926      1
#> 2     1  -0.95  -2.35 -0.44626121  0.1265621  -1.396261  -2.2234379      1
#> 3     1  -6.20  -2.30  0.08820424  0.6102511  -6.111796  -1.6897489      2
#> 4     1 -13.90  -2.55  0.58974194 -1.2617690 -13.310258  -3.8117690      2
#> 5     1 -14.40  -5.80 -0.15078747  4.0017594 -14.550787  -1.7982406      2
#> 6     1  -3.60  -1.70  2.03602961  1.5876173  -1.563970  -0.1123827      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -39025   6975 
#> initial  value 998.131940 
#> iter   2 value 809.472073
#> iter   3 value 796.658382
#> iter   4 value 794.968249
#> iter   5 value 759.567558
#> iter   6 value 750.973226
#> iter   7 value 749.635459
#> iter   8 value 749.606661
#> iter   9 value 749.606616
#> iter  10 value 749.606605
#> iter  10 value 749.606597
#> iter  10 value 749.606591
#> final  value 749.606591 
#> converged
#> This is Run number  234 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.20312965 -0.4369401  -0.7531296 -13.036940      1
#> 2     1  -0.95  -2.35  1.58038645 -0.5655113   0.6303864  -2.915511      1
#> 3     1  -6.20  -2.30  0.68258610 -0.3409222  -5.5174139  -2.640922      2
#> 4     1 -13.90  -2.55  1.08750589 -0.4550891 -12.8124941  -3.005089      2
#> 5     1 -14.40  -5.80 -0.09852209 -1.1345732 -14.4985221  -6.934573      2
#> 6     1  -3.60  -1.70 -0.64938331 -1.0224924  -4.2493833  -2.722492      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -40700   6375 
#> initial  value 998.131940 
#> iter   2 value 786.396879
#> iter   3 value 772.502015
#> iter   4 value 769.353571
#> iter   5 value 739.332176
#> iter   6 value 730.547941
#> iter   7 value 729.276095
#> iter   8 value 729.245000
#> iter   9 value 729.244945
#> iter   9 value 729.244939
#> iter   9 value 729.244933
#> final  value 729.244933 
#> converged
#> This is Run number  235 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.80982266  1.4263786  -1.3598227 -11.173621      1
#> 2     1  -0.95  -2.35  1.27694536  0.9225383   0.3269454  -1.427462      1
#> 3     1  -6.20  -2.30  2.98622402 -0.3988181  -3.2137760  -2.698818      2
#> 4     1 -13.90  -2.55 -0.36101653  0.3252803 -14.2610165  -2.224720      2
#> 5     1 -14.40  -5.80 -0.07688913  0.3382052 -14.4768891  -5.461795      2
#> 6     1  -3.60  -1.70 -0.33120811  0.2577318  -3.9312081  -1.442268      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -38925   7200 
#> initial  value 998.131940 
#> iter   2 value 809.888783
#> iter   3 value 794.990142
#> iter   4 value 792.372727
#> iter   5 value 757.001830
#> iter   6 value 748.455523
#> iter   7 value 747.182970
#> iter   8 value 747.157635
#> iter   9 value 747.157605
#> iter   9 value 747.157596
#> iter   9 value 747.157591
#> final  value 747.157591 
#> converged
#> This is Run number  236 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7965914 -0.04870332   1.246591 -12.6487033      1
#> 2     1  -0.95  -2.35 -0.3530705 -0.35677258  -1.303071  -2.7067726      1
#> 3     1  -6.20  -2.30  0.6195920 -0.69061997  -5.580408  -2.9906200      2
#> 4     1 -13.90  -2.55  0.6252621  1.19040595 -13.274738  -1.3595940      2
#> 5     1 -14.40  -5.80  0.5936413 -0.27481174 -13.806359  -6.0748117      2
#> 6     1  -3.60  -1.70 -0.5563107  2.55929414  -4.156311   0.8592941      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -38250   7375 
#> initial  value 998.131940 
#> iter   2 value 818.729364
#> iter   3 value 804.677775
#> iter   4 value 802.616641
#> iter   5 value 765.113626
#> iter   6 value 756.689200
#> iter   7 value 755.400449
#> iter   8 value 755.375906
#> iter   9 value 755.375875
#> iter   9 value 755.375865
#> iter   9 value 755.375859
#> final  value 755.375859 
#> converged
#> This is Run number  237 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.00448599  0.5773295  -1.554486 -12.02267052      1
#> 2     1  -0.95  -2.35 -1.05295748  2.4025245  -2.002957   0.05252447      2
#> 3     1  -6.20  -2.30 -0.17379317  4.6904100  -6.373793   2.39041002      2
#> 4     1 -13.90  -2.55  0.08746244 -0.7566977 -13.812538  -3.30669772      2
#> 5     1 -14.40  -5.80  0.30851843  1.6665333 -14.091482  -4.13346667      2
#> 6     1  -3.60  -1.70  0.53126972  0.2393648  -3.068730  -1.46063515      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -39125   7100 
#> initial  value 998.131940 
#> iter   2 value 807.356921
#> iter   3 value 793.531199
#> iter   4 value 791.502450
#> iter   5 value 756.531381
#> iter   6 value 747.937458
#> iter   7 value 746.641842
#> iter   8 value 746.614866
#> iter   9 value 746.614830
#> iter   9 value 746.614820
#> iter   9 value 746.614814
#> final  value 746.614814 
#> converged
#> This is Run number  238 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8405225  1.2268711   0.2905225 -11.3731289      1
#> 2     1  -0.95  -2.35 -0.1030576  0.2193215  -1.0530576  -2.1306785      1
#> 3     1  -6.20  -2.30  0.6144532  1.3732119  -5.5855468  -0.9267881      2
#> 4     1 -13.90  -2.55 -0.2888606 -0.9605566 -14.1888606  -3.5105566      2
#> 5     1 -14.40  -5.80  0.2597323  2.3425253 -14.1402677  -3.4574747      2
#> 6     1  -3.60  -1.70 -0.6243951  0.1923333  -4.2243951  -1.5076667      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38050   6900 
#> initial  value 998.131940 
#> iter   2 value 824.087932
#> iter   3 value 812.903341
#> iter   4 value 811.618463
#> iter   5 value 773.234850
#> iter   6 value 764.827717
#> iter   7 value 763.423150
#> iter   8 value 763.393480
#> iter   9 value 763.393428
#> iter  10 value 763.393414
#> iter  10 value 763.393404
#> iter  10 value 763.393400
#> final  value 763.393400 
#> converged
#> This is Run number  239 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.1772484  0.2126690   2.6272484 -12.387331      1
#> 2     1  -0.95  -2.35  0.0816046  0.2679445  -0.8683954  -2.082055      1
#> 3     1  -6.20  -2.30 -0.2190574  0.3126964  -6.4190574  -1.987304      2
#> 4     1 -13.90  -2.55  0.9748933  1.1207130 -12.9251067  -1.429287      2
#> 5     1 -14.40  -5.80  2.5001654  0.1922016 -11.8998346  -5.607798      2
#> 6     1  -3.60  -1.70  0.2016867 -0.2987466  -3.3983133  -1.998747      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6560 -39400   6925 
#> initial  value 998.131940 
#> iter   2 value 803.957698
#> iter   3 value 791.377019
#> iter   4 value 789.925105
#> iter   5 value 755.555420
#> iter   6 value 746.898259
#> iter   7 value 745.564684
#> iter   8 value 745.535133
#> iter   9 value 745.535085
#> iter  10 value 745.535074
#> iter  10 value 745.535065
#> iter  10 value 745.535060
#> final  value 745.535060 
#> converged
#> This is Run number  240 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  5.0093042 1.02414952   4.459304 -11.57585048      1
#> 2     1  -0.95  -2.35  3.3717477 0.58398147   2.421748  -1.76601853      1
#> 3     1  -6.20  -2.30 -0.5433670 2.35125957  -6.743367   0.05125957      2
#> 4     1 -13.90  -2.55  0.4631510 0.70165006 -13.436849  -1.84834994      2
#> 5     1 -14.40  -5.80  0.4880912 0.03061548 -13.911909  -5.76938452      2
#> 6     1  -3.60  -1.70  1.9404469 0.27519715  -1.659553  -1.42480285      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -38775   7350 
#> initial  value 998.131940 
#> iter   2 value 810.726593
#> iter   3 value 798.730358
#> iter   4 value 798.302582
#> iter   5 value 761.871486
#> iter   6 value 753.298017
#> iter   7 value 751.974126
#> iter   8 value 751.946825
#> iter   9 value 751.946781
#> iter  10 value 751.946766
#> iter  10 value 751.946757
#> iter  10 value 751.946749
#> final  value 751.946749 
#> converged
#> This is Run number  241 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.31016368  0.8647829  -0.8601637 -11.7352171      1
#> 2     1  -0.95  -2.35  1.11268413  3.9797480   0.1626841   1.6297480      2
#> 3     1  -6.20  -2.30  0.35103620  0.9718929  -5.8489638  -1.3281071      2
#> 4     1 -13.90  -2.55 -0.52632554 -0.3870442 -14.4263255  -2.9370442      2
#> 5     1 -14.40  -5.80 -0.01124584 -0.2165955 -14.4112458  -6.0165955      2
#> 6     1  -3.60  -1.70 -0.87348806  1.3790042  -4.4734881  -0.3209958      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -40375   6750 
#> initial  value 998.131940 
#> iter   2 value 789.591202
#> iter   3 value 776.204988
#> iter   4 value 774.224881
#> iter   5 value 742.933012
#> iter   6 value 734.183495
#> iter   7 value 732.917333
#> iter   8 value 732.888181
#> iter   9 value 732.888137
#> iter   9 value 732.888137
#> iter   9 value 732.888137
#> final  value 732.888137 
#> converged
#> This is Run number  242 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6494390  1.54342819   0.09943900 -11.0565718      1
#> 2     1  -0.95  -2.35  1.0192253  0.08960209   0.06922532  -2.2603979      1
#> 3     1  -6.20  -2.30 -0.3140770  2.96674827  -6.51407703   0.6667483      2
#> 4     1 -13.90  -2.55 -0.3208263  2.28910240 -14.22082633  -0.2608976      2
#> 5     1 -14.40  -5.80  1.5841395 -0.17950177 -12.81586051  -5.9795018      2
#> 6     1  -3.60  -1.70  0.5659185 -0.62849461  -3.03408154  -2.3284946      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6840 -37400   6400 
#> initial  value 998.131940 
#> iter   2 value 835.178170
#> iter   3 value 827.635495
#> iter   4 value 827.446241
#> iter   5 value 786.873888
#> iter   6 value 778.675208
#> iter   7 value 777.085423
#> iter   8 value 777.049741
#> iter   9 value 777.049650
#> iter  10 value 777.049634
#> iter  10 value 777.049625
#> iter  10 value 777.049616
#> final  value 777.049616 
#> converged
#> This is Run number  243 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2          U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 2.4805062  3.0838861   1.93050618 -9.516114      1
#> 2     1  -0.95  -2.35 1.0495383 -0.1520628   0.09953833 -2.502063      1
#> 3     1  -6.20  -2.30 1.9789513 -0.7203178  -4.22104871 -3.020318      2
#> 4     1 -13.90  -2.55 0.8635060  0.1326368 -13.03649397 -2.417363      2
#> 5     1 -14.40  -5.80 0.2057064  2.3673315 -14.19429357 -3.432668      2
#> 6     1  -3.60  -1.70 0.3295832 -0.4042369  -3.27041683 -2.104237      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6400 -38850   6225 
#> initial  value 998.131940 
#> iter   2 value 815.947555
#> iter   3 value 804.900656
#> iter   4 value 802.724024
#> iter   5 value 766.852562
#> iter   6 value 758.269569
#> iter   7 value 756.768084
#> iter   8 value 756.732173
#> iter   9 value 756.732095
#> iter   9 value 756.732084
#> iter   9 value 756.732078
#> final  value 756.732078 
#> converged
#> This is Run number  244 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.655043227  1.22161720   0.1050432 -11.3783828      1
#> 2     1  -0.95  -2.35 -0.002454318 -0.24362416  -0.9524543  -2.5936242      1
#> 3     1  -6.20  -2.30 -1.006912432 -0.09113768  -7.2069124  -2.3911377      2
#> 4     1 -13.90  -2.55 -0.549814037  3.38010125 -14.4498140   0.8301013      2
#> 5     1 -14.40  -5.80  1.731383699  1.19105735 -12.6686163  -4.6089427      2
#> 6     1  -3.60  -1.70 -0.477807517  1.59538957  -4.0778075  -0.1046104      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6120 -38175   7600 
#> initial  value 998.131940 
#> iter   2 value 818.360246
#> iter   3 value 804.983630
#> iter   4 value 803.822680
#> iter   5 value 765.866144
#> iter   6 value 757.446109
#> iter   7 value 756.170251
#> iter   8 value 756.146611
#> iter   9 value 756.146580
#> iter   9 value 756.146569
#> iter   9 value 756.146563
#> final  value 756.146563 
#> converged
#> This is Run number  245 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.8445037  0.4627549   2.294504 -12.1372451      1
#> 2     1  -0.95  -2.35 -0.1232785  0.0791009  -1.073279  -2.2708991      1
#> 3     1  -6.20  -2.30  0.5272793 -1.0085839  -5.672721  -3.3085839      2
#> 4     1 -13.90  -2.55  1.9527666 -0.9632221 -11.947233  -3.5132221      2
#> 5     1 -14.40  -5.80  0.9935716  2.0774481 -13.406428  -3.7225519      2
#> 6     1  -3.60  -1.70  1.8113113  1.1359141  -1.788689  -0.5640859      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -36750   6000 
#> initial  value 998.131940 
#> iter   2 value 846.554042
#> iter   3 value 837.205108
#> iter   4 value 835.097604
#> iter   5 value 793.376229
#> iter   6 value 785.348486
#> iter   7 value 783.819987
#> iter   8 value 783.788448
#> iter   9 value 783.788381
#> iter   9 value 783.788372
#> iter   9 value 783.788368
#> final  value 783.788368 
#> converged
#> This is Run number  246 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.1947171  1.2179700   1.6447171 -11.3820300      1
#> 2     1  -0.95  -2.35  1.2186088  1.7841259   0.2686088  -0.5658741      1
#> 3     1  -6.20  -2.30  1.4122247  0.9045920  -4.7877753  -1.3954080      2
#> 4     1 -13.90  -2.55  0.1791404 -0.5492948 -13.7208596  -3.0992948      2
#> 5     1 -14.40  -5.80  1.6302392  1.9455393 -12.7697608  -3.8544607      2
#> 6     1  -3.60  -1.70 -0.9766555  0.2611104  -4.5766555  -1.4388896      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -38300   6525 
#> initial  value 998.131940 
#> iter   2 value 822.181386
#> iter   3 value 812.747373
#> iter   4 value 811.998231
#> iter   5 value 774.108233
#> iter   6 value 765.647492
#> iter   7 value 764.133339
#> iter   8 value 764.098441
#> iter   9 value 764.098363
#> iter  10 value 764.098348
#> iter  10 value 764.098338
#> iter  10 value 764.098333
#> final  value 764.098333 
#> converged
#> This is Run number  247 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.2088165  0.5931075   0.6588165 -12.006892      1
#> 2     1  -0.95  -2.35  0.4808139 -1.0211328  -0.4691861  -3.371133      1
#> 3     1  -6.20  -2.30  3.5088141  0.4158355  -2.6911859  -1.884164      2
#> 4     1 -13.90  -2.55  0.8408609 -0.0235867 -13.0591391  -2.573587      2
#> 5     1 -14.40  -5.80 -0.5046380 -0.7710901 -14.9046380  -6.571090      2
#> 6     1  -3.60  -1.70  2.1141948 -0.7719867  -1.4858052  -2.471987      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -38200   6125 
#> initial  value 998.131940 
#> iter   2 value 825.987177
#> iter   3 value 815.241085
#> iter   4 value 812.885430
#> iter   5 value 775.191752
#> iter   6 value 766.746118
#> iter   7 value 765.214787
#> iter   8 value 765.179433
#> iter   9 value 765.179354
#> iter   9 value 765.179343
#> iter   9 value 765.179338
#> final  value 765.179338 
#> converged
#> This is Run number  248 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.02810859 -0.61540022  -0.5218914 -13.2154002      1
#> 2     1  -0.95  -2.35 -1.27613975  0.54502206  -2.2261397  -1.8049779      2
#> 3     1  -6.20  -2.30  0.14504544  0.40146568  -6.0549546  -1.8985343      2
#> 4     1 -13.90  -2.55  2.08761878  0.05451075 -11.8123812  -2.4954893      2
#> 5     1 -14.40  -5.80  1.33323333  0.58618945 -13.0667667  -5.2138106      2
#> 6     1  -3.60  -1.70  0.42835266  2.52480226  -3.1716473   0.8248023      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -40875   6800 
#> initial  value 998.131940 
#> iter   2 value 781.280346
#> iter   3 value 766.563653
#> iter   4 value 763.997399
#> iter   5 value 734.433159
#> iter   6 value 725.700456
#> iter   7 value 724.523136
#> iter   8 value 724.496845
#> iter   9 value 724.496813
#> iter   9 value 724.496812
#> iter   9 value 724.496812
#> final  value 724.496812 
#> converged
#> This is Run number  249 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.6333742 -0.7362471  -2.1833742 -13.3362471      1
#> 2     1  -0.95  -2.35 -0.7205674  0.5910431  -1.6705674  -1.7589569      1
#> 3     1  -6.20  -2.30  0.4194497  3.6669410  -5.7805503   1.3669410      2
#> 4     1 -13.90  -2.55  0.8342635  2.3644905 -13.0657365  -0.1855095      2
#> 5     1 -14.40  -5.80 -0.4914265  0.7035326 -14.8914265  -5.0964674      2
#> 6     1  -3.60  -1.70  4.4156025  1.8720871   0.8156025   0.1720871      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6200 -36725   6500 
#> initial  value 998.131940 
#> iter   2 value 844.266208
#> iter   3 value 835.862053
#> iter   4 value 834.980809
#> iter   5 value 792.810447
#> iter   6 value 784.796024
#> iter   7 value 783.312871
#> iter   8 value 783.282686
#> iter   9 value 783.282623
#> iter   9 value 783.282619
#> iter   9 value 783.282619
#> final  value 783.282619 
#> converged
#> This is Run number  250 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7381788  1.5872388   1.188179 -11.0127612      1
#> 2     1  -0.95  -2.35 -0.7568609  2.6698661  -1.706861   0.3198661      2
#> 3     1  -6.20  -2.30  2.1164821  0.8411596  -4.083518  -1.4588404      2
#> 4     1 -13.90  -2.55  0.3853132  1.0538036 -13.514687  -1.4961964      2
#> 5     1 -14.40  -5.80  0.5614486 -0.2464262 -13.838551  -6.0464262      2
#> 6     1  -3.60  -1.70 -0.2661704  0.8739728  -3.866170  -0.8260272      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5760 -36625   6350 
#> initial  value 998.131940 
#> iter   2 value 846.527470
#> iter   3 value 836.680841
#> iter   4 value 834.681412
#> iter   5 value 792.580035
#> iter   6 value 784.580769
#> iter   7 value 783.124309
#> iter   8 value 783.095515
#> iter   9 value 783.095462
#> iter   9 value 783.095461
#> iter   9 value 783.095461
#> final  value 783.095461 
#> converged
#> This is Run number  251 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.1561369  0.7081376  -1.7061369 -11.8918624      1
#> 2     1  -0.95  -2.35  1.4298268  5.7933276   0.4798268   3.4433276      2
#> 3     1  -6.20  -2.30  2.3851884 -0.8059106  -3.8148116  -3.1059106      2
#> 4     1 -13.90  -2.55 -0.8106951  1.2064598 -14.7106951  -1.3435402      2
#> 5     1 -14.40  -5.80 -0.8619319  1.3703933 -15.2619319  -4.4296067      2
#> 6     1  -3.60  -1.70  0.4952075  2.3965973  -3.1047925   0.6965973      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -38150   6675 
#> initial  value 998.131940 
#> iter   2 value 823.951017
#> iter   3 value 812.417941
#> iter   4 value 810.512955
#> iter   5 value 772.582669
#> iter   6 value 764.152880
#> iter   7 value 762.728128
#> iter   8 value 762.697398
#> iter   9 value 762.697342
#> iter   9 value 762.697342
#> iter   9 value 762.697342
#> final  value 762.697342 
#> converged
#> This is Run number  252 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.5596742  0.55386934   2.009674 -12.0461307      1
#> 2     1  -0.95  -2.35 -0.2015699  2.93604776  -1.151570   0.5860478      2
#> 3     1  -6.20  -2.30 -0.1707201 -0.07179202  -6.370720  -2.3717920      2
#> 4     1 -13.90  -2.55 -0.1397897  0.04092373 -14.039790  -2.5090763      2
#> 5     1 -14.40  -5.80 -0.3211993  2.73792648 -14.721199  -3.0620735      2
#> 6     1  -3.60  -1.70  0.3891829  1.58555717  -3.210817  -0.1144428      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -39125   6675 
#> initial  value 998.131940 
#> iter   2 value 809.707936
#> iter   3 value 796.307177
#> iter   4 value 793.614386
#> iter   5 value 758.761945
#> iter   6 value 750.140558
#> iter   7 value 748.781748
#> iter   8 value 748.751536
#> iter   9 value 748.751486
#> iter   9 value 748.751477
#> iter   9 value 748.751472
#> final  value 748.751472 
#> converged
#> This is Run number  253 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6197171  0.999364053  -1.169717 -11.600636      1
#> 2     1  -0.95  -2.35  1.1803660  0.557361371   0.230366  -1.792639      1
#> 3     1  -6.20  -2.30  2.7702375 -0.938393045  -3.429762  -3.238393      2
#> 4     1 -13.90  -2.55 -1.0333665  0.000621511 -14.933366  -2.549378      2
#> 5     1 -14.40  -5.80  5.6772584  0.337473267  -8.722742  -5.462527      2
#> 6     1  -3.60  -1.70  0.7180809 -1.523482153  -2.881919  -3.223482      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -40025   7325 
#> initial  value 998.131940 
#> iter   2 value 791.919262
#> iter   3 value 777.766786
#> iter   4 value 776.609688
#> iter   5 value 744.145843
#> iter   6 value 735.460709
#> iter   7 value 734.252548
#> iter   8 value 734.227952
#> iter   9 value 734.227923
#> iter   9 value 734.227913
#> iter   9 value 734.227906
#> final  value 734.227906 
#> converged
#> This is Run number  254 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  4.1904158  2.59241227   3.6404158 -10.0075877      1
#> 2     1  -0.95  -2.35  0.6318071  2.14138571  -0.3181929  -0.2086143      2
#> 3     1  -6.20  -2.30 -0.4486886  0.32046953  -6.6486886  -1.9795305      2
#> 4     1 -13.90  -2.55  3.4114280  0.03430246 -10.4885720  -2.5156975      2
#> 5     1 -14.40  -5.80 -0.7089325  2.62019631 -15.1089325  -3.1798037      2
#> 6     1  -3.60  -1.70  6.6011162 -0.72163302   3.0011162  -2.4216330      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -38750   7500 
#> initial  value 998.131940 
#> iter   2 value 810.634163
#> iter   3 value 796.418401
#> iter   4 value 794.857008
#> iter   5 value 758.707181
#> iter   6 value 750.192886
#> iter   7 value 748.934718
#> iter   8 value 748.910741
#> iter   9 value 748.910713
#> iter   9 value 748.910703
#> iter   9 value 748.910696
#> final  value 748.910696 
#> converged
#> This is Run number  255 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 0.4402523 -0.9887353  -0.1097477 -13.5887353      1
#> 2     1  -0.95  -2.35 1.5494531  2.8822533   0.5994531   0.5322533      1
#> 3     1  -6.20  -2.30 0.7975385 -0.4613180  -5.4024615  -2.7613180      2
#> 4     1 -13.90  -2.55 0.8567760 -0.9043923 -13.0432240  -3.4543923      2
#> 5     1 -14.40  -5.80 0.2642116 -0.6270664 -14.1357884  -6.4270664      2
#> 6     1  -3.60  -1.70 0.4927658  1.8388325  -3.1072342   0.1388325      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6660 -39125   6500 
#> initial  value 998.131940 
#> iter   2 value 810.270795
#> iter   3 value 799.443926
#> iter   4 value 798.081893
#> iter   5 value 762.782520
#> iter   6 value 754.152172
#> iter   7 value 752.695273
#> iter   8 value 752.660657
#> iter   9 value 752.660586
#> iter  10 value 752.660574
#> iter  10 value 752.660567
#> iter  10 value 752.660561
#> final  value 752.660561 
#> converged
#> This is Run number  256 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2436453  1.18896074  -0.7936453 -11.411039      1
#> 2     1  -0.95  -2.35  2.2454091 -0.11922326   1.2954091  -2.469223      1
#> 3     1  -6.20  -2.30 -0.2637810  0.42521340  -6.4637810  -1.874787      2
#> 4     1 -13.90  -2.55 -0.5819784  2.42218098 -14.4819784  -0.127819      2
#> 5     1 -14.40  -5.80  4.0508737 -0.01946365 -10.3491263  -5.819464      2
#> 6     1  -3.60  -1.70  1.3757228  2.77810478  -2.2242772   1.078105      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6100 -40625   8150 
#> initial  value 998.131940 
#> iter   2 value 777.662101
#> iter   3 value 757.006316
#> iter   4 value 754.138877
#> iter   5 value 724.325319
#> iter   6 value 715.943653
#> iter   7 value 714.935922
#> iter   8 value 714.920615
#> iter   9 value 714.920604
#> iter   9 value 714.920598
#> iter   9 value 714.920598
#> final  value 714.920598 
#> converged
#> This is Run number  257 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 1.27071338 -0.3540568   0.7207134 -12.9540568      1
#> 2     1  -0.95  -2.35 0.07494138  0.4708555  -0.8750586  -1.8791445      1
#> 3     1  -6.20  -2.30 1.49787382  1.5970045  -4.7021262  -0.7029955      2
#> 4     1 -13.90  -2.55 0.04792892 -0.3201371 -13.8520711  -2.8701371      2
#> 5     1 -14.40  -5.80 0.50897854  0.7292844 -13.8910215  -5.0707156      2
#> 6     1  -3.60  -1.70 0.36966777 -0.3580409  -3.2303322  -2.0580409      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7040 -39325   6300 
#> initial  value 998.131940 
#> iter   2 value 807.854068
#> iter   3 value 798.454167
#> iter   4 value 797.719068
#> iter   5 value 762.759881
#> iter   6 value 754.095581
#> iter   7 value 752.556624
#> iter   8 value 752.517842
#> iter   9 value 752.517749
#> iter  10 value 752.517734
#> iter  10 value 752.517727
#> iter  10 value 752.517720
#> final  value 752.517720 
#> converged
#> This is Run number  258 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.33196803  2.0588522  -0.2180320 -10.541148      1
#> 2     1  -0.95  -2.35  0.12840013 -0.2039175  -0.8215999  -2.553917      1
#> 3     1  -6.20  -2.30 -0.08936058  0.1248208  -6.2893606  -2.175179      2
#> 4     1 -13.90  -2.55  0.89975357  0.4167752 -13.0002464  -2.133225      2
#> 5     1 -14.40  -5.80 -0.44046379 -0.2346377 -14.8404638  -6.034638      2
#> 6     1  -3.60  -1.70  0.52815807  0.3637958  -3.0718419  -1.336204      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6040 -38150   6875 
#> initial  value 998.131940 
#> iter   2 value 822.927788
#> iter   3 value 810.617600
#> iter   4 value 808.600803
#> iter   5 value 770.726039
#> iter   6 value 762.298998
#> iter   7 value 760.918630
#> iter   8 value 760.889857
#> iter   9 value 760.889811
#> iter   9 value 760.889800
#> iter   9 value 760.889794
#> final  value 760.889794 
#> converged
#> This is Run number  259 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.8780564  2.20764333  -1.428056 -10.392357      1
#> 2     1  -0.95  -2.35  1.4397950 -1.50001471   0.489795  -3.850015      1
#> 3     1  -6.20  -2.30 -0.2169486 -0.91174839  -6.416949  -3.211748      2
#> 4     1 -13.90  -2.55 -0.1822472 -0.09998267 -14.082247  -2.649983      2
#> 5     1 -14.40  -5.80  0.6001515 -0.08210979 -13.799849  -5.882110      2
#> 6     1  -3.60  -1.70  1.7128590 -1.49172820  -1.887141  -3.191728      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -40025   7825 
#> initial  value 998.131940 
#> iter   2 value 789.078234
#> iter   3 value 772.664622
#> iter   4 value 771.347166
#> iter   5 value 739.089936
#> iter   6 value 730.502929
#> iter   7 value 729.385127
#> iter   8 value 729.365821
#> iter   9 value 729.365800
#> iter   9 value 729.365792
#> iter   9 value 729.365786
#> final  value 729.365786 
#> converged
#> This is Run number  260 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.2026689 -0.2758724   0.6526689 -12.8758724      1
#> 2     1  -0.95  -2.35 -1.5887154  3.0894023  -2.5387154   0.7394023      2
#> 3     1  -6.20  -2.30  1.0129490 -0.3665425  -5.1870510  -2.6665425      2
#> 4     1 -13.90  -2.55  2.8700788  0.7383350 -11.0299212  -1.8116650      2
#> 5     1 -14.40  -5.80  3.1028744 -0.5085462 -11.2971256  -6.3085462      2
#> 6     1  -3.60  -1.70  0.0027649  0.4068498  -3.5972351  -1.2931502      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -37750   7200 
#> initial  value 998.131940 
#> iter   2 value 826.843666
#> iter   3 value 813.126525
#> iter   4 value 810.641819
#> iter   5 value 771.784682
#> iter   6 value 763.460592
#> iter   7 value 762.142673
#> iter   8 value 762.117632
#> iter   9 value 762.117600
#> iter   9 value 762.117590
#> iter   9 value 762.117585
#> final  value 762.117585 
#> converged
#> This is Run number  261 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.03938052  1.1927672  -0.5893805 -11.4072328      1
#> 2     1  -0.95  -2.35  3.13432496  0.2028294   2.1843250  -2.1471706      1
#> 3     1  -6.20  -2.30 -0.42791980  0.1915672  -6.6279198  -2.1084328      2
#> 4     1 -13.90  -2.55  2.85895386 -0.5962267 -11.0410461  -3.1462267      2
#> 5     1 -14.40  -5.80 -0.93648301 -1.1104720 -15.3364830  -6.9104720      2
#> 6     1  -3.60  -1.70  0.08913710  1.0899383  -3.5108629  -0.6100617      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5360 -37550   7425 
#> initial  value 998.131940 
#> iter   2 value 828.307070
#> iter   3 value 812.975935
#> iter   4 value 809.816103
#> iter   5 value 770.574733
#> iter   6 value 762.307716
#> iter   7 value 761.032284
#> iter   8 value 761.009774
#> iter   9 value 761.009751
#> iter   9 value 761.009742
#> iter   9 value 761.009738
#> final  value 761.009738 
#> converged
#> This is Run number  262 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1425067 -1.4406223  -0.4074933 -14.04062235      1
#> 2     1  -0.95  -2.35  0.1678418  1.3499121  -0.7821582  -1.00008795      1
#> 3     1  -6.20  -2.30 -0.1230280 -0.6759555  -6.3230280  -2.97595551      2
#> 4     1 -13.90  -2.55  2.4721228  2.4826997 -11.4278772  -0.06730028      2
#> 5     1 -14.40  -5.80  0.5183590 -0.4281362 -13.8816410  -6.22813621      2
#> 6     1  -3.60  -1.70 -0.4999486  1.1265143  -4.0999486  -0.57348566      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38925   7800 
#> initial  value 998.131940 
#> iter   2 value 806.010915
#> iter   3 value 791.830837
#> iter   4 value 791.153079
#> iter   5 value 755.342687
#> iter   6 value 746.791024
#> iter   7 value 745.574160
#> iter   8 value 745.552279
#> iter   8 value 745.552272
#> final  value 745.552272 
#> converged
#> This is Run number  263 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6377269 -0.50416279   0.08772691 -13.104163      1
#> 2     1  -0.95  -2.35 -0.5738979 -0.01040989  -1.52389790  -2.360410      1
#> 3     1  -6.20  -2.30  1.0005281 -0.16308516  -5.19947187  -2.463085      2
#> 4     1 -13.90  -2.55  0.7276166  0.29187939 -13.17238336  -2.258121      2
#> 5     1 -14.40  -5.80  2.3134102  3.51299710 -12.08658979  -2.287003      2
#> 6     1  -3.60  -1.70  1.7366259 -0.12815988  -1.86337412  -1.828160      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5920 -37100   6550 
#> initial  value 998.131940 
#> iter   2 value 839.187781
#> iter   3 value 828.928431
#> iter   4 value 827.146195
#> iter   5 value 786.245981
#> iter   6 value 778.098462
#> iter   7 value 776.651350
#> iter   8 value 776.621914
#> iter   9 value 776.621860
#> iter   9 value 776.621858
#> iter   9 value 776.621858
#> final  value 776.621858 
#> converged
#> This is Run number  264 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6209664  0.6631102   0.07096643 -11.9368898      1
#> 2     1  -0.95  -2.35  0.8757897 -1.5785130  -0.07421032  -3.9285130      1
#> 3     1  -6.20  -2.30 -0.5101587  3.4580951  -6.71015870   1.1580951      2
#> 4     1 -13.90  -2.55 -0.2240903  0.8752780 -14.12409029  -1.6747220      2
#> 5     1 -14.40  -5.80  0.9276813  3.3713160 -13.47231873  -2.4286840      2
#> 6     1  -3.60  -1.70 -0.1044358  1.1091605  -3.70443581  -0.5908395      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -37825   7100 
#> initial  value 998.131940 
#> iter   2 value 826.266903
#> iter   3 value 814.185859
#> iter   4 value 812.588821
#> iter   5 value 773.680367
#> iter   6 value 765.331249
#> iter   7 value 763.973071
#> iter   8 value 763.945951
#> iter   9 value 763.945909
#> iter  10 value 763.945897
#> iter  10 value 763.945887
#> iter  10 value 763.945885
#> final  value 763.945885 
#> converged
#> This is Run number  265 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2552601 -0.08744323  -0.8052601 -12.687443      1
#> 2     1  -0.95  -2.35 -0.8589044  1.28768019  -1.8089044  -1.062320      2
#> 3     1  -6.20  -2.30  0.9168319  0.22914383  -5.2831681  -2.070856      2
#> 4     1 -13.90  -2.55  0.5863428  0.47770852 -13.3136572  -2.072291      2
#> 5     1 -14.40  -5.80 -1.8810551 -0.27699357 -16.2810551  -6.076994      2
#> 6     1  -3.60  -1.70  2.2326590 -0.95832001  -1.3673410  -2.658320      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -38000   7000 
#> initial  value 998.131940 
#> iter   2 value 824.199771
#> iter   3 value 813.149956
#> iter   4 value 812.129540
#> iter   5 value 773.535088
#> iter   6 value 765.136071
#> iter   7 value 763.739798
#> iter   8 value 763.710586
#> iter   9 value 763.710534
#> iter  10 value 763.710520
#> iter  10 value 763.710509
#> iter  10 value 763.710507
#> final  value 763.710507 
#> converged
#> This is Run number  266 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2           U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5521719  2.1162354   0.002171926 -10.483765      1
#> 2     1  -0.95  -2.35  0.9513936 -0.7059960   0.001393558  -3.055996      1
#> 3     1  -6.20  -2.30  1.0143771  1.0757955  -5.185622869  -1.224204      2
#> 4     1 -13.90  -2.55  1.4865684 -0.3557861 -12.413431599  -2.905786      2
#> 5     1 -14.40  -5.80  0.3326057  0.8715644 -14.067394292  -4.928436      2
#> 6     1  -3.60  -1.70 -0.5109481  0.1392917  -4.110948112  -1.560708      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6160 -37575   7950 
#> initial  value 998.131940 
#> iter   2 value 824.547919
#> iter   3 value 811.706234
#> iter   4 value 811.198739
#> iter   5 value 771.355225
#> iter   6 value 763.040429
#> iter   7 value 761.793135
#> iter   8 value 761.772096
#> iter   8 value 761.772095
#> final  value 761.772095 
#> converged
#> This is Run number  267 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  3.6418425  1.1239771   3.09184245 -11.4760229      1
#> 2     1  -0.95  -2.35  0.9290501 -0.5259110  -0.02094991  -2.8759110      1
#> 3     1  -6.20  -2.30  1.8655929  1.3855948  -4.33440705  -0.9144052      2
#> 4     1 -13.90  -2.55  0.6335735  4.4043032 -13.26642652   1.8543032      2
#> 5     1 -14.40  -5.80  1.3032937  0.4693574 -13.09670632  -5.3306426      2
#> 6     1  -3.60  -1.70 -1.5845678  3.6242659  -5.18456785   1.9242659      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7080 -38775   6875 
#> initial  value 998.131940 
#> iter   2 value 812.963624
#> iter   3 value 803.078116
#> iter   4 value 802.940144
#> iter   5 value 766.323858
#> iter   6 value 757.748867
#> iter   7 value 756.287536
#> iter   8 value 756.253636
#> iter   9 value 756.253561
#> iter  10 value 756.253542
#> iter  10 value 756.253533
#> iter  10 value 756.253525
#> final  value 756.253525 
#> converged
#> This is Run number  268 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.85863948 -0.4506675   1.3086395 -13.050668      1
#> 2     1  -0.95  -2.35  0.04596431 -1.5868603  -0.9040357  -3.936860      1
#> 3     1  -6.20  -2.30 -1.23894270  0.2192232  -7.4389427  -2.080777      2
#> 4     1 -13.90  -2.55 -1.77185545 -0.4983418 -15.6718554  -3.048342      2
#> 5     1 -14.40  -5.80 -0.40853453  0.2119774 -14.8085345  -5.588023      2
#> 6     1  -3.60  -1.70  0.50957777 -0.4919903  -3.0904222  -2.191990      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6840 -39725   5950 
#> initial  value 998.131940 
#> iter   2 value 803.676913
#> iter   3 value 793.477023
#> iter   4 value 791.586709
#> iter   5 value 758.173955
#> iter   6 value 749.450544
#> iter   7 value 747.901674
#> iter   8 value 747.860808
#> iter   9 value 747.860704
#> iter  10 value 747.860691
#> iter  10 value 747.860691
#> iter  10 value 747.860685
#> final  value 747.860685 
#> converged
#> This is Run number  269 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7718741 -0.3199869   0.2218741 -12.9199869      1
#> 2     1  -0.95  -2.35 -0.3593836 -0.6087115  -1.3093836  -2.9587115      1
#> 3     1  -6.20  -2.30 -0.2082694  0.4688898  -6.4082694  -1.8311102      2
#> 4     1 -13.90  -2.55  1.1035857  0.4758437 -12.7964143  -2.0741563      2
#> 5     1 -14.40  -5.80  1.2532171  2.1069011 -13.1467829  -3.6930989      2
#> 6     1  -3.60  -1.70  0.1925566  1.2763763  -3.4074434  -0.4236237      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6400 -38225   6325 
#> initial  value 998.131940 
#> iter   2 value 824.513406
#> iter   3 value 814.505051
#> iter   4 value 812.957506
#> iter   5 value 775.096424
#> iter   6 value 766.656763
#> iter   7 value 765.137024
#> iter   8 value 765.102162
#> iter   9 value 765.102086
#> iter  10 value 765.102074
#> iter  10 value 765.102068
#> iter  10 value 765.102064
#> final  value 765.102064 
#> converged
#> This is Run number  270 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.60425824  0.3128764   1.0542582 -12.287124      1
#> 2     1  -0.95  -2.35  0.07235627  3.5707550  -0.8776437   1.220755      2
#> 3     1  -6.20  -2.30  0.96356455 -0.1455178  -5.2364354  -2.445518      2
#> 4     1 -13.90  -2.55  1.17866977  0.7324385 -12.7213302  -1.817561      2
#> 5     1 -14.40  -5.80  0.68413629  0.6136341 -13.7158637  -5.186366      2
#> 6     1  -3.60  -1.70 -0.25629799 -0.1790901  -3.8562980  -1.879090      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -38800   6125 
#> initial  value 998.131940 
#> iter   2 value 817.221522
#> iter   3 value 805.990434
#> iter   4 value 803.505758
#> iter   5 value 767.572377
#> iter   6 value 758.993323
#> iter   7 value 757.478627
#> iter   8 value 757.442193
#> iter   9 value 757.442111
#> iter   9 value 757.442100
#> iter   9 value 757.442094
#> final  value 757.442094 
#> converged
#> This is Run number  271 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.3979533 -0.3033646   0.8479533 -12.9033646      1
#> 2     1  -0.95  -2.35  1.2403548 -0.1480009   0.2903548  -2.4980009      1
#> 3     1  -6.20  -2.30  0.0979576 -0.4825124  -6.1020424  -2.7825124      2
#> 4     1 -13.90  -2.55 -0.5131946  2.7826686 -14.4131946   0.2326686      2
#> 5     1 -14.40  -5.80  1.4826828  0.8766343 -12.9173172  -4.9233657      2
#> 6     1  -3.60  -1.70  0.7357638  1.2998386  -2.8642362  -0.4001614      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6140 -38450   7975 
#> initial  value 998.131940 
#> iter   2 value 812.070245
#> iter   3 value 797.297561
#> iter   4 value 796.294107
#> iter   5 value 759.173788
#> iter   6 value 750.725941
#> iter   7 value 749.518966
#> iter   8 value 749.498661
#> iter   9 value 749.498644
#> iter   9 value 749.498641
#> iter  10 value 749.498626
#> iter  10 value 749.498616
#> iter  10 value 749.498614
#> final  value 749.498614 
#> converged
#> This is Run number  272 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2048856  0.7941502  -0.3451144 -11.8058498      1
#> 2     1  -0.95  -2.35  1.4538246  1.3645683   0.5038246  -0.9854317      1
#> 3     1  -6.20  -2.30  1.7738528  0.3578582  -4.4261472  -1.9421418      2
#> 4     1 -13.90  -2.55  1.4193496  2.0273056 -12.4806504  -0.5226944      2
#> 5     1 -14.40  -5.80 -0.4247481  3.9689190 -14.8247481  -1.8310810      2
#> 6     1  -3.60  -1.70  4.8461607 -0.4444106   1.2461607  -2.1444106      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38625   7300 
#> initial  value 998.131940 
#> iter   2 value 813.436569
#> iter   3 value 801.091505
#> iter   4 value 800.236617
#> iter   5 value 763.462989
#> iter   6 value 754.932131
#> iter   7 value 753.609375
#> iter   8 value 753.582383
#> iter   9 value 753.582341
#> iter  10 value 753.582327
#> iter  10 value 753.582318
#> iter  10 value 753.582311
#> final  value 753.582311 
#> converged
#> This is Run number  273 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.2631006 -0.4689069  -1.813101 -13.068907      1
#> 2     1  -0.95  -2.35 -1.1052696  0.4636591  -2.055270  -1.886341      2
#> 3     1  -6.20  -2.30 -0.4097308 -0.2536360  -6.609731  -2.553636      2
#> 4     1 -13.90  -2.55 -0.7447861  4.4598698 -14.644786   1.909870      2
#> 5     1 -14.40  -5.80  2.4652082 -0.6402120 -11.934792  -6.440212      2
#> 6     1  -3.60  -1.70 -0.9450787 -0.2502349  -4.545079  -1.950235      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -36225   6400 
#> initial  value 998.131940 
#> iter   2 value 850.892455
#> iter   3 value 844.306361
#> iter   4 value 844.158057
#> iter   5 value 800.508369
#> iter   6 value 792.693377
#> iter   7 value 791.161015
#> iter   8 value 791.129950
#> iter   9 value 791.129874
#> iter   9 value 791.129871
#> iter   9 value 791.129871
#> final  value 791.129871 
#> converged
#> This is Run number  274 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.77612950 -0.3865490  -1.3261295 -12.9865490      1
#> 2     1  -0.95  -2.35  0.05689359  0.3934569  -0.8931064  -1.9565431      1
#> 3     1  -6.20  -2.30  0.70066342 -0.8065447  -5.4993366  -3.1065447      2
#> 4     1 -13.90  -2.55 -0.86424704 -1.6095553 -14.7642470  -4.1595553      2
#> 5     1 -14.40  -5.80  1.63653758  1.2759479 -12.7634624  -4.5240521      2
#> 6     1  -3.60  -1.70  1.39532466  2.5278723  -2.2046753   0.8278723      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -39600   7900 
#> initial  value 998.131940 
#> iter   2 value 795.211057
#> iter   3 value 779.397964
#> iter   4 value 778.392022
#> iter   5 value 744.756702
#> iter   6 value 736.178833
#> iter   7 value 735.032101
#> iter   8 value 735.012473
#> iter   9 value 735.012451
#> iter   9 value 735.012444
#> iter   9 value 735.012435
#> final  value 735.012435 
#> converged
#> This is Run number  275 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.16437206  2.3694129  -0.3856279 -10.230587      1
#> 2     1  -0.95  -2.35  0.07988825 -0.3717487  -0.8701117  -2.721749      1
#> 3     1  -6.20  -2.30  0.26699233 -0.4774439  -5.9330077  -2.777444      2
#> 4     1 -13.90  -2.55  1.86501522 -0.3565152 -12.0349848  -2.906515      2
#> 5     1 -14.40  -5.80 -1.77503947 -0.3541150 -16.1750395  -6.154115      2
#> 6     1  -3.60  -1.70 -1.63781093 -0.5333874  -5.2378109  -2.233387      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6940 -40675   8075 
#> initial  value 998.131940 
#> iter   2 value 776.661939
#> iter   3 value 759.798327
#> iter   4 value 759.358912
#> iter   5 value 728.963762
#> iter   6 value 720.395247
#> iter   7 value 719.362215
#> iter   8 value 719.346455
#> iter   9 value 719.346436
#> iter   9 value 719.346435
#> iter   9 value 719.346435
#> final  value 719.346435 
#> converged
#> This is Run number  276 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9293992 -0.2619156   0.3793992 -12.8619156      1
#> 2     1  -0.95  -2.35 -1.4085752 -0.4011672  -2.3585752  -2.7511672      1
#> 3     1  -6.20  -2.30  0.8568314 -0.6484953  -5.3431686  -2.9484953      2
#> 4     1 -13.90  -2.55 -0.8541278 -0.6760779 -14.7541278  -3.2260779      2
#> 5     1 -14.40  -5.80  1.8478614  3.4641571 -12.5521386  -2.3358429      2
#> 6     1  -3.60  -1.70  2.4065746  1.1664569  -1.1934254  -0.5335431      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6800 -39175   6475 
#> initial  value 998.131940 
#> iter   2 value 809.508874
#> iter   3 value 799.180322
#> iter   4 value 798.126497
#> iter   5 value 762.865888
#> iter   6 value 754.225102
#> iter   7 value 752.747693
#> iter   8 value 752.712040
#> iter   9 value 752.711963
#> iter  10 value 752.711950
#> iter  10 value 752.711942
#> iter  10 value 752.711936
#> final  value 752.711936 
#> converged
#> This is Run number  277 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9055812  0.1417301  -1.455581 -12.4582699      1
#> 2     1  -0.95  -2.35  1.9247040 -0.2951434   0.974704  -2.6451434      1
#> 3     1  -6.20  -2.30  1.3158075 -1.4302361  -4.884192  -3.7302361      2
#> 4     1 -13.90  -2.55  1.0070552  0.8472370 -12.892945  -1.7027630      2
#> 5     1 -14.40  -5.80 -0.6332324 -0.7995667 -15.033232  -6.5995667      2
#> 6     1  -3.60  -1.70  0.6365395  0.9161157  -2.963460  -0.7838843      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6120 -37225   6350 
#> initial  value 998.131940 
#> iter   2 value 838.431526
#> iter   3 value 829.040606
#> iter   4 value 827.527501
#> iter   5 value 786.886136
#> iter   6 value 778.715630
#> iter   7 value 777.212920
#> iter   8 value 777.181141
#> iter   9 value 777.181076
#> iter   9 value 777.181074
#> iter   9 value 777.181074
#> final  value 777.181074 
#> converged
#> This is Run number  278 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.001524013 0.6411316  -0.5515240 -11.9588684      1
#> 2     1  -0.95  -2.35  0.750347116 1.0546986  -0.1996529  -1.2953014      1
#> 3     1  -6.20  -2.30  0.466137457 1.2934910  -5.7338625  -1.0065090      2
#> 4     1 -13.90  -2.55 -0.556914859 1.0221688 -14.4569149  -1.5278312      2
#> 5     1 -14.40  -5.80  0.531830013 2.6158880 -13.8681700  -3.1841120      2
#> 6     1  -3.60  -1.70  0.340057256 2.2176824  -3.2599427   0.5176824      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6660 -39800   6675 
#> initial  value 998.131940 
#> iter   2 value 799.085962
#> iter   3 value 786.689506
#> iter   4 value 784.952572
#> iter   5 value 751.821650
#> iter   6 value 743.104778
#> iter   7 value 741.755967
#> iter   8 value 741.724457
#> iter   9 value 741.724402
#> iter   9 value 741.724402
#> iter   9 value 741.724402
#> final  value 741.724402 
#> converged
#> This is Run number  279 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.7837237  1.5654851   2.233724 -11.0345149      1
#> 2     1  -0.95  -2.35 -0.7079730 -0.2799493  -1.657973  -2.6299493      1
#> 3     1  -6.20  -2.30  2.0591468  1.3507134  -4.140853  -0.9492866      2
#> 4     1 -13.90  -2.55 -0.2930431  0.4137083 -14.193043  -2.1362917      2
#> 5     1 -14.40  -5.80  0.6432261  2.3224831 -13.756774  -3.4775169      2
#> 6     1  -3.60  -1.70 -1.0362391  0.1764486  -4.636239  -1.5235514      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -38250   7300 
#> initial  value 998.131940 
#> iter   2 value 818.607814
#> iter   3 value 807.576347
#> iter   4 value 807.320138
#> iter   5 value 769.300237
#> iter   6 value 760.820854
#> iter   7 value 759.453848
#> iter   8 value 759.425536
#> iter   9 value 759.425485
#> iter  10 value 759.425469
#> iter  10 value 759.425460
#> iter  10 value 759.425452
#> final  value 759.425452 
#> converged
#> This is Run number  280 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4847143 -0.9930409  -1.034714 -13.5930409      1
#> 2     1  -0.95  -2.35 -1.3183224  0.3057531  -2.268322  -2.0442469      2
#> 3     1  -6.20  -2.30  1.3990523  0.8340658  -4.800948  -1.4659342      2
#> 4     1 -13.90  -2.55  2.1841161 -0.6417372 -11.715884  -3.1917372      2
#> 5     1 -14.40  -5.80  1.5175532 -0.9624980 -12.882447  -6.7624980      2
#> 6     1  -3.60  -1.70  0.2836440  1.9346242  -3.316356   0.2346242      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -38650   7725 
#> initial  value 998.131940 
#> iter   2 value 810.814263
#> iter   3 value 795.516409
#> iter   4 value 793.698524
#> iter   5 value 757.372226
#> iter   6 value 748.904535
#> iter   7 value 747.681931
#> iter   8 value 747.660163
#> iter   9 value 747.660142
#> iter   9 value 747.660134
#> iter   9 value 747.660134
#> final  value 747.660134 
#> converged
#> This is Run number  281 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1           U_2 CHOICE
#> 1     1  -0.55 -12.60  0.90509759  0.1638638   0.3550976 -12.436136228      1
#> 2     1  -0.95  -2.35 -0.71653521  0.9526180  -1.6665352  -1.397382042      2
#> 3     1  -6.20  -2.30  0.13383855 -0.8447082  -6.0661614  -3.144708183      2
#> 4     1 -13.90  -2.55 -0.11044502  5.0615541 -14.0104450   2.511554103      2
#> 5     1 -14.40  -5.80 -0.38939275  1.1222731 -14.7893928  -4.677726854      2
#> 6     1  -3.60  -1.70 -0.06628418  1.7069123  -3.6662842   0.006912299      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6680 -38650   6825 
#> initial  value 998.131940 
#> iter   2 value 815.542924
#> iter   3 value 804.944413
#> iter   4 value 804.212859
#> iter   5 value 767.377801
#> iter   6 value 758.831194
#> iter   7 value 757.398925
#> iter   8 value 757.366657
#> iter   9 value 757.366593
#> iter  10 value 757.366578
#> iter  10 value 757.366568
#> iter  10 value 757.366567
#> final  value 757.366567 
#> converged
#> This is Run number  282 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2013878  0.5743022  -0.3486122 -12.025698      1
#> 2     1  -0.95  -2.35  1.2066503  0.4031522   0.2566503  -1.946848      1
#> 3     1  -6.20  -2.30 -0.5835865  0.4178137  -6.7835865  -1.882186      2
#> 4     1 -13.90  -2.55  4.6214791 -0.2441506  -9.2785209  -2.794151      2
#> 5     1 -14.40  -5.80  1.0993522  0.5707295 -13.3006478  -5.229271      2
#> 6     1  -3.60  -1.70 -0.4120859  0.1823609  -4.0120859  -1.517639      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6260 -38850   7175 
#> initial  value 998.131940 
#> iter   2 value 811.005481
#> iter   3 value 797.705430
#> iter   4 value 796.054238
#> iter   5 value 760.162451
#> iter   6 value 751.608600
#> iter   7 value 750.299799
#> iter   8 value 750.272891
#> iter   9 value 750.272853
#> iter  10 value 750.272842
#> iter  10 value 750.272833
#> iter  10 value 750.272827
#> final  value 750.272827 
#> converged
#> This is Run number  283 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.00819158 -1.13168941   0.4581916 -13.731689      1
#> 2     1  -0.95  -2.35  0.42936756  4.24022332  -0.5206324   1.890223      2
#> 3     1  -6.20  -2.30 -0.55317758  0.92729462  -6.7531776  -1.372705      2
#> 4     1 -13.90  -2.55  1.10763434 -0.04370111 -12.7923657  -2.593701      2
#> 5     1 -14.40  -5.80 -0.00558303  0.48576025 -14.4055830  -5.314240      2
#> 6     1  -3.60  -1.70  0.25969910  4.65542024  -3.3403009   2.955420      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -38475   6700 
#> initial  value 998.131940 
#> iter   2 value 819.081953
#> iter   3 value 807.501082
#> iter   4 value 805.762303
#> iter   5 value 768.718316
#> iter   6 value 760.217025
#> iter   7 value 758.798340
#> iter   8 value 758.767109
#> iter   9 value 758.767052
#> iter   9 value 758.767052
#> iter   9 value 758.767052
#> final  value 758.767052 
#> converged
#> This is Run number  284 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.36788545 1.52636031  -0.9178854 -11.0736397      1
#> 2     1  -0.95  -2.35  0.63709467 0.70875165  -0.3129053  -1.6412484      1
#> 3     1  -6.20  -2.30  1.17739812 3.10833616  -5.0226019   0.8083362      2
#> 4     1 -13.90  -2.55 -0.09264853 0.33344740 -13.9926485  -2.2165526      2
#> 5     1 -14.40  -5.80  0.74080958 0.46590215 -13.6591904  -5.3340978      2
#> 6     1  -3.60  -1.70  0.08153080 0.09503826  -3.5184692  -1.6049617      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6600 -38725   6100 
#> initial  value 998.131940 
#> iter   2 value 818.228753
#> iter   3 value 808.503501
#> iter   4 value 806.905439
#> iter   5 value 770.473138
#> iter   6 value 761.927271
#> iter   7 value 760.358929
#> iter   8 value 760.320643
#> iter   9 value 760.320551
#> iter  10 value 760.320539
#> iter  10 value 760.320535
#> iter  10 value 760.320530
#> final  value 760.320530 
#> converged
#> This is Run number  285 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.6022371 -1.2033874  -1.1522371 -13.8033874      1
#> 2     1  -0.95  -2.35  1.8182032 -0.5521168   0.8682032  -2.9021168      1
#> 3     1  -6.20  -2.30  0.5816969 -0.4030901  -5.6183031  -2.7030901      2
#> 4     1 -13.90  -2.55 -0.6125738  1.9198178 -14.5125738  -0.6301822      2
#> 5     1 -14.40  -5.80  0.2860004  2.7830409 -14.1139996  -3.0169591      2
#> 6     1  -3.60  -1.70 -0.3261783 -0.8303205  -3.9261783  -2.5303205      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -39500   7625 
#> initial  value 998.131940 
#> iter   2 value 798.351681
#> iter   3 value 783.950087
#> iter   4 value 783.086683
#> iter   5 value 749.024474
#> iter   6 value 740.402224
#> iter   7 value 739.197563
#> iter   8 value 739.174837
#> iter   9 value 739.174811
#> iter   9 value 739.174804
#> iter   9 value 739.174801
#> final  value 739.174801 
#> converged
#> This is Run number  286 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1905537  2.18196627   0.6405537 -10.4180337      1
#> 2     1  -0.95  -2.35  0.5388286 -0.27934489  -0.4111714  -2.6293449      1
#> 3     1  -6.20  -2.30 -0.2610999  0.26879412  -6.4610999  -2.0312059      2
#> 4     1 -13.90  -2.55  0.9420888 -0.17029248 -12.9579112  -2.7202925      2
#> 5     1 -14.40  -5.80  0.1548488  0.06150118 -14.2451512  -5.7384988      2
#> 6     1  -3.60  -1.70 -0.1984917  0.95709282  -3.7984917  -0.7429072      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -40400   7475 
#> initial  value 998.131940 
#> iter   2 value 785.470845
#> iter   3 value 767.570924
#> iter   4 value 764.434163
#> iter   5 value 733.773438
#> iter   6 value 725.191845
#> iter   7 value 724.092364
#> iter   8 value 724.072099
#> iter   9 value 724.072087
#> iter   9 value 724.072083
#> iter   9 value 724.072080
#> final  value 724.072080 
#> converged
#> This is Run number  287 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5076248 0.98609725  -0.04237522 -11.6139028      1
#> 2     1  -0.95  -2.35  1.3573293 0.03920183   0.40732928  -2.3107982      1
#> 3     1  -6.20  -2.30 -0.3641849 2.01204306  -6.56418492  -0.2879569      2
#> 4     1 -13.90  -2.55 -0.1267031 4.96725074 -14.02670315   2.4172507      2
#> 5     1 -14.40  -5.80  0.2795242 1.54785148 -14.12047585  -4.2521485      2
#> 6     1  -3.60  -1.70  0.6619803 1.37428527  -2.93801969  -0.3257147      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6800 -39850   6600 
#> initial  value 998.131940 
#> iter   2 value 798.567507
#> iter   3 value 786.834120
#> iter   4 value 785.399487
#> iter   5 value 752.302906
#> iter   6 value 743.571146
#> iter   7 value 742.194513
#> iter   8 value 742.161541
#> iter   9 value 742.161480
#> iter  10 value 742.161469
#> iter  10 value 742.161462
#> iter  10 value 742.161456
#> final  value 742.161456 
#> converged
#> This is Run number  288 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.65580316 -0.4708927   1.1058032 -13.070893      1
#> 2     1  -0.95  -2.35  0.77763706 -0.2816477  -0.1723629  -2.631648      1
#> 3     1  -6.20  -2.30  0.68765278 -0.6020579  -5.5123472  -2.902058      2
#> 4     1 -13.90  -2.55 -0.04588102  0.1147279 -13.9458810  -2.435272      2
#> 5     1 -14.40  -5.80  0.08748400  1.7322508 -14.3125160  -4.067749      2
#> 6     1  -3.60  -1.70 -0.37499139  0.2620016  -3.9749914  -1.437998      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -38850   6600 
#> initial  value 998.131940 
#> iter   2 value 814.007535
#> iter   3 value 802.666717
#> iter   4 value 801.050467
#> iter   5 value 765.044212
#> iter   6 value 756.466101
#> iter   7 value 755.032867
#> iter   8 value 755.000046
#> iter   9 value 754.999983
#> iter   9 value 754.999983
#> iter   9 value 754.999983
#> final  value 754.999983 
#> converged
#> This is Run number  289 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6011042 -0.6826234   0.05110418 -13.282623      1
#> 2     1  -0.95  -2.35 -0.1339453 -0.6745897  -1.08394527  -3.024590      1
#> 3     1  -6.20  -2.30  1.2313434 -0.1002653  -4.96865656  -2.400265      2
#> 4     1 -13.90  -2.55 -0.1695969  0.6437505 -14.06959694  -1.906249      2
#> 5     1 -14.40  -5.80 -0.2062934  0.8690371 -14.60629341  -4.930963      2
#> 6     1  -3.60  -1.70 -0.8048178 -0.4197297  -4.40481781  -2.119730      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7100 -41100   6375 
#> initial  value 998.131940 
#> iter   2 value 779.349120
#> iter   3 value 767.145852
#> iter   4 value 765.318087
#> iter   5 value 736.111955
#> iter   6 value 727.303168
#> iter   7 value 726.024776
#> iter   8 value 725.992472
#> iter   9 value 725.992415
#> iter   9 value 725.992414
#> iter   9 value 725.992414
#> final  value 725.992414 
#> converged
#> This is Run number  290 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.008949155  1.6955392  -0.5410508 -10.9044608      1
#> 2     1  -0.95  -2.35  1.311077425  0.1578775   0.3610774  -2.1921225      1
#> 3     1  -6.20  -2.30 -0.300495483 -0.8522437  -6.5004955  -3.1522437      2
#> 4     1 -13.90  -2.55  3.281663352  0.8756732 -10.6183366  -1.6743268      2
#> 5     1 -14.40  -5.80 -0.523778478  1.6556789 -14.9237785  -4.1443211      2
#> 6     1  -3.60  -1.70  0.390782230  2.4784976  -3.2092178   0.7784976      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6780 -40425   7250 
#> initial  value 998.131940 
#> iter   2 value 785.945036
#> iter   3 value 771.545249
#> iter   4 value 770.243577
#> iter   5 value 739.026683
#> iter   6 value 730.323080
#> iter   7 value 729.144734
#> iter   8 value 729.120485
#> iter   9 value 729.120458
#> iter   9 value 729.120450
#> iter   9 value 729.120449
#> final  value 729.120449 
#> converged
#> This is Run number  291 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9916452 -0.1556574  -1.5416452 -12.7556574      1
#> 2     1  -0.95  -2.35  0.4452418 -0.8554306  -0.5047582  -3.2054306      1
#> 3     1  -6.20  -2.30  1.6855650 -0.6379268  -4.5144350  -2.9379268      2
#> 4     1 -13.90  -2.55  2.1738105  2.1950055 -11.7261895  -0.3549945      2
#> 5     1 -14.40  -5.80 -0.5885028  1.6089816 -14.9885028  -4.1910184      2
#> 6     1  -3.60  -1.70 -0.1394898  0.1004576  -3.7394898  -1.5995424      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -38650   7450 
#> initial  value 998.131940 
#> iter   2 value 812.506146
#> iter   3 value 797.376118
#> iter   4 value 795.017916
#> iter   5 value 758.800075
#> iter   6 value 750.317222
#> iter   7 value 749.063814
#> iter   8 value 749.040236
#> iter   9 value 749.040210
#> iter   9 value 749.040201
#> iter   9 value 749.040196
#> final  value 749.040196 
#> converged
#> This is Run number  292 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.60597228 -0.94821184  -1.1559723 -13.5482118      1
#> 2     1  -0.95  -2.35  0.12246990  0.18554587  -0.8275301  -2.1644541      1
#> 3     1  -6.20  -2.30 -1.07231477 -0.17785620  -7.2723148  -2.4778562      2
#> 4     1 -13.90  -2.55  0.04241251  0.06740511 -13.8575875  -2.4825949      2
#> 5     1 -14.40  -5.80  2.04608595  5.22571290 -12.3539141  -0.5742871      2
#> 6     1  -3.60  -1.70 -0.11791534 -1.01692523  -3.7179153  -2.7169252      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6460 -39250   7300 
#> initial  value 998.131940 
#> iter   2 value 804.182615
#> iter   3 value 790.644777
#> iter   4 value 789.374218
#> iter   5 value 754.587770
#> iter   6 value 745.974760
#> iter   7 value 744.702271
#> iter   8 value 744.676314
#> iter   9 value 744.676279
#> iter  10 value 744.676268
#> iter  10 value 744.676259
#> iter  10 value 744.676253
#> final  value 744.676253 
#> converged
#> This is Run number  293 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.029249747  0.3062264   0.4792497 -12.2937736      1
#> 2     1  -0.95  -2.35  0.514623864 -1.8646259  -0.4353761  -4.2146259      1
#> 3     1  -6.20  -2.30 -0.448628938 -0.2372209  -6.6486289  -2.5372209      2
#> 4     1 -13.90  -2.55  0.001758364 -1.0346977 -13.8982416  -3.5846977      2
#> 5     1 -14.40  -5.80  2.537414429 -0.6550224 -11.8625856  -6.4550224      2
#> 6     1  -3.60  -1.70  0.715012376  1.1727556  -2.8849876  -0.5272444      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -39650   8000 
#> initial  value 998.131940 
#> iter   2 value 793.893537
#> iter   3 value 777.214278
#> iter   4 value 775.934878
#> iter   5 value 742.562318
#> iter   6 value 734.018357
#> iter   7 value 732.894443
#> iter   8 value 732.875967
#> iter   9 value 732.875950
#> iter   9 value 732.875947
#> iter   9 value 732.875938
#> final  value 732.875938 
#> converged
#> This is Run number  294 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4373996  0.1241813  -0.1126004 -12.475819      1
#> 2     1  -0.95  -2.35 -0.5165349  1.0056473  -1.4665349  -1.344353      2
#> 3     1  -6.20  -2.30  2.0784907  1.2938491  -4.1215093  -1.006151      2
#> 4     1 -13.90  -2.55  1.7012782  0.6811564 -12.1987218  -1.868844      2
#> 5     1 -14.40  -5.80  0.1512028 -0.5688786 -14.2487972  -6.368879      2
#> 6     1  -3.60  -1.70  0.9094314 -0.7829091  -2.6905686  -2.482909      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -37150   6000 
#> initial  value 998.131940 
#> iter   2 value 840.750672
#> iter   3 value 833.693096
#> iter   4 value 833.079268
#> iter   5 value 791.941793
#> iter   6 value 783.843641
#> iter   7 value 782.210124
#> iter   8 value 782.173958
#> iter   9 value 782.173866
#> iter   9 value 782.173864
#> iter   9 value 782.173864
#> final  value 782.173864 
#> converged
#> This is Run number  295 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7938052 -0.9760831  -1.343805 -13.5760831      1
#> 2     1  -0.95  -2.35 -1.0282976  2.0448155  -1.978298  -0.3051845      2
#> 3     1  -6.20  -2.30  1.9459048  1.2208429  -4.254095  -1.0791571      2
#> 4     1 -13.90  -2.55 -0.6605715  1.6678608 -14.560571  -0.8821392      2
#> 5     1 -14.40  -5.80 -0.3434108 -1.1886303 -14.743411  -6.9886303      2
#> 6     1  -3.60  -1.70  2.3465152 -0.2127604  -1.253485  -1.9127604      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6940 -39775   6500 
#> initial  value 998.131940 
#> iter   2 value 800.092343
#> iter   3 value 789.243112
#> iter   4 value 788.152435
#> iter   5 value 754.693154
#> iter   6 value 745.961532
#> iter   7 value 744.534405
#> iter   8 value 744.499295
#> iter   9 value 744.499223
#> iter  10 value 744.499211
#> iter  10 value 744.499204
#> iter  10 value 744.499197
#> final  value 744.499197 
#> converged
#> This is Run number  296 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7061212 -0.6689785  -1.256121 -13.2689785      1
#> 2     1  -0.95  -2.35 -1.1758519  0.9209812  -2.125852  -1.4290188      2
#> 3     1  -6.20  -2.30  3.2063767  2.0893906  -2.993623  -0.2106094      2
#> 4     1 -13.90  -2.55  2.5097990  1.7489708 -11.390201  -0.8010292      2
#> 5     1 -14.40  -5.80  1.2575136 -1.2619651 -13.142486  -7.0619651      2
#> 6     1  -3.60  -1.70  2.3667859  0.5637031  -1.233214  -1.1362969      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7040 -40525   7075 
#> initial  value 998.131940 
#> iter   2 value 785.046841
#> iter   3 value 771.923139
#> iter   4 value 771.078567
#> iter   5 value 739.970771
#> iter   6 value 731.217083
#> iter   7 value 729.996208
#> iter   8 value 729.969426
#> iter   9 value 729.969390
#> iter   9 value 729.969380
#> iter   9 value 729.969372
#> final  value 729.969372 
#> converged
#> This is Run number  297 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.14881095  0.9628600  -0.6988109 -11.6371400      1
#> 2     1  -0.95  -2.35 -1.14492168  1.2328233  -2.0949217  -1.1171767      2
#> 3     1  -6.20  -2.30 -0.24911549  2.4536071  -6.4491155   0.1536071      2
#> 4     1 -13.90  -2.55  1.80287760 -0.6935562 -12.0971224  -3.2435562      2
#> 5     1 -14.40  -5.80  0.54510694 -0.0591580 -13.8548931  -5.8591580      2
#> 6     1  -3.60  -1.70  0.06751875 -1.2220161  -3.5324813  -2.9220161      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6980 -38725   5425 
#> initial  value 998.131940 
#> iter   2 value 820.869048
#> iter   3 value 813.534167
#> iter   4 value 812.315178
#> iter   5 value 775.724510
#> iter   6 value 767.240817
#> iter   7 value 765.437546
#> iter   8 value 765.389753
#> iter   9 value 765.389596
#> iter  10 value 765.389580
#> iter  10 value 765.389580
#> iter  10 value 765.389574
#> final  value 765.389574 
#> converged
#> This is Run number  298 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9067815  0.8753344   0.3567815 -11.7246656      1
#> 2     1  -0.95  -2.35 -0.3677609  1.2240229  -1.3177609  -1.1259771      2
#> 3     1  -6.20  -2.30  0.1482319  2.6328132  -6.0517681   0.3328132      2
#> 4     1 -13.90  -2.55 -0.3982143  0.3043862 -14.2982143  -2.2456138      2
#> 5     1 -14.40  -5.80  0.1167783 -0.4050884 -14.2832217  -6.2050884      2
#> 6     1  -3.60  -1.70  1.0130777 -0.6064547  -2.5869223  -2.3064547      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5500 -37825   7150 
#> initial  value 998.131940 
#> iter   2 value 826.089012
#> iter   3 value 811.223275
#> iter   4 value 808.003946
#> iter   5 value 769.543490
#> iter   6 value 761.194658
#> iter   7 value 759.889914
#> iter   8 value 759.865375
#> iter   9 value 759.865346
#> iter   9 value 759.865338
#> iter   9 value 759.865333
#> final  value 759.865333 
#> converged
#> This is Run number  299 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.5361188 1.2465345   0.98611875 -11.3534655      1
#> 2     1  -0.95  -2.35  0.9603229 1.8858991   0.01032288  -0.4641009      1
#> 3     1  -6.20  -2.30  2.0126352 0.6903366  -4.18736484  -1.6096634      2
#> 4     1 -13.90  -2.55  1.8404572 0.6342280 -12.05954279  -1.9157720      2
#> 5     1 -14.40  -5.80 -0.5978029 1.4999378 -14.99780294  -4.3000622      2
#> 6     1  -3.60  -1.70 -0.1646452 1.9801847  -3.76464524   0.2801847      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -41075   7775 
#> initial  value 998.131940 
#> iter   2 value 772.434527
#> iter   3 value 754.113941
#> iter   4 value 752.026103
#> iter   5 value 723.240968
#> iter   6 value 714.741473
#> iter   7 value 713.732106
#> iter   8 value 713.715280
#> iter   8 value 713.715275
#> final  value 713.715275 
#> converged
#> This is Run number  300 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1          e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.15985898 -0.538808880   1.6098590 -13.138809      1
#> 2     1  -0.95  -2.35  1.37166454  0.356914519   0.4216645  -1.993085      1
#> 3     1  -6.20  -2.30 -0.16082264  0.429795970  -6.3608226  -1.870204      2
#> 4     1 -13.90  -2.55 -0.29086665  0.002522419 -14.1908667  -2.547478      2
#> 5     1 -14.40  -5.80  0.06632225 -0.550516303 -14.3336778  -6.350516      2
#> 6     1  -3.60  -1.70  0.64579898  0.110839458  -2.9542010  -1.589161      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -37775   6125 
#> initial  value 998.131940 
#> iter   2 value 831.530493
#> iter   3 value 823.698904
#> iter   4 value 823.037123
#> iter   5 value 783.604943
#> iter   6 value 775.308642
#> iter   7 value 773.686855
#> iter   8 value 773.649295
#> iter   9 value 773.649199
#> iter   9 value 773.649198
#> iter   9 value 773.649198
#> final  value 773.649198 
#> converged
#> This is Run number  301 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0314769  0.50718647  -1.581477 -12.092814      1
#> 2     1  -0.95  -2.35 -0.2983395 -0.09345339  -1.248339  -2.443453      1
#> 3     1  -6.20  -2.30  0.9058604  0.56780467  -5.294140  -1.732195      2
#> 4     1 -13.90  -2.55 -0.5552764  0.32242730 -14.455276  -2.227573      2
#> 5     1 -14.40  -5.80 -0.7087601  1.05892282 -15.108760  -4.741077      2
#> 6     1  -3.60  -1.70  0.7342840  0.61491542  -2.865716  -1.085085      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6840 -40400   7550 
#> initial  value 998.131940 
#> iter   2 value 784.501724
#> iter   3 value 769.537085
#> iter   4 value 768.676956
#> iter   5 value 737.349320
#> iter   6 value 728.676280
#> iter   7 value 727.538787
#> iter   8 value 727.517249
#> iter   8 value 727.517240
#> final  value 727.517240 
#> converged
#> This is Run number  302 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.094580 -0.6039929  -1.6445796 -13.203993      1
#> 2     1  -0.95  -2.35  1.314734 -0.3358880   0.3647341  -2.685888      1
#> 3     1  -6.20  -2.30 -1.225248 -0.2580781  -7.4252477  -2.558078      2
#> 4     1 -13.90  -2.55  1.266008  0.1781303 -12.6339917  -2.371870      2
#> 5     1 -14.40  -5.80  1.150231  1.1993404 -13.2497691  -4.600660      2
#> 6     1  -3.60  -1.70  4.937996 -0.9948892   1.3379958  -2.694889      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -36475   5975 
#> initial  value 998.131940 
#> iter   2 value 849.574907
#> iter   3 value 843.707622
#> iter   4 value 843.532292
#> iter   5 value 800.514690
#> iter   6 value 792.666006
#> iter   7 value 791.027325
#> iter   8 value 790.992729
#> iter   9 value 790.992636
#> iter   9 value 790.992632
#> iter   9 value 790.992632
#> final  value 790.992632 
#> converged
#> This is Run number  303 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.40590684  1.5524560  -0.9559068 -11.04754398      1
#> 2     1  -0.95  -2.35 -0.33068900  2.2673515  -1.2806890  -0.08264855      2
#> 3     1  -6.20  -2.30 -0.38422678  0.1304595  -6.5842268  -2.16954055      2
#> 4     1 -13.90  -2.55 -0.57065640  1.7052237 -14.4706564  -0.84477627      2
#> 5     1 -14.40  -5.80 -0.02260589 -1.0794134 -14.4226059  -6.87941340      2
#> 6     1  -3.60  -1.70  0.06341166  0.3808744  -3.5365883  -1.31912564      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6840 -39500   6275 
#> initial  value 998.131940 
#> iter   2 value 805.562955
#> iter   3 value 795.221860
#> iter   4 value 793.854560
#> iter   5 value 759.629597
#> iter   6 value 750.937319
#> iter   7 value 749.441954
#> iter   8 value 749.404488
#> iter   9 value 749.404404
#> iter  10 value 749.404392
#> iter  10 value 749.404386
#> iter  10 value 749.404380
#> final  value 749.404380 
#> converged
#> This is Run number  304 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1941545  3.4089685  -0.7441545 -9.191032      1
#> 2     1  -0.95  -2.35 -1.0789333  0.6011597  -2.0289333 -1.748840      2
#> 3     1  -6.20  -2.30  1.6960547  0.6016739  -4.5039453 -1.698326      2
#> 4     1 -13.90  -2.55  0.6120742 -0.2948327 -13.2879258 -2.844833      2
#> 5     1 -14.40  -5.80  0.3942412  2.4759091 -14.0057588 -3.324091      2
#> 6     1  -3.60  -1.70  3.2190117  0.2208039  -0.3809883 -1.479196      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7220 -41850   6450 
#> initial  value 998.131940 
#> iter   2 value 766.187794
#> iter   3 value 753.018139
#> iter   4 value 750.972112
#> iter   5 value 724.162974
#> iter   6 value 715.413173
#> iter   7 value 714.273728
#> iter   8 value 714.246030
#> iter   9 value 714.245992
#> iter   9 value 714.245991
#> iter   9 value 714.245991
#> final  value 714.245991 
#> converged
#> This is Run number  305 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.3478016  1.7110517  -0.2021984 -10.8889483      1
#> 2     1  -0.95  -2.35 -0.2451101  1.3942342  -1.1951101  -0.9557658      2
#> 3     1  -6.20  -2.30  0.6828095  0.2478457  -5.5171905  -2.0521543      2
#> 4     1 -13.90  -2.55  3.0780664 -0.1979902 -10.8219336  -2.7479902      2
#> 5     1 -14.40  -5.80 -0.1020145  1.6251434 -14.5020145  -4.1748566      2
#> 6     1  -3.60  -1.70 -0.8691831  4.7392815  -4.4691831   3.0392815      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -38800   6375 
#> initial  value 998.131940 
#> iter   2 value 816.019245
#> iter   3 value 804.269008
#> iter   4 value 801.912782
#> iter   5 value 765.964753
#> iter   6 value 757.389612
#> iter   7 value 755.932605
#> iter   8 value 755.898783
#> iter   9 value 755.898716
#> iter   9 value 755.898705
#> iter   9 value 755.898700
#> final  value 755.898700 
#> converged
#> This is Run number  306 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  3.7118829  0.4204475   3.1618829 -12.1795525      1
#> 2     1  -0.95  -2.35  1.7955725  1.7363490   0.8455725  -0.6136510      1
#> 3     1  -6.20  -2.30  0.4305091 -0.5401033  -5.7694909  -2.8401033      2
#> 4     1 -13.90  -2.55 -0.7927717  2.4304739 -14.6927717  -0.1195261      2
#> 5     1 -14.40  -5.80  1.2183661  4.1554752 -13.1816339  -1.6445248      2
#> 6     1  -3.60  -1.70  0.3869888 -0.2138273  -3.2130112  -1.9138273      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -37525   6700 
#> initial  value 998.131940 
#> iter   2 value 832.410565
#> iter   3 value 822.815260
#> iter   4 value 821.909317
#> iter   5 value 781.911301
#> iter   6 value 773.642775
#> iter   7 value 772.177353
#> iter   8 value 772.146191
#> iter   9 value 772.146128
#> iter  10 value 772.146114
#> iter  10 value 772.146103
#> iter  10 value 772.146095
#> final  value 772.146095 
#> converged
#> This is Run number  307 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.58356302  1.27763642   0.03356302 -11.322364      1
#> 2     1  -0.95  -2.35 -0.12069215 -0.14483300  -1.07069215  -2.494833      1
#> 3     1  -6.20  -2.30  0.01304100  0.06300025  -6.18695900  -2.237000      2
#> 4     1 -13.90  -2.55  0.04833979 -0.72771657 -13.85166021  -3.277717      2
#> 5     1 -14.40  -5.80 -0.31499846 -1.20290065 -14.71499846  -7.002901      2
#> 6     1  -3.60  -1.70  0.84668095  0.03858374  -2.75331905  -1.661416      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5400 -36175   7525 
#> initial  value 998.131940 
#> iter   2 value 845.930639
#> iter   3 value 834.155696
#> iter   4 value 832.456199
#> iter   5 value 788.977059
#> iter   6 value 781.089171
#> iter   7 value 779.810499
#> iter   8 value 779.789297
#> iter   9 value 779.789270
#> iter   9 value 779.789260
#> iter   9 value 779.789255
#> final  value 779.789255 
#> converged
#> This is Run number  308 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.08226743  1.7623610  -0.6322674 -10.8376390      1
#> 2     1  -0.95  -2.35  0.37250021 -1.2937515  -0.5774998  -3.6437515      1
#> 3     1  -6.20  -2.30  1.58191587  2.0350729  -4.6180841  -0.2649271      2
#> 4     1 -13.90  -2.55  0.79278414 -0.2474368 -13.1072159  -2.7974368      2
#> 5     1 -14.40  -5.80  1.31923177  1.1375148 -13.0807682  -4.6624852      2
#> 6     1  -3.60  -1.70  1.29156677 -0.4790823  -2.3084332  -2.1790823      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -38025   7200 
#> initial  value 998.131940 
#> iter   2 value 822.892938
#> iter   3 value 810.215793
#> iter   4 value 808.549339
#> iter   5 value 770.248237
#> iter   6 value 761.855908
#> iter   7 value 760.521086
#> iter   8 value 760.494689
#> iter   9 value 760.494651
#> iter  10 value 760.494639
#> iter  10 value 760.494629
#> iter  10 value 760.494624
#> final  value 760.494624 
#> converged
#> This is Run number  309 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1          e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.50480533  1.801557091   0.9548053 -10.7984429      1
#> 2     1  -0.95  -2.35  0.16168568  0.003540297  -0.7883143  -2.3464597      1
#> 3     1  -6.20  -2.30  0.12520410  4.131404980  -6.0747959   1.8314050      2
#> 4     1 -13.90  -2.55 -0.18819509  4.846869497 -14.0881951   2.2968695      2
#> 5     1 -14.40  -5.80 -0.00632819 -0.379901772 -14.4063282  -6.1799018      2
#> 6     1  -3.60  -1.70 -1.24212465  1.303711640  -4.8421246  -0.3962884      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -38800   7075 
#> initial  value 998.131940 
#> iter   2 value 812.098544
#> iter   3 value 800.225868
#> iter   4 value 799.278769
#> iter   5 value 763.000301
#> iter   6 value 754.432559
#> iter   7 value 753.074910
#> iter   8 value 753.045765
#> iter   9 value 753.045716
#> iter  10 value 753.045703
#> iter  10 value 753.045693
#> iter  10 value 753.045686
#> final  value 753.045686 
#> converged
#> This is Run number  310 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.7958703 -0.7509965   1.245870 -13.350997      1
#> 2     1  -0.95  -2.35 -0.3219374  0.8200184  -1.271937  -1.529982      1
#> 3     1  -6.20  -2.30  1.3087280 -1.1667017  -4.891272  -3.466702      2
#> 4     1 -13.90  -2.55 -0.4568792 -0.3408168 -14.356879  -2.890817      2
#> 5     1 -14.40  -5.80  1.2741497 -0.2701575 -13.125850  -6.070158      2
#> 6     1  -3.60  -1.70  0.2961015  0.5498952  -3.303898  -1.150105      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5640 -36525   7050 
#> initial  value 998.131940 
#> iter   2 value 844.159748
#> iter   3 value 833.248612
#> iter   4 value 831.564070
#> iter   5 value 789.071110
#> iter   6 value 781.085447
#> iter   7 value 779.735822
#> iter   8 value 779.711083
#> iter   9 value 779.711045
#> iter   9 value 779.711034
#> iter   9 value 779.711029
#> final  value 779.711029 
#> converged
#> This is Run number  311 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.9673955  0.3836809   2.4173955 -12.216319      1
#> 2     1  -0.95  -2.35 -0.8194546 -1.5325756  -1.7694546  -3.882576      1
#> 3     1  -6.20  -2.30  1.8328013  0.1247555  -4.3671987  -2.175245      2
#> 4     1 -13.90  -2.55 -0.4657669 -1.0624877 -14.3657669  -3.612488      2
#> 5     1 -14.40  -5.80 -1.0640077  0.8685816 -15.4640077  -4.931418      2
#> 6     1  -3.60  -1.70  4.4382296 -0.4285952   0.8382296  -2.128595      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6520 -40750   6825 
#> initial  value 998.131940 
#> iter   2 value 783.314945
#> iter   3 value 767.935947
#> iter   4 value 764.921868
#> iter   5 value 735.113853
#> iter   6 value 726.395622
#> iter   7 value 725.223427
#> iter   8 value 725.197690
#> iter   9 value 725.197660
#> iter   9 value 725.197660
#> iter   9 value 725.197660
#> final  value 725.197660 
#> converged
#> This is Run number  312 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7598337  2.1988437   0.2098337 -10.4011563      1
#> 2     1  -0.95  -2.35  1.6586575 -0.5472722   0.7086575  -2.8972722      1
#> 3     1  -6.20  -2.30  0.7093915 -0.4065676  -5.4906085  -2.7065676      2
#> 4     1 -13.90  -2.55 -0.2951693  2.2431632 -14.1951693  -0.3068368      2
#> 5     1 -14.40  -5.80  0.5099310 -0.7741198 -13.8900690  -6.5741198      2
#> 6     1  -3.60  -1.70  2.7061986  0.5877788  -0.8938014  -1.1122212      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38850   7250 
#> initial  value 998.131940 
#> iter   2 value 810.587099
#> iter   3 value 797.044385
#> iter   4 value 795.405145
#> iter   5 value 759.525050
#> iter   6 value 750.976376
#> iter   7 value 749.681323
#> iter   8 value 749.655125
#> iter   9 value 749.655089
#> iter  10 value 749.655078
#> iter  10 value 749.655069
#> iter  10 value 749.655064
#> final  value 749.655064 
#> converged
#> This is Run number  313 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4312399  1.98602725  -0.9812399 -10.613973      1
#> 2     1  -0.95  -2.35 -0.2212085 -0.04895586  -1.1712085  -2.398956      1
#> 3     1  -6.20  -2.30  0.4556414  0.24529476  -5.7443586  -2.054705      2
#> 4     1 -13.90  -2.55  0.6738632  0.73677725 -13.2261368  -1.813223      2
#> 5     1 -14.40  -5.80 -0.3985851  0.52918028 -14.7985851  -5.270820      2
#> 6     1  -3.60  -1.70 -0.6329371 -0.09286154  -4.2329371  -1.792862      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7160 -39975   6350 
#> initial  value 998.131940 
#> iter   2 value 797.469323
#> iter   3 value 787.397342
#> iter   4 value 786.580313
#> iter   5 value 753.596279
#> iter   6 value 744.835139
#> iter   7 value 743.365620
#> iter   8 value 743.327936
#> iter   9 value 743.327850
#> iter  10 value 743.327837
#> iter  10 value 743.327830
#> iter  10 value 743.327823
#> final  value 743.327823 
#> converged
#> This is Run number  314 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.07219961 -0.1886265  -0.4778004 -12.788627      1
#> 2     1  -0.95  -2.35 -0.32335231 -0.4993384  -1.2733523  -2.849338      1
#> 3     1  -6.20  -2.30  0.41933730 -0.6681020  -5.7806627  -2.968102      2
#> 4     1 -13.90  -2.55  0.54981169 -0.1217973 -13.3501883  -2.671797      2
#> 5     1 -14.40  -5.80  1.39773965  0.1849908 -13.0022603  -5.615009      2
#> 6     1  -3.60  -1.70 -0.30607395 -0.3337629  -3.9060740  -2.033763      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -38600   6325 
#> initial  value 998.131940 
#> iter   2 value 819.297768
#> iter   3 value 806.952963
#> iter   4 value 804.090450
#> iter   5 value 767.693466
#> iter   6 value 759.146204
#> iter   7 value 757.693663
#> iter   8 value 757.660495
#> iter   9 value 757.660429
#> iter   9 value 757.660419
#> iter   9 value 757.660414
#> final  value 757.660414 
#> converged
#> This is Run number  315 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.36654271 -0.2614218  -0.9165427 -12.8614218      1
#> 2     1  -0.95  -2.35  0.55885513  0.1550267  -0.3911449  -2.1949733      1
#> 3     1  -6.20  -2.30 -0.88384255 -0.9596687  -7.0838425  -3.2596687      2
#> 4     1 -13.90  -2.55 -0.01315882  3.2964378 -13.9131588   0.7464378      2
#> 5     1 -14.40  -5.80  0.62881653  0.1870362 -13.7711835  -5.6129638      2
#> 6     1  -3.60  -1.70  0.38536530 -0.1703279  -3.2146347  -1.8703279      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -39750   7725 
#> initial  value 998.131940 
#> iter   2 value 793.933463
#> iter   3 value 778.614151
#> iter   4 value 777.570860
#> iter   5 value 744.354542
#> iter   6 value 735.740694
#> iter   7 value 734.578079
#> iter   8 value 734.557033
#> iter   9 value 734.557019
#> iter   9 value 734.557015
#> iter  10 value 734.556999
#> iter  10 value 734.556990
#> iter  10 value 734.556986
#> final  value 734.556986 
#> converged
#> This is Run number  316 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.629480 -0.33385311   1.0794796 -12.933853      1
#> 2     1  -0.95  -2.35  1.845130  0.53983855   0.8951301  -1.810161      1
#> 3     1  -6.20  -2.30  3.448022 -0.06794323  -2.7519780  -2.367943      2
#> 4     1 -13.90  -2.55 -1.364370  1.35255294 -15.2643703  -1.197447      2
#> 5     1 -14.40  -5.80 -1.718977  0.50819185 -16.1189767  -5.291808      2
#> 6     1  -3.60  -1.70 -1.538403 -0.60846442  -5.1384034  -2.308464      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6120 -38600   8500 
#> initial  value 998.131940 
#> iter   2 value 806.427929
#> iter   3 value 789.825732
#> iter   4 value 789.050460
#> iter   5 value 752.407194
#> iter   6 value 743.990863
#> iter   7 value 742.866716
#> iter   8 value 742.850945
#> iter   9 value 742.850927
#> iter   9 value 742.850920
#> iter   9 value 742.850916
#> final  value 742.850916 
#> converged
#> This is Run number  317 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.06908058 -0.3912956  -0.6190806 -12.991296      1
#> 2     1  -0.95  -2.35 -0.78614594 -0.9567659  -1.7361459  -3.306766      1
#> 3     1  -6.20  -2.30 -0.28215590  0.6953846  -6.4821559  -1.604615      2
#> 4     1 -13.90  -2.55  0.95008130 -1.2485916 -12.9499187  -3.798592      2
#> 5     1 -14.40  -5.80  0.52450917 -0.4985620 -13.8754908  -6.298562      2
#> 6     1  -3.60  -1.70  0.60343276  0.5020075  -2.9965672  -1.197993      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5980 -37250   6725 
#> initial  value 998.131940 
#> iter   2 value 836.230660
#> iter   3 value 825.718979
#> iter   4 value 824.131617
#> iter   5 value 783.584732
#> iter   6 value 775.390734
#> iter   7 value 773.965346
#> iter   8 value 773.936417
#> iter   9 value 773.936366
#> iter   9 value 773.936364
#> iter   9 value 773.936364
#> final  value 773.936364 
#> converged
#> This is Run number  318 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 1.1591665 -0.1564187   0.60916653 -12.7564187      1
#> 2     1  -0.95  -2.35 1.0152183 -0.8295712   0.06521828  -3.1795712      1
#> 3     1  -6.20  -2.30 0.6550211 -0.4054553  -5.54497890  -2.7054553      2
#> 4     1 -13.90  -2.55 0.7746068  0.6274750 -13.12539321  -1.9225250      2
#> 5     1 -14.40  -5.80 0.2259394  0.3745007 -14.17406059  -5.4254993      2
#> 6     1  -3.60  -1.70 1.7145243  1.1914711  -1.88547574  -0.5085289      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7020 -39825   7100 
#> initial  value 998.131940 
#> iter   2 value 795.970683
#> iter   3 value 783.852889
#> iter   4 value 783.366889
#> iter   5 value 750.028053
#> iter   6 value 741.302728
#> iter   7 value 739.998851
#> iter   8 value 739.969869
#> iter   9 value 739.969822
#> iter  10 value 739.969808
#> iter  10 value 739.969799
#> iter  10 value 739.969791
#> final  value 739.969791 
#> converged
#> This is Run number  319 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.0473500  0.2164144   0.4973500 -12.383586      1
#> 2     1  -0.95  -2.35  0.5382308  0.6379600  -0.4117692  -1.712040      1
#> 3     1  -6.20  -2.30  0.9016668 -0.1106530  -5.2983332  -2.410653      2
#> 4     1 -13.90  -2.55  0.6270367  0.3556341 -13.2729633  -2.194366      2
#> 5     1 -14.40  -5.80  4.8086493  1.1028323  -9.5913507  -4.697168      2
#> 6     1  -3.60  -1.70 -0.2528278 -0.6407626  -3.8528278  -2.340763      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6960 -39200   6250 
#> initial  value 998.131940 
#> iter   2 value 810.082501
#> iter   3 value 800.706271
#> iter   4 value 799.829969
#> iter   5 value 764.543425
#> iter   6 value 755.903049
#> iter   7 value 754.352693
#> iter   8 value 754.313796
#> iter   9 value 754.313702
#> iter  10 value 754.313688
#> iter  10 value 754.313681
#> iter  10 value 754.313674
#> final  value 754.313674 
#> converged
#> This is Run number  320 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.62147554 -1.25170625   0.07147554 -13.8517062      1
#> 2     1  -0.95  -2.35 -0.02247538 -0.32550634  -0.97247538  -2.6755063      1
#> 3     1  -6.20  -2.30  0.41162730  2.79392450  -5.78837270   0.4939245      2
#> 4     1 -13.90  -2.55 -0.03282543 -0.06878074 -13.93282543  -2.6187807      2
#> 5     1 -14.40  -5.80 -0.62926088  0.88401003 -15.02926088  -4.9159900      2
#> 6     1  -3.60  -1.70  0.84006966 -0.03880140  -2.75993034  -1.7388014      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38950   7050 
#> initial  value 998.131940 
#> iter   2 value 810.245376
#> iter   3 value 796.889710
#> iter   4 value 794.966932
#> iter   5 value 759.431501
#> iter   6 value 750.857944
#> iter   7 value 749.539050
#> iter   8 value 749.511355
#> iter   9 value 749.511315
#> iter   9 value 749.511304
#> iter   9 value 749.511298
#> final  value 749.511298 
#> converged
#> This is Run number  321 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.47064696  0.5297818  -2.020647 -12.070218      1
#> 2     1  -0.95  -2.35 -0.20229351  3.4539031  -1.152294   1.103903      2
#> 3     1  -6.20  -2.30 -0.46642555  0.9638335  -6.666426  -1.336167      2
#> 4     1 -13.90  -2.55  0.21087505 -0.1197997 -13.689125  -2.669800      2
#> 5     1 -14.40  -5.80 -0.04661594  1.1393276 -14.446616  -4.660672      2
#> 6     1  -3.60  -1.70 -0.21215975 -0.3721022  -3.812160  -2.072102      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7020 -39400   6275 
#> initial  value 998.131940 
#> iter   2 value 806.870198
#> iter   3 value 797.345698
#> iter   4 value 796.502692
#> iter   5 value 761.797805
#> iter   6 value 753.121303
#> iter   7 value 751.587291
#> iter   8 value 751.548489
#> iter   9 value 751.548396
#> iter  10 value 751.548382
#> iter  10 value 751.548375
#> iter  10 value 751.548368
#> final  value 751.548368 
#> converged
#> This is Run number  322 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.78701341  1.5295592  -1.3370134 -11.0704408      1
#> 2     1  -0.95  -2.35  1.74620565  0.2455997   0.7962057  -2.1044003      1
#> 3     1  -6.20  -2.30 -0.07882724  1.1717892  -6.2788272  -1.1282108      2
#> 4     1 -13.90  -2.55  0.55789649  2.1511872 -13.3421035  -0.3988128      2
#> 5     1 -14.40  -5.80 -0.30563354 -0.8423720 -14.7056335  -6.6423720      2
#> 6     1  -3.60  -1.70  1.39817121 -1.5852613  -2.2018288  -3.2852613      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -38950   5950 
#> initial  value 998.131940 
#> iter   2 value 815.832647
#> iter   3 value 804.480538
#> iter   4 value 801.674112
#> iter   5 value 766.251827
#> iter   6 value 757.634826
#> iter   7 value 756.094215
#> iter   8 value 756.055958
#> iter   9 value 756.055861
#> iter  10 value 756.055849
#> iter  10 value 756.055849
#> iter  10 value 756.055844
#> final  value 756.055844 
#> converged
#> This is Run number  323 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.38205614  0.37708040  -1.9320561 -12.22291960      1
#> 2     1  -0.95  -2.35  1.51015207 -0.01738002   0.5601521  -2.36738002      1
#> 3     1  -6.20  -2.30  2.11443822  2.35480584  -4.0855618   0.05480584      2
#> 4     1 -13.90  -2.55 -0.63516341  2.27650377 -14.5351634  -0.27349623      2
#> 5     1 -14.40  -5.80  0.21084765 -0.62198258 -14.1891524  -6.42198258      2
#> 6     1  -3.60  -1.70 -0.01578352  0.79606526  -3.6157835  -0.90393474      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5940 -37500   6425 
#> initial  value 998.131940 
#> iter   2 value 834.398041
#> iter   3 value 823.553041
#> iter   4 value 821.385339
#> iter   5 value 781.688435
#> iter   6 value 773.421222
#> iter   7 value 771.955222
#> iter   8 value 771.924271
#> iter   9 value 771.924212
#> iter   9 value 771.924202
#> iter   9 value 771.924197
#> final  value 771.924197 
#> converged
#> This is Run number  324 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.46787091  1.0533915  -0.08212909 -11.5466085      1
#> 2     1  -0.95  -2.35 -0.46529368 -0.5091562  -1.41529368  -2.8591562      1
#> 3     1  -6.20  -2.30  0.26367336 -1.5893438  -5.93632664  -3.8893438      2
#> 4     1 -13.90  -2.55  1.97487699 -0.1982987 -11.92512301  -2.7482987      2
#> 5     1 -14.40  -5.80  0.07546907  0.4870631 -14.32453093  -5.3129369      2
#> 6     1  -3.60  -1.70 -0.04707616  0.7349967  -3.64707616  -0.9650033      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5860 -37075   7250 
#> initial  value 998.131940 
#> iter   2 value 835.724851
#> iter   3 value 824.291326
#> iter   4 value 822.944198
#> iter   5 value 781.856856
#> iter   6 value 773.701367
#> iter   7 value 772.359923
#> iter   8 value 772.334779
#> iter   9 value 772.334741
#> iter  10 value 772.334728
#> iter  10 value 772.334718
#> iter  10 value 772.334717
#> final  value 772.334717 
#> converged
#> This is Run number  325 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.8914225 -0.0459648   1.341423 -12.6459648      1
#> 2     1  -0.95  -2.35 -0.6912446 -0.3965918  -1.641245  -2.7465918      1
#> 3     1  -6.20  -2.30 -0.7232214 -0.4788291  -6.923221  -2.7788291      2
#> 4     1 -13.90  -2.55 -1.1017164  2.1832367 -15.001716  -0.3667633      2
#> 5     1 -14.40  -5.80 -0.4048291 -0.8246345 -14.804829  -6.6246345      2
#> 6     1  -3.60  -1.70 -0.8388993  0.7410073  -4.438899  -0.9589927      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38525   7200 
#> initial  value 998.131940 
#> iter   2 value 815.626289
#> iter   3 value 802.856747
#> iter   4 value 801.428395
#> iter   5 value 764.512520
#> iter   6 value 756.012573
#> iter   7 value 754.686210
#> iter   8 value 754.659194
#> iter   9 value 754.659154
#> iter  10 value 754.659142
#> iter  10 value 754.659132
#> iter  10 value 754.659127
#> final  value 754.659127 
#> converged
#> This is Run number  326 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.9457421  0.01379859   0.3957421 -12.5862014      1
#> 2     1  -0.95  -2.35 -0.5945031  2.98566041  -1.5445031   0.6356604      2
#> 3     1  -6.20  -2.30 -0.2877314  3.83116242  -6.4877314   1.5311624      2
#> 4     1 -13.90  -2.55  1.1321191  2.43504301 -12.7678809  -0.1149570      2
#> 5     1 -14.40  -5.80  0.3785449  0.51901195 -14.0214551  -5.2809881      2
#> 6     1  -3.60  -1.70  0.3515232 -0.25457716  -3.2484768  -1.9545772      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5940 -38375   6850 
#> initial  value 998.131940 
#> iter   2 value 819.883974
#> iter   3 value 806.603552
#> iter   4 value 804.030163
#> iter   5 value 766.964926
#> iter   6 value 758.487525
#> iter   7 value 757.127083
#> iter   8 value 757.098719
#> iter   9 value 757.098676
#> iter   9 value 757.098667
#> iter   9 value 757.098661
#> final  value 757.098661 
#> converged
#> This is Run number  327 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.0577793 0.8791231   0.5077793 -11.7208769      1
#> 2     1  -0.95  -2.35  5.0438882 0.9149064   4.0938882  -1.4350936      1
#> 3     1  -6.20  -2.30 -1.5418716 1.9689192  -7.7418716  -0.3310808      2
#> 4     1 -13.90  -2.55 -1.5791201 1.0168672 -15.4791201  -1.5331328      2
#> 5     1 -14.40  -5.80 -0.1454676 0.1607948 -14.5454676  -5.6392052      2
#> 6     1  -3.60  -1.70 -0.6114485 0.7155251  -4.2114485  -0.9844749      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6820 -39775   7275 
#> initial  value 998.131940 
#> iter   2 value 795.976941
#> iter   3 value 782.847966
#> iter   4 value 782.105967
#> iter   5 value 748.740736
#> iter   6 value 740.047123
#> iter   7 value 738.791162
#> iter   8 value 738.764807
#> iter   9 value 738.764770
#> iter  10 value 738.764758
#> iter  10 value 738.764749
#> iter  10 value 738.764742
#> final  value 738.764742 
#> converged
#> This is Run number  328 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.6164419 -0.55315774   0.06644195 -13.153158      1
#> 2     1  -0.95  -2.35 -1.1933987  0.87491435  -2.14339874  -1.475086      2
#> 3     1  -6.20  -2.30  2.0312490 -0.39272183  -4.16875101  -2.692722      2
#> 4     1 -13.90  -2.55  0.3600632  1.21118110 -13.53993684  -1.338819      2
#> 5     1 -14.40  -5.80  1.5030814  0.04612378 -12.89691861  -5.753876      2
#> 6     1  -3.60  -1.70 -0.6303895 -1.10337349  -4.23038950  -2.803373      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -39575   7650 
#> initial  value 998.131940 
#> iter   2 value 796.916369
#> iter   3 value 782.767329
#> iter   4 value 782.181793
#> iter   5 value 748.280607
#> iter   6 value 739.638262
#> iter   7 value 738.436342
#> iter   8 value 738.413678
#> iter   8 value 738.413678
#> final  value 738.413678 
#> converged
#> This is Run number  329 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.63345292 -0.03478091  -1.1834529 -12.634781      1
#> 2     1  -0.95  -2.35 -0.02588636  1.05382460  -0.9758864  -1.296175      1
#> 3     1  -6.20  -2.30  1.57338664 -0.49584678  -4.6266134  -2.795847      2
#> 4     1 -13.90  -2.55  0.40664092 -0.86091031 -13.4933591  -3.410910      2
#> 5     1 -14.40  -5.80  0.61196773  0.85964961 -13.7880323  -4.940350      2
#> 6     1  -3.60  -1.70  1.03426258  1.26900504  -2.5657374  -0.430995      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5520 -36575   8450 
#> initial  value 998.131940 
#> iter   2 value 834.882150
#> iter   3 value 821.124482
#> iter   4 value 820.117962
#> iter   5 value 777.433798
#> iter   6 value 769.398374
#> iter   7 value 768.214596
#> iter   8 value 768.198228
#> iter   8 value 768.198224
#> final  value 768.198224 
#> converged
#> This is Run number  330 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  2.2014078 -0.7721612   1.6514078 -13.372161      1
#> 2     1  -0.95  -2.35  1.3805602 -0.3667444   0.4305602  -2.716744      1
#> 3     1  -6.20  -2.30  0.3148464 -1.3149346  -5.8851536  -3.614935      2
#> 4     1 -13.90  -2.55  1.4536262 -1.5521222 -12.4463738  -4.102122      2
#> 5     1 -14.40  -5.80  0.5691426 -0.4494811 -13.8308574  -6.249481      2
#> 6     1  -3.60  -1.70 -0.1372707  0.2990096  -3.7372707  -1.400990      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6660 -40100   6075 
#> initial  value 998.131940 
#> iter   2 value 797.419252
#> iter   3 value 785.442034
#> iter   4 value 782.733413
#> iter   5 value 750.717645
#> iter   6 value 741.943265
#> iter   7 value 740.506463
#> iter   8 value 740.469232
#> iter   9 value 740.469146
#> iter   9 value 740.469136
#> iter   9 value 740.469129
#> final  value 740.469129 
#> converged
#> This is Run number  331 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1       e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.498349 4.0480043  -1.0483490 -8.551996      1
#> 2     1  -0.95  -2.35  1.124881 0.4956368   0.1748814 -1.854363      1
#> 3     1  -6.20  -2.30  1.480164 1.0776677  -4.7198361 -1.222332      2
#> 4     1 -13.90  -2.55  1.052400 0.5539734 -12.8475997 -1.996027      2
#> 5     1 -14.40  -5.80  1.328359 1.1621677 -13.0716409 -4.637832      2
#> 6     1  -3.60  -1.70  1.113688 0.5633360  -2.4863120 -1.136664      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -39150   6550 
#> initial  value 998.131940 
#> iter   2 value 809.894170
#> iter   3 value 797.476439
#> iter   4 value 795.166803
#> iter   5 value 760.255640
#> iter   6 value 751.624165
#> iter   7 value 750.223422
#> iter   8 value 750.191202
#> iter   9 value 750.191144
#> iter   9 value 750.191134
#> iter   9 value 750.191128
#> final  value 750.191128 
#> converged
#> This is Run number  332 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.3830268 -0.1846500   1.833027 -12.7846500      1
#> 2     1  -0.95  -2.35 -0.4897286  1.5980095  -1.439729  -0.7519905      2
#> 3     1  -6.20  -2.30  1.2550224  0.9405607  -4.944978  -1.3594393      2
#> 4     1 -13.90  -2.55 -1.1909683  0.6612989 -15.090968  -1.8887011      2
#> 5     1 -14.40  -5.80  2.9816990  2.2632610 -11.418301  -3.5367390      2
#> 6     1  -3.60  -1.70  1.6000323 -0.2105599  -1.999968  -1.9105599      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6220 -39375   6400 
#> initial  value 998.131940 
#> iter   2 value 807.335537
#> iter   3 value 793.988764
#> iter   4 value 790.869914
#> iter   5 value 756.832940
#> iter   6 value 748.153759
#> iter   7 value 746.766114
#> iter   8 value 746.733642
#> iter   9 value 746.733581
#> iter   9 value 746.733572
#> iter   9 value 746.733567
#> final  value 746.733567 
#> converged
#> This is Run number  333 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0589620 -0.15474069  -1.60896196 -12.75474069      1
#> 2     1  -0.95  -2.35 -0.3511384  0.01170706  -1.30113837  -2.33829294      1
#> 3     1  -6.20  -2.30  0.5861452  2.33444235  -5.61385479   0.03444235      2
#> 4     1 -13.90  -2.55 -0.4451951  0.34134033 -14.34519513  -2.20865967      2
#> 5     1 -14.40  -5.80  1.2166667  4.20368226 -13.18333330  -1.59631774      2
#> 6     1  -3.60  -1.70  3.5658421  2.79183590  -0.03415792   1.09183590      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -37475   6425 
#> initial  value 998.131940 
#> iter   2 value 834.458349
#> iter   3 value 825.663412
#> iter   4 value 824.762800
#> iter   5 value 784.607062
#> iter   6 value 776.368431
#> iter   7 value 774.843259
#> iter   8 value 774.809969
#> iter   9 value 774.809896
#> iter   9 value 774.809894
#> iter   9 value 774.809894
#> final  value 774.809894 
#> converged
#> This is Run number  334 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.9370693  1.1731714   1.387069 -11.426829      1
#> 2     1  -0.95  -2.35 -0.1109525 -0.5582708  -1.060953  -2.908271      1
#> 3     1  -6.20  -2.30  1.1757224 -0.1306707  -5.024278  -2.430671      2
#> 4     1 -13.90  -2.55  0.7755591  1.3042647 -13.124441  -1.245735      2
#> 5     1 -14.40  -5.80  3.8068524  3.3777310 -10.593148  -2.422269      2
#> 6     1  -3.60  -1.70 -0.3400079 -0.5529537  -3.940008  -2.252954      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39975   7375 
#> initial  value 998.131940 
#> iter   2 value 792.600854
#> iter   3 value 777.487972
#> iter   4 value 775.768040
#> iter   5 value 743.341727
#> iter   6 value 734.691219
#> iter   7 value 733.503723
#> iter   8 value 733.480264
#> iter   9 value 733.480240
#> iter   9 value 733.480232
#> iter   9 value 733.480231
#> final  value 733.480231 
#> converged
#> This is Run number  335 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.17450730  0.06087795   1.6245073 -12.5391221      1
#> 2     1  -0.95  -2.35  0.78615543  1.94370318  -0.1638446  -0.4062968      1
#> 3     1  -6.20  -2.30 -0.35607041  0.49310307  -6.5560704  -1.8068969      2
#> 4     1 -13.90  -2.55  2.49375070 -0.96443223 -11.4062493  -3.5144322      2
#> 5     1 -14.40  -5.80  0.06726243 -0.25792727 -14.3327376  -6.0579273      2
#> 6     1  -3.60  -1.70  0.07467203  0.21506193  -3.5253280  -1.4849381      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6780 -39175   6275 
#> initial  value 998.131940 
#> iter   2 value 810.537920
#> iter   3 value 800.503656
#> iter   4 value 799.218868
#> iter   5 value 764.005789
#> iter   6 value 755.368255
#> iter   7 value 753.849154
#> iter   8 value 753.811648
#> iter   9 value 753.811562
#> iter  10 value 753.811549
#> iter  10 value 753.811544
#> iter  10 value 753.811538
#> final  value 753.811538 
#> converged
#> This is Run number  336 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.9344689 -0.1999444  -1.484469 -12.7999444      1
#> 2     1  -0.95  -2.35 -0.2264984 -0.4230930  -1.176498  -2.7730930      1
#> 3     1  -6.20  -2.30 -0.3654192  1.6548446  -6.565419  -0.6451554      2
#> 4     1 -13.90  -2.55  0.3353433  0.6751990 -13.564657  -1.8748010      2
#> 5     1 -14.40  -5.80  3.1321961  1.2437724 -11.267804  -4.5562276      2
#> 6     1  -3.60  -1.70  0.1995289  0.7236368  -3.400471  -0.9763632      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -37575   7425 
#> initial  value 998.131940 
#> iter   2 value 827.724970
#> iter   3 value 816.322784
#> iter   4 value 815.665436
#> iter   5 value 775.809336
#> iter   6 value 767.501065
#> iter   7 value 766.166077
#> iter   8 value 766.140486
#> iter   9 value 766.140445
#> iter  10 value 766.140431
#> iter  10 value 766.140421
#> iter  10 value 766.140415
#> final  value 766.140415 
#> converged
#> This is Run number  337 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.19867472  0.08149714  -0.7486747 -12.51850286      1
#> 2     1  -0.95  -2.35  2.34185369  0.35699970   1.3918537  -1.99300030      1
#> 3     1  -6.20  -2.30 -0.07446225 -0.10584834  -6.2744622  -2.40584834      2
#> 4     1 -13.90  -2.55  1.29217815 -0.26625308 -12.6078218  -2.81625308      2
#> 5     1 -14.40  -5.80  0.06267331  0.48748990 -14.3373267  -5.31251010      2
#> 6     1  -3.60  -1.70 -1.20717399  1.71801337  -4.8071740   0.01801337      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -37325   7150 
#> initial  value 998.131940 
#> iter   2 value 832.593680
#> iter   3 value 822.704872
#> iter   4 value 822.319291
#> iter   5 value 781.668776
#> iter   6 value 773.426751
#> iter   7 value 772.024920
#> iter   8 value 771.996651
#> iter   9 value 771.996597
#> iter  10 value 771.996581
#> iter  10 value 771.996571
#> iter  10 value 771.996565
#> final  value 771.996565 
#> converged
#> This is Run number  338 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.8362462 -0.1823339   3.286246 -12.782334      1
#> 2     1  -0.95  -2.35 -0.6571561  0.5452190  -1.607156  -1.804781      1
#> 3     1  -6.20  -2.30  2.3490039 -1.6625787  -3.850996  -3.962579      1
#> 4     1 -13.90  -2.55  2.8095248  0.4908367 -11.090475  -2.059163      2
#> 5     1 -14.40  -5.80 -0.7897648 -0.4467115 -15.189765  -6.246712      2
#> 6     1  -3.60  -1.70  2.1597726 -0.7062147  -1.440227  -2.406215      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5820 -38150   6775 
#> initial  value 998.131940 
#> iter   2 value 823.538814
#> iter   3 value 810.213233
#> iter   4 value 807.387565
#> iter   5 value 769.727475
#> iter   6 value 761.291007
#> iter   7 value 759.919689
#> iter   8 value 759.891325
#> iter   9 value 759.891282
#> iter   9 value 759.891272
#> iter   9 value 759.891267
#> final  value 759.891267 
#> converged
#> This is Run number  339 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.3524023 -0.9301874   1.802402 -13.5301874      1
#> 2     1  -0.95  -2.35  0.5030850  3.4490365  -0.446915   1.0990365      2
#> 3     1  -6.20  -2.30 -0.4448381  1.6999167  -6.644838  -0.6000833      2
#> 4     1 -13.90  -2.55  0.8116578  1.3919652 -13.088342  -1.1580348      2
#> 5     1 -14.40  -5.80 -0.6964294 -1.1663204 -15.096429  -6.9663204      2
#> 6     1  -3.60  -1.70  2.4871416  0.2208575  -1.112858  -1.4791425      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -37250   6350 
#> initial  value 998.131940 
#> iter   2 value 837.889089
#> iter   3 value 829.568678
#> iter   4 value 828.744820
#> iter   5 value 787.951013
#> iter   6 value 779.784982
#> iter   7 value 778.244580
#> iter   8 value 778.211266
#> iter   9 value 778.211191
#> iter   9 value 778.211188
#> iter   9 value 778.211188
#> final  value 778.211188 
#> converged
#> This is Run number  340 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  2.72489900  0.3149005   2.1748990 -12.28509945      1
#> 2     1  -0.95  -2.35  0.02140309  1.8697448  -0.9285969  -0.48025524      2
#> 3     1  -6.20  -2.30  2.10168021 -0.3444461  -4.0983198  -2.64444611      2
#> 4     1 -13.90  -2.55 -1.01255683  1.3334944 -14.9125568  -1.21650560      2
#> 5     1 -14.40  -5.80  1.39672169  1.6207472 -13.0032783  -4.17925276      2
#> 6     1  -3.60  -1.70  0.18949537  1.7284294  -3.4105046   0.02842944      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5880 -37125   7150 
#> initial  value 998.131940 
#> iter   2 value 835.619342
#> iter   3 value 824.321636
#> iter   4 value 822.911472
#> iter   5 value 781.978888
#> iter   6 value 773.811433
#> iter   7 value 772.455440
#> iter   8 value 772.429577
#> iter   9 value 772.429536
#> iter  10 value 772.429524
#> iter  10 value 772.429514
#> iter  10 value 772.429510
#> final  value 772.429510 
#> converged
#> This is Run number  341 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7428068  2.2897717   0.1928068 -10.310228      1
#> 2     1  -0.95  -2.35  0.8053019 -1.6774258  -0.1446981  -4.027426      1
#> 3     1  -6.20  -2.30 -1.3720056 -0.5339634  -7.5720056  -2.833963      2
#> 4     1 -13.90  -2.55 -0.1080168  3.0104230 -14.0080168   0.460423      2
#> 5     1 -14.40  -5.80 -0.9774153  2.2464676 -15.3774153  -3.553532      2
#> 6     1  -3.60  -1.70  1.4997238  0.1296843  -2.1002762  -1.570316      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -39225   7250 
#> initial  value 998.131940 
#> iter   2 value 804.631655
#> iter   3 value 792.132029
#> iter   4 value 791.422984
#> iter   5 value 756.381034
#> iter   6 value 747.745656
#> iter   7 value 746.440289
#> iter   8 value 746.412789
#> iter   9 value 746.412747
#> iter  10 value 746.412734
#> iter  10 value 746.412724
#> iter  10 value 746.412717
#> final  value 746.412717 
#> converged
#> This is Run number  342 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1          e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.840371383 -1.144275520   1.290371 -13.7442755      1
#> 2     1  -0.95  -2.35 -0.180659912  0.006129065  -1.130660  -2.3438709      1
#> 3     1  -6.20  -2.30  0.169224400 -0.777003133  -6.030776  -3.0770031      2
#> 4     1 -13.90  -2.55  0.828893820 -0.117982112 -13.071106  -2.6679821      2
#> 5     1 -14.40  -5.80  0.752175670 -0.180421255 -13.647824  -5.9804213      2
#> 6     1  -3.60  -1.70  0.005402943  2.129517292  -3.594597   0.4295173      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -38625   6825 
#> initial  value 998.131940 
#> iter   2 value 816.294918
#> iter   3 value 803.736142
#> iter   4 value 801.684681
#> iter   5 value 765.192114
#> iter   6 value 756.664611
#> iter   7 value 755.289655
#> iter   8 value 755.260043
#> iter   9 value 755.259994
#> iter   9 value 755.259984
#> iter   9 value 755.259977
#> final  value 755.259977 
#> converged
#> This is Run number  343 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.02531463  0.1906863  -0.5753146 -12.409314      1
#> 2     1  -0.95  -2.35 -0.61876090  0.4279317  -1.5687609  -1.922068      1
#> 3     1  -6.20  -2.30  0.18000464 -1.5466374  -6.0199954  -3.846637      2
#> 4     1 -13.90  -2.55  0.95573340 -0.3893291 -12.9442666  -2.939329      2
#> 5     1 -14.40  -5.80  5.78483356 -0.1020647  -8.6151664  -5.902065      2
#> 6     1  -3.60  -1.70  1.73463023 -0.7188000  -1.8653698  -2.418800      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7040 -41025   7575 
#> initial  value 998.131940 
#> iter   2 value 773.979879
#> iter   3 value 758.499143
#> iter   4 value 757.747071
#> iter   5 value 728.330119
#> iter   6 value 719.680609
#> iter   7 value 718.612603
#> iter   8 value 718.593152
#> iter   9 value 718.593129
#> iter   9 value 718.593122
#> iter   9 value 718.593116
#> final  value 718.593116 
#> converged
#> This is Run number  344 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7692084  0.7352012   0.2192084 -11.8647988      1
#> 2     1  -0.95  -2.35 -1.8969808  1.2309850  -2.8469808  -1.1190150      2
#> 3     1  -6.20  -2.30 -0.2699617  3.1934366  -6.4699617   0.8934366      2
#> 4     1 -13.90  -2.55  0.3955223 -0.9354481 -13.5044777  -3.4854481      2
#> 5     1 -14.40  -5.80  0.2868132  1.3083763 -14.1131868  -4.4916237      2
#> 6     1  -3.60  -1.70  2.9389821  0.2635140  -0.6610179  -1.4364860      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6620 -40675   7025 
#> initial  value 998.131940 
#> iter   2 value 783.352827
#> iter   3 value 768.259852
#> iter   4 value 765.961852
#> iter   5 value 735.760448
#> iter   6 value 727.056498
#> iter   7 value 725.892092
#> iter   8 value 725.867364
#> iter   9 value 725.867338
#> iter   9 value 725.867331
#> iter   9 value 725.867326
#> final  value 725.867326 
#> converged
#> This is Run number  345 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.03910911 1.6391779  -0.5891091 -10.9608221      1
#> 2     1  -0.95  -2.35  0.31517967 2.0893938  -0.6348203  -0.2606062      2
#> 3     1  -6.20  -2.30 -0.12868398 1.2851888  -6.3286840  -1.0148112      2
#> 4     1 -13.90  -2.55 -0.69674029 0.3612209 -14.5967403  -2.1887791      2
#> 5     1 -14.40  -5.80  1.60706151 0.1813545 -12.7929385  -5.6186455      2
#> 6     1  -3.60  -1.70 -1.33724400 0.0639025  -4.9372440  -1.6360975      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7100 -40200   6400 
#> initial  value 998.131940 
#> iter   2 value 793.765130
#> iter   3 value 783.031321
#> iter   4 value 781.963710
#> iter   5 value 749.755901
#> iter   6 value 740.974387
#> iter   7 value 739.556976
#> iter   8 value 739.520995
#> iter   9 value 739.520919
#> iter  10 value 739.520907
#> iter  10 value 739.520901
#> iter  10 value 739.520894
#> final  value 739.520894 
#> converged
#> This is Run number  346 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1421221  0.08251169  -0.6921221 -12.517488      1
#> 2     1  -0.95  -2.35  0.8369211  0.80858431  -0.1130789  -1.541416      1
#> 3     1  -6.20  -2.30  2.8699339 -1.02739652  -3.3300661  -3.327397      2
#> 4     1 -13.90  -2.55  1.2357735 -1.31597203 -12.6642265  -3.865972      2
#> 5     1 -14.40  -5.80 -0.9792634 -0.70896788 -15.3792634  -6.508968      2
#> 6     1  -3.60  -1.70  4.3953201  0.30450941   0.7953201  -1.395491      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6560 -39100   5150 
#> initial  value 998.131940 
#> iter   2 value 816.875929
#> iter   3 value 807.145751
#> iter   4 value 804.227240
#> iter   5 value 769.235821
#> iter   6 value 760.606304
#> iter   7 value 758.824920
#> iter   8 value 758.773957
#> iter   9 value 758.773733
#> iter  10 value 758.773706
#> iter  10 value 758.773706
#> iter  11 value 758.773694
#> iter  11 value 758.773691
#> iter  11 value 758.773689
#> final  value 758.773689 
#> converged
#> This is Run number  347 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4963171  1.54776181  -1.046317 -11.052238      1
#> 2     1  -0.95  -2.35 -0.4092942 -0.73490196  -1.359294  -3.084902      1
#> 3     1  -6.20  -2.30  0.9007669  0.06077286  -5.299233  -2.239227      2
#> 4     1 -13.90  -2.55 -1.1846619  0.96892488 -15.084662  -1.581075      2
#> 5     1 -14.40  -5.80  0.1620215 -1.08171979 -14.237979  -6.881720      2
#> 6     1  -3.60  -1.70  1.9468417 -1.12592985  -1.653158  -2.825930      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6280 -39225   7225 
#> initial  value 998.131940 
#> iter   2 value 805.120005
#> iter   3 value 791.017050
#> iter   4 value 789.157742
#> iter   5 value 754.461374
#> iter   6 value 745.862181
#> iter   7 value 744.591508
#> iter   8 value 744.565599
#> iter   9 value 744.565566
#> iter   9 value 744.565556
#> iter   9 value 744.565550
#> final  value 744.565550 
#> converged
#> This is Run number  348 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1070251  1.3735966  -0.4429749 -11.226403      1
#> 2     1  -0.95  -2.35  2.5382252 -1.2283300   1.5882252  -3.578330      1
#> 3     1  -6.20  -2.30  0.3895258  0.2032263  -5.8104742  -2.096774      2
#> 4     1 -13.90  -2.55 -1.2189927 -0.1188508 -15.1189927  -2.668851      2
#> 5     1 -14.40  -5.80  2.6274349  0.1071135 -11.7725651  -5.692886      2
#> 6     1  -3.60  -1.70  2.2582843 -0.6188796  -1.3417157  -2.318880      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7020 -39425   5650 
#> initial  value 998.131940 
#> iter   2 value 809.422403
#> iter   3 value 800.910052
#> iter   4 value 799.485381
#> iter   5 value 765.000282
#> iter   6 value 756.347193
#> iter   7 value 754.653113
#> iter   8 value 754.607029
#> iter   9 value 754.606889
#> iter  10 value 754.606874
#> iter  10 value 754.606874
#> iter  10 value 754.606868
#> final  value 754.606868 
#> converged
#> This is Run number  349 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.01433267 1.6887938  -0.5643327 -10.9112062      1
#> 2     1  -0.95  -2.35  0.31574402 1.2191064  -0.6342560  -1.1308936      1
#> 3     1  -6.20  -2.30 -0.06492914 0.3449202  -6.2649291  -1.9550798      2
#> 4     1 -13.90  -2.55  3.02505611 0.3281834 -10.8749439  -2.2218166      2
#> 5     1 -14.40  -5.80 -0.62320971 0.3506439 -15.0232097  -5.4493561      2
#> 6     1  -3.60  -1.70 -0.16654804 2.6227382  -3.7665480   0.9227382      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6780 -38625   6300 
#> initial  value 998.131940 
#> iter   2 value 818.532458
#> iter   3 value 809.335732
#> iter   4 value 808.445193
#> iter   5 value 771.500496
#> iter   6 value 762.974936
#> iter   7 value 761.417934
#> iter   8 value 761.380454
#> iter   9 value 761.380365
#> iter  10 value 761.380351
#> iter  10 value 761.380344
#> iter  10 value 761.380340
#> final  value 761.380340 
#> converged
#> This is Run number  350 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1          e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  4.0230003  0.833798587   3.473000 -11.766201      1
#> 2     1  -0.95  -2.35 -1.4871632 -0.615569238  -2.437163  -2.965569      1
#> 3     1  -6.20  -2.30 -1.0053340  1.572916981  -7.205334  -0.727083      2
#> 4     1 -13.90  -2.55  1.3485823 -1.433612543 -12.551418  -3.983613      2
#> 5     1 -14.40  -5.80  1.6443260 -0.004162723 -12.755674  -5.804163      2
#> 6     1  -3.60  -1.70 -0.7486553 -0.173373405  -4.348655  -1.873373      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6820 -40575   6550 
#> initial  value 998.131940 
#> iter   2 value 787.340478
#> iter   3 value 774.450360
#> iter   4 value 772.385245
#> iter   5 value 741.686081
#> iter   6 value 732.908298
#> iter   7 value 731.619766
#> iter   8 value 731.588727
#> iter   9 value 731.588675
#> iter   9 value 731.588675
#> iter   9 value 731.588675
#> final  value 731.588675 
#> converged
#> This is Run number  351 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -1.0231889 -0.01071702  -1.573189 -12.610717      1
#> 2     1  -0.95  -2.35  1.9699135  4.06919077   1.019913   1.719191      2
#> 3     1  -6.20  -2.30  0.5046416 -0.95647561  -5.695358  -3.256476      2
#> 4     1 -13.90  -2.55  0.8071614  0.44074450 -13.092839  -2.109255      2
#> 5     1 -14.40  -5.80  0.6271912 -0.35827125 -13.772809  -6.158271      2
#> 6     1  -3.60  -1.70  2.3725348 -0.35232170  -1.227465  -2.052322      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -40575   7550 
#> initial  value 998.131940 
#> iter   2 value 782.134675
#> iter   3 value 764.430684
#> iter   4 value 761.753671
#> iter   5 value 731.521445
#> iter   6 value 722.946360
#> iter   7 value 721.865700
#> iter   8 value 721.846121
#> iter   8 value 721.846115
#> final  value 721.846115 
#> converged
#> This is Run number  352 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1767934 -1.7626297  -0.7267934 -14.3626297      1
#> 2     1  -0.95  -2.35  4.1777955  1.8719151   3.2277955  -0.4780849      1
#> 3     1  -6.20  -2.30  2.0225471  1.1616393  -4.1774529  -1.1383607      2
#> 4     1 -13.90  -2.55 -0.3668602  0.1575424 -14.2668602  -2.3924576      2
#> 5     1 -14.40  -5.80 -0.4243312  1.9044261 -14.8243312  -3.8955739      2
#> 6     1  -3.60  -1.70  0.7445153  3.8724074  -2.8554847   2.1724074      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6360 -40350   7950 
#> initial  value 998.131940 
#> iter   2 value 783.234317
#> iter   3 value 765.200002
#> iter   4 value 763.358892
#> iter   5 value 732.308498
#> iter   6 value 723.787577
#> iter   7 value 722.723758
#> iter   8 value 722.706459
#> iter   8 value 722.706452
#> final  value 722.706452 
#> converged
#> This is Run number  353 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5889278  1.4076894  -1.138928 -11.192311      1
#> 2     1  -0.95  -2.35 -0.6842479 -0.5114510  -1.634248  -2.861451      1
#> 3     1  -6.20  -2.30  0.4429901 -0.5546245  -5.757010  -2.854624      2
#> 4     1 -13.90  -2.55 -0.5745614  0.3328260 -14.474561  -2.217174      2
#> 5     1 -14.40  -5.80 -0.9843947 -1.1808871 -15.384395  -6.980887      2
#> 6     1  -3.60  -1.70  1.4004910  0.1947095  -2.199509  -1.505290      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6380 -39075   7150 
#> initial  value 998.131940 
#> iter   2 value 807.730018
#> iter   3 value 794.545094
#> iter   4 value 793.043329
#> iter   5 value 757.769096
#> iter   6 value 749.174792
#> iter   7 value 747.869024
#> iter   8 value 747.841730
#> iter   9 value 747.841691
#> iter  10 value 747.841680
#> iter  10 value 747.841671
#> iter  10 value 747.841665
#> final  value 747.841665 
#> converged
#> This is Run number  354 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4956821  0.03096127  -1.045682 -12.569039      1
#> 2     1  -0.95  -2.35 -0.1474271 -0.19864114  -1.097427  -2.548641      1
#> 3     1  -6.20  -2.30  1.3401975  0.68786517  -4.859803  -1.612135      2
#> 4     1 -13.90  -2.55  1.7107599  1.14629727 -12.189240  -1.403703      2
#> 5     1 -14.40  -5.80 -0.4163354 -1.05937308 -14.816335  -6.859373      2
#> 6     1  -3.60  -1.70 -0.7355363 -0.33361057  -4.335536  -2.033611      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -38425   6625 
#> initial  value 998.131940 
#> iter   2 value 820.035676
#> iter   3 value 809.586530
#> iter   4 value 808.421991
#> iter   5 value 771.038591
#> iter   6 value 762.546780
#> iter   7 value 761.083672
#> iter   8 value 761.050621
#> iter   9 value 761.050554
#> iter  10 value 761.050541
#> iter  10 value 761.050532
#> iter  10 value 761.050528
#> final  value 761.050528 
#> converged
#> This is Run number  355 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1           U_2 CHOICE
#> 1     1  -0.55 -12.60  0.1647103 0.07930866  -0.3852897 -12.520691341      1
#> 2     1  -0.95  -2.35 -0.1424667 0.09561892  -1.0924667  -2.254381083      1
#> 3     1  -6.20  -2.30  0.1453071 2.29248432  -6.0546929  -0.007515684      2
#> 4     1 -13.90  -2.55  0.2810925 0.06856221 -13.6189075  -2.481437787      2
#> 5     1 -14.40  -5.80  0.2624897 0.28416731 -14.1375103  -5.515832692      2
#> 6     1  -3.60  -1.70  0.1326678 0.87133245  -3.4673322  -0.828667548      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -38275   7200 
#> initial  value 998.131940 
#> iter   2 value 819.411201
#> iter   3 value 805.080679
#> iter   4 value 802.488279
#> iter   5 value 765.186242
#> iter   6 value 756.750302
#> iter   7 value 755.447849
#> iter   8 value 755.422520
#> iter   9 value 755.422489
#> iter   9 value 755.422479
#> iter   9 value 755.422474
#> final  value 755.422474 
#> converged
#> This is Run number  356 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  3.1639730  2.2700330   2.6139730 -10.329967      1
#> 2     1  -0.95  -2.35  1.9268195 -0.5313038   0.9768195  -2.881304      1
#> 3     1  -6.20  -2.30 -1.2520206  0.4916557  -7.4520206  -1.808344      2
#> 4     1 -13.90  -2.55  0.7966865 -0.2261394 -13.1033135  -2.776139      2
#> 5     1 -14.40  -5.80  0.9265471 -0.9538936 -13.4734529  -6.753894      2
#> 6     1  -3.60  -1.70  1.3908764 -0.4156827  -2.2091236  -2.115683      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6960 -39750   5700 
#> initial  value 998.131940 
#> iter   2 value 804.298384
#> iter   3 value 794.943756
#> iter   4 value 793.129145
#> iter   5 value 759.748662
#> iter   6 value 751.032268
#> iter   7 value 749.398314
#> iter   8 value 749.353398
#> iter   9 value 749.353266
#> iter  10 value 749.353252
#> iter  10 value 749.353252
#> iter  10 value 749.353245
#> final  value 749.353245 
#> converged
#> This is Run number  357 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2163244  2.0755156  -0.7663244 -10.524484      1
#> 2     1  -0.95  -2.35  0.1444617  2.7800720  -0.8055383   0.430072      2
#> 3     1  -6.20  -2.30  4.1538867  1.2051474  -2.0461133  -1.094853      2
#> 4     1 -13.90  -2.55  0.1143133  0.2053682 -13.7856867  -2.344632      2
#> 5     1 -14.40  -5.80  0.2530071 -0.7430220 -14.1469929  -6.543022      2
#> 6     1  -3.60  -1.70 -0.4340374 -0.4435678  -4.0340374  -2.143568      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7540 -37625   5175 
#> initial  value 998.131940 
#> iter   2 value 836.630691
#> iter   3 value 832.151170
#> iter   4 value 832.119520
#> iter   5 value 791.884196
#> iter   6 value 783.886878
#> iter   7 value 781.937015
#> iter   8 value 781.889829
#> iter   9 value 781.889663
#> iter   9 value 781.889653
#> iter   9 value 781.889648
#> final  value 781.889648 
#> converged
#> This is Run number  358 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.06739831  0.69529612  -0.6173983 -11.9047039      1
#> 2     1  -0.95  -2.35  0.81668059 -0.03531337  -0.1333194  -2.3853134      1
#> 3     1  -6.20  -2.30  0.72046779  0.85285334  -5.4795322  -1.4471467      2
#> 4     1 -13.90  -2.55 -0.15622525  0.10450807 -14.0562253  -2.4454919      2
#> 5     1 -14.40  -5.80 -0.90321422  0.52869760 -15.3032142  -5.2713024      2
#> 6     1  -3.60  -1.70  1.58720911  2.46149805  -2.0127909   0.7614981      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6760 -38125   6750 
#> initial  value 998.131940 
#> iter   2 value 823.398595
#> iter   3 value 813.994851
#> iter   4 value 813.612432
#> iter   5 value 775.153250
#> iter   6 value 766.723202
#> iter   7 value 765.234403
#> iter   8 value 765.200888
#> iter   9 value 765.200814
#> iter  10 value 765.200797
#> iter  10 value 765.200787
#> iter  10 value 765.200783
#> final  value 765.200783 
#> converged
#> This is Run number  359 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 0.6188256 -0.06815642   0.06882556 -12.668156      1
#> 2     1  -0.95  -2.35 0.5141668  0.12498910  -0.43583323  -2.225011      1
#> 3     1  -6.20  -2.30 0.3418607 -0.47637036  -5.85813935  -2.776370      2
#> 4     1 -13.90  -2.55 0.7931820 -1.18340333 -13.10681803  -3.733403      2
#> 5     1 -14.40  -5.80 0.3194183  0.43100700 -14.08058172  -5.368993      2
#> 6     1  -3.60  -1.70 0.8196028 -1.63211592  -2.78039724  -3.332116      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -39150   7150 
#> initial  value 998.131940 
#> iter   2 value 806.579370
#> iter   3 value 793.414178
#> iter   4 value 791.969250
#> iter   5 value 756.901162
#> iter   6 value 748.294456
#> iter   7 value 746.991423
#> iter   8 value 746.964086
#> iter   9 value 746.964047
#> iter  10 value 746.964035
#> iter  10 value 746.964026
#> iter  10 value 746.964021
#> final  value 746.964021 
#> converged
#> This is Run number  360 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.45632825  0.4773167  -1.006328 -12.1226833      1
#> 2     1  -0.95  -2.35  1.41010702 -0.1876814   0.460107  -2.5376814      1
#> 3     1  -6.20  -2.30  0.52837584 -0.2807183  -5.671624  -2.5807183      2
#> 4     1 -13.90  -2.55  1.14854173  3.1284415 -12.751458   0.5784415      2
#> 5     1 -14.40  -5.80  0.19964892  0.4862284 -14.200351  -5.3137716      2
#> 6     1  -3.60  -1.70  0.07946421 -0.2202404  -3.520536  -1.9202404      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -36775   6425 
#> initial  value 998.131940 
#> iter   2 value 843.966177
#> iter   3 value 835.715227
#> iter   4 value 834.837824
#> iter   5 value 792.798838
#> iter   6 value 784.774229
#> iter   7 value 783.273462
#> iter   8 value 783.242586
#> iter   9 value 783.242520
#> iter   9 value 783.242516
#> iter   9 value 783.242516
#> final  value 783.242516 
#> converged
#> This is Run number  361 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.51498132  2.4538083  -0.03501868 -10.1461917      1
#> 2     1  -0.95  -2.35 -0.71842931 -0.9474839  -1.66842931  -3.2974839      1
#> 3     1  -6.20  -2.30  0.05002474 -0.6330070  -6.14997526  -2.9330070      2
#> 4     1 -13.90  -2.55  0.16714203 -0.3488155 -13.73285797  -2.8988155      2
#> 5     1 -14.40  -5.80  1.91759542  0.6568617 -12.48240458  -5.1431383      2
#> 6     1  -3.60  -1.70  0.66187875  1.3674711  -2.93812125  -0.3325289      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -38875   7300 
#> initial  value 998.131940 
#> iter   2 value 810.012725
#> iter   3 value 795.563277
#> iter   4 value 793.445374
#> iter   5 value 757.797076
#> iter   6 value 749.259800
#> iter   7 value 747.988233
#> iter   8 value 747.963147
#> iter   9 value 747.963116
#> iter   9 value 747.963106
#> iter   9 value 747.963101
#> final  value 747.963101 
#> converged
#> This is Run number  362 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.23390383 -0.1052986  -0.7839038 -12.7052986      1
#> 2     1  -0.95  -2.35 -0.08126034  1.6060861  -1.0312603  -0.7439139      2
#> 3     1  -6.20  -2.30  0.51963484  5.4460350  -5.6803652   3.1460350      2
#> 4     1 -13.90  -2.55  1.09290992  0.7979132 -12.8070901  -1.7520868      2
#> 5     1 -14.40  -5.80  0.04661247  1.5709687 -14.3533875  -4.2290313      2
#> 6     1  -3.60  -1.70  1.93927856 -0.5402503  -1.6607214  -2.2402503      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6580 -37025   6000 
#> initial  value 998.131940 
#> iter   2 value 842.458362
#> iter   3 value 835.460265
#> iter   4 value 834.835288
#> iter   5 value 793.373097
#> iter   6 value 785.313892
#> iter   7 value 783.688344
#> iter   8 value 783.652790
#> iter   9 value 783.652701
#> iter   9 value 783.652699
#> iter   9 value 783.652699
#> final  value 783.652699 
#> converged
#> This is Run number  363 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4375808  2.5347218  -0.9875808 -10.065278      1
#> 2     1  -0.95  -2.35  0.4008422 -0.5472970  -0.5491578  -2.897297      1
#> 3     1  -6.20  -2.30  0.4459111  0.0593896  -5.7540889  -2.240610      2
#> 4     1 -13.90  -2.55  1.4093182  0.4646540 -12.4906818  -2.085346      2
#> 5     1 -14.40  -5.80 -0.5070267  3.3176282 -14.9070267  -2.482372      2
#> 6     1  -3.60  -1.70  0.4878147 -0.3172919  -3.1121853  -2.017292      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6220 -39075   7825 
#> initial  value 998.131940 
#> iter   2 value 803.797170
#> iter   3 value 788.358299
#> iter   4 value 787.012756
#> iter   5 value 751.851182
#> iter   6 value 743.322542
#> iter   7 value 742.132008
#> iter   8 value 742.111126
#> iter   8 value 742.111115
#> final  value 742.111115 
#> converged
#> This is Run number  364 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.01995143  0.53422335  -0.5300486 -12.065777      1
#> 2     1  -0.95  -2.35 -0.62971605  0.06020800  -1.5797160  -2.289792      1
#> 3     1  -6.20  -2.30  0.60995632  0.08139514  -5.5900437  -2.218605      2
#> 4     1 -13.90  -2.55  1.60937819  0.61695081 -12.2906218  -1.933049      2
#> 5     1 -14.40  -5.80 -0.40124867  0.31516816 -14.8012487  -5.484832      2
#> 6     1  -3.60  -1.70  2.24563245 -0.54011054  -1.3543676  -2.240111      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7060 -40475   6650 
#> initial  value 998.131940 
#> iter   2 value 788.148555
#> iter   3 value 776.257903
#> iter   4 value 775.121898
#> iter   5 value 743.831508
#> iter   6 value 735.044632
#> iter   7 value 733.728957
#> iter   8 value 733.697153
#> iter   9 value 733.697098
#> iter   9 value 733.697087
#> iter   9 value 733.697079
#> final  value 733.697079 
#> converged
#> This is Run number  365 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8751368 -0.9911158   0.3251368 -13.591116      1
#> 2     1  -0.95  -2.35  0.1464418  3.5580936  -0.8035582   1.208094      2
#> 3     1  -6.20  -2.30 -1.1980566 -0.1028167  -7.3980566  -2.402817      2
#> 4     1 -13.90  -2.55  2.7824423 -0.6203856 -11.1175577  -3.170386      2
#> 5     1 -14.40  -5.80 -0.3606440  0.6812046 -14.7606440  -5.118795      2
#> 6     1  -3.60  -1.70  0.8549905  2.9972896  -2.7450095   1.297290      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6540 -38900   6550 
#> initial  value 998.131940 
#> iter   2 value 813.464444
#> iter   3 value 802.458650
#> iter   4 value 800.983558
#> iter   5 value 765.069570
#> iter   6 value 756.481052
#> iter   7 value 755.031367
#> iter   8 value 754.997685
#> iter   9 value 754.997618
#> iter  10 value 754.997606
#> iter  10 value 754.997598
#> iter  10 value 754.997597
#> final  value 754.997597 
#> converged
#> This is Run number  366 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 0.5695015  0.20727390   0.01950149 -12.3927261      1
#> 2     1  -0.95  -2.35 0.2393554  0.29883996  -0.71064464  -2.0511600      1
#> 3     1  -6.20  -2.30 2.1657006 -0.19050295  -4.03429936  -2.4905029      2
#> 4     1 -13.90  -2.55 1.4067805  0.63720574 -12.49321950  -1.9127943      2
#> 5     1 -14.40  -5.80 0.6878175 -0.06525298 -13.71218248  -5.8652530      2
#> 6     1  -3.60  -1.70 0.4342491  1.46327143  -3.16575094  -0.2367286      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6080 -37950   6125 
#> initial  value 998.131940 
#> iter   2 value 829.572433
#> iter   3 value 818.815599
#> iter   4 value 816.389203
#> iter   5 value 778.008470
#> iter   6 value 769.620999
#> iter   7 value 768.093586
#> iter   8 value 768.059064
#> iter   9 value 768.058989
#> iter   9 value 768.058978
#> iter   9 value 768.058973
#> final  value 768.058973 
#> converged
#> This is Run number  367 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2           U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.1874893 -1.2087198  -0.737489278 -13.8087198      1
#> 2     1  -0.95  -2.35  0.9526646  0.1423270   0.002664623  -2.2076730      1
#> 3     1  -6.20  -2.30  1.8403500  1.8578535  -4.359649967  -0.4421465      2
#> 4     1 -13.90  -2.55  2.8530679 -0.2822310 -11.046932091  -2.8322310      2
#> 5     1 -14.40  -5.80 -0.8516124  2.7621652 -15.251612433  -3.0378348      2
#> 6     1  -3.60  -1.70  6.3520478  0.9184675   2.752047773  -0.7815325      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6400 -39375   7975 
#> initial  value 998.131940 
#> iter   2 value 798.210136
#> iter   3 value 782.427358
#> iter   4 value 781.475501
#> iter   5 value 747.154833
#> iter   6 value 738.600097
#> iter   7 value 737.447510
#> iter   8 value 737.428186
#> iter   9 value 737.428165
#> iter   9 value 737.428157
#> iter   9 value 737.428148
#> final  value 737.428148 
#> converged
#> This is Run number  368 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1       U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4062999  2.8343699  -0.1437001 -9.765630      1
#> 2     1  -0.95  -2.35  1.5973706 -1.5884579   0.6473706 -3.938458      1
#> 3     1  -6.20  -2.30  0.3456394 -0.4764808  -5.8543606 -2.776481      2
#> 4     1 -13.90  -2.55 -0.8083315 -0.6385367 -14.7083315 -3.188537      2
#> 5     1 -14.40  -5.80  1.0850059  0.1068061 -13.3149941 -5.693194      2
#> 6     1  -3.60  -1.70  0.5018938  3.3553942  -3.0981062  1.655394      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5580 -37275   7000 
#> initial  value 998.131940 
#> iter   2 value 834.499348
#> iter   3 value 821.640321
#> iter   4 value 819.097887
#> iter   5 value 778.892110
#> iter   6 value 770.679340
#> iter   7 value 769.330882
#> iter   8 value 769.305245
#> iter   9 value 769.305209
#> iter   9 value 769.305199
#> iter   9 value 769.305194
#> final  value 769.305194 
#> converged
#> This is Run number  369 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.7902159 -0.8189835  -1.340216 -13.4189835      1
#> 2     1  -0.95  -2.35 -0.3906358 -0.4260556  -1.340636  -2.7760556      1
#> 3     1  -6.20  -2.30  1.0894944  1.7445495  -5.110506  -0.5554505      2
#> 4     1 -13.90  -2.55 -0.1850612  0.6815254 -14.085061  -1.8684746      2
#> 5     1 -14.40  -5.80  0.6805067  2.3398522 -13.719493  -3.4601478      2
#> 6     1  -3.60  -1.70  0.5428826 -0.7067463  -3.057117  -2.4067463      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6600 -39800   7750 
#> initial  value 998.131940 
#> iter   2 value 792.951216
#> iter   3 value 777.683514
#> iter   4 value 776.777968
#> iter   5 value 743.683178
#> iter   6 value 735.062785
#> iter   7 value 733.905691
#> iter   8 value 733.884880
#> iter   9 value 733.884862
#> iter   9 value 733.884859
#> iter  10 value 733.884845
#> iter  10 value 733.884836
#> iter  10 value 733.884834
#> final  value 733.884834 
#> converged
#> This is Run number  370 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.3909281 -0.6072395  -0.9409281 -13.2072395      1
#> 2     1  -0.95  -2.35 -0.3691396  1.6925847  -1.3191396  -0.6574153      2
#> 3     1  -6.20  -2.30  0.3141480  2.4939592  -5.8858520   0.1939592      2
#> 4     1 -13.90  -2.55  1.6185558 -0.6706478 -12.2814442  -3.2206478      2
#> 5     1 -14.40  -5.80  2.6666213 -1.3239352 -11.7333787  -7.1239352      2
#> 6     1  -3.60  -1.70 -0.3682570 -0.4843449  -3.9682570  -2.1843449      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6500 -39150   6975 
#> initial  value 998.131940 
#> iter   2 value 807.500091
#> iter   3 value 795.041824
#> iter   4 value 793.660719
#> iter   5 value 758.533229
#> iter   6 value 749.913357
#> iter   7 value 748.571412
#> iter   8 value 748.542120
#> iter   9 value 748.542073
#> iter  10 value 748.542061
#> iter  10 value 748.542052
#> iter  10 value 748.542046
#> final  value 748.542046 
#> converged
#> This is Run number  371 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.8273588  1.1024889   2.277359 -11.4975111      1
#> 2     1  -0.95  -2.35 -0.2498194 -0.4256222  -1.199819  -2.7756222      1
#> 3     1  -6.20  -2.30  0.8873638 -0.1677692  -5.312636  -2.4677692      2
#> 4     1 -13.90  -2.55  1.0876094 -0.6882743 -12.812391  -3.2382743      2
#> 5     1 -14.40  -5.80 -0.9126750  0.8517798 -15.312675  -4.9482202      2
#> 6     1  -3.60  -1.70 -0.7615486  1.0037164  -4.361549  -0.6962836      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6000 -39000   7725 
#> initial  value 998.131940 
#> iter   2 value 805.646106
#> iter   3 value 789.618798
#> iter   4 value 787.555409
#> iter   5 value 752.359711
#> iter   6 value 743.855228
#> iter   7 value 742.656718
#> iter   8 value 742.635422
#> iter   9 value 742.635403
#> iter   9 value 742.635397
#> iter   9 value 742.635394
#> final  value 742.635394 
#> converged
#> This is Run number  372 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.2984392  2.4489337  -0.8484392 -10.1510663      1
#> 2     1  -0.95  -2.35 -0.4680845 -0.1391742  -1.4180845  -2.4891742      1
#> 3     1  -6.20  -2.30  0.8443279 -1.0376599  -5.3556721  -3.3376599      2
#> 4     1 -13.90  -2.55 -0.8184065  3.0300119 -14.7184065   0.4800119      2
#> 5     1 -14.40  -5.80 -1.3966762  0.2316948 -15.7966762  -5.5683052      2
#> 6     1  -3.60  -1.70 -0.8443892  0.8223841  -4.4443892  -0.8776159      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6980 -38750   6975 
#> initial  value 998.131940 
#> iter   2 value 812.911051
#> iter   3 value 802.599545
#> iter   4 value 802.398700
#> iter   5 value 765.749538
#> iter   6 value 757.173248
#> iter   7 value 755.743221
#> iter   8 value 755.710822
#> iter   9 value 755.710754
#> iter  10 value 755.710736
#> iter  10 value 755.710727
#> iter  10 value 755.710719
#> final  value 755.710719 
#> converged
#> This is Run number  373 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60  0.40311048  0.6188739  -0.1468895 -11.98112608      1
#> 2     1  -0.95  -2.35 -0.07586796  3.8948570  -1.0258680   1.54485697      2
#> 3     1  -6.20  -2.30  0.26682261  2.3918669  -5.9331774   0.09186686      2
#> 4     1 -13.90  -2.55 -0.57302935  1.1657545 -14.4730293  -1.38424551      2
#> 5     1 -14.40  -5.80 -1.04429617  0.3873057 -15.4442962  -5.41269430      2
#> 6     1  -3.60  -1.70 -0.07368434 -0.8095394  -3.6736843  -2.50953943      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6560 -38525   6175 
#> initial  value 998.131940 
#> iter   2 value 820.813180
#> iter   3 value 811.159712
#> iter   4 value 809.679208
#> iter   5 value 772.638315
#> iter   6 value 764.135057
#> iter   7 value 762.576863
#> iter   8 value 762.539612
#> iter   9 value 762.539525
#> iter  10 value 762.539513
#> iter  10 value 762.539507
#> iter  10 value 762.539505
#> final  value 762.539505 
#> converged
#> This is Run number  374 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.0094982  1.0977488   0.4594982 -11.502251      1
#> 2     1  -0.95  -2.35  0.1242718 -0.1444734  -0.8257282  -2.494473      1
#> 3     1  -6.20  -2.30  2.6413519 -0.6005646  -3.5586481  -2.900565      2
#> 4     1 -13.90  -2.55  3.2114058  0.8292145 -10.6885942  -1.720785      2
#> 5     1 -14.40  -5.80 -0.9376428  1.5703528 -15.3376428  -4.229647      2
#> 6     1  -3.60  -1.70  0.9083187  1.2261480  -2.6916813  -0.473852      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -38625   6800 
#> initial  value 998.131940 
#> iter   2 value 816.578230
#> iter   3 value 801.196248
#> iter   4 value 797.396418
#> iter   5 value 761.347269
#> iter   6 value 752.802784
#> iter   7 value 751.486929
#> iter   8 value 751.459930
#> iter   9 value 751.459893
#> iter   9 value 751.459885
#> iter   9 value 751.459881
#> final  value 751.459881 
#> converged
#> This is Run number  375 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.8416216  0.4739841   0.2916216 -12.1260159      1
#> 2     1  -0.95  -2.35  0.7674261  1.9003111  -0.1825739  -0.4496889      1
#> 3     1  -6.20  -2.30 -0.1642891  0.5924705  -6.3642891  -1.7075295      2
#> 4     1 -13.90  -2.55 -1.2235572  0.3337879 -15.1235572  -2.2162121      2
#> 5     1 -14.40  -5.80  1.9947066  3.4438550 -12.4052934  -2.3561450      2
#> 6     1  -3.60  -1.70  0.4160676 -0.4382540  -3.1839324  -2.1382540      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -37725   6675 
#> initial  value 998.131940 
#> iter   2 value 830.066285
#> iter   3 value 817.050882
#> iter   4 value 814.099169
#> iter   5 value 775.240155
#> iter   6 value 766.894687
#> iter   7 value 765.505296
#> iter   8 value 765.477041
#> iter   9 value 765.476996
#> iter   9 value 765.476987
#> iter   9 value 765.476983
#> final  value 765.476983 
#> converged
#> This is Run number  376 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1       e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 0.6336797 0.3933123   0.08367973 -12.2066877      1
#> 2     1  -0.95  -2.35 0.8934883 1.6525625  -0.05651167  -0.6974375      1
#> 3     1  -6.20  -2.30 1.9000939 0.8107729  -4.29990613  -1.4892271      2
#> 4     1 -13.90  -2.55 2.1753895 1.2698681 -11.72461046  -1.2801319      2
#> 5     1 -14.40  -5.80 2.0232928 1.8456050 -12.37670722  -3.9543950      2
#> 6     1  -3.60  -1.70 2.1533809 0.2632653  -1.44661913  -1.4367347      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   7020 -39125   6575 
#> initial  value 998.131940 
#> iter   2 value 809.477345
#> iter   3 value 799.713789
#> iter   4 value 799.231085
#> iter   5 value 763.657755
#> iter   6 value 755.020669
#> iter   7 value 753.528709
#> iter   8 value 753.492554
#> iter   9 value 753.492472
#> iter  10 value 753.492456
#> iter  10 value 753.492446
#> iter  10 value 753.492439
#> final  value 753.492439 
#> converged
#> This is Run number  377 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 2.6985567  1.0295795   2.1485567 -11.5704205      1
#> 2     1  -0.95  -2.35 1.4779324  1.3619245   0.5279324  -0.9880755      1
#> 3     1  -6.20  -2.30 0.6740668  1.5149367  -5.5259332  -0.7850633      2
#> 4     1 -13.90  -2.55 1.2484564  1.8452279 -12.6515436  -0.7047721      2
#> 5     1 -14.40  -5.80 1.7680666 -1.0564887 -12.6319334  -6.8564887      2
#> 6     1  -3.60  -1.70 0.5286699  0.8785516  -3.0713301  -0.8214484      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6920 -39200   6350 
#> initial  value 998.131940 
#> iter   2 value 809.632558
#> iter   3 value 799.928793
#> iter   4 value 799.041545
#> iter   5 value 763.775590
#> iter   6 value 755.131952
#> iter   7 value 753.611110
#> iter   8 value 753.573484
#> iter   9 value 753.573397
#> iter  10 value 753.573383
#> iter  10 value 753.573376
#> iter  10 value 753.573369
#> final  value 753.573369 
#> converged
#> This is Run number  378 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2       e_1        e_2          U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 0.6366927  1.6028180   0.08669266 -10.99718195      1
#> 2     1  -0.95  -2.35 1.6326450  2.1872964   0.68264500  -0.16270357      1
#> 3     1  -6.20  -2.30 0.1648658 -0.2870617  -6.03513422  -2.58706174      2
#> 4     1 -13.90  -2.55 0.6211208 -0.8389696 -13.27887924  -3.38896964      2
#> 5     1 -14.40  -5.80 0.1086370  1.7454727 -14.29136297  -4.05452735      2
#> 6     1  -3.60  -1.70 1.7543899  1.7103005  -1.84561007   0.01030046      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -38450   8125 
#> initial  value 998.131940 
#> iter   2 value 811.211263
#> iter   3 value 795.105425
#> iter   4 value 793.571699
#> iter   5 value 756.627645
#> iter   6 value 748.224357
#> iter   7 value 747.044111
#> iter   8 value 747.025357
#> iter   9 value 747.025339
#> iter   9 value 747.025332
#> iter   9 value 747.025324
#> final  value 747.025324 
#> converged
#> This is Run number  379 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1       e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.4299685 0.3667506  -0.1200315 -12.233249      1
#> 2     1  -0.95  -2.35  0.6316911 0.3922987  -0.3183089  -1.957701      1
#> 3     1  -6.20  -2.30 -0.2325828 0.2415930  -6.4325828  -2.058407      2
#> 4     1 -13.90  -2.55 -0.0566559 0.6890830 -13.9566559  -1.860917      2
#> 5     1 -14.40  -5.80 -0.1040032 1.4518417 -14.5040032  -4.348158      2
#> 6     1  -3.60  -1.70  0.8550014 0.2665985  -2.7449986  -1.433401      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6920 -41625   7525 
#> initial  value 998.131940 
#> iter   2 value 764.397068
#> iter   3 value 747.441781
#> iter   4 value 745.870165
#> iter   5 value 718.539216
#> iter   6 value 710.004995
#> iter   7 value 709.018109
#> iter   8 value 709.000720
#> iter   9 value 709.000705
#> iter   9 value 709.000702
#> iter   9 value 709.000702
#> final  value 709.000702 
#> converged
#> This is Run number  380 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  2.9233471 -0.2593132   2.373347 -12.8593132      1
#> 2     1  -0.95  -2.35  2.0873200  2.1207258   1.137320  -0.2292742      1
#> 3     1  -6.20  -2.30  0.9967502  1.6615115  -5.203250  -0.6384885      2
#> 4     1 -13.90  -2.55 -0.4637537  0.8230316 -14.363754  -1.7269684      2
#> 5     1 -14.40  -5.80  1.6764089  0.5599035 -12.723591  -5.2400965      2
#> 6     1  -3.60  -1.70 -0.1407450 -0.1025925  -3.740745  -1.8025925      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -39800   7200 
#> initial  value 998.131940 
#> iter   2 value 796.501366
#> iter   3 value 780.971417
#> iter   4 value 778.392952
#> iter   5 value 745.649741
#> iter   6 value 737.009404
#> iter   7 value 735.798112
#> iter   8 value 735.773603
#> iter   9 value 735.773577
#> iter   9 value 735.773570
#> iter   9 value 735.773565
#> final  value 735.773565 
#> converged
#> This is Run number  381 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1          U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.98134842  2.1886455  -1.531348 -10.41135446      1
#> 2     1  -0.95  -2.35 -0.95216744 -0.1455566  -1.902167  -2.49555657      1
#> 3     1  -6.20  -2.30 -0.69298069  2.2827336  -6.892981  -0.01726645      2
#> 4     1 -13.90  -2.55  0.08347104  0.9776597 -13.816529  -1.57234034      2
#> 5     1 -14.40  -5.80 -0.04771824 -0.3847907 -14.447718  -6.18479073      2
#> 6     1  -3.60  -1.70  1.16966859  2.2530089  -2.430331   0.55300889      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5720 -36125   7525 
#> initial  value 998.131940 
#> iter   2 value 846.520309
#> iter   3 value 836.101753
#> iter   4 value 835.218213
#> iter   5 value 791.396658
#> iter   6 value 783.511009
#> iter   7 value 782.218537
#> iter   8 value 782.196578
#> iter   9 value 782.196545
#> iter  10 value 782.196533
#> iter  10 value 782.196525
#> iter  10 value 782.196520
#> final  value 782.196520 
#> converged
#> This is Run number  382 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.02408941 -0.3231195  -0.5740894 -12.9231195      1
#> 2     1  -0.95  -2.35 -0.28691271  1.3415195  -1.2369127  -1.0084805      2
#> 3     1  -6.20  -2.30 -0.69591141  0.8037257  -6.8959114  -1.4962743      2
#> 4     1 -13.90  -2.55  0.97163116  2.0660749 -12.9283688  -0.4839251      2
#> 5     1 -14.40  -5.80  2.51790328  1.9915539 -11.8820967  -3.8084461      2
#> 6     1  -3.60  -1.70  0.88624229 -1.9995759  -2.7137577  -3.6995759      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6900 -40700   5975 
#> initial  value 998.131940 
#> iter   2 value 788.075215
#> iter   3 value 776.338320
#> iter   4 value 773.726556
#> iter   5 value 743.491964
#> iter   6 value 734.672884
#> iter   7 value 733.264983
#> iter   8 value 733.226944
#> iter   9 value 733.226852
#> iter   9 value 733.226843
#> iter   9 value 733.226835
#> final  value 733.226835 
#> converged
#> This is Run number  383 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.4022502 -0.75425242  -0.9522502 -13.354252      1
#> 2     1  -0.95  -2.35  0.6445126 -0.06195407  -0.3054874  -2.411954      1
#> 3     1  -6.20  -2.30 -1.0436236 -0.09434359  -7.2436236  -2.394344      2
#> 4     1 -13.90  -2.55 -0.3128351  0.79290920 -14.2128351  -1.757091      2
#> 5     1 -14.40  -5.80 -1.0383794  0.10552442 -15.4383794  -5.694476      2
#> 6     1  -3.60  -1.70  1.0426777  0.35749799  -2.5573223  -1.342502      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6240 -38400   7300 
#> initial  value 998.131940 
#> iter   2 value 816.854078
#> iter   3 value 804.130658
#> iter   4 value 802.881237
#> iter   5 value 765.561760
#> iter   6 value 757.085971
#> iter   7 value 755.767722
#> iter   8 value 755.741401
#> iter   9 value 755.741362
#> iter  10 value 755.741350
#> iter  10 value 755.741340
#> iter  10 value 755.741334
#> final  value 755.741334 
#> converged
#> This is Run number  384 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  0.86016070  2.09920781   0.3101607 -10.5007922      1
#> 2     1  -0.95  -2.35  4.86636467 -0.61936208   3.9163647  -2.9693621      1
#> 3     1  -6.20  -2.30  0.22126184  0.08310593  -5.9787382  -2.2168941      2
#> 4     1 -13.90  -2.55 -1.26723880  1.85423949 -15.1672388  -0.6957605      2
#> 5     1 -14.40  -5.80  0.37560552  2.73209412 -14.0243945  -3.0679059      2
#> 6     1  -3.60  -1.70  0.06485589  1.80668976  -3.5351441   0.1066898      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6060 -38750   6700 
#> initial  value 998.131940 
#> iter   2 value 815.191067
#> iter   3 value 801.930440
#> iter   4 value 799.233029
#> iter   5 value 763.277896
#> iter   6 value 754.720174
#> iter   7 value 753.348200
#> iter   8 value 753.318367
#> iter   9 value 753.318318
#> iter   9 value 753.318309
#> iter   9 value 753.318304
#> final  value 753.318304 
#> converged
#> This is Run number  385 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5750582  0.7749512  -1.1250582 -11.825049      1
#> 2     1  -0.95  -2.35  1.7181055  3.5591389   0.7681055   1.209139      2
#> 3     1  -6.20  -2.30  1.8240353 -0.4220063  -4.3759647  -2.722006      2
#> 4     1 -13.90  -2.55  4.0793705 -0.7976963  -9.8206295  -3.347696      2
#> 5     1 -14.40  -5.80  1.7985952  0.8337251 -12.6014048  -4.966275      2
#> 6     1  -3.60  -1.70 -0.7872331  2.6730500  -4.3872331   0.973050      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6340 -37200   7475 
#> initial  value 998.131940 
#> iter   2 value 832.449713
#> iter   3 value 821.863762
#> iter   4 value 821.556165
#> iter   5 value 780.569566
#> iter   6 value 772.343081
#> iter   7 value 771.001017
#> iter   8 value 770.975645
#> iter   9 value 770.975602
#> iter  10 value 770.975587
#> iter  10 value 770.975579
#> iter  10 value 770.975572
#> final  value 770.975572 
#> converged
#> This is Run number  386 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.5546662 -0.67921366   1.0046662 -13.2792137      1
#> 2     1  -0.95  -2.35  0.4346368  0.01529455  -0.5153632  -2.3347055      1
#> 3     1  -6.20  -2.30  2.4643902  1.98883111  -3.7356098  -0.3111689      2
#> 4     1 -13.90  -2.55 -1.3766436  0.71933013 -15.2766436  -1.8306699      2
#> 5     1 -14.40  -5.80 -1.0012224  1.04021914 -15.4012224  -4.7597809      2
#> 6     1  -3.60  -1.70 -0.6257157  0.14101634  -4.2257157  -1.5589837      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6040 -37725   6400 
#> initial  value 998.131940 
#> iter   2 value 831.381448
#> iter   3 value 820.595030
#> iter   4 value 818.501825
#> iter   5 value 779.408249
#> iter   6 value 771.083088
#> iter   7 value 769.605764
#> iter   8 value 769.573850
#> iter   9 value 769.573788
#> iter   9 value 769.573778
#> iter   9 value 769.573773
#> final  value 769.573773 
#> converged
#> This is Run number  387 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1934979  0.5068392   0.6434979 -12.093161      1
#> 2     1  -0.95  -2.35 -0.3887606  0.7939239  -1.3387606  -1.556076      1
#> 3     1  -6.20  -2.30  1.4601304 -0.8008198  -4.7398696  -3.100820      2
#> 4     1 -13.90  -2.55  0.4544119  0.7148145 -13.4455881  -1.835186      2
#> 5     1 -14.40  -5.80  0.9843404  0.2833669 -13.4156596  -5.516633      2
#> 6     1  -3.60  -1.70 -0.5844084 -1.1428747  -4.1844084  -2.842875      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6660 -38875   6375 
#> initial  value 998.131940 
#> iter   2 value 814.618530
#> iter   3 value 804.447411
#> iter   4 value 803.156669
#> iter   5 value 767.082485
#> iter   6 value 758.499976
#> iter   7 value 756.995069
#> iter   8 value 756.959054
#> iter   9 value 756.958975
#> iter  10 value 756.958963
#> iter  10 value 756.958956
#> iter  10 value 756.958954
#> final  value 756.958954 
#> converged
#> This is Run number  388 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.36159854 -0.61719830   0.8115985 -13.2171983      1
#> 2     1  -0.95  -2.35 -0.06827419 -1.02220040  -1.0182742  -3.3722004      1
#> 3     1  -6.20  -2.30 -1.12219955 -0.95754697  -7.3221995  -3.2575470      2
#> 4     1 -13.90  -2.55 -0.72812885 -0.06459167 -14.6281289  -2.6145917      2
#> 5     1 -14.40  -5.80  0.71409152 -1.03773856 -13.6859085  -6.8377386      2
#> 6     1  -3.60  -1.70 -0.79821620  1.08541548  -4.3982162  -0.6145845      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6720 -39925   6150 
#> initial  value 998.131940 
#> iter   2 value 799.745642
#> iter   3 value 788.312436
#> iter   4 value 786.072679
#> iter   5 value 753.394435
#> iter   6 value 744.643204
#> iter   7 value 743.188895
#> iter   8 value 743.151675
#> iter   9 value 743.151591
#> iter   9 value 743.151581
#> iter   9 value 743.151574
#> final  value 743.151574 
#> converged
#> This is Run number  389 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.2616386  1.4979140   0.7116386 -11.1020860      1
#> 2     1  -0.95  -2.35  1.2850819 -0.1074828   0.3350819  -2.4574828      1
#> 3     1  -6.20  -2.30  1.0901391  0.6865399  -5.1098609  -1.6134601      2
#> 4     1 -13.90  -2.55 -0.6815610  1.5983537 -14.5815610  -0.9516463      2
#> 5     1 -14.40  -5.80 -0.7099566  0.0504715 -15.1099566  -5.7495285      2
#> 6     1  -3.60  -1.70  2.7168153  1.1040768  -0.8831847  -0.5959232      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -38950   7150 
#> initial  value 998.131940 
#> iter   2 value 809.511573
#> iter   3 value 796.974740
#> iter   4 value 795.840962
#> iter   5 value 760.079997
#> iter   6 value 751.495065
#> iter   7 value 750.168892
#> iter   8 value 750.140925
#> iter   9 value 750.140882
#> iter  10 value 750.140869
#> iter  10 value 750.140859
#> iter  10 value 750.140853
#> final  value 750.140853 
#> converged
#> This is Run number  390 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.0300587 -0.05836067   0.4800587 -12.6583607      1
#> 2     1  -0.95  -2.35 -0.6573730  1.95293425  -1.6073730  -0.3970657      2
#> 3     1  -6.20  -2.30  1.1908195  1.06384082  -5.0091805  -1.2361592      2
#> 4     1 -13.90  -2.55  0.6757082 -0.30707691 -13.2242918  -2.8570769      2
#> 5     1 -14.40  -5.80  1.3173434  0.29613831 -13.0826566  -5.5038617      2
#> 6     1  -3.60  -1.70 -0.6502400  0.72564662  -4.2502400  -0.9743534      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6840 -39375   6400 
#> initial  value 998.131940 
#> iter   2 value 806.835596
#> iter   3 value 796.471155
#> iter   4 value 795.313944
#> iter   5 value 760.665973
#> iter   6 value 751.992247
#> iter   7 value 750.512155
#> iter   8 value 750.475792
#> iter   9 value 750.475712
#> iter  10 value 750.475700
#> iter  10 value 750.475693
#> iter  10 value 750.475687
#> final  value 750.475687 
#> converged
#> This is Run number  391 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.1793078  0.0597127   0.6293078 -12.540287      1
#> 2     1  -0.95  -2.35  3.8157788  0.7884374   2.8657788  -1.561563      1
#> 3     1  -6.20  -2.30  1.6935533  0.8035916  -4.5064467  -1.496408      2
#> 4     1 -13.90  -2.55  2.4354232  0.3897652 -11.4645768  -2.160235      2
#> 5     1 -14.40  -5.80  1.9754951 -0.7870454 -12.4245049  -6.587045      2
#> 6     1  -3.60  -1.70 -0.8367366 -0.4017785  -4.4367366  -2.101778      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5700 -36925   6475 
#> initial  value 998.131940 
#> iter   2 value 841.964213
#> iter   3 value 831.073092
#> iter   4 value 828.757340
#> iter   5 value 787.527215
#> iter   6 value 779.419312
#> iter   7 value 777.984234
#> iter   8 value 777.955670
#> iter   9 value 777.955620
#> iter   9 value 777.955611
#> iter   9 value 777.955606
#> final  value 777.955606 
#> converged
#> This is Run number  392 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  1.98760318  0.5246833   1.437603 -12.075317      1
#> 2     1  -0.95  -2.35  2.50915485  0.2717297   1.559155  -2.078270      1
#> 3     1  -6.20  -2.30  1.15533925  0.6709925  -5.044661  -1.629008      2
#> 4     1 -13.90  -2.55 -0.32659327 -0.2357859 -14.226593  -2.785786      2
#> 5     1 -14.40  -5.80  1.64875434  1.5635779 -12.751246  -4.236422      2
#> 6     1  -3.60  -1.70 -0.03715614  0.6983324  -3.637156  -1.001668      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -39050   6950 
#> initial  value 998.131940 
#> iter   2 value 809.148236
#> iter   3 value 796.850569
#> iter   4 value 795.466566
#> iter   5 value 760.037556
#> iter   6 value 751.432168
#> iter   7 value 750.078961
#> iter   8 value 750.049374
#> iter   9 value 750.049325
#> iter  10 value 750.049313
#> iter  10 value 750.049304
#> iter  10 value 750.049298
#> final  value 750.049298 
#> converged
#> This is Run number  393 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.5609193  0.8057181   0.01091932 -11.794282      1
#> 2     1  -0.95  -2.35 -0.2319742 -0.2740095  -1.18197415  -2.624010      1
#> 3     1  -6.20  -2.30  2.6065732  0.3612030  -3.59342683  -1.938797      2
#> 4     1 -13.90  -2.55 -0.1184011 -0.3454797 -14.01840113  -2.895480      2
#> 5     1 -14.40  -5.80 -0.5362941  0.9843056 -14.93629406  -4.815694      2
#> 6     1  -3.60  -1.70 -0.5271261 -0.7200434  -4.12712612  -2.420043      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5900 -37575   5900 
#> initial  value 998.131940 
#> iter   2 value 835.910071
#> iter   3 value 825.124327
#> iter   4 value 822.340933
#> iter   5 value 782.985077
#> iter   6 value 774.678965
#> iter   7 value 773.122856
#> iter   8 value 773.088035
#> iter   9 value 773.087952
#> iter  10 value 773.087940
#> iter  10 value 773.087940
#> iter  10 value 773.087937
#> final  value 773.087937 
#> converged
#> This is Run number  394 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60  1.87306595  0.7340686   1.323066 -11.8659314      1
#> 2     1  -0.95  -2.35  3.55007143  1.5317993   2.600071  -0.8182007      1
#> 3     1  -6.20  -2.30  1.92309765 -0.6364091  -4.276902  -2.9364091      2
#> 4     1 -13.90  -2.55  0.73380606  1.9614065 -13.166194  -0.5885935      2
#> 5     1 -14.40  -5.80 -0.06800317  2.3975514 -14.468003  -3.4024486      2
#> 6     1  -3.60  -1.70  2.02615738  0.5378184  -1.573843  -1.1621816      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6420 -38350   6475 
#> initial  value 998.131940 
#> iter   2 value 821.954559
#> iter   3 value 811.576562
#> iter   4 value 810.124366
#> iter   5 value 772.601574
#> iter   6 value 764.129285
#> iter   7 value 762.643118
#> iter   8 value 762.609300
#> iter   9 value 762.609230
#> iter   9 value 762.609230
#> iter   9 value 762.609230
#> final  value 762.609230 
#> converged
#> This is Run number  395 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.5197825  0.2284862  -1.06978247 -12.3715138      1
#> 2     1  -0.95  -2.35  0.9222157 -0.1965568  -0.02778429  -2.5465568      1
#> 3     1  -6.20  -2.30  0.4212002  0.9388130  -5.77879980  -1.3611870      2
#> 4     1 -13.90  -2.55 -0.5108112  0.3571466 -14.41081125  -2.1928534      2
#> 5     1 -14.40  -5.80  0.5565217  0.1597867 -13.84347832  -5.6402133      2
#> 6     1  -3.60  -1.70  0.7062580  2.1187989  -2.89374204   0.4187989      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -39600   6375 
#> initial  value 998.131940 
#> iter   2 value 803.678521
#> iter   3 value 792.391759
#> iter   4 value 790.634522
#> iter   5 value 756.855822
#> iter   6 value 748.150599
#> iter   7 value 746.710049
#> iter   8 value 746.674721
#> iter   9 value 746.674648
#> iter   9 value 746.674637
#> iter   9 value 746.674630
#> final  value 746.674630 
#> converged
#> This is Run number  396 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.7716232 -0.07867748   0.2216232 -12.678677      1
#> 2     1  -0.95  -2.35  1.2084628  0.55151828   0.2584628  -1.798482      1
#> 3     1  -6.20  -2.30  1.2289188 -0.84870033  -4.9710812  -3.148700      2
#> 4     1 -13.90  -2.55  0.5936138  1.28716332 -13.3063862  -1.262837      2
#> 5     1 -14.40  -5.80  0.7854765  0.07561280 -13.6145235  -5.724387      2
#> 6     1  -3.60  -1.70 -0.8077821 -0.18979441  -4.4077821  -1.889794      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6320 -38550   5950 
#> initial  value 998.131940 
#> iter   2 value 821.700769
#> iter   3 value 811.158228
#> iter   4 value 808.737250
#> iter   5 value 772.053890
#> iter   6 value 763.530926
#> iter   7 value 761.959675
#> iter   8 value 761.921551
#> iter   9 value 761.921456
#> iter  10 value 761.921444
#> iter  10 value 761.921444
#> iter  10 value 761.921440
#> final  value 761.921440 
#> converged
#> This is Run number  397 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.09800931  0.07762348  -0.6480093 -12.5223765      1
#> 2     1  -0.95  -2.35 -0.71189947 -1.03019867  -1.6618995  -3.3801987      1
#> 3     1  -6.20  -2.30 -0.42530173  0.32014262  -6.6253017  -1.9798574      2
#> 4     1 -13.90  -2.55  1.41832048  1.19219493 -12.4816795  -1.3578051      2
#> 5     1 -14.40  -5.80  0.05305799  0.86979775 -14.3469420  -4.9302023      2
#> 6     1  -3.60  -1.70 -0.51863770  2.55608217  -4.1186377   0.8560822      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6700 -37325   5775 
#> initial  value 998.131940 
#> iter   2 value 839.352210
#> iter   3 value 832.595632
#> iter   4 value 831.896448
#> iter   5 value 791.251158
#> iter   6 value 783.120603
#> iter   7 value 781.427220
#> iter   8 value 781.388647
#> iter   9 value 781.388543
#> iter   9 value 781.388532
#> iter   9 value 781.388527
#> final  value 781.388527 
#> converged
#> This is Run number  398 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2          e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -0.55 -12.60 -0.005288403  2.1169402  -0.5552884 -10.4830598      1
#> 2     1  -0.95  -2.35 -0.472443097  1.5677220  -1.4224431  -0.7822780      2
#> 3     1  -6.20  -2.30  1.991515053  1.9780401  -4.2084849  -0.3219599      2
#> 4     1 -13.90  -2.55  0.630065536 -0.7929014 -13.2699345  -3.3429014      2
#> 5     1 -14.40  -5.80  0.060043352 -0.5819580 -14.3399566  -6.3819580      2
#> 6     1  -3.60  -1.70  1.788968914  0.2464999  -1.8110311  -1.4535001      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6480 -38100   6650 
#> initial  value 998.131940 
#> iter   2 value 824.558933
#> iter   3 value 814.553368
#> iter   4 value 813.575052
#> iter   5 value 775.206284
#> iter   6 value 766.789392
#> iter   7 value 765.316547
#> iter   8 value 765.283844
#> iter   9 value 765.283777
#> iter  10 value 765.283763
#> iter  10 value 765.283753
#> iter  10 value 765.283747
#> final  value 765.283747 
#> converged
#> This is Run number  399 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.04688664 -1.2120014  -0.5031134 -13.812001      1
#> 2     1  -0.95  -2.35 -0.13104231  1.0593395  -1.0810423  -1.290660      1
#> 3     1  -6.20  -2.30 -0.32275209 -0.4262292  -6.5227521  -2.726229      2
#> 4     1 -13.90  -2.55  0.20126180 -0.2126988 -13.6987382  -2.762699      2
#> 5     1 -14.40  -5.80  0.50840447 -0.2068077 -13.8915955  -6.006808      2
#> 6     1  -3.60  -1.70 -1.41150988 -1.3783189  -5.0115099  -3.078319      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6180 -39400   7425 
#> initial  value 998.131940 
#> iter   2 value 801.363611
#> iter   3 value 785.961565
#> iter   4 value 783.821350
#> iter   5 value 749.788339
#> iter   6 value 741.201845
#> iter   7 value 739.985822
#> iter   8 value 739.962368
#> iter   9 value 739.962345
#> iter   9 value 739.962336
#> iter   9 value 739.962330
#> final  value 739.962330 
#> converged
#> This is Run number  400 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1                7      80      25     100      60     200     100     1
#> 2  1               19      20      25      50      60      25       0     1
#> 3  1               30      20     100      50      80      50     100     1
#> 4  1               32      40     200      25      80      25       0     1
#> 5  1               39      40     200       0      80     100     100     1
#> 6  1               48      60      50      25      20      50     100     1
#>   group    V_1    V_2        e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -0.55 -12.60  0.2217718  0.20697389  -0.32822816 -12.393026      1
#> 2     1  -0.95  -2.35  1.0128797 -1.03146229   0.06287967  -3.381462      1
#> 3     1  -6.20  -2.30  0.8820241 -1.11248262  -5.31797587  -3.412483      2
#> 4     1 -13.90  -2.55  1.8566836 -0.79412064 -12.04331641  -3.344121      2
#> 5     1 -14.40  -5.80 -0.7138804 -0.27749917 -15.11388043  -6.077499      2
#> 6     1  -3.60  -1.70  3.4019058  0.01002359  -0.19809417  -1.689976      1
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6200 -38975   6950 
#> initial  value 998.131940 
#> iter   2 value 810.452373
#> iter   3 value 797.032710
#> iter   4 value 794.853280
#> iter   5 value 759.452026
#> iter   6 value 750.870833
#> iter   7 value 749.542047
#> iter   8 value 749.513770
#> iter   9 value 749.513728
#> iter   9 value 749.513718
#> iter   9 value 749.513712
#> final  value 749.513712 
#> converged
#> 
#> 
#> ================  ====  ===  =====  ====  ======  =====  =====  =====  =====  ========  ====
#> \                 vars    n   mean    sd  median    min    max  range   skew  kurtosis    se
#> ================  ====  ===  =====  ====  ======  =====  =====  =====  =====  ========  ====
#> est_bpreis           1  400  -0.01  0.00   -0.01  -0.01   0.00   0.01   0.14     -0.09  0.00
#> est_blade            2  400  -0.01  0.00   -0.01  -0.02  -0.01   0.00  -0.01      0.00  0.00
#> est_bwarte           3  400   0.01  0.00    0.01   0.00   0.01   0.01   0.12     -0.21  0.00
#> rob_pval0_bpreis     4  400   0.08  0.14    0.03   0.00   0.89   0.89   3.12     11.56  0.01
#> rob_pval0_blade      5  400   0.00  0.00    0.00   0.00   0.00   0.00    NaN       NaN  0.00
#> rob_pval0_bwarte     6  400   0.00  0.00    0.00   0.00   0.02   0.02  12.43    157.23  0.00
#> ================  ====  ===  =====  ====  ======  =====  =====  =====  =====  ========  ====
#> 
#> FALSE  TRUE 
#>  39.5  60.5
#> 'simple' is deprecated and will be removed in the future. Use 'exact' instead.
#> bcoeff_lookup already exists; skipping modification.
#> Utility function used in simulation, ie the true utility: 
#> 
#> $u1
#> $u1$v1
#> V.1 ~ bpreis * alt1.x1 + blade * alt1.x2 + bwarte * alt1.x3
#> <environment: 0x5cc5fa59c340>
#> 
#> $u1$v2
#> V.2 ~ bpreis * alt2.x1 + blade * alt2.x2 + bwarte * alt2.x3
#> <environment: 0x5cc5ff73c3f8>
#> 
#> 
#> $u2
#> $u2$v1
#> V.1 ~ bpreis * alt1.x1
#> <environment: 0x5cc5fa47aac8>
#> 
#> $u2$v2
#> V.2 ~ bpreis * alt2.x1
#> <environment: 0x5cc602342058>
#> 'destype' is deprecated. Please use 'designtype' instead.
#> New names:
#>  
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  3.4067198  2.2592227   1.0567198  -9.9407773      1
#> 2     1  -6.20  -3.90  0.3349690 -0.8642693  -5.8650310  -4.7642693      2
#> 3     1 -14.20  -5.80  1.3866982  1.1314531 -12.8133018  -4.6685469      2
#> 4     1  -2.10 -13.20  0.4485455  0.1741001  -1.6514545 -13.0258999      1
#> 5     1  -1.70  -4.30  0.9047444  0.7390266  -0.7952556  -3.5609734      1
#> 6     1  -6.90  -1.55 -1.0202728  1.2444422  -7.9202728  -0.3055578      2
#> 
#>  
#>  Transformed utility function (type: simple ):
#> [1] "U_1 = @bpreis * $alt1_x1 + @blade * $alt1_x2 + @bwarte * $alt1_x3 ;U_2 = @bpreis * $alt2_x1 + @blade * $alt2_x2 + @bwarte * $alt2_x3 ;"
#> This is Run number  1 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.7319505  0.11444472  -3.0819505 -12.085555      1
#> 2     1  -6.20  -3.90  1.4362204  0.42102585  -4.7637796  -3.478974      2
#> 3     1 -14.20  -5.80  0.6587789  1.32408012 -13.5412211  -4.475920      2
#> 4     1  -2.10 -13.20  2.7182567  0.10518714   0.6182567 -13.094813      1
#> 5     1  -1.70  -4.30 -0.9148015 -0.52089662  -2.6148015  -4.820897      1
#> 6     1  -6.90  -1.55 -1.0560936 -0.01388186  -7.9560936  -1.563882      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4720 -38550   7325 
#> initial  value 998.131940 
#> iter   2 value 825.310412
#> iter   3 value 821.153371
#> iter   4 value 816.651404
#> iter   5 value 770.388073
#> iter   6 value 760.396657
#> iter   7 value 758.911258
#> iter   8 value 758.884143
#> iter   9 value 758.884012
#> iter  10 value 758.883964
#> iter  10 value 758.883961
#> iter  10 value 758.883954
#> final  value 758.883954 
#> converged
#> This is Run number  2 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.2295296 -0.8751128  -3.5795296 -13.075113      1
#> 2     1  -6.20  -3.90  0.1574216  1.1650507  -6.0425784  -2.734949      2
#> 3     1 -14.20  -5.80  0.5427261  0.5174867 -13.6572739  -5.282513      2
#> 4     1  -2.10 -13.20 -0.2517136  3.6272465  -2.3517136  -9.572754      1
#> 5     1  -1.70  -4.30  0.8085399 -0.6735272  -0.8914601  -4.973527      1
#> 6     1  -6.90  -1.55 -0.5439133 -0.8040005  -7.4439133  -2.354000      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4280 -37750   7575 
#> initial  value 998.131940 
#> iter   2 value 834.994815
#> iter   3 value 830.862279
#> iter   4 value 825.857090
#> iter   5 value 776.264858
#> iter   6 value 766.555380
#> iter   7 value 765.023705
#> iter   8 value 764.998426
#> iter   9 value 764.998337
#> iter  10 value 764.998279
#> iter  10 value 764.998279
#> iter  10 value 764.998275
#> final  value 764.998275 
#> converged
#> This is Run number  3 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.7322418  3.6273303  -3.0822418  -8.572670      1
#> 2     1  -6.20  -3.90  2.5280089  0.9755771  -3.6719911  -2.924423      2
#> 3     1 -14.20  -5.80 -0.3422426  1.1968711 -14.5422426  -4.603129      2
#> 4     1  -2.10 -13.20 -1.2580096  0.2338313  -3.3580096 -12.966169      1
#> 5     1  -1.70  -4.30  1.1329713  0.1901108  -0.5670287  -4.109889      1
#> 6     1  -6.90  -1.55 -0.6143258 -0.3320346  -7.5143258  -1.882035      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3980 -35800   9850 
#> initial  value 998.131940 
#> iter   2 value 845.231568
#> iter   3 value 824.696946
#> iter   4 value 824.248186
#> iter   5 value 783.361872
#> iter   6 value 776.267336
#> iter   7 value 775.643166
#> iter   8 value 775.621372
#> iter   9 value 775.621110
#> iter  10 value 775.620878
#> iter  11 value 775.620621
#> iter  12 value 775.620511
#> iter  12 value 775.620511
#> iter  12 value 775.620511
#> final  value 775.620511 
#> converged
#> This is Run number  4 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.1297209 0.52518522  -3.4797209 -11.674815      1
#> 2     1  -6.20  -3.90  2.4520130 1.04414498  -3.7479870  -2.855855      2
#> 3     1 -14.20  -5.80  2.4018497 0.92780739 -11.7981503  -4.872193      2
#> 4     1  -2.10 -13.20  1.5132752 0.59761188  -0.5867248 -12.602388      1
#> 5     1  -1.70  -4.30  1.4571803 0.07054883  -0.2428197  -4.229451      1
#> 6     1  -6.90  -1.55 -0.1447297 3.01532050  -7.0447297   1.465321      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4740 -37775   7100 
#> initial  value 998.131940 
#> iter   2 value 837.590811
#> iter   3 value 834.923861
#> iter   4 value 831.190558
#> iter   5 value 782.541478
#> iter   6 value 772.727586
#> iter   7 value 771.203023
#> iter   8 value 771.173745
#> iter   9 value 771.173710
#> iter  10 value 771.173539
#> iter  10 value 771.173539
#> iter  11 value 771.173507
#> iter  12 value 771.173490
#> iter  12 value 771.173489
#> iter  12 value 771.173486
#> final  value 771.173486 
#> converged
#> This is Run number  5 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.7052337 -0.01113643  -1.644766 -12.211136      1
#> 2     1  -6.20  -3.90 -0.9929875  1.54859296  -7.192987  -2.351407      2
#> 3     1 -14.20  -5.80 -0.8621834  3.35798866 -15.062183  -2.442011      2
#> 4     1  -2.10 -13.20  0.3661770  1.04306171  -1.733823 -12.156938      1
#> 5     1  -1.70  -4.30 -0.2749495  0.49903110  -1.974949  -3.800969      1
#> 6     1  -6.90  -1.55  1.9017416  0.20376958  -4.998258  -1.346230      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4880 -38025   7525 
#> initial  value 998.131940 
#> iter   2 value 831.778853
#> iter   3 value 830.002808
#> iter   4 value 827.116558
#> iter   5 value 778.357684
#> iter   6 value 768.524369
#> iter   7 value 767.041356
#> iter   8 value 767.013562
#> iter   9 value 767.013261
#> iter  10 value 767.013063
#> iter  10 value 767.013062
#> iter  11 value 767.013045
#> iter  12 value 767.013001
#> iter  12 value 767.013001
#> iter  12 value 767.012999
#> final  value 767.012999 
#> converged
#> This is Run number  6 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.05385395 -0.6374426  -2.403854 -12.837443      1
#> 2     1  -6.20  -3.90 -0.03725587 -0.4194024  -6.237256  -4.319402      2
#> 3     1 -14.20  -5.80  1.81374075 -0.9260723 -12.386259  -6.726072      2
#> 4     1  -2.10 -13.20 -0.50216610  0.2567539  -2.602166 -12.943246      1
#> 5     1  -1.70  -4.30  0.53083692  0.2043818  -1.169163  -4.095618      1
#> 6     1  -6.90  -1.55  0.39289697  4.4403211  -6.507103   2.890321      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4680 -36175   8200 
#> initial  value 998.131940 
#> iter   2 value 852.431655
#> iter   3 value 838.279037
#> iter   4 value 837.676018
#> iter   5 value 795.711241
#> iter   6 value 787.815682
#> iter   7 value 786.665519
#> iter   8 value 786.628507
#> iter   9 value 786.627917
#> iter  10 value 786.627731
#> iter  11 value 786.627493
#> iter  12 value 786.627347
#> iter  12 value 786.627347
#> iter  12 value 786.627347
#> final  value 786.627347 
#> converged
#> This is Run number  7 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.2145506 -0.9101014  -2.135449 -13.1101014      1
#> 2     1  -6.20  -3.90  0.5533264  1.9511195  -5.646674  -1.9488805      2
#> 3     1 -14.20  -5.80 -1.1585438  0.6832981 -15.358544  -5.1167019      2
#> 4     1  -2.10 -13.20 -0.6593329  0.2395157  -2.759333 -12.9604843      1
#> 5     1  -1.70  -4.30 -0.3714403 -0.1176897  -2.071440  -4.4176897      1
#> 6     1  -6.90  -1.55  0.5245958  1.2349465  -6.375404  -0.3150535      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3880 -37175   7875 
#> initial  value 998.131940 
#> iter   2 value 840.717972
#> iter   3 value 836.460799
#> iter   4 value 830.879941
#> iter   5 value 778.615877
#> iter   6 value 769.152550
#> iter   7 value 767.574797
#> iter   8 value 767.551216
#> iter   8 value 767.551216
#> final  value 767.551216 
#> converged
#> This is Run number  8 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2892283  0.7829595  -2.639228 -11.417040      1
#> 2     1  -6.20  -3.90  0.9495775 -0.9723260  -5.250423  -4.872326      2
#> 3     1 -14.20  -5.80  0.1064353  2.1516768 -14.093565  -3.648323      2
#> 4     1  -2.10 -13.20  0.5013370  2.0012226  -1.598663 -11.198777      1
#> 5     1  -1.70  -4.30  0.1789177  0.9749531  -1.521082  -3.325047      1
#> 6     1  -6.90  -1.55  1.2743899  1.7829220  -5.625610   0.232922      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4260 -37125   7300 
#> initial  value 998.131940 
#> iter   2 value 845.078792
#> iter   3 value 841.817304
#> iter   4 value 837.254910
#> iter   5 value 785.962000
#> iter   6 value 776.408451
#> iter   7 value 774.862606
#> iter   8 value 774.836293
#> iter   9 value 774.836222
#> iter  10 value 774.836169
#> iter  10 value 774.836168
#> iter  10 value 774.836160
#> final  value 774.836160 
#> converged
#> This is Run number  9 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.6909745  1.0868451  -3.040974 -11.1131549      1
#> 2     1  -6.20  -3.90  0.1503257  3.1449802  -6.049674  -0.7550198      2
#> 3     1 -14.20  -5.80 -0.9296206 -0.4196626 -15.129621  -6.2196626      2
#> 4     1  -2.10 -13.20  0.1293581  2.2839048  -1.970642 -10.9160952      1
#> 5     1  -1.70  -4.30 -0.3476424  1.2378285  -2.047642  -3.0621715      1
#> 6     1  -6.90  -1.55  0.7593131 -0.4419187  -6.140687  -1.9919187      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3920 -35800   9050 
#> initial  value 998.131940 
#> iter   2 value 851.001999
#> iter   3 value 832.983518
#> iter   4 value 831.764257
#> iter   5 value 789.120672
#> iter   6 value 781.686178
#> iter   7 value 780.796413
#> iter   8 value 780.764223
#> iter   9 value 780.763688
#> iter  10 value 780.763551
#> iter  11 value 780.763385
#> iter  12 value 780.763273
#> iter  12 value 780.763273
#> iter  12 value 780.763273
#> final  value 780.763273 
#> converged
#> This is Run number  10 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2878232  0.21470560  -2.637823 -11.985294      1
#> 2     1  -6.20  -3.90  0.1954157  1.81243376  -6.004584  -2.087566      2
#> 3     1 -14.20  -5.80 -0.5789778  0.40708226 -14.778978  -5.392918      2
#> 4     1  -2.10 -13.20  4.2857778 -0.36017762   2.185778 -13.560178      1
#> 5     1  -1.70  -4.30 -0.2196795  1.76443561  -1.919679  -2.535564      1
#> 6     1  -6.90  -1.55  0.4892240 -0.06706601  -6.410776  -1.617066      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4380 -37275   9275 
#> initial  value 998.131940 
#> iter   2 value 830.624563
#> iter   3 value 812.196231
#> iter   4 value 811.384449
#> iter   5 value 771.887319
#> iter   6 value 764.075665
#> iter   7 value 763.246978
#> iter   8 value 763.209214
#> iter   9 value 763.208609
#> iter  10 value 763.208327
#> iter  11 value 763.208033
#> iter  12 value 763.207960
#> iter  12 value 763.207960
#> iter  12 value 763.207960
#> final  value 763.207960 
#> converged
#> This is Run number  11 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.3936919 -0.2443918  -1.956308 -12.444392      1
#> 2     1  -6.20  -3.90 -0.2718327  0.0466080  -6.471833  -3.853392      2
#> 3     1 -14.20  -5.80 -1.2377716  1.1402276 -15.437772  -4.659772      2
#> 4     1  -2.10 -13.20  4.3819161 -1.0371597   2.281916 -14.237160      1
#> 5     1  -1.70  -4.30  0.6550745 -0.3523469  -1.044925  -4.652347      1
#> 6     1  -6.90  -1.55  0.3616460  0.2859499  -6.538354  -1.264050      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4200 -38250   8450 
#> initial  value 998.131940 
#> iter   2 value 822.511961
#> iter   3 value 818.363656
#> iter   4 value 813.532954
#> iter   5 value 763.923355
#> iter   6 value 754.322033
#> iter   7 value 752.769627
#> iter   8 value 752.746351
#> iter   9 value 752.746276
#> iter  10 value 752.746118
#> iter  10 value 752.746115
#> iter  10 value 752.746107
#> final  value 752.746107 
#> converged
#> This is Run number  12 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  2.1565560  4.2978838  -0.1934440  -7.9021162      1
#> 2     1  -6.20  -3.90  0.7194092  2.1767754  -5.4805908  -1.7232246      2
#> 3     1 -14.20  -5.80  2.1606670 -0.5126003 -12.0393330  -6.3126003      2
#> 4     1  -2.10 -13.20 -1.1897251  1.7594412  -3.2897251 -11.4405588      1
#> 5     1  -1.70  -4.30  1.0239231  0.6546142  -0.6760769  -3.6453858      1
#> 6     1  -6.90  -1.55 -1.1935798  0.6107404  -8.0935798  -0.9392596      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4440 -37700   8225 
#> initial  value 998.131940 
#> iter   2 value 831.903199
#> iter   3 value 830.115835
#> iter   4 value 826.780464
#> iter   5 value 775.391236
#> iter   6 value 765.828773
#> iter   7 value 764.307418
#> iter   8 value 764.283799
#> iter   9 value 764.283629
#> iter  10 value 764.283507
#> iter  10 value 764.283503
#> iter  11 value 764.283458
#> iter  12 value 764.283374
#> iter  12 value 764.283368
#> iter  12 value 764.283368
#> final  value 764.283368 
#> converged
#> This is Run number  13 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.4740991  2.02404962  -2.824099 -10.175950      1
#> 2     1  -6.20  -3.90  1.5845029  0.28002640  -4.615497  -3.619974      2
#> 3     1 -14.20  -5.80  1.2377882 -0.70639653 -12.962212  -6.506397      2
#> 4     1  -2.10 -13.20 -0.4920876  0.49082851  -2.592088 -12.709171      1
#> 5     1  -1.70  -4.30 -0.4617310  0.04827574  -2.161731  -4.251724      1
#> 6     1  -6.90  -1.55  0.8715223 -1.29838773  -6.028478  -2.848388      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4700 -38850   8950 
#> initial  value 998.131940 
#> iter   2 value 810.750095
#> iter   3 value 808.118962
#> iter   4 value 805.642437
#> iter   5 value 756.871744
#> iter   6 value 747.251102
#> iter   7 value 745.713749
#> iter   8 value 745.690615
#> iter   9 value 745.690413
#> iter  10 value 745.690210
#> iter  10 value 745.690205
#> iter  11 value 745.690171
#> iter  12 value 745.690157
#> iter  12 value 745.690154
#> iter  13 value 745.690139
#> iter  14 value 745.690127
#> iter  14 value 745.690125
#> iter  14 value 745.690125
#> final  value 745.690125 
#> converged
#> This is Run number  14 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 0.42455157  0.1152696  -1.9254484 -12.0847304      1
#> 2     1  -6.20  -3.90 0.08346348  0.8884457  -6.1165365  -3.0115543      2
#> 3     1 -14.20  -5.80 1.20013917 -0.4530278 -12.9998608  -6.2530278      2
#> 4     1  -2.10 -13.20 1.98972840  1.0847762  -0.1102716 -12.1152238      1
#> 5     1  -1.70  -4.30 0.11247627  0.5792154  -1.5875237  -3.7207846      1
#> 6     1  -6.90  -1.55 1.57090220  2.2902244  -5.3290978   0.7402244      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -37350   8125 
#> initial  value 998.131940 
#> iter   2 value 837.328108
#> iter   3 value 836.166848
#> iter   4 value 833.010943
#> iter   5 value 780.564460
#> iter   6 value 771.081929
#> iter   7 value 769.561564
#> iter   8 value 769.537529
#> iter   9 value 769.537244
#> iter  10 value 769.537120
#> iter  10 value 769.537111
#> iter  10 value 769.537100
#> final  value 769.537100 
#> converged
#> This is Run number  15 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.1918681  3.4090631  -2.1581319  -8.790937      1
#> 2     1  -6.20  -3.90 -0.2645194  0.3125024  -6.4645194  -3.587498      2
#> 3     1 -14.20  -5.80  0.4719808  2.2698821 -13.7280192  -3.530118      2
#> 4     1  -2.10 -13.20 -1.0987583  0.1187937  -3.1987583 -13.081206      1
#> 5     1  -1.70  -4.30  1.8079772  0.7633315   0.1079772  -3.536669      1
#> 6     1  -6.90  -1.55  2.1257787 -0.5221384  -4.7742213  -2.072138      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5040 -38075   8325 
#> initial  value 998.131940 
#> iter   2 value 826.242674
#> iter   3 value 826.003131
#> iter   4 value 824.636608
#> iter   5 value 774.324871
#> iter   6 value 764.580289
#> iter   7 value 763.074809
#> iter   8 value 763.049968
#> iter   9 value 763.049748
#> iter  10 value 763.049634
#> iter  11 value 763.049606
#> iter  12 value 763.049274
#> iter  12 value 763.049274
#> iter  12 value 763.049274
#> final  value 763.049274 
#> converged
#> This is Run number  16 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.2651461 -0.4113575  -1.084854 -12.6113575      1
#> 2     1  -6.20  -3.90  1.3529913  1.5229075  -4.847009  -2.3770925      2
#> 3     1 -14.20  -5.80  0.3084988  0.5483560 -13.891501  -5.2516440      2
#> 4     1  -2.10 -13.20  0.5304605 -0.1648219  -1.569540 -13.3648219      1
#> 5     1  -1.70  -4.30 -0.2476335  0.8715403  -1.947633  -3.4284597      1
#> 6     1  -6.90  -1.55  0.9365203  0.5906034  -5.963480  -0.9593966      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4680 -36300   7650 
#> initial  value 998.131940 
#> iter   2 value 854.173206
#> iter   3 value 841.432938
#> iter   4 value 840.281623
#> iter   5 value 797.653485
#> iter   6 value 789.628204
#> iter   7 value 788.153963
#> iter   8 value 788.102437
#> iter   9 value 788.101627
#> iter  10 value 788.101449
#> iter  11 value 788.101237
#> iter  12 value 788.101099
#> iter  12 value 788.101099
#> iter  12 value 788.101099
#> final  value 788.101099 
#> converged
#> This is Run number  17 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 6.1638485  0.4776054   3.8138485 -11.722395      1
#> 2     1  -6.20  -3.90 1.2891821 -0.9421834  -4.9108179  -4.842183      2
#> 3     1 -14.20  -5.80 0.8159298  0.2965880 -13.3840702  -5.503412      2
#> 4     1  -2.10 -13.20 0.4088749  1.7626748  -1.6911251 -11.437325      1
#> 5     1  -1.70  -4.30 1.8168295  0.1880587   0.1168295  -4.111941      1
#> 6     1  -6.90  -1.55 1.8250701  0.3183898  -5.0749299  -1.231610      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5020 -37950   7550 
#> initial  value 998.131940 
#> iter   2 value 832.727257
#> iter   3 value 831.725068
#> iter   4 value 829.475310
#> iter   5 value 780.350914
#> iter   6 value 770.524082
#> iter   7 value 769.038864
#> iter   8 value 769.009817
#> iter   9 value 769.009538
#> iter  10 value 769.009427
#> iter  11 value 769.009414
#> iter  12 value 769.009110
#> iter  12 value 769.009110
#> iter  12 value 769.009110
#> final  value 769.009110 
#> converged
#> This is Run number  18 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.1713109  0.2794148  -3.521311 -11.920585      1
#> 2     1  -6.20  -3.90  0.2835647  1.1816846  -5.916435  -2.718315      2
#> 3     1 -14.20  -5.80  1.0865846  0.1951784 -13.113415  -5.604822      2
#> 4     1  -2.10 -13.20 -0.3939160 -0.3043081  -2.493916 -13.504308      1
#> 5     1  -1.70  -4.30 -0.1644935 -1.0311772  -1.864494  -5.331177      1
#> 6     1  -6.90  -1.55  3.4643930  4.2741223  -3.435607   2.724122      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4020 -35600   8675 
#> initial  value 998.131940 
#> iter   2 value 856.112219
#> iter   3 value 839.539953
#> iter   4 value 838.313043
#> iter   5 value 795.027697
#> iter   6 value 787.528633
#> iter   7 value 786.523255
#> iter   8 value 786.489326
#> iter   9 value 786.488773
#> iter  10 value 786.488629
#> iter  11 value 786.488467
#> iter  12 value 786.488360
#> iter  12 value 786.488360
#> iter  12 value 786.488360
#> final  value 786.488360 
#> converged
#> This is Run number  19 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.37400935 -0.7450607  -3.724009 -12.945061      1
#> 2     1  -6.20  -3.90 -0.08352759  1.0874457  -6.283528  -2.812554      2
#> 3     1 -14.20  -5.80  1.40145401 -0.1174018 -12.798546  -5.917402      2
#> 4     1  -2.10 -13.20 -1.51563727  1.3599491  -3.615637 -11.840051      1
#> 5     1  -1.70  -4.30  0.44860060  0.3905686  -1.251399  -3.909431      1
#> 6     1  -6.90  -1.55  0.27158974 -0.6420536  -6.628410  -2.192054      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5260 -40225   8050 
#> initial  value 998.131940 
#> iter   2 value 795.676754
#> iter   3 value 791.303413
#> iter   4 value 788.323962
#> iter   5 value 746.513628
#> iter   6 value 736.518658
#> iter   7 value 735.141203
#> iter   8 value 735.117266
#> iter   9 value 735.117056
#> iter  10 value 735.116628
#> iter  11 value 735.116609
#> iter  12 value 735.116474
#> iter  12 value 735.116474
#> iter  12 value 735.116474
#> final  value 735.116474 
#> converged
#> This is Run number  20 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2144009 -0.86481610  -2.564401 -13.064816      1
#> 2     1  -6.20  -3.90 -1.3853106 -1.65350286  -7.585311  -5.553503      2
#> 3     1 -14.20  -5.80  0.1451558 -0.52504721 -14.054844  -6.325047      2
#> 4     1  -2.10 -13.20  0.8084614 -0.03173075  -1.291539 -13.231731      1
#> 5     1  -1.70  -4.30  0.6589040 -0.11177173  -1.041096  -4.411772      1
#> 6     1  -6.90  -1.55 -0.6975627  0.45258704  -7.597563  -1.097413      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4780 -36250   7250 
#> initial  value 998.131940 
#> iter   2 value 857.111653
#> iter   3 value 845.559907
#> iter   4 value 844.274380
#> iter   5 value 801.199265
#> iter   6 value 793.157004
#> iter   7 value 791.458031
#> iter   8 value 791.398462
#> iter   9 value 791.397571
#> iter  10 value 791.397401
#> iter  11 value 791.397189
#> iter  12 value 791.397055
#> iter  12 value 791.397055
#> iter  12 value 791.397055
#> final  value 791.397055 
#> converged
#> This is Run number  21 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.3703675  1.1503162   0.02036752 -11.049684      1
#> 2     1  -6.20  -3.90  1.4733011  1.4447841  -4.72669887  -2.455216      2
#> 3     1 -14.20  -5.80  0.7403851 -0.5302634 -13.45961492  -6.330263      2
#> 4     1  -2.10 -13.20 -0.4780235  6.3332672  -2.57802349  -6.866733      1
#> 5     1  -1.70  -4.30 -0.8151027 -1.4223288  -2.51510272  -5.722329      1
#> 6     1  -6.90  -1.55  2.0824132  0.1129708  -4.81758677  -1.437029      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4580 -36925   8150 
#> initial  value 998.131940 
#> iter   2 value 842.977619
#> iter   3 value 828.454046
#> iter   4 value 827.179798
#> iter   5 value 785.975479
#> iter   6 value 777.816126
#> iter   7 value 776.551710
#> iter   8 value 776.502040
#> iter   9 value 776.501156
#> iter  10 value 776.500984
#> iter  11 value 776.500800
#> iter  12 value 776.500657
#> iter  12 value 776.500657
#> iter  12 value 776.500657
#> final  value 776.500657 
#> converged
#> This is Run number  22 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1       e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 0.6900697 1.0958959  -1.659930 -11.104104      1
#> 2     1  -6.20  -3.90 1.1771276 5.0803128  -5.022872   1.180313      2
#> 3     1 -14.20  -5.80 1.5275729 3.5040715 -12.672427  -2.295928      2
#> 4     1  -2.10 -13.20 0.7674494 3.1030246  -1.332551 -10.096975      1
#> 5     1  -1.70  -4.30 0.4678916 2.6639779  -1.232108  -1.636022      1
#> 6     1  -6.90  -1.55 3.8644370 0.2558699  -3.035563  -1.294130      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4640 -36125   8275 
#> initial  value 998.131940 
#> iter   2 value 852.575541
#> iter   3 value 838.159059
#> iter   4 value 837.565116
#> iter   5 value 795.577382
#> iter   6 value 787.719425
#> iter   7 value 786.603611
#> iter   8 value 786.567932
#> iter   9 value 786.567363
#> iter  10 value 786.567180
#> iter  11 value 786.566944
#> iter  12 value 786.566801
#> iter  12 value 786.566801
#> iter  12 value 786.566801
#> final  value 786.566801 
#> converged
#> This is Run number  23 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  3.0696373  0.1139559   0.71963728 -12.0860441      1
#> 2     1  -6.20  -3.90  1.0380117  0.2643139  -5.16198826  -3.6356861      2
#> 3     1 -14.20  -5.80  1.7228809 -1.4468334 -12.47711905  -7.2468334      2
#> 4     1  -2.10 -13.20 -0.8658669  1.3431095  -2.96586694 -11.8568905      1
#> 5     1  -1.70  -4.30  1.6014845 -0.7574144  -0.09851551  -5.0574144      1
#> 6     1  -6.90  -1.55  0.4443535  1.3386907  -6.45564646  -0.2113093      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4920 -36525   7425 
#> initial  value 998.131940 
#> iter   2 value 852.647158
#> iter   3 value 840.822601
#> iter   4 value 839.848203
#> iter   5 value 797.714440
#> iter   6 value 789.572769
#> iter   7 value 787.985914
#> iter   8 value 787.930145
#> iter   9 value 787.929278
#> iter  10 value 787.929083
#> iter  11 value 787.928838
#> iter  12 value 787.928683
#> iter  12 value 787.928683
#> iter  12 value 787.928683
#> final  value 787.928683 
#> converged
#> This is Run number  24 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.5480181 -0.67530780  -1.801982 -12.8753078      1
#> 2     1  -6.20  -3.90 -1.0115325  0.78782907  -7.211533  -3.1121709      2
#> 3     1 -14.20  -5.80 -0.9401809 -0.05642427 -15.140181  -5.8564243      2
#> 4     1  -2.10 -13.20  0.5216900  2.68799285  -1.578310 -10.5120072      1
#> 5     1  -1.70  -4.30  0.2058140  0.81199836  -1.494186  -3.4880016      1
#> 6     1  -6.90  -1.55  0.4105592  1.16010664  -6.489441  -0.3898934      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3080 -36275  10075 
#> initial  value 998.131940 
#> iter   2 value 836.322535
#> iter   3 value 812.585895
#> iter   4 value 809.787675
#> iter   5 value 766.755092
#> iter   6 value 759.803512
#> iter   7 value 759.018700
#> iter   8 value 758.977637
#> iter   9 value 758.977188
#> iter  10 value 758.977159
#> iter  11 value 758.977123
#> iter  12 value 758.977079
#> iter  12 value 758.977079
#> iter  12 value 758.977079
#> final  value 758.977079 
#> converged
#> This is Run number  25 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.3893017  1.9209584 -2.7393017 -10.279042      1
#> 2     1  -6.20  -3.90  1.2374886 -0.7597671 -4.9625114  -4.659767      2
#> 3     1 -14.20  -5.80  4.4373183 -0.1483760 -9.7626817  -5.948376      2
#> 4     1  -2.10 -13.20  0.2997054  0.4157365 -1.8002946 -12.784263      1
#> 5     1  -1.70  -4.30  0.9823897  1.3023428 -0.7176103  -2.997657      1
#> 6     1  -6.90  -1.55 -1.5504738 -0.3523872 -8.4504738  -1.902387      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4040 -37375   8550 
#> initial  value 998.131940 
#> iter   2 value 833.958960
#> iter   3 value 831.711247
#> iter   4 value 827.450521
#> iter   5 value 774.246051
#> iter   6 value 764.880122
#> iter   7 value 763.297352
#> iter   8 value 763.274864
#> iter   9 value 763.274804
#> iter  10 value 763.274618
#> iter  10 value 763.274615
#> iter  10 value 763.274606
#> final  value 763.274606 
#> converged
#> This is Run number  26 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2          e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.007008881  1.4549374  -2.357009 -10.745063      1
#> 2     1  -6.20  -3.90  1.374385934  0.9222580  -4.825614  -2.977742      2
#> 3     1 -14.20  -5.80 -0.567117601 -0.6089608 -14.767118  -6.408961      2
#> 4     1  -2.10 -13.20  1.012107501  0.5314781  -1.087892 -12.668522      1
#> 5     1  -1.70  -4.30 -0.603949880  0.5813597  -2.303950  -3.718640      1
#> 6     1  -6.90  -1.55 -1.102216774 -1.4307725  -8.002217  -2.980772      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4520 -36500   8750 
#> initial  value 998.131940 
#> iter   2 value 844.621456
#> iter   3 value 828.440266
#> iter   4 value 827.832743
#> iter   5 value 786.851474
#> iter   6 value 779.002893
#> iter   7 value 778.056973
#> iter   8 value 778.023430
#> iter   9 value 778.022858
#> iter  10 value 778.022675
#> iter  11 value 778.022422
#> iter  12 value 778.022265
#> iter  12 value 778.022265
#> iter  12 value 778.022265
#> final  value 778.022265 
#> converged
#> This is Run number  27 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.6862357 -0.37731581   0.3362357 -12.577316      1
#> 2     1  -6.20  -3.90  2.6588761  0.66005481  -3.5411239  -3.239945      2
#> 3     1 -14.20  -5.80  2.5184884  0.55342696 -11.6815116  -5.246573      2
#> 4     1  -2.10 -13.20 -0.2629038 -0.02022635  -2.3629038 -13.220226      1
#> 5     1  -1.70  -4.30 -0.2897550 -0.73905191  -1.9897550  -5.039052      1
#> 6     1  -6.90  -1.55 -0.4053292 -0.42239065  -7.3053292  -1.972391      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4020 -36350   9100 
#> initial  value 998.131940 
#> iter   2 value 843.798578
#> iter   3 value 825.580600
#> iter   4 value 824.305292
#> iter   5 value 782.554496
#> iter   6 value 774.951378
#> iter   7 value 774.052306
#> iter   8 value 774.016304
#> iter   9 value 774.015690
#> iter  10 value 774.015651
#> iter  11 value 774.015475
#> iter  12 value 774.015252
#> iter  12 value 774.015252
#> iter  12 value 774.015252
#> final  value 774.015252 
#> converged
#> This is Run number  28 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  3.2749799 -0.66467520   0.9249799 -12.864675      1
#> 2     1  -6.20  -3.90  0.2139321  1.34579503  -5.9860679  -2.554205      2
#> 3     1 -14.20  -5.80  1.3861520 -0.46153021 -12.8138480  -6.261530      2
#> 4     1  -2.10 -13.20  0.1806948  0.01678434  -1.9193052 -13.183216      1
#> 5     1  -1.70  -4.30  1.8833165  2.67416799   0.1833165  -1.625832      1
#> 6     1  -6.90  -1.55 -0.2887903  3.10945865  -7.1887903   1.559459      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3840 -38475   8975 
#> initial  value 998.131940 
#> iter   2 value 815.369378
#> iter   3 value 809.337321
#> iter   4 value 803.065800
#> iter   5 value 753.511607
#> iter   6 value 744.059730
#> iter   7 value 742.411057
#> iter   8 value 742.384355
#> iter   9 value 742.384262
#> iter  10 value 742.384231
#> iter  10 value 742.384229
#> iter  10 value 742.384229
#> final  value 742.384229 
#> converged
#> This is Run number  29 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1       e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.37262927 0.8670987  -2.722629 -11.3329013      1
#> 2     1  -6.20  -3.90 -0.06000197 0.6706381  -6.260002  -3.2293619      2
#> 3     1 -14.20  -5.80  0.43856037 0.6647895 -13.761440  -5.1352105      2
#> 4     1  -2.10 -13.20 -0.15682800 1.9586036  -2.256828 -11.2413964      1
#> 5     1  -1.70  -4.30 -0.49391714 0.8200100  -2.193917  -3.4799900      1
#> 6     1  -6.90  -1.55 -0.55802445 1.1719655  -7.458024  -0.3780345      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5380 -36850   7750 
#> initial  value 998.131940 
#> iter   2 value 846.514471
#> iter   3 value 834.496451
#> iter   4 value 834.347603
#> iter   5 value 793.886815
#> iter   6 value 785.600122
#> iter   7 value 784.307860
#> iter   8 value 784.267126
#> iter   9 value 784.266542
#> iter  10 value 784.266343
#> iter  11 value 784.266059
#> iter  12 value 784.265883
#> iter  12 value 784.265883
#> iter  12 value 784.265883
#> final  value 784.265883 
#> converged
#> This is Run number  30 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1           e_2          U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.6983266 -0.5606535377  -0.65167343 -12.7606535      1
#> 2     1  -6.20  -3.90  2.3454175 -0.0003949978  -3.85458251  -3.9003950      1
#> 3     1 -14.20  -5.80 -0.7683467  0.7140527393 -14.96834665  -5.0859473      2
#> 4     1  -2.10 -13.20  2.0763598 -0.3413050988  -0.02364018 -13.5413051      1
#> 5     1  -1.70  -4.30  1.5126180 -0.0308160859  -0.18738200  -4.3308161      1
#> 6     1  -6.90  -1.55  0.2978253  0.6158008780  -6.60217471  -0.9341991      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4780 -37775   8550 
#> initial  value 998.131940 
#> iter   2 value 828.934527
#> iter   3 value 828.821765
#> iter   4 value 827.122455
#> iter   5 value 775.196756
#> iter   6 value 765.608540
#> iter   7 value 764.078088
#> iter   8 value 764.054801
#> iter   9 value 764.054682
#> iter  10 value 764.054357
#> iter  11 value 764.054334
#> iter  12 value 764.054225
#> iter  12 value 764.054225
#> iter  12 value 764.054225
#> final  value 764.054225 
#> converged
#> This is Run number  31 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.2038101  0.2988100  -2.1461899 -11.901190      1
#> 2     1  -6.20  -3.90  0.6150782  0.3541169  -5.5849218  -3.545883      2
#> 3     1 -14.20  -5.80  0.2087358  0.6498554 -13.9912642  -5.150145      2
#> 4     1  -2.10 -13.20  1.9292007 -0.3884696  -0.1707993 -13.588470      1
#> 5     1  -1.70  -4.30  1.1095214  0.4415471  -0.5904786  -3.858453      1
#> 6     1  -6.90  -1.55 -0.2764128  0.3636535  -7.1764128  -1.186347      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4380 -36475   7675 
#> initial  value 998.131940 
#> iter   2 value 851.615752
#> iter   3 value 851.513373
#> iter   4 value 848.587435
#> iter   5 value 794.120244
#> iter   6 value 784.881649
#> iter   7 value 783.377746
#> iter   8 value 783.352192
#> iter   9 value 783.352018
#> iter  10 value 783.351926
#> iter  10 value 783.351920
#> iter  11 value 783.351860
#> iter  12 value 783.351750
#> iter  12 value 783.351740
#> iter  12 value 783.351740
#> final  value 783.351740 
#> converged
#> This is Run number  32 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  2.6395857 -0.2143965   0.2895857 -12.4143965      1
#> 2     1  -6.20  -3.90  1.5886761  0.3125212  -4.6113239  -3.5874788      2
#> 3     1 -14.20  -5.80 -0.2723993 -1.5754728 -14.4723993  -7.3754728      2
#> 4     1  -2.10 -13.20  0.7339479  0.2318166  -1.3660521 -12.9681834      1
#> 5     1  -1.70  -4.30 -1.0516375 -0.4357972  -2.7516375  -4.7357972      1
#> 6     1  -6.90  -1.55 -1.2416690  0.7184026  -8.1416690  -0.8315974      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4780 -37325   7875 
#> initial  value 998.131940 
#> iter   2 value 839.381605
#> iter   3 value 839.322146
#> iter   4 value 837.224483
#> iter   5 value 785.205412
#> iter   6 value 775.641244
#> iter   7 value 774.138505
#> iter   8 value 774.111379
#> iter   9 value 774.111017
#> iter  10 value 774.110810
#> iter  11 value 774.110772
#> iter  12 value 774.110691
#> iter  12 value 774.110691
#> iter  12 value 774.110691
#> final  value 774.110691 
#> converged
#> This is Run number  33 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.62198172  0.1192210  -0.7280183 -12.0807790      1
#> 2     1  -6.20  -3.90  0.69146605  1.0669748  -5.5085339  -2.8330252      2
#> 3     1 -14.20  -5.80 -0.39009408 -1.2766655 -14.5900941  -7.0766655      2
#> 4     1  -2.10 -13.20  4.35295631  0.5151864   2.2529563 -12.6848136      1
#> 5     1  -1.70  -4.30  0.02659975  1.8254432  -1.6734002  -2.4745568      1
#> 6     1  -6.90  -1.55  0.05662132  1.2343851  -6.8433787  -0.3156149      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3700 -36225   9200 
#> initial  value 998.131940 
#> iter   2 value 844.355446
#> iter   3 value 825.144004
#> iter   4 value 823.217247
#> iter   5 value 780.588481
#> iter   6 value 773.101934
#> iter   7 value 772.179943
#> iter   8 value 772.141053
#> iter   9 value 772.140421
#> iter   9 value 772.140414
#> iter   9 value 772.140414
#> final  value 772.140414 
#> converged
#> This is Run number  34 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.4804763  0.4996805  -1.869524 -11.700319      1
#> 2     1  -6.20  -3.90  2.3704964  0.3812655  -3.829504  -3.518735      2
#> 3     1 -14.20  -5.80  2.3940746 -0.6394105 -11.805925  -6.439410      2
#> 4     1  -2.10 -13.20 -1.0328887 -0.4851286  -3.132889 -13.685129      1
#> 5     1  -1.70  -4.30  0.2677072  0.2764882  -1.432293  -4.023512      1
#> 6     1  -6.90  -1.55 -0.7486153  3.0485042  -7.648615   1.498504      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5100 -36250   7850 
#> initial  value 998.131940 
#> iter   2 value 853.707124
#> iter   3 value 841.193921
#> iter   4 value 840.951064
#> iter   5 value 799.274498
#> iter   6 value 791.252344
#> iter   7 value 789.996333
#> iter   8 value 789.959274
#> iter   9 value 789.958762
#> iter  10 value 789.958582
#> iter  11 value 789.958330
#> iter  12 value 789.958182
#> iter  12 value 789.958182
#> iter  12 value 789.958182
#> final  value 789.958182 
#> converged
#> This is Run number  35 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.63579675  1.14568509  -1.714203 -11.054315      1
#> 2     1  -6.20  -3.90 -0.39858372  0.93945936  -6.598584  -2.960541      2
#> 3     1 -14.20  -5.80  2.26660274 -0.28238476 -11.933397  -6.082385      2
#> 4     1  -2.10 -13.20  0.58755458 -0.18785251  -1.512445 -13.387853      1
#> 5     1  -1.70  -4.30 -0.08175432 -0.05879871  -1.781754  -4.358799      1
#> 6     1  -6.90  -1.55 -0.80715466 -0.41908850  -7.707155  -1.969089      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5360 -37400   7925 
#> initial  value 998.131940 
#> iter   2 value 838.104587
#> iter   3 value 825.407234
#> iter   4 value 825.180447
#> iter   5 value 785.864212
#> iter   6 value 777.414587
#> iter   7 value 776.189367
#> iter   8 value 776.145791
#> iter   9 value 776.145065
#> iter  10 value 776.144837
#> iter  11 value 776.144521
#> iter  12 value 776.144313
#> iter  12 value 776.144313
#> iter  12 value 776.144313
#> final  value 776.144313 
#> converged
#> This is Run number  36 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.3561211  0.01237756 -0.9938789 -12.187622      1
#> 2     1  -6.20  -3.90 -0.2871143 -0.02079995 -6.4871143  -3.920800      2
#> 3     1 -14.20  -5.80  4.2980215 -0.86093094 -9.9019785  -6.660931      2
#> 4     1  -2.10 -13.20 -0.2549352  1.25937829 -2.3549352 -11.940622      1
#> 5     1  -1.70  -4.30  0.5772472  0.54639164 -1.1227528  -3.753608      1
#> 6     1  -6.90  -1.55  2.0653982 -0.04400445 -4.8346018  -1.594004      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   6020 -38500   6525 
#> initial  value 998.131940 
#> iter   2 value 830.150507
#> iter   3 value 830.081442
#> iter   4 value 829.188354
#> iter   5 value 784.046956
#> iter   6 value 773.884648
#> iter   7 value 772.250724
#> iter   8 value 772.205243
#> iter   9 value 772.204970
#> iter  10 value 772.204546
#> iter  11 value 772.204522
#> iter  12 value 772.204406
#> iter  12 value 772.204406
#> iter  12 value 772.204406
#> final  value 772.204406 
#> converged
#> This is Run number  37 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1           e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 1.1310102  2.0336062685  -1.218990 -10.166394      1
#> 2     1  -6.20  -3.90 0.2290076  0.7067515962  -5.970992  -3.193248      2
#> 3     1 -14.20  -5.80 0.6564241 -0.0004879638 -13.543576  -5.800488      2
#> 4     1  -2.10 -13.20 0.9035120  0.2765372028  -1.196488 -12.923463      1
#> 5     1  -1.70  -4.30 0.4558847  0.4893635150  -1.244115  -3.810636      1
#> 6     1  -6.90  -1.55 1.0354170 -0.9631780882  -5.864583  -2.513178      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5180 -37700   7675 
#> initial  value 998.131940 
#> iter   2 value 835.502991
#> iter   3 value 823.054663
#> iter   4 value 822.210782
#> iter   5 value 782.851450
#> iter   6 value 774.302289
#> iter   7 value 772.851316
#> iter   8 value 772.792130
#> iter   9 value 772.791057
#> iter  10 value 772.790842
#> iter  11 value 772.790589
#> iter  12 value 772.790395
#> iter  12 value 772.790395
#> iter  12 value 772.790395
#> final  value 772.790395 
#> converged
#> This is Run number  38 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.42817501 -0.39894103  -1.921825 -12.598941      1
#> 2     1  -6.20  -3.90  0.08118998 -0.61713647  -6.118810  -4.517136      2
#> 3     1 -14.20  -5.80  1.44285357 -0.46523310 -12.757146  -6.265233      2
#> 4     1  -2.10 -13.20  1.58995603  1.55947203  -0.510044 -11.640528      1
#> 5     1  -1.70  -4.30 -0.84971510  0.09245052  -2.549715  -4.207549      1
#> 6     1  -6.90  -1.55  0.91764723 -0.40349353  -5.982353  -1.953494      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4600 -38100   8125 
#> initial  value 998.131940 
#> iter   2 value 827.007267
#> iter   3 value 824.771711
#> iter   4 value 821.509992
#> iter   5 value 771.786435
#> iter   6 value 762.086876
#> iter   7 value 760.587735
#> iter   8 value 760.563641
#> iter   9 value 760.563446
#> iter  10 value 760.563308
#> iter  10 value 760.563307
#> iter  11 value 760.563260
#> iter  12 value 760.563160
#> iter  12 value 760.563152
#> iter  12 value 760.563147
#> final  value 760.563147 
#> converged
#> This is Run number  39 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2293600 -0.8876553  -2.579360 -13.0876553      1
#> 2     1  -6.20  -3.90  0.1966103 -1.5463738  -6.003390  -5.4463738      2
#> 3     1 -14.20  -5.80  0.9458235  1.0368767 -13.254176  -4.7631233      2
#> 4     1  -2.10 -13.20 -0.1769461 -0.4227397  -2.276946 -13.6227397      1
#> 5     1  -1.70  -4.30  2.1118930 -1.1196273   0.411893  -5.4196273      1
#> 6     1  -6.90  -1.55  1.6798599  2.0891961  -5.220140   0.5391961      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4440 -36475   7875 
#> initial  value 998.131940 
#> iter   2 value 850.472860
#> iter   3 value 836.593603
#> iter   4 value 834.978310
#> iter   5 value 792.391997
#> iter   6 value 784.338409
#> iter   7 value 782.926301
#> iter   8 value 782.873361
#> iter   9 value 782.872499
#> iter  10 value 782.872352
#> iter  11 value 782.872204
#> iter  12 value 782.872090
#> iter  12 value 782.872090
#> iter  12 value 782.872090
#> final  value 782.872090 
#> converged
#> This is Run number  40 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.31330943 -0.3917061  -2.0366906 -12.591706      1
#> 2     1  -6.20  -3.90 -0.44968319 -1.0152068  -6.6496832  -4.915207      2
#> 3     1 -14.20  -5.80 -0.02694603 -0.4131738 -14.2269460  -6.213174      2
#> 4     1  -2.10 -13.20 -0.10255449  0.2843361  -2.2025545 -12.915664      1
#> 5     1  -1.70  -4.30  1.10133148  0.2175302  -0.5986685  -4.082470      1
#> 6     1  -6.90  -1.55  2.80880255  3.1015288  -4.0911974   1.551529      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5140 -37975   8325 
#> initial  value 998.131940 
#> iter   2 value 827.660966
#> iter   3 value 813.281188
#> iter   4 value 812.793716
#> iter   5 value 774.601260
#> iter   6 value 766.120791
#> iter   7 value 765.030252
#> iter   8 value 764.983758
#> iter   9 value 764.982875
#> iter  10 value 764.982820
#> iter  11 value 764.982504
#> iter  12 value 764.982111
#> iter  12 value 764.982111
#> iter  12 value 764.982111
#> final  value 764.982111 
#> converged
#> This is Run number  41 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.8336767  1.2926512  -3.1836767 -10.9073488      1
#> 2     1  -6.20  -3.90 -0.7142264  0.4934506  -6.9142264  -3.4065494      2
#> 3     1 -14.20  -5.80 -0.6275591  1.1206589 -14.8275591  -4.6793411      2
#> 4     1  -2.10 -13.20 -0.5123700  0.9882496  -2.6123700 -12.2117504      1
#> 5     1  -1.70  -4.30  0.7354067 -0.8042403  -0.9645933  -5.1042403      1
#> 6     1  -6.90  -1.55  3.1833829  1.4034197  -3.7166171  -0.1465803      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -37450   8450 
#> initial  value 998.131940 
#> iter   2 value 834.093070
#> iter   3 value 819.014869
#> iter   4 value 818.316519
#> iter   5 value 778.865009
#> iter   6 value 770.598512
#> iter   7 value 769.521666
#> iter   8 value 769.477576
#> iter   9 value 769.476753
#> iter   9 value 769.476744
#> iter   9 value 769.476744
#> final  value 769.476744 
#> converged
#> This is Run number  42 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1       e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.7388208 3.9251731  -3.088821  -8.274827      1
#> 2     1  -6.20  -3.90  0.2972668 0.9915603  -5.902733  -2.908440      2
#> 3     1 -14.20  -5.80 -0.2661600 2.7051783 -14.466160  -3.094822      2
#> 4     1  -2.10 -13.20  0.7131473 0.3559195  -1.386853 -12.844081      1
#> 5     1  -1.70  -4.30  0.4587632 0.4930344  -1.241237  -3.806966      1
#> 6     1  -6.90  -1.55  2.3611070 0.4555440  -4.538893  -1.094456      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5280 -37300   7450 
#> initial  value 998.131940 
#> iter   2 value 842.276553
#> iter   3 value 830.720991
#> iter   4 value 830.082702
#> iter   5 value 789.905678
#> iter   6 value 781.456213
#> iter   7 value 779.905338
#> iter   8 value 779.847309
#> iter   9 value 779.846348
#> iter  10 value 779.846121
#> iter  11 value 779.845832
#> iter  12 value 779.845637
#> iter  12 value 779.845637
#> iter  12 value 779.845637
#> final  value 779.845637 
#> converged
#> This is Run number  43 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  3.3392590 -0.17314272   0.989259 -12.3731427      1
#> 2     1  -6.20  -3.90 -0.4092820  2.90145662  -6.609282  -0.9985434      2
#> 3     1 -14.20  -5.80  3.0993024 -0.23225518 -11.100698  -6.0322552      2
#> 4     1  -2.10 -13.20 -0.6871393  0.32581572  -2.787139 -12.8741843      1
#> 5     1  -1.70  -4.30 -1.3140607 -0.32474045  -3.014061  -4.6247404      1
#> 6     1  -6.90  -1.55 -0.5506818  0.00384525  -7.450682  -1.5461548      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5100 -37375   7450 
#> initial  value 998.131940 
#> iter   2 value 841.260581
#> iter   3 value 829.359060
#> iter   4 value 828.302067
#> iter   5 value 787.962052
#> iter   6 value 779.502699
#> iter   7 value 777.899749
#> iter   8 value 777.836301
#> iter   9 value 777.835217
#> iter  10 value 777.835018
#> iter  11 value 777.834785
#> iter  12 value 777.834613
#> iter  12 value 777.834613
#> iter  12 value 777.834613
#> final  value 777.834613 
#> converged
#> This is Run number  44 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.0561136  0.7667949  -1.293886 -11.4332051      1
#> 2     1  -6.20  -3.90  0.2904447  3.4802587  -5.909555  -0.4197413      2
#> 3     1 -14.20  -5.80  0.5007030  0.4527343 -13.699297  -5.3472657      2
#> 4     1  -2.10 -13.20 -1.0622565 -0.4565755  -3.162257 -13.6565755      1
#> 5     1  -1.70  -4.30 -0.4197725 -0.4633292  -2.119772  -4.7633292      1
#> 6     1  -6.90  -1.55  0.5183234  5.1021769  -6.381677   3.5521769      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4220 -36000   7525 
#> initial  value 998.131940 
#> iter   2 value 858.408517
#> iter   3 value 858.371355
#> iter   4 value 855.211237
#> iter   5 value 799.505498
#> iter   6 value 790.456593
#> iter   7 value 788.959034
#> iter   8 value 788.934299
#> iter   9 value 788.934229
#> iter  10 value 788.934008
#> iter  10 value 788.934007
#> iter  11 value 788.933975
#> iter  12 value 788.933914
#> iter  12 value 788.933906
#> iter  12 value 788.933904
#> final  value 788.933904 
#> converged
#> This is Run number  45 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.9770879 -0.5331898  -1.372912 -12.733190      1
#> 2     1  -6.20  -3.90  0.6188149  0.9935593  -5.581185  -2.906441      2
#> 3     1 -14.20  -5.80  1.3031484 -1.2303248 -12.896852  -7.030325      2
#> 4     1  -2.10 -13.20 -0.3870820  0.6134700  -2.487082 -12.586530      1
#> 5     1  -1.70  -4.30  3.4573002 -0.2934759   1.757300  -4.593476      1
#> 6     1  -6.90  -1.55  0.5435977 -0.9309058  -6.356402  -2.480906      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3940 -35400   8500 
#> initial  value 998.131940 
#> iter   2 value 859.622019
#> iter   3 value 843.478845
#> iter   4 value 842.025135
#> iter   5 value 797.994798
#> iter   6 value 790.526816
#> iter   7 value 789.448592
#> iter   8 value 789.412644
#> iter   9 value 789.412079
#> iter  10 value 789.411946
#> iter  11 value 789.411806
#> iter  12 value 789.411711
#> iter  12 value 789.411711
#> iter  12 value 789.411711
#> final  value 789.411711 
#> converged
#> This is Run number  46 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  8.0946745 -0.39534642   5.744674 -12.5953464      1
#> 2     1  -6.20  -3.90 -0.5413074 -0.28762967  -6.741307  -4.1876297      2
#> 3     1 -14.20  -5.80 -1.1400700 -0.04888199 -15.340070  -5.8488820      2
#> 4     1  -2.10 -13.20 -0.1074818 -0.90853832  -2.207482 -14.1085383      1
#> 5     1  -1.70  -4.30  0.0373976  2.65389998  -1.662602  -1.6461000      2
#> 6     1  -6.90  -1.55 -0.5826485  2.44500364  -7.482649   0.8950036      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5380 -39325   7275 
#> initial  value 998.131940 
#> iter   2 value 814.218426
#> iter   3 value 811.497369
#> iter   4 value 808.803130
#> iter   5 value 765.139770
#> iter   6 value 754.925747
#> iter   7 value 753.508775
#> iter   8 value 753.480105
#> iter   9 value 753.479719
#> iter  10 value 753.479677
#> iter  10 value 753.479676
#> iter  11 value 753.479640
#> iter  12 value 753.479513
#> iter  12 value 753.479509
#> iter  13 value 753.479496
#> iter  13 value 753.479494
#> iter  13 value 753.479493
#> final  value 753.479493 
#> converged
#> This is Run number  47 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.0046455 -1.1623668  -3.3546455 -13.362367      1
#> 2     1  -6.20  -3.90  0.7514134  0.5142024  -5.4485866  -3.385798      2
#> 3     1 -14.20  -5.80  0.3465487  0.6153043 -13.8534513  -5.184696      2
#> 4     1  -2.10 -13.20  1.2504921 -0.1115016  -0.8495079 -13.311502      1
#> 5     1  -1.70  -4.30 -0.5127211  1.5830428  -2.2127211  -2.716957      1
#> 6     1  -6.90  -1.55  1.7555586  3.1278597  -5.1444414   1.577860      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -37475   8425 
#> initial  value 998.131940 
#> iter   2 value 833.913655
#> iter   3 value 818.897168
#> iter   4 value 818.163935
#> iter   5 value 778.717338
#> iter   6 value 770.436612
#> iter   7 value 769.345531
#> iter   8 value 769.300585
#> iter   9 value 769.299742
#> iter   9 value 769.299735
#> iter   9 value 769.299735
#> final  value 769.299735 
#> converged
#> This is Run number  48 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.79058067  0.7202817  -3.140581 -11.479718      1
#> 2     1  -6.20  -3.90  0.79204040  0.1129894  -5.407960  -3.787011      2
#> 3     1 -14.20  -5.80  0.85399183  1.5300737 -13.346008  -4.269926      2
#> 4     1  -2.10 -13.20 -0.22768638  0.8309363  -2.327686 -12.369064      1
#> 5     1  -1.70  -4.30  6.26732611  0.9631317   4.567326  -3.336868      1
#> 6     1  -6.90  -1.55  0.04578162 -0.3114252  -6.854218  -1.861425      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4940 -37925   7775 
#> initial  value 998.131940 
#> iter   2 value 831.743323
#> iter   3 value 830.815168
#> iter   4 value 828.595191
#> iter   5 value 778.903110
#> iter   6 value 769.127999
#> iter   7 value 767.642800
#> iter   8 value 767.615278
#> iter   9 value 767.614868
#> iter  10 value 767.614679
#> iter  11 value 767.614657
#> iter  12 value 767.614570
#> iter  12 value 767.614570
#> iter  12 value 767.614570
#> final  value 767.614570 
#> converged
#> This is Run number  49 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.30682651  0.3126437  -0.04317349 -11.887356      1
#> 2     1  -6.20  -3.90  2.62194660  1.4702864  -3.57805340  -2.429714      2
#> 3     1 -14.20  -5.80  0.24474927  0.6753785 -13.95525073  -5.124621      2
#> 4     1  -2.10 -13.20  2.46406130 -0.7541648   0.36406130 -13.954165      1
#> 5     1  -1.70  -4.30 -1.48412757  0.5572091  -3.18412757  -3.742791      1
#> 6     1  -6.90  -1.55 -0.09641577 -0.1128043  -6.99641577  -1.662804      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4360 -36500   8225 
#> initial  value 998.131940 
#> iter   2 value 847.947902
#> iter   3 value 832.956590
#> iter   4 value 831.500810
#> iter   5 value 789.306615
#> iter   6 value 781.326888
#> iter   7 value 780.088309
#> iter   8 value 780.041383
#> iter   9 value 780.040579
#> iter  10 value 780.040424
#> iter  11 value 780.040266
#> iter  12 value 780.040144
#> iter  12 value 780.040144
#> iter  12 value 780.040144
#> final  value 780.040144 
#> converged
#> This is Run number  50 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2          e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.703579024 -0.9510993  -0.646421 -13.1510993      1
#> 2     1  -6.20  -3.90 -0.008326799  0.7815381  -6.208327  -3.1184619      2
#> 3     1 -14.20  -5.80  0.808150589  0.6003857 -13.391849  -5.1996143      2
#> 4     1  -2.10 -13.20 -0.136086526  2.4637606  -2.236087 -10.7362394      1
#> 5     1  -1.70  -4.30 -0.305163828  1.7509572  -2.005164  -2.5490428      1
#> 6     1  -6.90  -1.55  0.185886476  1.2428984  -6.714114  -0.3071016      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4140 -36400   8475 
#> initial  value 998.131940 
#> iter   2 value 847.474333
#> iter   3 value 831.355690
#> iter   4 value 829.675559
#> iter   5 value 787.199726
#> iter   6 value 779.339296
#> iter   7 value 778.186698
#> iter   8 value 778.141966
#> iter   9 value 778.141201
#> iter  10 value 778.141066
#> iter  11 value 778.140938
#> iter  12 value 778.140833
#> iter  12 value 778.140833
#> iter  12 value 778.140833
#> final  value 778.140833 
#> converged
#> This is Run number  51 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.98194900  0.50973468  -1.368051 -11.6902653      1
#> 2     1  -6.20  -3.90 -0.36553577  1.50277704  -6.565536  -2.3972230      2
#> 3     1 -14.20  -5.80 -0.14931099  3.59693518 -14.349311  -2.2030648      2
#> 4     1  -2.10 -13.20  0.19822848  0.40146056  -1.901772 -12.7985394      1
#> 5     1  -1.70  -4.30 -0.03639585 -0.01177724  -1.736396  -4.3117772      1
#> 6     1  -6.90  -1.55  1.22512314  2.53600584  -5.674877   0.9860058      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4560 -37200   7875 
#> initial  value 998.131940 
#> iter   2 value 840.973282
#> iter   3 value 840.327073
#> iter   4 value 837.556467
#> iter   5 value 785.121194
#> iter   6 value 775.628088
#> iter   7 value 774.122135
#> iter   8 value 774.096429
#> iter   9 value 774.096090
#> iter  10 value 774.095952
#> iter  11 value 774.095939
#> iter  12 value 774.095864
#> iter  12 value 774.095864
#> iter  12 value 774.095864
#> final  value 774.095864 
#> converged
#> This is Run number  52 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.1222335 -0.52915171  -2.227766 -12.729152      1
#> 2     1  -6.20  -3.90  2.1135934 -0.06660978  -4.086407  -3.966610      2
#> 3     1 -14.20  -5.80  3.1754112  0.68444905 -11.024589  -5.115551      2
#> 4     1  -2.10 -13.20 -0.6841028 -0.63325480  -2.784103 -13.833255      1
#> 5     1  -1.70  -4.30  0.1287893  0.18839710  -1.571211  -4.111603      1
#> 6     1  -6.90  -1.55 -0.6705420  4.97460520  -7.570542   3.424605      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3280 -36875  10200 
#> initial  value 998.131940 
#> iter   2 value 827.826419
#> iter   3 value 827.302910
#> iter   4 value 822.101520
#> iter   5 value 762.706874
#> iter   6 value 753.782524
#> iter   7 value 751.925158
#> iter   8 value 751.886775
#> iter   9 value 751.886733
#> iter   9 value 751.886730
#> iter   9 value 751.886730
#> final  value 751.886730 
#> converged
#> This is Run number  53 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.74947912  0.01250242   0.3994791 -12.187498      1
#> 2     1  -6.20  -3.90 -1.09408501 -0.40845736  -7.2940850  -4.308457      2
#> 3     1 -14.20  -5.80  0.06814824  1.81261473 -14.1318518  -3.987385      2
#> 4     1  -2.10 -13.20 -1.26604008  0.31517105  -3.3660401 -12.884829      1
#> 5     1  -1.70  -4.30  0.91460636  0.73359870  -0.7853936  -3.566401      1
#> 6     1  -6.90  -1.55  0.15480907 -0.24158386  -6.7451909  -1.791584      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -39025   8400 
#> initial  value 998.131940 
#> iter   2 value 811.658210
#> iter   3 value 806.453678
#> iter   4 value 801.548884
#> iter   5 value 754.974336
#> iter   6 value 745.234252
#> iter   7 value 743.727283
#> iter   8 value 743.703415
#> iter   9 value 743.703300
#> iter  10 value 743.703145
#> iter  10 value 743.703135
#> iter  10 value 743.703135
#> final  value 743.703135 
#> converged
#> This is Run number  54 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.51372700  0.7989452  -1.836273 -11.401055      1
#> 2     1  -6.20  -3.90  0.40590012  1.2053960  -5.794100  -2.694604      2
#> 3     1 -14.20  -5.80  0.08897046 -1.0653002 -14.111030  -6.865300      2
#> 4     1  -2.10 -13.20 -1.52647558  1.1804794  -3.626476 -12.019521      1
#> 5     1  -1.70  -4.30  0.39127006 -1.2260929  -1.308730  -5.526093      1
#> 6     1  -6.90  -1.55  0.39037691 -0.2882428  -6.509623  -1.838243      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4720 -37775   7750 
#> initial  value 998.131940 
#> iter   2 value 833.915055
#> iter   3 value 832.381270
#> iter   4 value 829.449940
#> iter   5 value 779.331643
#> iter   6 value 769.624438
#> iter   7 value 768.133087
#> iter   8 value 768.106738
#> iter   9 value 768.106386
#> iter  10 value 768.106287
#> iter  10 value 768.106283
#> iter  11 value 768.106257
#> iter  12 value 768.106184
#> iter  12 value 768.106181
#> iter  12 value 768.106178
#> final  value 768.106178 
#> converged
#> This is Run number  55 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.19327923  1.2215320  -1.156721 -10.978468      1
#> 2     1  -6.20  -3.90  2.26838942  2.4169136  -3.931611  -1.483086      2
#> 3     1 -14.20  -5.80 -0.24473387  0.2727369 -14.444734  -5.527263      2
#> 4     1  -2.10 -13.20 -0.12440643  2.5800021  -2.224406 -10.619998      1
#> 5     1  -1.70  -4.30 -0.09188671  0.7590902  -1.791887  -3.540910      1
#> 6     1  -6.90  -1.55  1.54910607 -0.2135422  -5.350894  -1.763542      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5180 -36200   7100 
#> initial  value 998.131940 
#> iter   2 value 858.622824
#> iter   3 value 848.148348
#> iter   4 value 847.561718
#> iter   5 value 804.901921
#> iter   6 value 796.871217
#> iter   7 value 795.165635
#> iter   8 value 795.111488
#> iter   9 value 795.110742
#> iter  10 value 795.110534
#> iter  11 value 795.110246
#> iter  12 value 795.110089
#> iter  12 value 795.110089
#> iter  12 value 795.110089
#> final  value 795.110089 
#> converged
#> This is Run number  56 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.06679665 -1.01650683  -2.2832034 -13.216507      1
#> 2     1  -6.20  -3.90  2.70837623  0.11359293  -3.4916238  -3.786407      1
#> 3     1 -14.20  -5.80  0.28956855  0.05244931 -13.9104315  -5.747551      2
#> 4     1  -2.10 -13.20 -1.13139743  0.46590643  -3.2313974 -12.734094      1
#> 5     1  -1.70  -4.30  1.33135036 -0.03279888  -0.3686496  -4.332799      1
#> 6     1  -6.90  -1.55  0.11170111  4.15743107  -6.7882989   2.607431      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4660 -38025   7450 
#> initial  value 998.131940 
#> iter   2 value 832.112239
#> iter   3 value 829.148075
#> iter   4 value 825.252427
#> iter   5 value 776.771792
#> iter   6 value 766.944614
#> iter   7 value 765.448549
#> iter   8 value 765.421769
#> iter   9 value 765.421556
#> iter  10 value 765.421506
#> iter  10 value 765.421505
#> iter  11 value 765.421488
#> iter  12 value 765.421438
#> iter  12 value 765.421436
#> iter  12 value 765.421433
#> final  value 765.421433 
#> converged
#> This is Run number  57 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.9152459  1.3086786  -3.265246 -10.891321      1
#> 2     1  -6.20  -3.90  2.2545075  0.1260269  -3.945493  -3.773973      2
#> 3     1 -14.20  -5.80 -0.5405821  0.3233013 -14.740582  -5.476699      2
#> 4     1  -2.10 -13.20 -0.3358695  0.7498803  -2.435869 -12.450120      1
#> 5     1  -1.70  -4.30  0.3615463 -0.3853142  -1.338454  -4.685314      1
#> 6     1  -6.90  -1.55  2.2002336  3.1676627  -4.699766   1.617663      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4880 -38100   7675 
#> initial  value 998.131940 
#> iter   2 value 829.847077
#> iter   3 value 828.143604
#> iter   4 value 825.385899
#> iter   5 value 776.562955
#> iter   6 value 766.735330
#> iter   7 value 765.257041
#> iter   8 value 765.229984
#> iter   9 value 765.229607
#> iter  10 value 765.229485
#> iter  10 value 765.229482
#> iter  11 value 765.229457
#> iter  12 value 765.229382
#> iter  12 value 765.229379
#> iter  12 value 765.229376
#> final  value 765.229376 
#> converged
#> This is Run number  58 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.2239443  0.2591357  -2.126056 -11.940864      1
#> 2     1  -6.20  -3.90 -0.7100291  0.4965561  -6.910029  -3.403444      2
#> 3     1 -14.20  -5.80  1.0560323  3.0649659 -13.143968  -2.735034      2
#> 4     1  -2.10 -13.20  0.8632542 -1.1615996  -1.236746 -14.361600      1
#> 5     1  -1.70  -4.30 -0.8380725  1.4809453  -2.538073  -2.819055      1
#> 6     1  -6.90  -1.55  0.6282001 -0.7188565  -6.271800  -2.268857      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5500 -38750   8350 
#> initial  value 998.131940 
#> iter   2 value 816.307454
#> iter   3 value 815.876855
#> iter   4 value 815.276526
#> iter   5 value 767.540077
#> iter   6 value 757.583179
#> iter   7 value 756.097847
#> iter   8 value 756.073573
#> iter   9 value 756.073407
#> iter  10 value 756.073027
#> iter  11 value 756.072947
#> iter  12 value 756.072815
#> iter  12 value 756.072815
#> iter  12 value 756.072815
#> final  value 756.072815 
#> converged
#> This is Run number  59 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1       e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2413716 1.6783906  -2.5913716 -10.5216094      1
#> 2     1  -6.20  -3.90  2.1052818 0.4999755  -4.0947182  -3.4000245      2
#> 3     1 -14.20  -5.80 -1.2109782 0.1597809 -15.4109782  -5.6402191      2
#> 4     1  -2.10 -13.20  1.2620759 0.8817886  -0.8379241 -12.3182114      1
#> 5     1  -1.70  -4.30  0.1492418 0.3312733  -1.5507582  -3.9687267      1
#> 6     1  -6.90  -1.55 -0.6768452 1.7362861  -7.5768452   0.1862861      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4540 -36425   8025 
#> initial  value 998.131940 
#> iter   2 value 850.264790
#> iter   3 value 836.220121
#> iter   4 value 835.042206
#> iter   5 value 792.855482
#> iter   6 value 784.847363
#> iter   7 value 783.548253
#> iter   8 value 783.501353
#> iter   9 value 783.500569
#> iter  10 value 783.500395
#> iter  11 value 783.500198
#> iter  12 value 783.500062
#> iter  12 value 783.500062
#> iter  12 value 783.500062
#> final  value 783.500062 
#> converged
#> This is Run number  60 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.9403374 -0.89843536  -3.2903374 -13.098435      1
#> 2     1  -6.20  -3.90  1.8100131  0.31054109  -4.3899869  -3.589459      2
#> 3     1 -14.20  -5.80  0.9700724  1.04086594 -13.2299276  -4.759134      2
#> 4     1  -2.10 -13.20  1.3108147 -1.35465609  -0.7891853 -14.554656      1
#> 5     1  -1.70  -4.30  0.2377307 -0.90326217  -1.4622693  -5.203262      1
#> 6     1  -6.90  -1.55  0.1550381 -0.02513497  -6.7449619  -1.575135      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4960 -38325   7325 
#> initial  value 998.131940 
#> iter   2 value 828.659437
#> iter   3 value 826.252404
#> iter   4 value 823.062892
#> iter   5 value 775.813092
#> iter   6 value 765.858210
#> iter   7 value 764.379274
#> iter   8 value 764.350739
#> iter   9 value 764.350501
#> iter  10 value 764.350336
#> iter  10 value 764.350335
#> iter  11 value 764.350313
#> iter  12 value 764.350279
#> iter  12 value 764.350279
#> iter  12 value 764.350276
#> final  value 764.350276 
#> converged
#> This is Run number  61 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.3606790 -0.4836395  -1.989321 -12.683639      1
#> 2     1  -6.20  -3.90  1.2360164  0.7274717  -4.963984  -3.172528      2
#> 3     1 -14.20  -5.80 -0.9873912  1.0959163 -15.187391  -4.704084      2
#> 4     1  -2.10 -13.20 -0.2012224 -0.6221022  -2.301222 -13.822102      1
#> 5     1  -1.70  -4.30  3.5924705  1.9395643   1.892470  -2.360436      1
#> 6     1  -6.90  -1.55 -1.0628638 -0.5837008  -7.962864  -2.133701      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5520 -39450   7900 
#> initial  value 998.131940 
#> iter   2 value 808.652731
#> iter   3 value 806.755819
#> iter   4 value 805.322503
#> iter   5 value 760.821745
#> iter   6 value 750.710600
#> iter   7 value 749.295291
#> iter   8 value 749.269313
#> iter   9 value 749.268939
#> iter  10 value 749.268759
#> iter  11 value 749.268731
#> iter  12 value 749.268411
#> iter  12 value 749.268411
#> iter  12 value 749.268411
#> final  value 749.268411 
#> converged
#> This is Run number  62 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.05554581 -0.1883352  -2.2944542 -12.388335      1
#> 2     1  -6.20  -3.90  2.14079827 -0.6942596  -4.0592017  -4.594260      1
#> 3     1 -14.20  -5.80  1.67514876 -0.2747328 -12.5248512  -6.074733      2
#> 4     1  -2.10 -13.20 -0.67376439  0.9152453  -2.7737644 -12.284755      1
#> 5     1  -1.70  -4.30  1.26531454  0.3944486  -0.4346855  -3.905551      1
#> 6     1  -6.90  -1.55 -0.47477404 -0.6525285  -7.3747740  -2.202529      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4260 -36750   7500 
#> initial  value 998.131940 
#> iter   2 value 848.946136
#> iter   3 value 847.155311
#> iter   4 value 843.271386
#> iter   5 value 790.199813
#> iter   6 value 780.830378
#> iter   7 value 779.307465
#> iter   8 value 779.282190
#> iter   9 value 779.282056
#> iter  10 value 779.281946
#> iter  10 value 779.281946
#> iter  11 value 779.281922
#> iter  12 value 779.281904
#> iter  12 value 779.281904
#> iter  12 value 779.281900
#> final  value 779.281900 
#> converged
#> This is Run number  63 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1         e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 0.7049117  0.83650472  -1.6450883 -11.3634953      1
#> 2     1  -6.20  -3.90 1.2413823  3.14874439  -4.9586177  -0.7512556      2
#> 3     1 -14.20  -5.80 0.7515753  0.04476255 -13.4484247  -5.7552375      2
#> 4     1  -2.10 -13.20 1.7082685 -0.60583605  -0.3917315 -13.8058361      1
#> 5     1  -1.70  -4.30 0.9144838  1.33293480  -0.7855162  -2.9670652      1
#> 6     1  -6.90  -1.55 3.3565398  0.87857828  -3.5434602  -0.6714217      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -38200   9225 
#> initial  value 998.131940 
#> iter   2 value 818.311397
#> iter   3 value 818.072991
#> iter   4 value 816.931939
#> iter   5 value 765.113829
#> iter   6 value 755.550308
#> iter   7 value 753.984050
#> iter   8 value 753.962499
#> iter   9 value 753.962267
#> iter  10 value 753.962114
#> iter  10 value 753.962114
#> iter  11 value 753.962069
#> iter  11 value 753.962066
#> iter  12 value 753.962053
#> iter  12 value 753.962046
#> iter  12 value 753.962046
#> final  value 753.962046 
#> converged
#> This is Run number  64 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.74224034  1.1042593  -1.607760 -11.095741      1
#> 2     1  -6.20  -3.90  0.11250293 -0.8977172  -6.087497  -4.797717      2
#> 3     1 -14.20  -5.80 -0.40348622  0.4970745 -14.603486  -5.302926      2
#> 4     1  -2.10 -13.20  0.08981291 -0.4154599  -2.010187 -13.615460      1
#> 5     1  -1.70  -4.30  1.34411399  0.1835940  -0.355886  -4.116406      1
#> 6     1  -6.90  -1.55  2.38868673 -0.2847194  -4.511313  -1.834719      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5000 -39175   7900 
#> initial  value 998.131940 
#> iter   2 value 812.819943
#> iter   3 value 809.516865
#> iter   4 value 806.380262
#> iter   5 value 761.021080
#> iter   6 value 751.033668
#> iter   7 value 749.602087
#> iter   8 value 749.577446
#> iter   9 value 749.577327
#> iter  10 value 749.576927
#> iter  10 value 749.576924
#> iter  11 value 749.576868
#> iter  12 value 749.576841
#> iter  12 value 749.576835
#> iter  12 value 749.576835
#> final  value 749.576835 
#> converged
#> This is Run number  65 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.08691641 -0.02878832  -2.26308359 -12.228788      1
#> 2     1  -6.20  -3.90 -0.91774016  1.34660555  -7.11774016  -2.553394      2
#> 3     1 -14.20  -5.80  1.37308501 -0.23456203 -12.82691499  -6.034562      2
#> 4     1  -2.10 -13.20  0.18093148  1.44403306  -1.91906852 -11.755967      1
#> 5     1  -1.70  -4.30  1.71474876  2.58269500   0.01474876  -1.717305      1
#> 6     1  -6.90  -1.55  0.20839467 -0.28189139  -6.69160533  -1.831891      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4040 -36825   8375 
#> initial  value 998.131940 
#> iter   2 value 842.480456
#> iter   3 value 841.443751
#> iter   4 value 837.639787
#> iter   5 value 782.770535
#> iter   6 value 773.534759
#> iter   7 value 771.971682
#> iter   8 value 771.949357
#> iter   9 value 771.949269
#> iter  10 value 771.949142
#> iter  10 value 771.949134
#> iter  11 value 771.949105
#> iter  12 value 771.949057
#> iter  12 value 771.949048
#> iter  12 value 771.949047
#> final  value 771.949047 
#> converged
#> This is Run number  66 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.05593889  1.4049648  -2.294061 -10.795035      1
#> 2     1  -6.20  -3.90 -0.37450786 -0.4704617  -6.574508  -4.370462      2
#> 3     1 -14.20  -5.80  0.37534751 -0.5989741 -13.824652  -6.398974      2
#> 4     1  -2.10 -13.20 -0.83005334 -0.3126427  -2.930053 -13.512643      1
#> 5     1  -1.70  -4.30  0.43988701  0.2521451  -1.260113  -4.047855      1
#> 6     1  -6.90  -1.55  1.42117014 -0.1803194  -5.478830  -1.730319      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4380 -36700   7400 
#> initial  value 998.131940 
#> iter   2 value 850.259110
#> iter   3 value 848.971779
#> iter   4 value 845.483840
#> iter   5 value 792.449196
#> iter   6 value 783.084643
#> iter   7 value 781.568142
#> iter   8 value 781.541896
#> iter   9 value 781.541818
#> iter  10 value 781.541629
#> iter  10 value 781.541629
#> iter  11 value 781.541610
#> iter  12 value 781.541551
#> iter  12 value 781.541551
#> iter  12 value 781.541548
#> final  value 781.541548 
#> converged
#> This is Run number  67 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.1303160  2.2271925  -2.4803160  -9.9728075      1
#> 2     1  -6.20  -3.90  4.4813891  2.6635557  -1.7186109  -1.2364443      2
#> 3     1 -14.20  -5.80  2.2320284 -0.5483224 -11.9679716  -6.3483224      2
#> 4     1  -2.10 -13.20  1.6570825 -0.2070998  -0.4429175 -13.4070998      1
#> 5     1  -1.70  -4.30 -0.1750784  0.4829291  -1.8750784  -3.8170709      1
#> 6     1  -6.90  -1.55 -0.2696483  1.3620277  -7.1696483  -0.1879723      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3720 -37575   8875 
#> initial  value 998.131940 
#> iter   2 value 828.675389
#> iter   3 value 824.678385
#> iter   4 value 819.010998
#> iter   5 value 766.051896
#> iter   6 value 756.732432
#> iter   7 value 755.069437
#> iter   8 value 755.045403
#> iter   9 value 755.045349
#> iter  10 value 755.045297
#> iter  10 value 755.045296
#> iter  11 value 755.045284
#> iter  11 value 755.045279
#> iter  11 value 755.045279
#> final  value 755.045279 
#> converged
#> This is Run number  68 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  3.3833380  0.86922487   1.033338 -11.330775      1
#> 2     1  -6.20  -3.90  0.8437777  0.00852502  -5.356222  -3.891475      2
#> 3     1 -14.20  -5.80  0.5613912  0.11544104 -13.638609  -5.684559      2
#> 4     1  -2.10 -13.20 -1.3817953 -0.65112548  -3.481795 -13.851125      1
#> 5     1  -1.70  -4.30  0.3651437 -0.50626862  -1.334856  -4.806269      1
#> 6     1  -6.90  -1.55 -1.3438314  2.58832529  -8.243831   1.038325      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3940 -35175   9450 
#> initial  value 998.131940 
#> iter   2 value 855.792320
#> iter   3 value 836.815291
#> iter   4 value 836.277056
#> iter   5 value 793.999774
#> iter   6 value 786.930148
#> iter   7 value 786.234393
#> iter   8 value 786.213842
#> iter   9 value 786.213554
#> iter  10 value 786.213422
#> iter  11 value 786.213222
#> iter  12 value 786.213119
#> iter  12 value 786.213119
#> iter  12 value 786.213119
#> final  value 786.213119 
#> converged
#> This is Run number  69 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.4651999  0.3885999  -2.815200 -11.811400      1
#> 2     1  -6.20  -3.90  1.1080846 -0.5256243  -5.091915  -4.425624      2
#> 3     1 -14.20  -5.80  2.0956649  2.4927948 -12.104335  -3.307205      2
#> 4     1  -2.10 -13.20  1.3005730 -0.5364762  -0.799427 -13.736476      1
#> 5     1  -1.70  -4.30 -0.4120258 -0.6109967  -2.112026  -4.910997      1
#> 6     1  -6.90  -1.55 -0.2608904  0.4550302  -7.160890  -1.094970      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4400 -36775   8150 
#> initial  value 998.131940 
#> iter   2 value 844.855215
#> iter   3 value 830.022989
#> iter   4 value 828.389904
#> iter   5 value 786.543782
#> iter   6 value 778.446270
#> iter   7 value 777.151138
#> iter   8 value 777.099923
#> iter   9 value 777.099038
#> iter  10 value 777.098891
#> iter  11 value 777.098752
#> iter  12 value 777.098636
#> iter  12 value 777.098636
#> iter  12 value 777.098636
#> final  value 777.098636 
#> converged
#> This is Run number  70 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.8165725  0.9626176  -3.1665725 -11.237382      1
#> 2     1  -6.20  -3.90  1.1118690  0.5078099  -5.0881310  -3.392190      2
#> 3     1 -14.20  -5.80  2.0329138  0.7559811 -12.1670862  -5.044019      2
#> 4     1  -2.10 -13.20  2.9823756 -1.1659006   0.8823756 -14.365901      1
#> 5     1  -1.70  -4.30  2.8614145 -0.1327276   1.1614145  -4.432728      1
#> 6     1  -6.90  -1.55  1.2917455  0.3822399  -5.6082545  -1.167760      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4660 -36975   6600 
#> initial  value 998.131940 
#> iter   2 value 851.020828
#> iter   3 value 848.611774
#> iter   4 value 844.971960
#> iter   5 value 794.612407
#> iter   6 value 785.045825
#> iter   7 value 783.435321
#> iter   8 value 783.402730
#> iter   9 value 783.402692
#> iter  10 value 783.402645
#> iter  10 value 783.402642
#> iter  10 value 783.402642
#> final  value 783.402642 
#> converged
#> This is Run number  71 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.3976929  0.9177073  -2.7476929 -11.282293      1
#> 2     1  -6.20  -3.90  2.7823111  0.5875632  -3.4176889  -3.312437      2
#> 3     1 -14.20  -5.80  0.3129113  0.4492086 -13.8870887  -5.350791      2
#> 4     1  -2.10 -13.20 -0.5796708  2.1342480  -2.6796708 -11.065752      1
#> 5     1  -1.70  -4.30  1.2523503 -0.9882201  -0.4476497  -5.288220      1
#> 6     1  -6.90  -1.55  0.8617463 -0.5378500  -6.0382537  -2.087850      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4720 -39200   8825 
#> initial  value 998.131940 
#> iter   2 value 806.385411
#> iter   3 value 802.788700
#> iter   4 value 799.838408
#> iter   5 value 752.711387
#> iter   6 value 743.042890
#> iter   7 value 741.529469
#> iter   8 value 741.505839
#> iter   9 value 741.505630
#> iter  10 value 741.505417
#> iter  10 value 741.505411
#> iter  10 value 741.505410
#> final  value 741.505410 
#> converged
#> This is Run number  72 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2          U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.5039744  3.74164899  -1.84602559  -8.4583510      1
#> 2     1  -6.20  -3.90  0.6014584  1.09783691  -5.59854157  -2.8021631      2
#> 3     1 -14.20  -5.80 -0.7142847  0.05776387 -14.91428468  -5.7422361      2
#> 4     1  -2.10 -13.20  2.0433677 -0.80199150  -0.05663231 -14.0019915      1
#> 5     1  -1.70  -4.30  0.1146474  1.99534585  -1.58535256  -2.3046542      1
#> 6     1  -6.90  -1.55  2.5278417  2.13058140  -4.37215827   0.5805814      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3780 -36925   8600 
#> initial  value 998.131940 
#> iter   2 value 839.409943
#> iter   3 value 837.209696
#> iter   4 value 832.400696
#> iter   5 value 777.476360
#> iter   6 value 768.266911
#> iter   7 value 766.648901
#> iter   8 value 766.626719
#> iter   9 value 766.626676
#> iter  10 value 766.626555
#> iter  10 value 766.626550
#> iter  10 value 766.626545
#> final  value 766.626545 
#> converged
#> This is Run number  73 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.4494958  1.7345651  -3.7994958 -10.465435      1
#> 2     1  -6.20  -3.90  0.3442363  1.0075835  -5.8557637  -2.892417      2
#> 3     1 -14.20  -5.80  1.2978076  3.4928670 -12.9021924  -2.307133      2
#> 4     1  -2.10 -13.20 -0.5748624 -0.1875035  -2.6748624 -13.387504      1
#> 5     1  -1.70  -4.30  0.8694614 -0.4563697  -0.8305386  -4.756370      1
#> 6     1  -6.90  -1.55 -0.2704916  0.4798187  -7.1704916  -1.070181      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4320 -37150   7175 
#> initial  value 998.131940 
#> iter   2 value 845.474908
#> iter   3 value 842.184350
#> iter   4 value 837.692625
#> iter   5 value 786.745469
#> iter   6 value 777.161731
#> iter   7 value 775.610103
#> iter   8 value 775.582905
#> iter   9 value 775.582871
#> iter  10 value 775.582813
#> iter  10 value 775.582810
#> iter  10 value 775.582801
#> final  value 775.582801 
#> converged
#> This is Run number  74 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.4055048  0.6363696  -0.9444952 -11.563630      1
#> 2     1  -6.20  -3.90 -0.8410177 -0.6075035  -7.0410177  -4.507503      2
#> 3     1 -14.20  -5.80  0.5864629  0.8108504 -13.6135371  -4.989150      2
#> 4     1  -2.10 -13.20 -0.7713636  4.6759420  -2.8713636  -8.524058      1
#> 5     1  -1.70  -4.30  0.2133817  1.8492769  -1.4866183  -2.450723      1
#> 6     1  -6.90  -1.55  1.8425574  0.3298618  -5.0574426  -1.220138      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4620 -37475   8700 
#> initial  value 998.131940 
#> iter   2 value 832.019744
#> iter   3 value 815.771456
#> iter   4 value 814.825325
#> iter   5 value 775.292606
#> iter   6 value 767.139963
#> iter   7 value 766.124507
#> iter   8 value 766.080129
#> iter   9 value 766.079306
#> iter  10 value 766.079220
#> iter  11 value 766.078980
#> iter  12 value 766.078715
#> iter  12 value 766.078715
#> iter  12 value 766.078715
#> final  value 766.078715 
#> converged
#> This is Run number  75 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.04937408 -0.39690198  -2.399374 -12.596902      1
#> 2     1  -6.20  -3.90 -1.27871756  0.88952995  -7.478718  -3.010470      2
#> 3     1 -14.20  -5.80  0.89763527 -0.07210279 -13.302365  -5.872103      2
#> 4     1  -2.10 -13.20  0.18292648 -0.10810404  -1.917074 -13.308104      1
#> 5     1  -1.70  -4.30 -0.22566958 -0.84315770  -1.925670  -5.143158      1
#> 6     1  -6.90  -1.55 -1.35869959  0.58450903  -8.258700  -0.965491      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3780 -36775   8800 
#> initial  value 998.131940 
#> iter   2 value 840.068799
#> iter   3 value 838.857927
#> iter   4 value 834.507321
#> iter   5 value 778.460092
#> iter   6 value 769.335728
#> iter   7 value 767.704145
#> iter   8 value 767.682167
#> iter   9 value 767.682117
#> iter  10 value 767.682003
#> iter  10 value 767.682002
#> iter  10 value 767.682002
#> final  value 767.682002 
#> converged
#> This is Run number  76 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.4519911 0.61047138  -1.898009 -11.589529      1
#> 2     1  -6.20  -3.90 -0.2928155 1.27601586  -6.492815  -2.623984      2
#> 3     1 -14.20  -5.80  1.3831303 2.81239788 -12.816870  -2.987602      2
#> 4     1  -2.10 -13.20  0.5743638 1.89840165  -1.525636 -11.301598      1
#> 5     1  -1.70  -4.30 -1.1256945 0.48999387  -2.825695  -3.810006      1
#> 6     1  -6.90  -1.55 -0.0161102 0.08131718  -6.916110  -1.468683      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -38725   8250 
#> initial  value 998.131940 
#> iter   2 value 817.068573
#> iter   3 value 812.457111
#> iter   4 value 807.734063
#> iter   5 value 760.297454
#> iter   6 value 750.542999
#> iter   7 value 749.037400
#> iter   8 value 749.013823
#> iter   9 value 749.013736
#> iter  10 value 749.013544
#> iter  10 value 749.013534
#> iter  10 value 749.013523
#> final  value 749.013523 
#> converged
#> This is Run number  77 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.7092839 -0.7296749  -1.640716 -12.929675      1
#> 2     1  -6.20  -3.90  0.6129858  1.0979546  -5.587014  -2.802045      2
#> 3     1 -14.20  -5.80 -0.4285098 -0.9858998 -14.628510  -6.785900      2
#> 4     1  -2.10 -13.20 -0.2134370  1.2988319  -2.313437 -11.901168      1
#> 5     1  -1.70  -4.30 -0.2862218  0.3581475  -1.986222  -3.941853      1
#> 6     1  -6.90  -1.55 -0.6343464 -0.3393799  -7.534346  -1.889380      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4760 -37125   8250 
#> initial  value 998.131940 
#> iter   2 value 839.755472
#> iter   3 value 825.226355
#> iter   4 value 824.349966
#> iter   5 value 783.968283
#> iter   6 value 775.750450
#> iter   7 value 774.570434
#> iter   8 value 774.524300
#> iter   9 value 774.523459
#> iter  10 value 774.523263
#> iter  11 value 774.523026
#> iter  12 value 774.522855
#> iter  12 value 774.522855
#> iter  12 value 774.522855
#> final  value 774.522855 
#> converged
#> This is Run number  78 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.2608798 -1.11279258  -1.089120 -13.3127926      1
#> 2     1  -6.20  -3.90 -0.3279171  2.94484766  -6.527917  -0.9551523      2
#> 3     1 -14.20  -5.80  1.9931025  0.25163443 -12.206898  -5.5483656      2
#> 4     1  -2.10 -13.20  0.2185614  0.71829931  -1.881439 -12.4817007      1
#> 5     1  -1.70  -4.30 -1.0710554  0.05103286  -2.771055  -4.2489671      1
#> 6     1  -6.90  -1.55  2.8050428 -0.84598798  -4.094957  -2.3959880      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4240 -36225   8775 
#> initial  value 998.131940 
#> iter   2 value 847.812074
#> iter   3 value 831.118040
#> iter   4 value 830.109929
#> iter   5 value 788.211325
#> iter   6 value 780.498499
#> iter   7 value 779.524584
#> iter   8 value 779.489161
#> iter   9 value 779.488550
#> iter  10 value 779.488389
#> iter  11 value 779.488189
#> iter  12 value 779.488056
#> iter  12 value 779.488056
#> iter  12 value 779.488056
#> final  value 779.488056 
#> converged
#> This is Run number  79 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.3399326  1.2372152 -2.68993256 -10.962785      1
#> 2     1  -6.20  -3.90 -0.4568115  0.7409915 -6.65681154  -3.159009      2
#> 3     1 -14.20  -5.80  4.8352628 -0.9642566 -9.36473716  -6.764257      2
#> 4     1  -2.10 -13.20  0.9231170  0.5452014 -1.17688299 -12.654799      1
#> 5     1  -1.70  -4.30  1.6846959 -0.7585376 -0.01530415  -5.058538      1
#> 6     1  -6.90  -1.55  1.9289033  0.5238088 -4.97109674  -1.026191      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4740 -37125   8325 
#> initial  value 998.131940 
#> iter   2 value 839.271032
#> iter   3 value 824.493233
#> iter   4 value 823.644758
#> iter   5 value 783.327214
#> iter   6 value 775.131054
#> iter   7 value 773.986059
#> iter   8 value 773.941167
#> iter   9 value 773.940345
#> iter  10 value 773.940149
#> iter  11 value 773.939909
#> iter  12 value 773.939737
#> iter  12 value 773.939737
#> iter  12 value 773.939737
#> final  value 773.939737 
#> converged
#> This is Run number  80 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  5.0662042 -0.19352523   2.7162042 -12.393525      1
#> 2     1  -6.20  -3.90 -0.3584616 -0.10399107  -6.5584616  -4.003991      2
#> 3     1 -14.20  -5.80  0.1611421  0.11054841 -14.0388579  -5.689452      2
#> 4     1  -2.10 -13.20  2.6498533 -1.38669236   0.5498533 -14.586692      1
#> 5     1  -1.70  -4.30  0.7553165 -1.22336938  -0.9446835  -5.523369      1
#> 6     1  -6.90  -1.55 -0.5841141 -0.08842405  -7.4841141  -1.638424      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5060 -37600   7075 
#> initial  value 998.131940 
#> iter   2 value 840.250016
#> iter   3 value 839.364399
#> iter   4 value 836.983802
#> iter   5 value 787.671916
#> iter   6 value 777.898411
#> iter   7 value 776.373204
#> iter   8 value 776.340978
#> iter   9 value 776.340855
#> iter  10 value 776.340445
#> iter  10 value 776.340445
#> iter  11 value 776.340421
#> iter  12 value 776.340404
#> iter  12 value 776.340404
#> iter  12 value 776.340400
#> final  value 776.340400 
#> converged
#> This is Run number  81 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  1.3142708 -0.3536049  -1.035729 -12.5536049      1
#> 2     1  -6.20  -3.90  0.7193266  0.9760824  -5.480673  -2.9239176      2
#> 3     1 -14.20  -5.80 -0.2945289  0.5374173 -14.494529  -5.2625827      2
#> 4     1  -2.10 -13.20 -1.4992786  0.7774192  -3.599279 -12.4225808      1
#> 5     1  -1.70  -4.30  2.8189908  0.4188651   1.118991  -3.8811349      1
#> 6     1  -6.90  -1.55 -0.6367349  1.0924987  -7.536735  -0.4575013      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4660 -38175   7100 
#> initial  value 998.131940 
#> iter   2 value 831.910454
#> iter   3 value 827.862946
#> iter   4 value 823.299517
#> iter   5 value 776.145148
#> iter   6 value 766.205683
#> iter   7 value 764.682313
#> iter   8 value 764.653548
#> iter   9 value 764.653476
#> iter  10 value 764.653433
#> iter  10 value 764.653432
#> iter  10 value 764.653430
#> final  value 764.653430 
#> converged
#> This is Run number  82 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.18164345 -0.1033646  -2.168357 -12.303365      1
#> 2     1  -6.20  -3.90  0.85906048 -1.0061318  -5.340940  -4.906132      2
#> 3     1 -14.20  -5.80  0.08271827 -0.8723209 -14.117282  -6.672321      2
#> 4     1  -2.10 -13.20  3.50633784  0.7939991   1.406338 -12.406001      1
#> 5     1  -1.70  -4.30 -0.20138580 -0.9616517  -1.901386  -5.261652      1
#> 6     1  -6.90  -1.55  0.40847472 -0.3435611  -6.491525  -1.893561      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5240 -39000   7375 
#> initial  value 998.131940 
#> iter   2 value 818.545887
#> iter   3 value 816.018234
#> iter   4 value 813.272554
#> iter   5 value 768.260275
#> iter   6 value 758.135678
#> iter   7 value 756.699858
#> iter   8 value 756.671518
#> iter   9 value 756.671137
#> iter  10 value 756.671057
#> iter  10 value 756.671057
#> iter  11 value 756.671023
#> iter  12 value 756.670923
#> iter  12 value 756.670923
#> iter  12 value 756.670917
#> final  value 756.670917 
#> converged
#> This is Run number  83 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2          e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.006557373  2.35812781  -2.343443  -9.841872      1
#> 2     1  -6.20  -3.90 -0.570835146  1.04128380  -6.770835  -2.858716      2
#> 3     1 -14.20  -5.80  0.666473890  1.62960017 -13.533526  -4.170400      2
#> 4     1  -2.10 -13.20  0.628472938  1.23254962  -1.471527 -11.967450      1
#> 5     1  -1.70  -4.30  6.773680751  1.58148590   5.073681  -2.718514      1
#> 6     1  -6.90  -1.55 -0.610179733 -0.03501699  -7.510180  -1.585017      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4600 -35175   7575 
#> initial  value 998.131940 
#> iter   2 value 868.444370
#> iter   3 value 856.209917
#> iter   4 value 855.446727
#> iter   5 value 811.042523
#> iter   6 value 803.484509
#> iter   7 value 802.090879
#> iter   8 value 802.051597
#> iter   9 value 802.051076
#> iter  10 value 802.050911
#> iter  11 value 802.050691
#> iter  12 value 802.050578
#> iter  12 value 802.050578
#> iter  12 value 802.050578
#> final  value 802.050578 
#> converged
#> This is Run number  84 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2       U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.7410103  0.9308367 -1.608990 -11.269163      1
#> 2     1  -6.20  -3.90  0.2023885 -1.1993718 -5.997611  -5.099372      2
#> 3     1 -14.20  -5.80  6.5631674  2.7665919 -7.636833  -3.033408      2
#> 4     1  -2.10 -13.20  0.2260080 -0.3893936 -1.873992 -13.589394      1
#> 5     1  -1.70  -4.30 -0.2491636 -0.1650799 -1.949164  -4.465080      1
#> 6     1  -6.90  -1.55  3.1025138 -0.4356947 -3.797486  -1.985695      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4120 -36325   7950 
#> initial  value 998.131940 
#> iter   2 value 851.706422
#> iter   3 value 851.424004
#> iter   4 value 848.010123
#> iter   5 value 792.374803
#> iter   6 value 783.247393
#> iter   7 value 781.726859
#> iter   8 value 781.703535
#> iter   9 value 781.703289
#> iter  10 value 781.703225
#> iter  10 value 781.703218
#> iter  11 value 781.703202
#> iter  12 value 781.703154
#> iter  12 value 781.703149
#> iter  12 value 781.703149
#> final  value 781.703149 
#> converged
#> This is Run number  85 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.15685920  1.6181790  -0.1931408 -10.581821      1
#> 2     1  -6.20  -3.90  0.46672790 -0.5924700  -5.7332721  -4.492470      2
#> 3     1 -14.20  -5.80 -0.32280936  0.7126463 -14.5228094  -5.087354      2
#> 4     1  -2.10 -13.20 -0.25683466  0.5463735  -2.3568347 -12.653627      1
#> 5     1  -1.70  -4.30  0.08682804 -0.7854899  -1.6131720  -5.085490      1
#> 6     1  -6.90  -1.55  1.00940826  0.1061092  -5.8905917  -1.443891      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -39225   6775 
#> initial  value 998.131940 
#> iter   2 value 818.003724
#> iter   3 value 808.752365
#> iter   4 value 801.533124
#> iter   5 value 758.677619
#> iter   6 value 748.357946
#> iter   7 value 746.817670
#> iter   8 value 746.784597
#> iter   9 value 746.784494
#> iter  10 value 746.784477
#> iter  10 value 746.784469
#> iter  11 value 746.784455
#> iter  11 value 746.784452
#> iter  11 value 746.784450
#> final  value 746.784450 
#> converged
#> This is Run number  86 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.3010769 -0.9141604  -2.6510769 -13.114160      1
#> 2     1  -6.20  -3.90  0.1023188  0.8035392  -6.0976812  -3.096461      2
#> 3     1 -14.20  -5.80 -0.2459610 -0.1114015 -14.4459610  -5.911402      2
#> 4     1  -2.10 -13.20  0.4101373  0.5824786  -1.6898627 -12.617521      1
#> 5     1  -1.70  -4.30  1.4802254 -0.9604515  -0.2197746  -5.260452      1
#> 6     1  -6.90  -1.55  2.0798398  0.1295004  -4.8201602  -1.420500      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5220 -37050   6750 
#> initial  value 998.131940 
#> iter   2 value 849.418370
#> iter   3 value 839.474163
#> iter   4 value 838.177804
#> iter   5 value 796.663048
#> iter   6 value 788.310262
#> iter   7 value 786.256936
#> iter   8 value 786.177593
#> iter   9 value 786.176371
#> iter  10 value 786.176345
#> iter  11 value 786.176117
#> iter  12 value 786.175818
#> iter  12 value 786.175818
#> iter  12 value 786.175818
#> final  value 786.175818 
#> converged
#> This is Run number  87 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.2281456  0.07351175  -1.1218544 -12.126488      1
#> 2     1  -6.20  -3.90  1.5385527  0.00620283  -4.6614473  -3.893797      2
#> 3     1 -14.20  -5.80 -0.2672927  2.42437809 -14.4672927  -3.375622      2
#> 4     1  -2.10 -13.20 -0.2231812  1.63727386  -2.3231812 -11.562726      1
#> 5     1  -1.70  -4.30  1.2463589  0.24978596  -0.4536411  -4.050214      1
#> 6     1  -6.90  -1.55  0.6295867 -1.34875019  -6.2704133  -2.898750      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4600 -38650   8575 
#> initial  value 998.131940 
#> iter   2 value 816.185596
#> iter   3 value 813.204255
#> iter   4 value 809.970548
#> iter   5 value 761.322245
#> iter   6 value 751.639968
#> iter   7 value 750.124991
#> iter   8 value 750.101974
#> iter   9 value 750.101845
#> iter  10 value 750.101566
#> iter  10 value 750.101565
#> iter  11 value 750.101550
#> iter  12 value 750.101498
#> iter  12 value 750.101498
#> iter  12 value 750.101494
#> final  value 750.101494 
#> converged
#> This is Run number  88 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.3899620  3.6925034  -2.739962  -8.507497      1
#> 2     1  -6.20  -3.90  1.9221369  0.3410687  -4.277863  -3.558931      2
#> 3     1 -14.20  -5.80  2.5180977  0.8891951 -11.681902  -4.910805      2
#> 4     1  -2.10 -13.20  0.8369726  1.2324104  -1.263027 -11.967590      1
#> 5     1  -1.70  -4.30 -0.5723168 -0.3453459  -2.272317  -4.645346      1
#> 6     1  -6.90  -1.55  1.7238869  3.7486137  -5.176113   2.198614      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4660 -36750   8750 
#> initial  value 998.131940 
#> iter   2 value 841.423991
#> iter   3 value 825.403712
#> iter   4 value 824.930412
#> iter   5 value 784.559152
#> iter   6 value 776.612530
#> iter   7 value 775.679787
#> iter   8 value 775.646194
#> iter   9 value 775.645622
#> iter  10 value 775.645429
#> iter  11 value 775.645149
#> iter  12 value 775.644977
#> iter  12 value 775.644977
#> iter  12 value 775.644977
#> final  value 775.644977 
#> converged
#> This is Run number  89 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.8252059  3.2157923   0.4752059  -8.984208      1
#> 2     1  -6.20  -3.90 -1.6099043  2.0010008  -7.8099043  -1.898999      2
#> 3     1 -14.20  -5.80 -0.4744442  0.2704471 -14.6744442  -5.529553      2
#> 4     1  -2.10 -13.20 -0.4882044 -0.3979737  -2.5882044 -13.597974      1
#> 5     1  -1.70  -4.30 -0.3199300 -0.9464690  -2.0199300  -5.246469      1
#> 6     1  -6.90  -1.55 -0.7328442 -0.7353443  -7.6328442  -2.285344      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4240 -37500   9300 
#> initial  value 998.131940 
#> iter   2 value 827.275275
#> iter   3 value 827.058454
#> iter   4 value 824.532562
#> iter   5 value 769.781233
#> iter   6 value 760.483775
#> iter   7 value 758.859056
#> iter   8 value 758.836213
#> iter   9 value 758.836080
#> iter  10 value 758.835983
#> iter  10 value 758.835979
#> iter  11 value 758.835957
#> iter  11 value 758.835948
#> iter  11 value 758.835946
#> final  value 758.835946 
#> converged
#> This is Run number  90 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.49891682  2.0281329  -1.851083 -10.171867      1
#> 2     1  -6.20  -3.90 -0.40957352  2.0659096  -6.609574  -1.834090      2
#> 3     1 -14.20  -5.80  1.00185344  0.2533755 -13.198147  -5.546624      2
#> 4     1  -2.10 -13.20 -0.40556423  0.2048927  -2.505564 -12.995107      1
#> 5     1  -1.70  -4.30 -0.64828977  1.3893261  -2.348290  -2.910674      1
#> 6     1  -6.90  -1.55 -0.00287213 -0.2826485  -6.902872  -1.832648      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -36100   8075 
#> initial  value 998.131940 
#> iter   2 value 854.033442
#> iter   3 value 839.757460
#> iter   4 value 838.555263
#> iter   5 value 795.747354
#> iter   6 value 787.878810
#> iter   7 value 786.613038
#> iter   8 value 786.569092
#> iter   9 value 786.568378
#> iter  10 value 786.568212
#> iter  11 value 786.568023
#> iter  12 value 786.567897
#> iter  12 value 786.567897
#> iter  12 value 786.567897
#> final  value 786.567897 
#> converged
#> This is Run number  91 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.04731083  1.2046841  -2.397311 -10.9953159      1
#> 2     1  -6.20  -3.90 -0.50858903 -0.2590025  -6.708589  -4.1590025      2
#> 3     1 -14.20  -5.80 -1.42204082  0.3560212 -15.622041  -5.4439788      2
#> 4     1  -2.10 -13.20  3.96125219 -0.2783707   1.861252 -13.4783707      1
#> 5     1  -1.70  -4.30 -0.47344109  0.2934525  -2.173441  -4.0065475      1
#> 6     1  -6.90  -1.55  0.29926013  1.1701623  -6.600740  -0.3798377      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -39125   8300 
#> initial  value 998.131940 
#> iter   2 value 811.033137
#> iter   3 value 807.597655
#> iter   4 value 804.449714
#> iter   5 value 758.119461
#> iter   6 value 748.275491
#> iter   7 value 746.812537
#> iter   8 value 746.789105
#> iter   9 value 746.788968
#> iter  10 value 746.788596
#> iter  10 value 746.788591
#> iter  11 value 746.788569
#> iter  12 value 746.788528
#> iter  12 value 746.788527
#> iter  12 value 746.788522
#> final  value 746.788522 
#> converged
#> This is Run number  92 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.70951345 -0.7903765  -1.64048655 -12.990377      1
#> 2     1  -6.20  -3.90 -0.04594059 -0.6133461  -6.24594059  -4.513346      2
#> 3     1 -14.20  -5.80  1.75782510 -0.1693818 -12.44217490  -5.969382      2
#> 4     1  -2.10 -13.20 -0.31131070  3.3526483  -2.41131070  -9.847352      1
#> 5     1  -1.70  -4.30  1.73733633  1.1470262   0.03733633  -3.152974      1
#> 6     1  -6.90  -1.55  0.33397542  3.1130814  -6.56602458   1.563081      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5220 -37775   7700 
#> initial  value 998.131940 
#> iter   2 value 834.314337
#> iter   3 value 821.844110
#> iter   4 value 821.067774
#> iter   5 value 781.940916
#> iter   6 value 773.367865
#> iter   7 value 771.940261
#> iter   8 value 771.881778
#> iter   9 value 771.880709
#> iter  10 value 771.880489
#> iter  11 value 771.880227
#> iter  12 value 771.880026
#> iter  12 value 771.880026
#> iter  12 value 771.880026
#> final  value 771.880026 
#> converged
#> This is Run number  93 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2          e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.002544636  3.01269958  -2.352545  -9.1873004      1
#> 2     1  -6.20  -3.90  0.461620685 -0.57228098  -5.738379  -4.4722810      2
#> 3     1 -14.20  -5.80 -0.104974303  1.87082085 -14.304974  -3.9291792      2
#> 4     1  -2.10 -13.20  0.917834504  0.03849098  -1.182165 -13.1615090      1
#> 5     1  -1.70  -4.30 -1.047649137  1.06059458  -2.747649  -3.2394054      1
#> 6     1  -6.90  -1.55  2.266104335  0.79433077  -4.633896  -0.7556692      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5240 -39025   7300 
#> initial  value 998.131940 
#> iter   2 value 818.593263
#> iter   3 value 815.915283
#> iter   4 value 813.027616
#> iter   5 value 768.271419
#> iter   6 value 758.128104
#> iter   7 value 756.690588
#> iter   8 value 756.661966
#> iter   9 value 756.661623
#> iter  10 value 756.661524
#> iter  10 value 756.661522
#> iter  11 value 756.661497
#> iter  12 value 756.661419
#> iter  12 value 756.661417
#> iter  12 value 756.661412
#> final  value 756.661412 
#> converged
#> This is Run number  94 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.07649172 -0.4126947  -2.4264917 -12.612695      1
#> 2     1  -6.20  -3.90  0.91224528  0.3568797  -5.2877547  -3.543120      2
#> 3     1 -14.20  -5.80 -0.51983325 -0.3146800 -14.7198332  -6.114680      2
#> 4     1  -2.10 -13.20  1.03192599  0.2935649  -1.0680740 -12.906435      1
#> 5     1  -1.70  -4.30  1.62874650  1.0643130  -0.0712535  -3.235687      1
#> 6     1  -6.90  -1.55 -0.70073712  6.7215510  -7.6007371   5.171551      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5020 -38850   7450 
#> initial  value 998.131940 
#> iter   2 value 820.317754
#> iter   3 value 817.229385
#> iter   4 value 813.856785
#> iter   5 value 768.247771
#> iter   6 value 758.194501
#> iter   7 value 756.748091
#> iter   8 value 756.721008
#> iter   9 value 756.720699
#> iter  10 value 756.720675
#> iter  10 value 756.720672
#> iter  11 value 756.720645
#> iter  12 value 756.720554
#> iter  12 value 756.720553
#> iter  13 value 756.720540
#> iter  14 value 756.720528
#> iter  14 value 756.720527
#> iter  14 value 756.720527
#> final  value 756.720527 
#> converged
#> This is Run number  95 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.75476506  1.1376200  -0.5952349 -11.062380      1
#> 2     1  -6.20  -3.90  0.37143699 -0.4064870  -5.8285630  -4.306487      2
#> 3     1 -14.20  -5.80  0.05597248  1.8895934 -14.1440275  -3.910407      2
#> 4     1  -2.10 -13.20 -1.57002365  0.7956458  -3.6700237 -12.404354      1
#> 5     1  -1.70  -4.30  1.02477855  2.7510652  -0.6752215  -1.548935      1
#> 6     1  -6.90  -1.55  0.27774933 -1.4798926  -6.6222507  -3.029893      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4180 -37950   8700 
#> initial  value 998.131940 
#> iter   2 value 825.118573
#> iter   3 value 822.218489
#> iter   4 value 818.088146
#> iter   5 value 766.677225
#> iter   6 value 757.197793
#> iter   7 value 755.620741
#> iter   8 value 755.597842
#> iter   9 value 755.597757
#> iter  10 value 755.597589
#> iter  10 value 755.597589
#> iter  10 value 755.597582
#> final  value 755.597582 
#> converged
#> This is Run number  96 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.99460283  0.6204715  -3.3446028 -11.579529      1
#> 2     1  -6.20  -3.90  0.27052160  2.0403030  -5.9294784  -1.859697      2
#> 3     1 -14.20  -5.80  0.06212584  0.4919944 -14.1378742  -5.308006      2
#> 4     1  -2.10 -13.20 -0.28130468 -0.7168769  -2.3813047 -13.916877      1
#> 5     1  -1.70  -4.30  2.07091585  0.8318879   0.3709159  -3.468112      1
#> 6     1  -6.90  -1.55  1.75504684 -1.0429918  -5.1449532  -2.592992      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4240 -34975   7900 
#> initial  value 998.131940 
#> iter   2 value 868.696169
#> iter   3 value 855.026244
#> iter   4 value 853.943908
#> iter   5 value 809.123841
#> iter   6 value 801.699248
#> iter   7 value 800.440198
#> iter   8 value 800.403533
#> iter   9 value 800.403021
#> iter  10 value 800.402872
#> iter  11 value 800.402691
#> iter  12 value 800.402591
#> iter  12 value 800.402591
#> iter  12 value 800.402591
#> final  value 800.402591 
#> converged
#> This is Run number  97 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.6804658  7.8234856  -0.66953424  -4.376514      1
#> 2     1  -6.20  -3.90 -1.1723727  2.2616485  -7.37237269  -1.638352      2
#> 3     1 -14.20  -5.80  0.5888012  0.2182166 -13.61119883  -5.581783      2
#> 4     1  -2.10 -13.20  2.1592152 -0.4703820   0.05921521 -13.670382      1
#> 5     1  -1.70  -4.30 -0.1667923  2.4902909  -1.86679234  -1.809709      2
#> 6     1  -6.90  -1.55  3.5732289  0.1049713  -3.32677109  -1.445029      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3880 -35475   9075 
#> initial  value 998.131940 
#> iter   2 value 854.786382
#> iter   3 value 836.758096
#> iter   4 value 835.665082
#> iter   5 value 792.683592
#> iter   6 value 785.376819
#> iter   7 value 784.518924
#> iter   8 value 784.489941
#> iter   9 value 784.489473
#> iter  10 value 784.489337
#> iter  11 value 784.489169
#> iter  12 value 784.489063
#> iter  12 value 784.489063
#> iter  12 value 784.489063
#> final  value 784.489063 
#> converged
#> This is Run number  98 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.5462102 -1.1871589  -2.8962102 -13.387159      1
#> 2     1  -6.20  -3.90  0.7099834  2.1583818  -5.4900166  -1.741618      2
#> 3     1 -14.20  -5.80 -0.2238515 -1.4977059 -14.4238515  -7.297706      2
#> 4     1  -2.10 -13.20  0.5999046  2.8819350  -1.5000954 -10.318065      1
#> 5     1  -1.70  -4.30  0.9987987  0.4645474  -0.7012013  -3.835453      1
#> 6     1  -6.90  -1.55 -0.1866644 -0.7704091  -7.0866644  -2.320409      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4760 -37900   7825 
#> initial  value 998.131940 
#> iter   2 value 831.737854
#> iter   3 value 830.213381
#> iter   4 value 827.407609
#> iter   5 value 777.559280
#> iter   6 value 767.825921
#> iter   7 value 766.337915
#> iter   8 value 766.311793
#> iter   9 value 766.311410
#> iter  10 value 766.311377
#> iter  10 value 766.311371
#> iter  10 value 766.311371
#> final  value 766.311371 
#> converged
#> This is Run number  99 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2           e_1         e_2          U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.3315898832  2.05543660  -0.01841012 -10.144563      1
#> 2     1  -6.20  -3.90  4.7108183578 -0.22771780  -1.48918164  -4.127718      1
#> 3     1 -14.20  -5.80 -0.3416886667 -0.08102251 -14.54168867  -5.881023      2
#> 4     1  -2.10 -13.20  0.0009812646 -0.64774726  -2.09901874 -13.847747      1
#> 5     1  -1.70  -4.30  0.0158874385  2.67469882  -1.68411256  -1.625301      2
#> 6     1  -6.90  -1.55  0.8868829836  0.47373977  -6.01311702  -1.076260      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5080 -38100   8125 
#> initial  value 998.131940 
#> iter   2 value 827.160706
#> iter   3 value 826.778951
#> iter   4 value 825.297884
#> iter   5 value 775.491644
#> iter   6 value 765.702107
#> iter   7 value 764.208502
#> iter   8 value 764.182275
#> iter   9 value 764.181846
#> iter  10 value 764.181686
#> iter  11 value 764.181624
#> iter  12 value 764.181527
#> iter  12 value 764.181527
#> iter  12 value 764.181527
#> final  value 764.181527 
#> converged
#> This is Run number  100 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2           U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2749904  2.4036846  -2.624990392  -9.796315      1
#> 2     1  -6.20  -3.90  1.1747567  2.4109400  -5.025243267  -1.489060      2
#> 3     1 -14.20  -5.80  0.8599178 -0.6658785 -13.340082201  -6.465879      2
#> 4     1  -2.10 -13.20  3.3923544 -0.4249671   1.292354434 -13.624967      1
#> 5     1  -1.70  -4.30  1.7075315 -0.5737491   0.007531473  -4.873749      1
#> 6     1  -6.90  -1.55  0.4773335 -0.2693873  -6.422666472  -1.819387      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5080 -36025   8325 
#> initial  value 998.131940 
#> iter   2 value 853.590373
#> iter   3 value 839.779287
#> iter   4 value 839.735559
#> iter   5 value 798.398646
#> iter   6 value 790.565956
#> iter   7 value 789.582415
#> iter   8 value 789.557102
#> iter   9 value 789.556798
#> iter  10 value 789.556685
#> iter  11 value 789.556483
#> iter  12 value 789.556357
#> iter  12 value 789.556357
#> iter  12 value 789.556357
#> final  value 789.556357 
#> converged
#> This is Run number  101 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1        e_2          U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 0.4079910 -0.8162012  -1.94200896 -13.0162012      1
#> 2     1  -6.20  -3.90 0.1914849  1.4814915  -6.00851506  -2.4185085      2
#> 3     1 -14.20  -5.80 3.6540535 -0.3954948 -10.54594652  -6.1954948      2
#> 4     1  -2.10 -13.20 0.5519237  1.2387365  -1.54807631 -11.9612635      1
#> 5     1  -1.70  -4.30 1.7658721  4.0701144   0.06587208  -0.2298856      1
#> 6     1  -6.90  -1.55 0.3501438 -1.2284613  -6.54985618  -2.7784613      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4440 -37700   8075 
#> initial  value 998.131940 
#> iter   2 value 832.838065
#> iter   3 value 830.771989
#> iter   4 value 827.224463
#> iter   5 value 776.194040
#> iter   6 value 766.601257
#> iter   7 value 765.087081
#> iter   8 value 765.063059
#> iter   9 value 765.062831
#> iter  10 value 765.062673
#> iter  10 value 765.062672
#> iter  11 value 765.062655
#> iter  12 value 765.062623
#> iter  12 value 765.062623
#> iter  12 value 765.062622
#> final  value 765.062622 
#> converged
#> This is Run number  102 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.4812427  0.05158502  -3.8312427 -12.148415      1
#> 2     1  -6.20  -3.90  2.3049594  0.81413303  -3.8950406  -3.085867      2
#> 3     1 -14.20  -5.80 -0.1459469 -0.31402692 -14.3459469  -6.114027      2
#> 4     1  -2.10 -13.20  1.0471054  0.92633216  -1.0528946 -12.273668      1
#> 5     1  -1.70  -4.30  2.1909172  0.25721334   0.4909172  -4.042787      1
#> 6     1  -6.90  -1.55 -0.6036608 -1.53812679  -7.5036608  -3.088127      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5240 -38825   6850 
#> initial  value 998.131940 
#> iter   2 value 823.982573
#> iter   3 value 821.040668
#> iter   4 value 817.704584
#> iter   5 value 773.195450
#> iter   6 value 763.019507
#> iter   7 value 761.524643
#> iter   8 value 761.492486
#> iter   9 value 761.492462
#> iter  10 value 761.492272
#> iter  10 value 761.492270
#> iter  11 value 761.492221
#> iter  11 value 761.492211
#> iter  11 value 761.492210
#> final  value 761.492210 
#> converged
#> This is Run number  103 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.4537448  0.5306759  -0.8962552 -11.669324      1
#> 2     1  -6.20  -3.90  2.0038873  0.7907346  -4.1961127  -3.109265      2
#> 3     1 -14.20  -5.80  0.9048046  1.1175996 -13.2951954  -4.682400      2
#> 4     1  -2.10 -13.20  0.4674015  0.7068261  -1.6325985 -12.493174      1
#> 5     1  -1.70  -4.30  0.7021442  1.8859523  -0.9978558  -2.414048      1
#> 6     1  -6.90  -1.55 -0.3290045 -0.9432886  -7.2290045  -2.493289      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -38075   7275 
#> initial  value 998.131940 
#> iter   2 value 832.464692
#> iter   3 value 829.957257
#> iter   4 value 826.501729
#> iter   5 value 778.507509
#> iter   6 value 768.622799
#> iter   7 value 767.127165
#> iter   8 value 767.098667
#> iter   9 value 767.098497
#> iter   9 value 767.098488
#> iter   9 value 767.098488
#> final  value 767.098488 
#> converged
#> This is Run number  104 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.40140541  0.7093695  -2.751405 -11.4906305      1
#> 2     1  -6.20  -3.90  1.90602588 -0.4218238  -4.293974  -4.3218238      1
#> 3     1 -14.20  -5.80  1.15946145  3.5923799 -13.040539  -2.2076201      2
#> 4     1  -2.10 -13.20 -0.08381045  0.9720079  -2.183810 -12.2279921      1
#> 5     1  -1.70  -4.30 -0.01500206  0.8907941  -1.715002  -3.4092059      1
#> 6     1  -6.90  -1.55 -0.52757926  2.4772321  -7.427579   0.9272321      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4940 -35150   7100 
#> initial  value 998.131940 
#> iter   2 value 871.478534
#> iter   3 value 860.992859
#> iter   4 value 860.463363
#> iter   5 value 815.861088
#> iter   6 value 808.285567
#> iter   7 value 806.686941
#> iter   8 value 806.643973
#> iter   9 value 806.643460
#> iter  10 value 806.643289
#> iter  11 value 806.643046
#> iter  12 value 806.642932
#> iter  12 value 806.642932
#> iter  12 value 806.642932
#> final  value 806.642932 
#> converged
#> This is Run number  105 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.5000914 -0.30229569  -1.849909 -12.502296      1
#> 2     1  -6.20  -3.90  1.3090386 -0.69365525  -4.890961  -4.593655      2
#> 3     1 -14.20  -5.80 -1.3005179 -0.99797290 -15.500518  -6.797973      2
#> 4     1  -2.10 -13.20  0.3932459  0.05412133  -1.706754 -13.145879      1
#> 5     1  -1.70  -4.30  0.5934903  3.30139397  -1.106510  -0.998606      2
#> 6     1  -6.90  -1.55 -0.4097989 -0.72167328  -7.309799  -2.271673      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4620 -36650   8350 
#> initial  value 998.131940 
#> iter   2 value 845.348771
#> iter   3 value 830.468515
#> iter   4 value 829.646273
#> iter   5 value 788.437234
#> iter   6 value 780.413280
#> iter   7 value 779.288065
#> iter   8 value 779.247129
#> iter   9 value 779.246413
#> iter  10 value 779.246223
#> iter  11 value 779.245991
#> iter  12 value 779.245833
#> iter  12 value 779.245833
#> iter  12 value 779.245833
#> final  value 779.245833 
#> converged
#> This is Run number  106 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  3.4489183 -0.8182376   1.098918 -13.018238      1
#> 2     1  -6.20  -3.90  2.1715747  2.4147744  -4.028425  -1.485226      2
#> 3     1 -14.20  -5.80  0.7769808  1.5580908 -13.423019  -4.241909      2
#> 4     1  -2.10 -13.20 -0.6056746  0.6472338  -2.705675 -12.552766      1
#> 5     1  -1.70  -4.30  2.9298958  1.9208159   1.229896  -2.379184      1
#> 6     1  -6.90  -1.55  0.7805345 -0.5311440  -6.119465  -2.081144      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4900 -37725   7875 
#> initial  value 998.131940 
#> iter   2 value 833.927016
#> iter   3 value 833.427321
#> iter   4 value 831.379188
#> iter   5 value 780.762018
#> iter   6 value 771.061512
#> iter   7 value 769.567631
#> iter   8 value 769.540379
#> iter   9 value 769.539960
#> iter  10 value 769.539789
#> iter  11 value 769.539753
#> iter  12 value 769.539663
#> iter  12 value 769.539663
#> iter  12 value 769.539663
#> final  value 769.539663 
#> converged
#> This is Run number  107 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.03161072 -0.6483865  -2.318389 -12.8483865      1
#> 2     1  -6.20  -3.90 -0.83412787 -0.8700861  -7.034128  -4.7700861      2
#> 3     1 -14.20  -5.80  0.81627812  1.1674127 -13.383722  -4.6325873      2
#> 4     1  -2.10 -13.20  0.32777239 -0.5539485  -1.772228 -13.7539485      1
#> 5     1  -1.70  -4.30  0.23990160  2.3436375  -1.460098  -1.9563625      1
#> 6     1  -6.90  -1.55  1.66923123  0.8466937  -5.230769  -0.7033063      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5800 -39200   8300 
#> initial  value 998.131940 
#> iter   2 value 809.819226
#> iter   3 value 809.115534
#> iter   4 value 808.820495
#> iter   5 value 762.987148
#> iter   6 value 752.913973
#> iter   7 value 751.449182
#> iter   8 value 751.425478
#> iter   9 value 751.425287
#> iter  10 value 751.424868
#> iter  11 value 751.424780
#> iter  12 value 751.424679
#> iter  12 value 751.424679
#> iter  12 value 751.424679
#> final  value 751.424679 
#> converged
#> This is Run number  108 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.2108041  1.0967799  -2.139196 -11.1032201      1
#> 2     1  -6.20  -3.90  0.4956491 -0.2418877  -5.704351  -4.1418877      2
#> 3     1 -14.20  -5.80  0.7063748 -0.1584985 -13.493625  -5.9584985      2
#> 4     1  -2.10 -13.20  0.7124667 -0.4456100  -1.387533 -13.6456100      1
#> 5     1  -1.70  -4.30  0.2598926 -0.7813890  -1.440107  -5.0813890      1
#> 6     1  -6.90  -1.55 -0.9386438  1.3496515  -7.838644  -0.2003485      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4840 -37200   8425 
#> initial  value 998.131940 
#> iter   2 value 837.647995
#> iter   3 value 822.742205
#> iter   4 value 822.142081
#> iter   5 value 782.276052
#> iter   6 value 774.070759
#> iter   7 value 772.997513
#> iter   8 value 772.956073
#> iter   9 value 772.955320
#> iter  10 value 772.955114
#> iter  11 value 772.954838
#> iter  12 value 772.954651
#> iter  12 value 772.954651
#> iter  12 value 772.954651
#> final  value 772.954651 
#> converged
#> This is Run number  109 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.4600599  1.4704877  -2.810060 -10.729512      1
#> 2     1  -6.20  -3.90  2.5049667  0.5602735  -3.695033  -3.339726      2
#> 3     1 -14.20  -5.80 -0.5291462 -0.2513481 -14.729146  -6.051348      2
#> 4     1  -2.10 -13.20 -0.3335472 -1.4429086  -2.433547 -14.642909      1
#> 5     1  -1.70  -4.30 -0.6569452  0.3729968  -2.356945  -3.927003      1
#> 6     1  -6.90  -1.55  0.7496052  0.2483555  -6.150395  -1.301644      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4900 -37225   8000 
#> initial  value 998.131940 
#> iter   2 value 840.008831
#> iter   3 value 826.387453
#> iter   4 value 825.518935
#> iter   5 value 785.231876
#> iter   6 value 776.911707
#> iter   7 value 775.619076
#> iter   8 value 775.568739
#> iter   9 value 775.567833
#> iter  10 value 775.567629
#> iter  11 value 775.567388
#> iter  12 value 775.567211
#> iter  12 value 775.567211
#> iter  12 value 775.567211
#> final  value 775.567211 
#> converged
#> This is Run number  110 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  0.2036090  0.7283846  -2.1463910 -11.4716154      1
#> 2     1  -6.20  -3.90  0.4676617  0.2784334  -5.7323383  -3.6215666      2
#> 3     1 -14.20  -5.80  0.1859984  0.1470979 -14.0140016  -5.6529021      2
#> 4     1  -2.10 -13.20 -0.3001097  2.0874261  -2.4001097 -11.1125739      1
#> 5     1  -1.70  -4.30  1.2791438 -0.3651491  -0.4208562  -4.6651491      1
#> 6     1  -6.90  -1.55  0.9454083  1.6593665  -5.9545917   0.1093665      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4340 -36700   8550 
#> initial  value 998.131940 
#> iter   2 value 843.242397
#> iter   3 value 827.202216
#> iter   4 value 825.910783
#> iter   5 value 784.446618
#> iter   6 value 776.494698
#> iter   7 value 775.398651
#> iter   8 value 775.355386
#> iter   9 value 775.354612
#> iter  10 value 775.354453
#> iter  11 value 775.354278
#> iter  12 value 775.354144
#> iter  12 value 775.354144
#> iter  12 value 775.354144
#> final  value 775.354144 
#> converged
#> This is Run number  111 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.8473046 -0.02600532  -3.197305 -12.226005      1
#> 2     1  -6.20  -3.90  0.9876186 -1.22564925  -5.212381  -5.125649      2
#> 3     1 -14.20  -5.80  1.9564033 -0.62091324 -12.243597  -6.420913      2
#> 4     1  -2.10 -13.20 -0.4117944 -0.92077981  -2.511794 -14.120780      1
#> 5     1  -1.70  -4.30  0.0789743  2.31062567  -1.621026  -1.989374      1
#> 6     1  -6.90  -1.55 -0.9954379  0.30736517  -7.895438  -1.242635      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5080 -37175   6875 
#> initial  value 998.131940 
#> iter   2 value 847.092228
#> iter   3 value 846.758717
#> iter   4 value 844.602380
#> iter   5 value 794.290087
#> iter   6 value 784.662819
#> iter   7 value 783.103648
#> iter   8 value 783.069596
#> iter   9 value 783.069455
#> iter  10 value 783.069089
#> iter  10 value 783.069089
#> iter  11 value 783.069074
#> iter  12 value 783.069033
#> iter  12 value 783.069033
#> iter  12 value 783.069031
#> final  value 783.069031 
#> converged
#> This is Run number  112 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.32851519  1.1561615  -2.678515 -11.043839      1
#> 2     1  -6.20  -3.90  0.07855314  1.1513832  -6.121447  -2.748617      2
#> 3     1 -14.20  -5.80 -1.38328018  1.4413701 -15.583280  -4.358630      2
#> 4     1  -2.10 -13.20  0.81934598  1.6632724  -1.280654 -11.536728      1
#> 5     1  -1.70  -4.30 -0.73046403  2.1756354  -2.430464  -2.124365      2
#> 6     1  -6.90  -1.55  1.79683636 -0.5629719  -5.103164  -2.112972      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4420 -36800   8650 
#> initial  value 998.131940 
#> iter   2 value 841.319488
#> iter   3 value 825.109759
#> iter   4 value 824.051122
#> iter   5 value 783.065683
#> iter   6 value 775.106269
#> iter   7 value 774.068757
#> iter   8 value 774.027742
#> iter   9 value 774.027001
#> iter  10 value 774.026831
#> iter  11 value 774.026624
#> iter  12 value 774.026475
#> iter  12 value 774.026475
#> iter  12 value 774.026475
#> final  value 774.026475 
#> converged
#> This is Run number  113 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.67908208 -0.6172328  -3.029082 -12.8172328      1
#> 2     1  -6.20  -3.90 -0.17856471  0.2350492  -6.378565  -3.6649508      2
#> 3     1 -14.20  -5.80  0.24288854  3.4118086 -13.957111  -2.3881914      2
#> 4     1  -2.10 -13.20  0.70465092  2.1744507  -1.395349 -11.0255493      1
#> 5     1  -1.70  -4.30  0.02635375  1.4552814  -1.673646  -2.8447186      1
#> 6     1  -6.90  -1.55  0.09274352  0.7452774  -6.807256  -0.8047226      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3980 -35975   7550 
#> initial  value 998.131940 
#> iter   2 value 858.355060
#> iter   3 value 857.217708
#> iter   4 value 853.269406
#> iter   5 value 797.407201
#> iter   6 value 788.367794
#> iter   7 value 786.849729
#> iter   8 value 786.826365
#> iter   9 value 786.826258
#> iter  10 value 786.826165
#> iter  10 value 786.826165
#> iter  11 value 786.826143
#> iter  12 value 786.826129
#> iter  12 value 786.826129
#> iter  12 value 786.826128
#> final  value 786.826128 
#> converged
#> This is Run number  114 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1           e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.21211488  0.0002347488  -2.562115 -12.199765      1
#> 2     1  -6.20  -3.90  0.54538410  0.1543775376  -5.654616  -3.745622      2
#> 3     1 -14.20  -5.80  1.14179789 -0.6938781477 -13.058202  -6.493878      2
#> 4     1  -2.10 -13.20 -0.92658971  0.8548961868  -3.026590 -12.345104      1
#> 5     1  -1.70  -4.30 -0.71589547 -1.1728768929  -2.415895  -5.472877      1
#> 6     1  -6.90  -1.55 -0.03692229 -0.2732348157  -6.936922  -1.823235      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4120 -35175   9100 
#> initial  value 998.131940 
#> iter   2 value 858.439609
#> iter   3 value 840.955349
#> iter   4 value 840.470566
#> iter   5 value 797.888984
#> iter   6 value 790.669628
#> iter   7 value 789.886996
#> iter   8 value 789.865183
#> iter   9 value 789.864869
#> iter  10 value 789.864736
#> iter  11 value 789.864545
#> iter  12 value 789.864444
#> iter  12 value 789.864444
#> iter  12 value 789.864444
#> final  value 789.864444 
#> converged
#> This is Run number  115 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -1.0877371  0.5322919  -3.437737 -11.667708      1
#> 2     1  -6.20  -3.90 -1.0644939 -0.4748330  -7.264494  -4.374833      2
#> 3     1 -14.20  -5.80  0.1388093  0.7215145 -14.061191  -5.078485      2
#> 4     1  -2.10 -13.20  0.8783040 -1.2465353  -1.221696 -14.446535      1
#> 5     1  -1.70  -4.30  0.4531047 -0.5759108  -1.246895  -4.875911      1
#> 6     1  -6.90  -1.55 -0.4005852 -0.3492541  -7.300585  -1.899254      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4340 -37525   8100 
#> initial  value 998.131940 
#> iter   2 value 835.030800
#> iter   3 value 832.976787
#> iter   4 value 829.244684
#> iter   5 value 777.548338
#> iter   6 value 768.019109
#> iter   7 value 766.494836
#> iter   8 value 766.471117
#> iter   9 value 766.470917
#> iter  10 value 766.470771
#> iter  10 value 766.470770
#> iter  11 value 766.470751
#> iter  12 value 766.470723
#> iter  12 value 766.470723
#> iter  12 value 766.470718
#> final  value 766.470718 
#> converged
#> This is Run number  116 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.5140125 -1.36609455  -2.864012 -13.566095      1
#> 2     1  -6.20  -3.90  0.5196158  0.17772103  -5.680384  -3.722279      2
#> 3     1 -14.20  -5.80  2.0144796  0.82693930 -12.185520  -4.973061      2
#> 4     1  -2.10 -13.20 -0.6178215  0.75858402  -2.717822 -12.441416      1
#> 5     1  -1.70  -4.30 -0.6795010 -0.04639285  -2.379501  -4.346393      1
#> 6     1  -6.90  -1.55  0.1580696  0.07871844  -6.741930  -1.471282      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4280 -38475   9225 
#> initial  value 998.131940 
#> iter   2 value 814.059877
#> iter   3 value 810.974415
#> iter   4 value 807.456986
#> iter   5 value 756.781021
#> iter   6 value 747.340702
#> iter   7 value 745.733679
#> iter   8 value 745.708610
#> iter   9 value 745.708435
#> iter  10 value 745.708349
#> iter  10 value 745.708347
#> iter  10 value 745.708346
#> final  value 745.708346 
#> converged
#> This is Run number  117 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.09137498  3.6127809  -2.4413750  -8.5872191      1
#> 2     1  -6.20  -3.90  0.11303570 -0.2336817  -6.0869643  -4.1336817      2
#> 3     1 -14.20  -5.80  0.18366531  3.7779450 -14.0163347  -2.0220550      2
#> 4     1  -2.10 -13.20 -0.43863862 -0.1814993  -2.5386386 -13.3814993      1
#> 5     1  -1.70  -4.30  2.09093679 -0.6909362   0.3909368  -4.9909362      1
#> 6     1  -6.90  -1.55 -0.24385128  0.8031512  -7.1438513  -0.7468488      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4520 -37150   7625 
#> initial  value 998.131940 
#> iter   2 value 843.098724
#> iter   3 value 841.898313
#> iter   4 value 838.707941
#> iter   5 value 786.695234
#> iter   6 value 777.186229
#> iter   7 value 775.679939
#> iter   8 value 775.653690
#> iter   9 value 775.653460
#> iter  10 value 775.653284
#> iter  10 value 775.653283
#> iter  11 value 775.653255
#> iter  12 value 775.653225
#> iter  12 value 775.653225
#> iter  12 value 775.653217
#> final  value 775.653217 
#> converged
#> This is Run number  118 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  2.7345434 -0.9716435   0.3845434 -13.1716435      1
#> 2     1  -6.20  -3.90  2.6798949 -0.4213632  -3.5201051  -4.3213632      1
#> 3     1 -14.20  -5.80 -0.2692402 -0.4905069 -14.4692402  -6.2905069      2
#> 4     1  -2.10 -13.20 -0.6984046  0.5068236  -2.7984046 -12.6931764      1
#> 5     1  -1.70  -4.30  0.5454713  0.1233905  -1.1545287  -4.1766095      1
#> 6     1  -6.90  -1.55 -0.9141432  2.3300929  -7.8141432   0.7800929      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5520 -37075   6150 
#> initial  value 998.131940 
#> iter   2 value 851.968660
#> iter   3 value 843.755045
#> iter   4 value 842.522639
#> iter   5 value 800.924950
#> iter   6 value 792.633830
#> iter   7 value 790.167799
#> iter   8 value 790.071787
#> iter   9 value 790.070333
#> iter  10 value 790.070250
#> iter  11 value 790.069994
#> iter  12 value 790.069742
#> iter  12 value 790.069742
#> iter  12 value 790.069742
#> final  value 790.069742 
#> converged
#> This is Run number  119 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  2.0366815 -0.09483435  -0.3133185 -12.294834      1
#> 2     1  -6.20  -3.90  0.1135647  0.87455300  -6.0864353  -3.025447      2
#> 3     1 -14.20  -5.80 -0.7157262 -1.27910309 -14.9157262  -7.079103      2
#> 4     1  -2.10 -13.20  0.2852741  0.02788709  -1.8147259 -13.172113      1
#> 5     1  -1.70  -4.30 -0.3721056  0.20768438  -2.0721056  -4.092316      1
#> 6     1  -6.90  -1.55 -0.2523304 -0.26971477  -7.1523304  -1.819715      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4760 -39125   7250 
#> initial  value 998.131940 
#> iter   2 value 817.237940
#> iter   3 value 811.744572
#> iter   4 value 806.499551
#> iter   5 value 762.577763
#> iter   6 value 752.455199
#> iter   7 value 750.990088
#> iter   8 value 750.962768
#> iter   9 value 750.962742
#> iter  10 value 750.962661
#> iter  10 value 750.962660
#> iter  10 value 750.962654
#> final  value 750.962654 
#> converged
#> This is Run number  120 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.24027988  0.5732353  -1.109720 -11.626765      1
#> 2     1  -6.20  -3.90 -0.48024159 -0.4890192  -6.680242  -4.389019      2
#> 3     1 -14.20  -5.80 -0.38233676 -0.2497660 -14.582337  -6.049766      2
#> 4     1  -2.10 -13.20 -0.64242042 -0.5240717  -2.742420 -13.724072      1
#> 5     1  -1.70  -4.30 -0.09939448  2.2864335  -1.799394  -2.013567      1
#> 6     1  -6.90  -1.55  1.33511071 -1.1720366  -5.564889  -2.722037      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   3400 -36150   8950 
#> initial  value 998.131940 
#> iter   2 value 846.639551
#> iter   3 value 845.781297
#> iter   4 value 840.673805
#> iter   5 value 781.963073
#> iter   6 value 773.082551
#> iter   7 value 771.388196
#> iter   8 value 771.366187
#> iter   9 value 771.366155
#> iter  10 value 771.366114
#> iter  11 value 771.366097
#> iter  11 value 771.366093
#> iter  11 value 771.366093
#> final  value 771.366093 
#> converged
#> This is Run number  121 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1        e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.04222054 -0.2485311  -2.392221 -12.4485311      1
#> 2     1  -6.20  -3.90 -1.03776776  2.6307776  -7.237768  -1.2692224      2
#> 3     1 -14.20  -5.80  0.58557080 -1.1741697 -13.614429  -6.9741697      2
#> 4     1  -2.10 -13.20  0.34353713  1.4942259  -1.756463 -11.7057741      1
#> 5     1  -1.70  -4.30  0.51756185  2.9132265  -1.182438  -1.3867735      1
#> 6     1  -6.90  -1.55 -0.19531985  0.7059419  -7.095320  -0.8440581      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5340 -37175   6775 
#> initial  value 998.131940 
#> iter   2 value 847.612138
#> iter   3 value 837.776639
#> iter   4 value 836.702336
#> iter   5 value 795.650996
#> iter   6 value 787.253424
#> iter   7 value 785.231997
#> iter   8 value 785.154154
#> iter   9 value 785.152942
#> iter  10 value 785.152926
#> iter  11 value 785.152663
#> iter  12 value 785.152311
#> iter  12 value 785.152311
#> iter  12 value 785.152311
#> final  value 785.152311 
#> converged
#> This is Run number  122 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2       e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 1.0016892  2.3143741  -1.3483108  -9.885626      1
#> 2     1  -6.20  -3.90 1.6101777  1.2950576  -4.5898223  -2.604942      2
#> 3     1 -14.20  -5.80 1.9642354 -0.2866202 -12.2357646  -6.086620      2
#> 4     1  -2.10 -13.20 1.2871474  1.0206118  -0.8128526 -12.179388      1
#> 5     1  -1.70  -4.30 1.1514761  0.5088446  -0.5485239  -3.791155      1
#> 6     1  -6.90  -1.55 0.8105237 -0.3219842  -6.0894763  -1.871984      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4980 -38725   7325 
#> initial  value 998.131940 
#> iter   2 value 822.853584
#> iter   3 value 819.655096
#> iter   4 value 816.069924
#> iter   5 value 770.295687
#> iter   6 value 760.245544
#> iter   7 value 758.785174
#> iter   8 value 758.757404
#> iter   9 value 758.757151
#> iter  10 value 758.757124
#> iter  10 value 758.757120
#> iter  10 value 758.757117
#> final  value 758.757117 
#> converged
#> This is Run number  123 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1       e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.1505136  5.677472  -2.5005136  -6.522528      1
#> 2     1  -6.20  -3.90  3.1014103 -1.040188  -3.0985897  -4.940188      1
#> 3     1 -14.20  -5.80  0.9785421  1.629698 -13.2214579  -4.170302      2
#> 4     1  -2.10 -13.20  2.5095816  2.671151   0.4095816 -10.528849      1
#> 5     1  -1.70  -4.30  0.5502141  1.907676  -1.1497859  -2.392324      1
#> 6     1  -6.90  -1.55 -0.6353017  1.189380  -7.5353017  -0.360620      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4540 -35825   7625 
#> initial  value 998.131940 
#> iter   2 value 860.231791
#> iter   3 value 847.487802
#> iter   4 value 846.292879
#> iter   5 value 802.670157
#> iter   6 value 794.836996
#> iter   7 value 793.374416
#> iter   8 value 793.326133
#> iter   9 value 793.325412
#> iter  10 value 793.325246
#> iter  11 value 793.325043
#> iter  12 value 793.324920
#> iter  12 value 793.324920
#> iter  12 value 793.324920
#> final  value 793.324920 
#> converged
#> This is Run number  124 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.9123980  0.38570156  -3.262398 -11.814298      1
#> 2     1  -6.20  -3.90  1.5498398 -0.09666985  -4.650160  -3.996670      2
#> 3     1 -14.20  -5.80 -1.3184796 -0.01495153 -15.518480  -5.814952      2
#> 4     1  -2.10 -13.20 -1.4884834  0.19432379  -3.588483 -13.005676      1
#> 5     1  -1.70  -4.30 -0.4161544  0.60705575  -2.116154  -3.692944      1
#> 6     1  -6.90  -1.55  0.1930911  0.20397130  -6.706909  -1.346029      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4100 -35750   8150 
#> initial  value 998.131940 
#> iter   2 value 857.706440
#> iter   3 value 842.715591
#> iter   4 value 841.057462
#> iter   5 value 797.154901
#> iter   6 value 789.448607
#> iter   7 value 788.193302
#> iter   8 value 788.149515
#> iter   9 value 788.148832
#> iter  10 value 788.148700
#> iter  11 value 788.148568
#> iter  12 value 788.148471
#> iter  12 value 788.148471
#> iter  12 value 788.148471
#> final  value 788.148471 
#> converged
#> This is Run number  125 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.7573370  0.3504043  -1.592663 -11.849596      1
#> 2     1  -6.20  -3.90 -0.4384079  1.3770454  -6.638408  -2.522955      2
#> 3     1 -14.20  -5.80 -0.8598882  1.3788316 -15.059888  -4.421168      2
#> 4     1  -2.10 -13.20 -0.5838965  0.5965356  -2.683897 -12.603464      1
#> 5     1  -1.70  -4.30 -0.5884171 -0.4921006  -2.288417  -4.792101      1
#> 6     1  -6.90  -1.55  0.2653371  1.2149100  -6.634663  -0.335090      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4760 -37225   7175 
#> initial  value 998.131940 
#> iter   2 value 844.736737
#> iter   3 value 843.548964
#> iter   4 value 840.610099
#> iter   5 value 789.840495
#> iter   6 value 780.231657
#> iter   7 value 778.710434
#> iter   8 value 778.680882
#> iter   9 value 778.680793
#> iter  10 value 778.680467
#> iter  10 value 778.680467
#> iter  11 value 778.680437
#> iter  11 value 778.680433
#> iter  11 value 778.680432
#> final  value 778.680432 
#> converged
#> This is Run number  126 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.6756415  0.7055207  -3.0256415 -11.494479      1
#> 2     1  -6.20  -3.90  0.3086389  0.6147182  -5.8913611  -3.285282      2
#> 3     1 -14.20  -5.80 -0.2258853  0.2674702 -14.4258853  -5.532530      2
#> 4     1  -2.10 -13.20 -0.2322854  0.5821128  -2.3322854 -12.617887      1
#> 5     1  -1.70  -4.30  1.8727015  0.9561527   0.1727015  -3.343847      1
#> 6     1  -6.90  -1.55  1.3664775 -0.8963681  -5.5335225  -2.446368      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5220 -36125   7750 
#> initial  value 998.131940 
#> iter   2 value 855.878662
#> iter   3 value 843.854416
#> iter   4 value 843.718269
#> iter   5 value 801.873280
#> iter   6 value 793.881447
#> iter   7 value 792.606571
#> iter   8 value 792.571120
#> iter   9 value 792.570679
#> iter  10 value 792.570522
#> iter  11 value 792.570287
#> iter  12 value 792.570150
#> iter  12 value 792.570150
#> iter  12 value 792.570150
#> final  value 792.570150 
#> converged
#> This is Run number  127 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2         e_1       e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.18239791  5.014974  -2.532398  -7.185026      1
#> 2     1  -6.20  -3.90 -0.09821512  1.093688  -6.298215  -2.806312      2
#> 3     1 -14.20  -5.80  1.70352244  1.032816 -12.496478  -4.767184      2
#> 4     1  -2.10 -13.20 -0.39841541  2.254206  -2.498415 -10.945794      1
#> 5     1  -1.70  -4.30 -1.34278337  1.479273  -3.042783  -2.820727      2
#> 6     1  -6.90  -1.55  0.94808958 -1.994770  -5.951910  -3.544770      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4820 -38050   8150 
#> initial  value 998.131940 
#> iter   2 value 827.656968
#> iter   3 value 826.516513
#> iter   4 value 824.225901
#> iter   5 value 774.178354
#> iter   6 value 764.457903
#> iter   7 value 762.963210
#> iter   8 value 762.938271
#> iter   9 value 762.937932
#> iter  10 value 762.937729
#> iter  11 value 762.937705
#> iter  12 value 762.937623
#> iter  12 value 762.937623
#> iter  12 value 762.937623
#> final  value 762.937623 
#> converged
#> This is Run number  128 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20  3.1651854  0.1840418   0.8151854 -12.0159582      1
#> 2     1  -6.20  -3.90 -0.4119567  1.5007353  -6.6119567  -2.3992647      2
#> 3     1 -14.20  -5.80  1.3404447 -0.5106557 -12.8595553  -6.3106557      2
#> 4     1  -2.10 -13.20 -0.7945385  3.4739843  -2.8945385  -9.7260157      1
#> 5     1  -1.70  -4.30  0.5125475  0.5148778  -1.1874525  -3.7851222      1
#> 6     1  -6.90  -1.55 -0.2390756  0.6835191  -7.1390756  -0.8664809      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5040 -38375   8250 
#> initial  value 998.131940 
#> iter   2 value 822.437503
#> iter   3 value 821.473704
#> iter   4 value 819.788360
#> iter   5 value 770.696397
#> iter   6 value 760.886765
#> iter   7 value 759.398912
#> iter   8 value 759.374124
#> iter   9 value 759.373895
#> iter  10 value 759.373687
#> iter  10 value 759.373685
#> iter  10 value 759.373683
#> final  value 759.373683 
#> converged
#> This is Run number  129 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2          e_1         e_2        U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  0.030228998 -0.81525133  -2.319771 -13.015251      1
#> 2     1  -6.20  -3.90 -0.002161270  0.46314506  -6.202161  -3.436855      2
#> 3     1 -14.20  -5.80 -0.005469986  3.18949727 -14.205470  -2.610503      2
#> 4     1  -2.10 -13.20 -1.801684136 -0.36667101  -3.901684 -13.566671      1
#> 5     1  -1.70  -4.30 -1.152923130  0.24832529  -2.852923  -4.051675      1
#> 6     1  -6.90  -1.55 -0.134797343  0.03610368  -7.034797  -1.513896      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   4980 -37875   7950 
#> initial  value 998.131940 
#> iter   2 value 831.398350
#> iter   3 value 830.960214
#> iter   4 value 829.141569
#> iter   5 value 778.892601
#> iter   6 value 769.149129
#> iter   7 value 767.656557
#> iter   8 value 767.629426
#> iter   9 value 767.628970
#> iter  10 value 767.628849
#> iter  11 value 767.628809
#> iter  12 value 767.628684
#> iter  12 value 767.628684
#> iter  12 value 767.628684
#> final  value 767.628684 
#> converged
#> This is Run number  130 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1          U_2 CHOICE
#> 1     1  -2.35 -12.20  2.5125512  0.5868629   0.1625512 -11.61313705      1
#> 2     1  -6.20  -3.90 -0.1876644  3.3903967  -6.3876644  -0.50960325      2
#> 3     1 -14.20  -5.80  0.3928805 -0.8712741 -13.8071195  -6.67127413      2
#> 4     1  -2.10 -13.20 -0.2093922 -1.1212865  -2.3093922 -14.32128651      1
#> 5     1  -1.70  -4.30  0.1461210  1.6551210  -1.5538790  -2.64487902      1
#> 6     1  -6.90  -1.55  0.3450829  1.4968477  -6.5549171  -0.05315232      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5120 -39025   7450 
#> initial  value 998.131940 
#> iter   2 value 817.736729
#> iter   3 value 814.728745
#> iter   4 value 811.574235
#> iter   5 value 766.560236
#> iter   6 value 756.464096
#> iter   7 value 755.030437
#> iter   8 value 755.003261
#> iter   9 value 755.002919
#> iter  10 value 755.002882
#> iter  10 value 755.002879
#> iter  11 value 755.002849
#> iter  12 value 755.002742
#> iter  12 value 755.002735
#> iter  13 value 755.002720
#> iter  13 value 755.002720
#> iter  13 value 755.002719
#> final  value 755.002719 
#> converged
#> This is Run number  131 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2        U_1         U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.2060631 -0.01558264  -2.556063 -12.2155826      1
#> 2     1  -6.20  -3.90  0.7707421  0.77263842  -5.429258  -3.1273616      2
#> 3     1 -14.20  -5.80  1.6044850  1.24227409 -12.595515  -4.5577259      2
#> 4     1  -2.10 -13.20 -1.2009451  0.69290972  -3.300945 -12.5070903      1
#> 5     1  -1.70  -4.30  3.1853672  1.64548808   1.485367  -2.6545119      1
#> 6     1  -6.90  -1.55  2.4732815  2.01945264  -4.426718   0.4694526      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5440 -38275   6150 
#> initial  value 998.131940 
#> iter   2 value 835.402757
#> iter   3 value 833.206642
#> iter   4 value 830.291329
#> iter   5 value 785.227006
#> iter   6 value 775.168278
#> iter   7 value 773.476424
#> iter   8 value 773.433453
#> iter   9 value 773.433372
#> iter  10 value 773.433341
#> iter  10 value 773.433332
#> iter  10 value 773.433332
#> final  value 773.433332 
#> converged
#> This is Run number  132 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1        e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20  1.9666891 -0.3345445  -0.3833109 -12.534544      1
#> 2     1  -6.20  -3.90  0.3052846  1.6229937  -5.8947154  -2.277006      2
#> 3     1 -14.20  -5.80 -0.4057516  3.5136987 -14.6057516  -2.286301      2
#> 4     1  -2.10 -13.20  0.5944379  0.8094452  -1.5055621 -12.390555      1
#> 5     1  -1.70  -4.30 -0.1204873  3.1016291  -1.8204873  -1.198371      2
#> 6     1  -6.90  -1.55  2.2216167  2.5777421  -4.6783833   1.027742      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5620 -38500   6550 
#> initial  value 998.131940 
#> iter   2 value 830.215398
#> iter   3 value 828.997923
#> iter   4 value 826.987284
#> iter   5 value 781.797237
#> iter   6 value 771.660622
#> iter   7 value 770.079535
#> iter   8 value 770.040349
#> iter   9 value 770.040211
#> iter  10 value 770.039934
#> iter  10 value 770.039934
#> iter  11 value 770.039920
#> iter  12 value 770.039869
#> iter  12 value 770.039869
#> iter  12 value 770.039864
#> final  value 770.039864 
#> converged
#> This is Run number  133 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25      60      50     100      20     200      50     1
#> 5  1               29      20      50     100      80      50       0     1
#> 6  1               32      40     100      25      80      25      50     1
#>   group    V_1    V_2        e_1         e_2         U_1        U_2 CHOICE
#> 1     1  -2.35 -12.20 -0.8296372  6.78312244  -3.1796372  -5.416878      1
#> 2     1  -6.20  -3.90  1.3798955  1.40186349  -4.8201045  -2.498137      2
#> 3     1 -14.20  -5.80 -0.1950692  0.04042476 -14.3950692  -5.759575      2
#> 4     1  -2.10 -13.20  2.9033421  1.47087436   0.8033421 -11.729126      1
#> 5     1  -1.70  -4.30  1.1291111  0.30111061  -0.5708889  -3.998889      1
#> 6     1  -6.90  -1.55  0.5369565 -0.15209997  -6.3630435  -1.702100      2
#> 
#>  
#>  Initial function value: -998.1319 
#> Initial gradient value:
#> bpreis  blade bwarte 
#>   5680 -41450   8950 
#> initial  value 998.131940 
#> iter   2 value 769.549423
#> iter   3 value 764.266537
#> iter   4 value 763.046060
#> iter   5 value 724.028308
#> iter   6 value 714.649269
#> iter   7 value 713.202737
#> iter   8 value 713.170499
#> iter   9 value 713.170160
#> iter  10 value 713.169964
#> iter  11 value 713.169819
#> iter  12 value 713.169790
#> iter  12 value 713.169790
#> iter  12 value 713.169790
#> final  value 713.169790 
#> converged
#> This is Run number  134 
#>  does sou_gis exist:  FALSE 
#> 
#>  dataset final_set exists:  FALSE 
#> 
#>  decisiongroups exists:  TRUE
#>    1    2 
#> 1007  433 
#> 
#>  data has been created 
#> 
#>  First few observations of the dataset 
#>    ID Choice_situation alt1_x1 alt1_x2 alt1_x3 alt2_x1 alt2_x2 alt2_x3 Block
#> 1  1               12      60      25       0      20     200     100     1
#> 2  1               16      20     100      50      40      50       0     1
#> 3  1               17      20     200       0      80     100     100     1
#> 4  1               25 