% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_cluster.R
\name{sits_cluster_dendro}
\alias{sits_cluster_dendro}
\title{Find clusters in time series samples}
\usage{
sits_cluster_dendro(
  samples,
  bands = NULL,
  dist_method = "dtw_basic",
  linkage = "ward.D2",
  k = NULL,
  palette = "RdYlGn",
  ...
)
}
\arguments{
\item{samples}{Tibble with input set of time series (class "sits").}

\item{bands}{Bands to be used in the clustering
(character vector)}

\item{dist_method}{One of the supported distances (single char vector)
"dtw": DTW with a Sakoe-Chiba constraint.
"dtw2": DTW with L2 norm and Sakoe-Chiba constraint.
"dtw_basic": A faster DTW with less functionality.
"lbk": Keogh's lower bound for DTW.
"lbi": Lemire's lower bound for DTW.}

\item{linkage}{Agglomeration method to be used (single char vector)
One of "ward.D", "ward.D2", "single", "complete",
"average", "mcquitty", "median" or "centroid".}

\item{k}{Desired number of clusters (overrides default value)}

\item{palette}{Color palette as per `grDevices::hcl.pals()` function.}

\item{...}{Additional parameters to be passed
to dtwclust::tsclust() function.}
}
\value{
Tibble with "cluster" column (class "sits_cluster").
}
\description{
These functions support hierarchical agglomerative clustering in
sits. They provide support from creating a dendrogram and using it for
cleaning samples.

\code{link[sits]{sits_cluster_dendro()}} takes a tibble with time series and
produces a sits tibble with an added "cluster" column. The function first
calculates a dendrogram and obtains a validity index for best clustering
using the adjusted Rand Index. After cutting the dendrogram using the chosen
validity index, it assigns a cluster to each sample.

\code{link[sits]{sits_cluster_frequency()}} computes the contingency
table between labels
and clusters and produces a matrix.
Its input is a tibble produced by \code{link[sits]{sits_cluster_dendro()}}.

\code{link[sits]{sits_cluster_clean()}} takes a tibble with time series
that has an additional `cluster` produced by
\code{link[sits]{sits_cluster_dendro()}}
and removes labels that are minority in each cluster.
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # default
    clusters <- sits_cluster_dendro(cerrado_2classes)
    # with parameters
    clusters <- sits_cluster_dendro(cerrado_2classes,
        bands = "NDVI", k = 5
    )
}

}
\references{
"dtwclust" package (https://CRAN.R-project.org/package=dtwclust)
}
\author{
Rolf Simoes, \email{rolfsimoes@gmail.com}
}
