% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_tipo_caso_years}
\alias{plot_tipo_caso_years}
\title{Generar gráfico de distribución de casos por la clasificación
inicial del caso y los años seleccionados}
\usage{
plot_tipo_caso_years(
  data_agrupada,
  col_tipo = "tip_cas",
  col_year = "ano",
  fuente_data = NULL
)
}
\arguments{
\item{data_agrupada}{Un `data.frame` que contiene los datos de la
enfermedad o evento, agrupados por la clasificación inicial y los años
seleccionados.}

\item{col_tipo}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene la clasificación inicial del caso en los datos
agrupados de la enfermedad o evento; su valor por defecto es
`"tip_cas"`.}

\item{col_year}{Un `character` (cadena de caracteres) con el nombre de
la columna que contiene el año en los datos agrupados de la enfermedad
o evento; su valor por defecto es `"ano"`.}

\item{fuente_data}{Un `character` (cadena de caracteres) que contiene la
leyenda o fuente de información de los datos; su valor por defecto
es `NULL`.}
}
\value{
Un `plot` o gráfico de distribución de casos según su clasificación
inicial y los años seleccionados.
}
\description{
Función que genera un gráfico de distribución de casos
según su clasificación inicial y los años seleccionados.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(dengue2020)
data_agrupada <- agrupar_tipo_caso(
  data_event = data_limpia,
  cols_tipo = c(
    "tip_cas",
    "ano"
  )
)
plot_tipo_caso_years(data_agrupada,
  col_tipo = "tip_cas",
  col_year = "ano"
)
}
