% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mechanics.R
\name{parallax.corr}
\alias{parallax.corr}
\title{Corrected parallax for a given location and object altitude}
\usage{
parallax.corr(parallax, loc, altitude = 0)
}
\arguments{
\item{parallax}{Average parallax to correct (e.g. 0.00224 for the Sun, or 0.952 for the Moon)}

\item{loc}{This can be either the latitude of the location, or a \emph{skyscapeR.horizon} object.}

\item{altitude}{(Optional) Altitude of the celestial object.. Defaults to 0 degrees.}
}
\description{
Given the average parallax, this function corrects this value for a given latitude of the observer
and for the altitude of the celestial object.
}
\examples{
# Parallax correction for the moon, as seen from latitude 50ºN and at 0º altitude
parallax.corr(0.952, 50, 0)
}
