% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_vars.R
\name{skyscapeR.vars}
\alias{skyscapeR.vars}
\title{See and change the global variables used by skyscapeR}
\usage{
skyscapeR.vars(timezone, calendar, refraction, atm, temp, dec)
}
\arguments{
\item{timezone}{Timezone of input either as a known acronym (e.g. "GMT", "CET") or
a string with continent followed by country capital (e.g. "Europe/London"). See
\code{\link{timezones}} for details. Default is the system timezone}

\item{calendar}{Calendar used in parameter \emph{time}. G for gregorian and J for julian.
Defaults to \emph{Gregorian}.}

\item{refraction}{Whether atmospheric refraction is to be taken into account. Default is TRUE.}

\item{atm}{Atmospheric pressure for refraction calculation. Default is 1013.25 mbar.}

\item{temp}{Atmospheric temperature for refraction calculation. Default is 15 degrees.}

\item{dec}{Output declination: \emph{geo} for the geocentric, or \emph{topo} for the topocentric
frame of reference. Defaults to topocentric.}
}
\description{
See and change the global variables used by skyscapeR
}
\examples{
# Julian date at noon GMT on Christmas day 2018
time2jd('2018-12-25 12:00:00', 'GMT')
}
