% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{star}
\alias{star}
\title{Create \emph{skyscapeR.star} object}
\usage{
star(string, year = skyscapeR.env$cur.year)
}
\arguments{
\item{string}{This can be either the traditional name for the star or its Bayer designation.}

\item{year}{Year for which to calculate the coordinates.
Defaults to current year.}
}
\description{
This function retrieves information for a given star
and saves it in the \emph{skyscapeR.star} format ready to be
used by other skyscapeR package function.
}
\examples{
# Retrieve data for Aldebaran:
Aldeb <- star('Aldebaran')

# Retrieve data for Aldebaran on 2999 BC:
ss <- star('Aldebaran', -3000)
}
\seealso{
\code{\link[swephR]{swe_fixstar2_ut}}, \code{\link[swephR]{swe_fixstar2_mag}}
}
