% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.slcafit}
\alias{predict.slcafit}
\title{Model Predictions for Estimated \code{slca} Object}
\usage{
\method{predict}{slcafit}(object, newdata, type = c("class", "posterior"), ...)
}
\arguments{
\item{object}{An object of class \code{slcafit}, representing a fitted \code{slca} model.}

\item{newdata}{A \code{data.frame} containing the same variables as those used to estimate the \code{object}.}

\item{type}{A character string indicating the type of prediction. Use \code{"class"} to obtain the predicted class membership for each observation and latent class variable, or \code{"posterior"} to retrieve posterior probabilities for each class. The default is \code{"class"}.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A \code{data.frame} or \code{list} depending on the \code{type}:
\itemize{
\item For \code{type = "class"}, a \code{data.frame} is returned where rows represent observations and columns correspond to latent class variables.
\item For \code{type = "posterior"}, a \code{list} is returned containing \code{data.frame}s with posterior probabilities for each latent class variable.
}
}
\description{
Provides predicted class memberships or posterior probabilities for new data based on a fitted \code{slca} model.
}
