% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embedded.R
\name{embedded}
\alias{embedded}
\alias{embedded,sf-method}
\alias{embedded,SpatRaster-method}
\title{embedding spatial cross sectional data}
\usage{
\S4method{embedded}{sf}(data, target, E = 3, tau = 1, nb = NULL, detrend = FALSE)

\S4method{embedded}{SpatRaster}(data, target, E = 3, tau = 1, detrend = FALSE)
}
\arguments{
\item{data}{observation data.}

\item{target}{name of target variable.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of spatial lags.}

\item{nb}{(optional) neighbours list.}

\item{detrend}{(optional) whether to remove the linear trend.}
}
\value{
A matrix
}
\description{
embedding spatial cross sectional data
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
v = embedded(columbus,"crime")
v[1:5,]

cu = terra::rast(system.file("case/cu.tif", package="spEDM"))
r = embedded(cu,"cu")
r[1:5,]

}
