% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmatic.R
\name{sparse-arithmatic}
\alias{sparse-arithmatic}
\alias{sparse_multiplication}
\title{Vector arithmatic with sparse vectors}
\usage{
sparse_multiplication(x, y)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector.}
}
\value{
A sparse vector of same type.
}
\description{
Do arithmatic operations on sparse vectors while trying to void destroying
the sparsity.
}
\details{
Note that this function works with both sparse and dense vectors for both \code{x}
and \code{y}, returning a sparse or dense vector according to the input.

For \code{sparse_multiplication()} the class of the resulting vector depends on
the classes of \code{x} and \code{y}. If both \code{x} and \code{y} are integer vectors then an
integer vector is returned, otherwise a double vector is returned.

\code{sparse_multiplication()} will return a non-sparse vector if both \code{x} and \code{y}
is non-sparse. Otherwise a sparse vector is returned.

\code{sparse_multiplication()} will destroy sparsity of sparse vectors with non-0
\code{default} values.
}
\examples{
x_sparse <- sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10)

sparse_multiplication(x_sparse, x_sparse)
}
