% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{combine}
\alias{combine}
\title{raster combine}
\usage{
combine(x)
}
\arguments{
\item{x}{raster stack/brick or SpatialPixelsDataFrame object}
}
\value{
A ratified (factor) terra SpatRaster representing unique combinations.
}
\description{
Combines rasters into all unique combinations of inputs
}
\details{
A single ratified raster object is returned with the summary table
as the raster attribute table, this is most similar to the ESRI 
format resulting from their combine function. 
    
Please note that this is not a memory safe function that utilizes
out of memory in the manner that the terra package does.
}
\examples{
library(terra)

# Create example data (with a few NA's introduced)
 r1 <- rast(nrows=100, ncol=100)
   names(r1) <- "LC1"
   r1[] <- round(runif(ncell(r1), 1,4),0)
     r1[c(8,10,50,100)] <- NA
 r2 <- rast(nrows=100, ncol=100)
   names(r2) <- "LC2"
   r2[] <- round(runif(ncell(r2), 2,6),0)
     r2[c(10,50,100)] <- NA   
 r3 <- rast(nrows=100, ncol=100)
   names(r3) <- "LC3"
   r3[] <- round(runif(ncell(r3), 2,6),0)
     r3[c(10,50,100)] <- NA   
 r <- c(r1,r2,r3)  
   names(r) <- c("LC1","LC2","LC3")

 # Combine rasters with a multilayer stack
 cr <- combine(r)
   head(cr$summary)
   plot(cr$combine)

# or, from separate layers
 cr <- combine(c(r1,r3))

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
