% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.moments.R
\name{raster.moments}
\alias{raster.moments}
\title{Raster moments}
\usage{
raster.moments(x, type = "mean", s = 3, p = 0.75, ...)
}
\arguments{
\item{x}{A terra SpatRaster object}

\item{type}{The global statistic to represent the local deviation
options are: "min", "min", "mean", "median", "var, "sd", 
"mad", "kurt", "skew", "quantile"}

\item{s}{Size of matrix (focal window), can be single value or two 
values defining the [x,y] dimensions of the focal matrix}

\item{p}{if type="quantile", the returned percentile.}

\item{...}{Additional arguments passed to terra::focal}
}
\value{
A terra SpatRaster object representing the local distributional moment
}
\description{
Calculates focal statistical moments of a raster
}
\details{
This is a simple wrapper for the terra focal function, returning local statistical moments
}
\examples{
\donttest{
library(terra)
r <- rast(nrows=500, ncols=500, xmin=571823, xmax=616763, 
            ymin=4423540, ymax=4453690)
  crs(r) <- "epsg:9001"
r[] <- runif(ncell(r), 1000, 2500)

# Calculate 10th percentile for 3x3 window
r.p10 <- raster.moments(r, type="quantile", p=0.10) 
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
