% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran_multithreshold.R
\name{moran_multithreshold}
\alias{moran_multithreshold}
\title{Moran's I test on a numeric vector for different neighborhoods}
\usage{
moran_multithreshold(
  x = NULL,
  distance.matrix = NULL,
  distance.thresholds = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{Numeric vector, generally model residuals, Default: \code{NULL}}

\item{distance.matrix}{Distance matrix among cases in \code{x}. The number of rows of this matrix must be equal to the length of \code{x}. Default: \code{NULL}}

\item{distance.thresholds}{Numeric vector, distances below each value are set to 0 on separated copies of the distance matrix for the computation of Moran's I at different neighborhood distances. If \code{NULL}, it defaults to \code{seq(0, max(distance.matrix)/4, length.out = 2)}. Default: \code{NULL}}

\item{verbose}{Logical, if \code{TRUE}, plots Moran's I values for each distance threshold. Default: \code{TRUE}}
}
\value{
A named list with the slots:
\itemize{
\item \code{df}: Data frame with the results of \link{moran} per distance threshold.
\item \code{plot}: A plot of Moran's I across distance thresholds.
\item \code{max.moran}: Maximum value of Moran's I across thresholds.
\item \code{max.moran.distance.threshold}: Distance threshold with the maximum Moran's I value.
}
}
\description{
Applies \code{\link[=moran]{moran()}} to different distance thresholds at the same time.
}
\details{
Using different distance thresholds helps to take into account the uncertainty about what "neighborhood" means in ecological systems (1000km in geological time means little, but 100m might be quite a long distance for a tree to disperse seeds over), and allows to explore spatial autocorrelation of model residuals for several minimum-distance criteria at once.
}
\examples{
if(interactive()){

 #loading example data
 data(distance_matrix)
 data(plant_richness)

 #computing Moran's I for the response variable at several reference distances
 out <- moran_multithreshold(
   x = plant_richness$richness_species_vascular,
   distance.matrix = distance_matrix,
   distance.thresholds = c(0, 100, 1000, 10000),
   plot = TRUE
   )
 out

}
}
\seealso{
\code{\link[=moran]{moran()}}
}
