% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_patch_indic_methods.R
\name{patchdistr_sews_predict}
\alias{patchdistr_sews_predict}
\alias{predict.patchdistr_sews_single}
\title{predict method for patchdistr_sews objects}
\usage{
\method{predict}{patchdistr_sews_single}(object, ..., newdata = NULL, best_only = FALSE, xmin_rescale = FALSE)
}
\arguments{
\item{object}{An \code{\link{patchdistr_sews}} object}

\item{...}{Additional arguments (ignored)}

\item{newdata}{A vector of patch sizes at which the fit is returned (default 
to 200 regularly-spaced values).}

\item{best_only}{Return values for only the best fit of each element (matrix)
in \code{object}, or return the values for all fitted distribution.}

\item{xmin_rescale}{If the xmin value used for fits is above one, then setting this
to \code{TRUE} will rescale the predicted probabilities so that they align on 
the cumulative distribution of the observed patch sizes}
}
\value{
A list with component \code{obs}, a \code{data.frame} containing the observed 
  distribution values and \code{pred}, a \code{data.frame} containing the fitted 
  values. Both \code{data.frame}s have columns \code{matrixn}, the number of 
  the matrix for which values are given, \code{type}, the fitted type of distribution, 
  as well as \code{patchsize} and \code{y}, the patch size and value of the
  inverse cumulative distribution function (i.e. \eqn{1 - P(x<k)}).
}
\description{
Export the observed and fitted patch size distributions
}
\details{
The function \code{\link{patchdistr_sews}} fits competing 
  distribution models to the observed patch size distributions. This 
  functions is able to export the observed values and the fitted values 
  altogether.
}
\examples{

\donttest{ 
patch_indics <- patchdistr_sews(forestgap)

predict(patch_indics)

}

}
\seealso{
\code{\link{patchdistr_sews}}
}
