% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.spdur.R
\name{predict.spdur}
\alias{predict.spdur}
\alias{fitted.spdur}
\alias{residuals.spdur}
\title{Predict methods for spdur Objects}
\usage{
\method{predict}{spdur}(
  object,
  newdata = NULL,
  type = "response",
  truncate = TRUE,
  na.action = na.exclude,
  ...
)

\method{fitted}{spdur}(object, ...)

\method{residuals}{spdur}(object, type = c("response"), ...)
}
\arguments{
\item{object}{Object of class ``\code{spdur}''.}

\item{newdata}{Optional data for which to calculate fitted values, defaults to 
training data.}

\item{type}{Quantity of interest to calculate. Default conditional hazard, 
i.e. conditioned on observed survival up to time \code{t}. 
See below for list of values. For \code{residuals}, the type of residual to 
calculate}

\item{truncate}{For conditional hazard, truncate values greater than 1.}

\item{na.action}{Function determining what should be done with missing values 
in newdata. The default is to predict NA (\code{na.exclude}).}

\item{\dots}{not used, for compatibility with generic function.}
}
\value{
Returns a data frame with 1 column corresponding to \code{type}, in the same 
order as the data frame used to estimate \code{object}.
}
\description{
\code{predict} and related methods for class ``\code{spdur}''.
}
\details{
Calculates various types of probabilities, where ``conditional'' is used in 
reference to conditioning on the observed survival time of a spell up to 
time \eqn{t}, in addition to conditioning on any variables included in the 
model (which is always done). Valid values for the \code{type} option 
include:
\itemize{
\item ``conditional risk'': \eqn{Pr(Cure=0|Z\gamma, T>t)}{Pr(Cure=0|Z*gamma, T>t)}
\item ``conditional cure'': \eqn{Pr(Cure=1|Z\gamma, T>t)}{Pr(Cure=1|Z*gamma, T>t)}
\item ``hazard'': \eqn{Pr(T=t|T>t, C=0, X\beta) * Pr(Cure=0|Z\gamma)}{Pr(T=t|T>t, C=0, X*beta) * Pr(Cure=0|Z*gamma)}
\item ``failure'': \eqn{Pr(T=t|T>t-1, C=0, X\beta) * Pr(Cure=0|Z\gamma)}{Pr(T=t|T>t-1, C=0, X*beta) * Pr(Cure=0|Z*gamma)}
\item ``unconditional risk'': \eqn{Pr(Cure=0|Z\gamma)}{Pr(Cure=0|Z*gamma)}
\item ``unconditional cure'': \eqn{Pr(Cure=1|Z\gamma)}{Pr(Cure=1|Z*gamma)}
\item ``conditional hazard'' or ``response'': \eqn{Pr(T=t|T>t, C=0, X\beta) * Pr(Cure=0|Z\gamma, T>t)}{Pr(T=t|T>t, C=0, X*beta) * Pr(Cure=0|Z*gamma, T>t)}
\item ``conditional failure'': \eqn{Pr(T=t|T>t-1, C=0, X\beta) * Pr(Cure=0|Z\gamma, T>t)}{Pr(T=t|T>t-1, C=0, X*beta) * Pr(Cure=0|Z*gamma, T>t)}
}
The vector \eqn{Z\gamma}{Z*gamma} indicates the cure/at risk equation 
covariate vector, while \eqn{X\beta}{X*beta} indicates the duration equation 
covariate vector.
}
\note{
See \code{\link{forecast.spdur}} for producing forecasts when future 
covariate values are unknown.
}
\examples{
# get model estimates
data(model.coups)
ch <- predict(model.coups)

head(fitted(model.coups))

head(residuals(model.coups))

}
