% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{jknife}
\alias{jknife}
\title{Identifies outliers using Reverse Jackknifing method based on Chapman et al., (2005).}
\usage{
jknife(
  data,
  var,
  output = "outlier",
  mode = "soft",
  pc = FALSE,
  pcvar = NULL,
  boot = FALSE
)
}
\arguments{
\item{data}{Dataframe to check for outliers}

\item{var}{Variable considered in flagging suspicious outliers.}

\item{output}{Either clean: for data frame with no suspicious outliers or outlier: to return data frame with only outliers}

\item{mode}{Either robust, if a robust mode is used which uses median instead of mean and median absolute deviation from median
or mad instead of standard deviation.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
Data frame with or with no outliers.
}
\description{
Identifies outliers using Reverse Jackknifing method based on Chapman et al., (2005).
}
\details{
Reverse jackknifing was specifically developed to detect error climate profiles \code{(Chapman 1991, 1999)}.
The method has been applied in detecting outliers in environmental data \code{(García-Roselló et al. 2014; Robertson et al. 2016)}
 and incorporated in the DIVAS-GIS software \code{(Hijmans et al. 2001)}.
}
\examples{
\donttest{
data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                        lat = 'decimalLatitude',
                        lon= 'decimalLongitude',
                        colsp = "scientificName",
                        bbox = db,
                        minpts = 10)

jkout <- jknife(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')

}
}
\references{
\enumerate{

  \item Chapman AD. 1991. Quality control and validation of environmental resource data in
  Data Quality and Standards. Pages 1-23. Canberra. Available from
  https://www.researchgate.net/publication/332537824.
  \item Chapman AD. 1999. Quality Control and Validation of Point-Sourced Environmental Resource Data. eds. .
  Chelsea,. Pages 409-418 in Lowell K, Jaton A, editors. Spatial accuracy assessment:
  Land information uncertainty in natural resources, 1st edition. MI: Ann Arbor Press., Chelsea.
}
}
